/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MenuItemEnabledListener;
import freemind.controller.MenuItemSelectedListener;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.HookNodeAction;
import freemind.controller.actions.generated.instance.NodeChildParameter;
import freemind.controller.actions.generated.instance.NodeListMember;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookFactory;
import freemind.extensions.HookInstanciationMethod;
import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.HookAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class NodeHookAction
extends FreemindAction
implements HookAction,
ActorXml,
MenuItemEnabledListener,
MenuItemSelectedListener {
    String _hookName;
    MindMapController mMindMapController;
    private static Logger logger;

    public MindMapController getController() {
        return this.mMindMapController;
    }

    public NodeHookAction(String hookName, MindMapController controller) {
        super(hookName, (Icon)null, null);
        this._hookName = hookName;
        this.mMindMapController = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.mMindMapController.getFrame().setWaitingCursor(true);
        this.invoke(this.mMindMapController.getSelected(), this.mMindMapController.getSelecteds());
        this.mMindMapController.getFrame().setWaitingCursor(false);
    }

    public void addHook(MindMapNode focussed, List selecteds, String hookName, Properties pHookProperties) {
        HookNodeAction doAction = this.createHookNodeAction(focussed, selecteds, hookName, pHookProperties);
        CompoundAction undoAction = null;
        undoAction = new CompoundAction();
        if (this.getInstanciationMethod(hookName).isPermanent()) {
            undoAction = this.createHookNodeUndoAction(focussed, selecteds, hookName);
        }
        if (this.getInstanciationMethod(hookName).isUndoable()) {
            this.getController().doTransaction((String)this.getValue("Name"), new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        } else {
            this.invoke(focussed, selecteds, hookName, null);
        }
    }

    private XmlAction createHookNodeUndoAction(MindMapNode focussed, List selecteds, String hookName) {
        CompoundAction undoAction = new CompoundAction();
        HookNodeAction hookNodeAction = this.createHookNodeAction(focussed, selecteds, hookName, null);
        undoAction.addChoice((Object)hookNodeAction);
        HookInstanciationMethod instMethod = this.getInstanciationMethod(hookName);
        Collection destinationNodes = instMethod.getDestinationNodes(this.mMindMapController, focussed, selecteds);
        MindMapNode adaptedFocussedNode = instMethod.getCenterNode(this.mMindMapController, focussed, selecteds);
        if (instMethod.isAlreadyPresent(this.mMindMapController, hookName, adaptedFocussedNode)) {
            block0: for (MindMapNode currentDestinationNode : destinationNodes) {
                for (PermanentNodeHook hook : currentDestinationNode.getActivatedHooks()) {
                    if (!hook.getName().equals(hookName)) continue;
                    XMLElement child = new XMLElement();
                    hook.save(child);
                    if (child.countChildren() == 1) {
                        XMLElement parameters = (XMLElement)child.getChildren().firstElement();
                        if (Tools.safeEquals(parameters.getName(), "Parameters")) {
                            Iterator it = parameters.enumerateAttributeNames();
                            while (it.hasNext()) {
                                String name = (String)it.next();
                                NodeChildParameter nodeHookChild = new NodeChildParameter();
                                nodeHookChild.setKey(name);
                                nodeHookChild.setValue(parameters.getStringAttribute(name));
                                hookNodeAction.addNodeChildParameter(nodeHookChild);
                            }
                            continue block0;
                        }
                        logger.warning("Unusual save mechanism, implement me.");
                        continue block0;
                    }
                    logger.warning("Unusual save mechanism, implement me.");
                    continue block0;
                }
            }
        }
        return undoAction;
    }

    public void invoke(MindMapNode focussed, List selecteds) {
        this.addHook(focussed, selecteds, this._hookName, null);
    }

    private void invoke(MindMapNode focussed, List selecteds, String hookName, XMLElement pXmlParent) {
        logger.finest("invoke(selecteds) called.");
        HookInstanciationMethod instMethod = this.getInstanciationMethod(hookName);
        Collection destinationNodes = instMethod.getDestinationNodes(this.mMindMapController, focussed, selecteds);
        MindMapNode adaptedFocussedNode = instMethod.getCenterNode(this.mMindMapController, focussed, selecteds);
        if (instMethod.isAlreadyPresent(this.mMindMapController, hookName, adaptedFocussedNode)) {
            block0: for (MindMapNode currentDestinationNode : destinationNodes) {
                for (PermanentNodeHook hook : currentDestinationNode.getActivatedHooks()) {
                    if (!hook.getName().equals(hookName)) continue;
                    currentDestinationNode.removeHook(hook);
                    this.mMindMapController.nodeChanged(currentDestinationNode);
                    continue block0;
                }
            }
        } else {
            for (MindMapNode currentDestinationNode : destinationNodes) {
                NodeHook hook = this.mMindMapController.createNodeHook(hookName, currentDestinationNode, this.mMindMapController.getMap());
                logger.finest("created hook " + hookName);
                if (pXmlParent != null && hook instanceof PermanentNodeHook) {
                    ((PermanentNodeHook)hook).loadFrom(pXmlParent);
                }
                currentDestinationNode.invokeHook(hook);
                if (!(hook instanceof PermanentNodeHook)) continue;
                PermanentNodeHook permHook = (PermanentNodeHook)hook;
                logger.finest("This is a permanent hook " + hookName);
                if (currentDestinationNode == adaptedFocussedNode) {
                    permHook.onFocusNode(this.mMindMapController.getNodeView(currentDestinationNode));
                }
                this.mMindMapController.nodeChanged(currentDestinationNode);
            }
            this.finishInvocation(focussed, selecteds, adaptedFocussedNode, destinationNodes);
        }
    }

    private void finishInvocation(MindMapNode focussed, List selecteds, MindMapNode adaptedFocussedNode, Collection destinationNodes) {
        if (this.getController().getView().getSelecteds().size() == 0) {
            this.getController().select(focussed, selecteds);
        }
    }

    private HookInstanciationMethod getInstanciationMethod(String hookName) {
        HookFactory factory = this.getHookFactory();
        HookInstanciationMethod instMethod = factory.getInstanciationMethod(hookName);
        return instMethod;
    }

    private HookFactory getHookFactory() {
        HookFactory factory = this.mMindMapController.getHookFactory();
        return factory;
    }

    @Override
    public boolean isEnabled(JMenuItem item, Action action) {
        if (this.mMindMapController.getView() == null) {
            return false;
        }
        HookFactory factory = this.getHookFactory();
        Object baseClass = factory.getPluginBaseClass(this._hookName);
        if (baseClass != null && baseClass instanceof MenuItemEnabledListener) {
            MenuItemEnabledListener listener = (MenuItemEnabledListener)baseClass;
            return listener.isEnabled(item, action);
        }
        return true;
    }

    public HookNodeAction createHookNodeAction(MindMapNode focussed, List selecteds, String hookName, Properties pHookProperties) {
        HookNodeAction hookNodeAction = new HookNodeAction();
        hookNodeAction.setNode(focussed.getObjectId(this.getController()));
        hookNodeAction.setHookName(hookName);
        for (MindMapNode node : selecteds) {
            NodeListMember nodeListMember = new NodeListMember();
            nodeListMember.setNode(node.getObjectId(this.getController()));
            hookNodeAction.addNodeListMember(nodeListMember);
        }
        if (pHookProperties != null) {
            for (Map.Entry<Object, Object> entry : pHookProperties.entrySet()) {
                NodeChildParameter nodeChildParameter = new NodeChildParameter();
                nodeChildParameter.setKey((String)entry.getKey());
                nodeChildParameter.setValue((String)entry.getValue());
                hookNodeAction.addNodeChildParameter(nodeChildParameter);
            }
        }
        return hookNodeAction;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof HookNodeAction) {
            HookNodeAction hookNodeAction = (HookNodeAction)action;
            NodeAdapter selected = this.getController().getNodeFromID(hookNodeAction.getNode());
            Vector<NodeAdapter> selecteds = new Vector<NodeAdapter>();
            for (NodeListMember node : hookNodeAction.getListNodeListMemberList()) {
                selecteds.add(this.getController().getNodeFromID(node.getNode()));
            }
            XMLElement xmlParent = new XMLElement();
            xmlParent.setName(hookNodeAction.getHookName());
            XMLElement child = new XMLElement();
            xmlParent.addChild(child);
            child.setName("Parameters");
            for (NodeChildParameter childParameter : hookNodeAction.getListNodeChildParameterList()) {
                child.setAttribute(childParameter.getKey(), childParameter.getValue());
            }
            this.invoke(selected, selecteds, hookNodeAction.getHookName(), xmlParent);
        }
    }

    @Override
    public Class getDoActionClass() {
        return HookNodeAction.class;
    }

    @Override
    public String getHookName() {
        return this._hookName;
    }

    @Override
    public boolean isSelected(JMenuItem pCheckItem, Action pAction) {
        HookFactory factory = this.getHookFactory();
        Object baseClass = factory.getPluginBaseClass(this._hookName);
        if (baseClass != null && baseClass instanceof MenuItemSelectedListener) {
            MenuItemSelectedListener listener = (MenuItemSelectedListener)baseClass;
            return listener.isSelected(pCheckItem, pAction);
        }
        MindMapNode focussed = this.mMindMapController.getSelected();
        List selecteds = this.mMindMapController.getSelecteds();
        HookInstanciationMethod instMethod = this.getInstanciationMethod(this._hookName);
        Collection destinationNodes = instMethod.getDestinationNodes(this.mMindMapController, focussed, selecteds);
        MindMapNode adaptedFocussedNode = instMethod.getCenterNode(this.mMindMapController, focussed, selecteds);
        return instMethod.isAlreadyPresent(this.mMindMapController, this._hookName, adaptedFocussedNode);
    }

    public void removeHook(MindMapNode pFocussed, List pSelecteds, String pHookName) {
        HookNodeAction undoAction = this.createHookNodeAction(pFocussed, pSelecteds, pHookName, null);
        CompoundAction doAction = null;
        doAction = new CompoundAction();
        if (this.getInstanciationMethod(pHookName).isPermanent()) {
            doAction = this.createHookNodeUndoAction(pFocussed, pSelecteds, pHookName);
        }
        this.getController().doTransaction((String)this.getValue("Name"), new ActionPair((XmlAction)undoAction, (XmlAction)doAction));
    }
}

