import gtk
import os
import dbus
import dbus.glib
#import dbus.decorator

class Gaim:

    # called when we load the plugin. we get passed the mainWindow, plugin menu
    # item as well as a connection to mpd.
    def _init(self, data):
        self.xml, self.pluginMenu, self.pympd, self.base_dir, self.parser = data
        self.data = data

    def _conf(self, hasConf=False):
        if hasConf:
            return True
        self.logentry.set_text(self.filename) 
        self.logspinner.set_value(self.filesize)
        self.confDialog.present()
        return True

    # update plugin, data is of type mpdclient.Status
    def _spin(self, data, songChanged=False):
        song = self.pympd.getCurrentSong()
        if song == False:
            return
                
    # called on plugin unloaded
    def _unload(self):
        return

    def initBus(self):
        # Taken from gaim's example dbus plugin
        self.bus = dbus.SessionBus()
        self.gaim = dbus.Interface(self.bus.get_object("net.sf.gaim.GaimService", "/net/sf/gaim/GaimObject"), "net.sf.gaim.GaimInterface")
        self.gaim.Introspect()
        

    def readConfigParser(self):
        pass

if __name__ == "__main__":
    g = Gaim()
    g.initBus()
