/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.DefaultUserPreferences;
import com.eteks.sweethome3d.io.HomeContentContext;
import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Baseboard;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogLight;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomePrint;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeXMLHandler
extends DefaultHandler {
    private HomeContentContext contentContext;
    private UserPreferences preferences;
    private Home home;
    private final StringBuilder buffer = new StringBuilder();
    private final Stack<String> elements = new Stack();
    private final Stack<Map<String, String>> attributes = new Stack();
    private final Stack<List<HomePieceOfFurniture>> groupsFurniture = new Stack();
    private final Map<String, Level> levels = new HashMap<String, Level>();
    private final Map<String, JoinedWall> joinedWalls = new HashMap<String, JoinedWall>();
    private String homeElementName;
    private String labelText;
    private Baseboard leftSideBaseboard;
    private Baseboard rightSideBaseboard;
    private BackgroundImage homeBackgroundImage;
    private BackgroundImage backgroundImage;
    private final Map<String, String> homeProperties = new LinkedHashMap<String, String>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Map<String, TextStyle> textStyles = new HashMap<String, TextStyle>();
    private final Map<String, HomeTexture> textures = new HashMap<String, HomeTexture>();
    private final List<HomeMaterial> materials = new ArrayList<HomeMaterial>();
    private HomeTexture materialTexture;
    private final List<Sash> sashes = new ArrayList<Sash>();
    private final List<LightSource> lightSources = new ArrayList<LightSource>();
    private final List<float[]> points = new ArrayList<float[]>();
    private final List<HomePieceOfFurniture.SortableProperty> furnitureVisibleProperties = new ArrayList<HomePieceOfFurniture.SortableProperty>();

    public HomeXMLHandler() {
        this(null);
    }

    public HomeXMLHandler(UserPreferences userPreferences) {
        this.preferences = userPreferences != null ? userPreferences : new DefaultUserPreferences(false, null);
    }

    void setContentContext(HomeContentContext homeContentContext) {
        this.contentContext = homeContentContext;
    }

    @Override
    public void startDocument() throws SAXException {
        this.home = null;
        this.elements.clear();
        this.attributes.clear();
        this.groupsFurniture.clear();
        this.levels.clear();
        this.joinedWalls.clear();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.buffer.setLength(0);
        this.elements.push(string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            hashMap.put(attributes.getQName(i), attributes.getValue(i));
        }
        this.attributes.push(hashMap);
        if ("home".equals(string3)) {
            this.setHome(this.createHome(hashMap));
            this.homeProperties.clear();
            this.furnitureVisibleProperties.clear();
            this.homeBackgroundImage = null;
        } else if ("environment".equals(string3)) {
            this.textures.clear();
        } else if ("compass".equals(string3)) {
            this.properties.clear();
        } else if ("level".equals(string3)) {
            this.properties.clear();
            this.backgroundImage = null;
        } else if ("pieceOfFurniture".equals(string3) || "doorOrWindow".equals(string3) || "light".equals(string3) || "furnitureGroup".equals(string3)) {
            this.properties.clear();
            this.textStyles.clear();
            this.textures.clear();
            this.materials.clear();
            this.sashes.clear();
            this.lightSources.clear();
            if ("furnitureGroup".equals(string3)) {
                this.groupsFurniture.push(new ArrayList());
            }
        } else if ("camera".equals(string3) || "observerCamera".equals(string3)) {
            this.properties.clear();
        } else if ("room".equals(string3)) {
            this.properties.clear();
            this.textStyles.clear();
            this.textures.clear();
            this.points.clear();
        } else if ("polyline".equals(string3)) {
            this.properties.clear();
            this.points.clear();
        } else if ("dimensionLine".equals(string3)) {
            this.properties.clear();
            this.textStyles.clear();
        } else if ("label".equals(string3)) {
            this.properties.clear();
            this.textStyles.clear();
            this.labelText = null;
        } else if ("wall".equals(string3)) {
            this.properties.clear();
            this.textures.clear();
            this.leftSideBaseboard = null;
            this.rightSideBaseboard = null;
        } else if ("baseboard".equals(string3)) {
            this.textures.remove(null);
        } else if ("material".equals(string3)) {
            this.materialTexture = null;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.buffer.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.elements.pop();
        String string4 = this.elements.isEmpty() ? null : this.elements.peek();
        Map<String, String> map = this.attributes.pop();
        if (this.homeElementName != null && this.homeElementName.equals(string3)) {
            this.setHomeAttributes(this.home, string3, map);
        } else if ("furnitureVisibleProperty".equals(string3)) {
            try {
                if (map.get("name") == null) {
                    throw new SAXException("Missing name attribute");
                }
                this.furnitureVisibleProperties.add(HomePieceOfFurniture.SortableProperty.valueOf(map.get("name")));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if ("environment".equals(string3)) {
            this.setEnvironmentAttributes(this.home.getEnvironment(), string3, map);
        } else if ("compass".equals(string3)) {
            this.setCompassAttributes(this.home.getCompass(), string3, map);
        } else if ("print".equals(string3)) {
            this.home.setPrint(this.createPrint(map));
        } else if ("level".equals(string3)) {
            Level level = this.createLevel(map);
            this.setLevelAttributes(level, string3, map);
            this.levels.put(map.get("id"), level);
            this.home.addLevel(level);
        } else if ("camera".equals(string3) || "observerCamera".equals(string3)) {
            Camera camera = this.createCamera(string3, map);
            this.setCameraAttributes(camera, string3, map);
            String string5 = map.get("attribute");
            if ("cameraPath".equals(string5)) {
                ArrayList<Camera> arrayList = new ArrayList<Camera>(this.home.getEnvironment().getVideoCameraPath());
                arrayList.add(camera);
                this.home.getEnvironment().setVideoCameraPath(arrayList);
            } else if ("topCamera".equals(string5)) {
                Camera camera2 = this.home.getTopCamera();
                camera2.setCamera(camera);
                camera2.setTime(camera.getTime());
                camera2.setLens(camera.getLens());
            } else if ("observerCamera".equals(string5)) {
                ObserverCamera observerCamera = this.home.getObserverCamera();
                observerCamera.setCamera(camera);
                observerCamera.setTime(camera.getTime());
                observerCamera.setLens(camera.getLens());
                observerCamera.setFixedSize(((ObserverCamera)camera).isFixedSize());
            } else if ("storedCamera".equals(string5)) {
                ArrayList<Camera> arrayList = new ArrayList<Camera>(this.home.getStoredCameras());
                arrayList.add(camera);
                this.home.setStoredCameras(arrayList);
            }
        } else if ("pieceOfFurniture".equals(string3) || "doorOrWindow".equals(string3) || "light".equals(string3) || "furnitureGroup".equals(string3)) {
            HomePieceOfFurniture homePieceOfFurniture = "furnitureGroup".equals(string3) ? this.createFurnitureGroup(map, this.groupsFurniture.pop()) : this.createPieceOfFurniture(string3, map);
            this.setPieceOfFurnitureAttributes(homePieceOfFurniture, string3, map);
            if (this.homeElementName != null && this.homeElementName.equals(string4)) {
                this.home.addPieceOfFurniture(homePieceOfFurniture);
                String string6 = map.get("level");
                if (string6 != null) {
                    homePieceOfFurniture.setLevel(this.levels.get(string6));
                }
            } else if ("furnitureGroup".equals(string4)) {
                this.groupsFurniture.peek().add(homePieceOfFurniture);
                this.properties.clear();
                this.textStyles.clear();
            }
        } else if ("wall".equals(string3)) {
            Wall wall = this.createWall(map);
            this.joinedWalls.put(map.get("id"), new JoinedWall(wall, map.get("wallAtStart"), map.get("wallAtEnd")));
            this.setWallAttributes(wall, string3, map);
            this.home.addWall(wall);
            String string7 = map.get("level");
            if (string7 != null) {
                wall.setLevel(this.levels.get(string7));
            }
        } else if ("baseboard".equals(string3)) {
            Baseboard baseboard = this.createBaseboard(map);
            if ("leftSideBaseboard".equals(map.get("attribute"))) {
                this.leftSideBaseboard = baseboard;
            } else {
                this.rightSideBaseboard = baseboard;
            }
        } else if ("room".equals(string3)) {
            Room room = this.createRoom(map, (float[][])this.points.toArray((T[])new float[this.points.size()][]));
            this.setRoomAttributes(room, string3, map);
            this.home.addRoom(room);
            String string8 = map.get("level");
            if (string8 != null) {
                room.setLevel(this.levels.get(string8));
            }
        } else if ("polyline".equals(string3)) {
            Polyline polyline = this.createPolyline(map, (float[][])this.points.toArray((T[])new float[this.points.size()][]));
            this.setPolylineAttributes(polyline, string3, map);
            this.home.addPolyline(polyline);
            String string9 = map.get("level");
            if (string9 != null) {
                polyline.setLevel(this.levels.get(string9));
            }
        } else if ("dimensionLine".equals(string3)) {
            DimensionLine dimensionLine = this.createDimensionLine(map);
            this.setDimensionLineAttributes(dimensionLine, string3, map);
            this.home.addDimensionLine(dimensionLine);
            String string10 = map.get("level");
            if (string10 != null) {
                dimensionLine.setLevel(this.levels.get(string10));
            }
        } else if ("label".equals(string3)) {
            Label label = this.createLabel(map, this.labelText);
            this.setLabelAttributes(label, string3, map);
            this.home.addLabel(label);
            String string11 = map.get("level");
            if (string11 != null) {
                label.setLevel(this.levels.get(string11));
            }
        } else if ("text".equals(string3)) {
            this.labelText = this.getCharacters();
        } else if ("textStyle".equals(string3)) {
            this.textStyles.put(map.get("attribute"), this.createTextStyle(map));
        } else if ("texture".equals(string3)) {
            if ("material".equals(string4)) {
                this.materialTexture = this.createTexture(map);
            } else {
                this.textures.put(map.get("attribute"), this.createTexture(map));
            }
        } else if ("material".equals(string3)) {
            this.materials.add(this.createMaterial(map));
        } else if ("point".equals(string3)) {
            this.points.add(new float[]{this.parseFloat(map, "x"), this.parseFloat(map, "y")});
        } else if ("sash".equals(string3)) {
            this.sashes.add(new Sash(this.parseFloat(map, "xAxis"), this.parseFloat(map, "yAxis"), this.parseFloat(map, "width"), this.parseFloat(map, "startAngle"), this.parseFloat(map, "endAngle")));
        } else if ("lightSource".equals(string3)) {
            this.lightSources.add(new LightSource(this.parseFloat(map, "x"), this.parseFloat(map, "y"), this.parseFloat(map, "z"), this.parseOptionalColor(map, "color"), this.parseOptionalFloat(map, "diameter")));
        } else if ("backgroundImage".equals(string3)) {
            BackgroundImage backgroundImage = new BackgroundImage(this.parseContent(map.get("image")), this.parseFloat(map, "scaleDistance"), this.parseFloat(map, "scaleDistanceXStart"), this.parseFloat(map, "scaleDistanceYStart"), this.parseFloat(map, "scaleDistanceXEnd"), this.parseFloat(map, "scaleDistanceYEnd"), map.get("xOrigin") != null ? this.parseFloat(map, "xOrigin") : 0.0f, map.get("yOrigin") != null ? this.parseFloat(map, "yOrigin") : 0.0f, !"false".equals(map.get("visible")));
            if (this.homeElementName != null && this.homeElementName.equals(string4)) {
                this.homeBackgroundImage = backgroundImage;
            } else {
                this.backgroundImage = backgroundImage;
            }
        } else if ("property".equals(string3) && this.homeElementName != null) {
            if (this.homeElementName.equals(string4)) {
                this.homeProperties.put(map.get("name"), map.get("value"));
            } else {
                this.properties.put(map.get("name"), map.get("value"));
            }
        }
    }

    private String getCharacters() {
        return this.buffer.toString();
    }

    @Override
    public void endDocument() throws SAXException {
        for (JoinedWall joinedWall : this.joinedWalls.values()) {
            JoinedWall joinedWall2;
            Wall wall = joinedWall.getWall();
            if (joinedWall.getWallAtStartId() != null && (joinedWall2 = this.joinedWalls.get(joinedWall.getWallAtStartId())) != null) {
                wall.setWallAtStart(joinedWall2.getWall());
            }
            if (joinedWall.getWallAtEndId() == null || (joinedWall2 = this.joinedWalls.get(joinedWall.getWallAtEndId())) == null) continue;
            wall.setWallAtEnd(joinedWall2.getWall());
        }
    }

    private Home createHome(Map<String, String> map) throws SAXException {
        if (map.get("wallHeight") != null) {
            return new Home(this.parseFloat(map, "wallHeight"));
        }
        return new Home();
    }

    protected void setHomeAttributes(Home home, String string, Map<String, String> map) throws SAXException {
        for (Map.Entry<String, String> object2 : this.homeProperties.entrySet()) {
            home.setProperty(object2.getKey(), object2.getValue());
        }
        if (this.furnitureVisibleProperties.size() > 0) {
            this.home.setFurnitureVisibleProperties(this.furnitureVisibleProperties);
        }
        this.home.setBackgroundImage(this.homeBackgroundImage);
        String string2 = map.get("version");
        if (string2 != null) {
            try {
                home.setVersion(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for integer attribute version", numberFormatException);
            }
        }
        home.setName(map.get("name"));
        String string3 = map.get("selectedLevel");
        if (string3 != null) {
            this.home.setSelectedLevel(this.levels.get(string3));
        }
        if ("observerCamera".equals(map.get("camera"))) {
            this.home.setCamera(this.home.getObserverCamera());
        }
        home.setBasePlanLocked("true".equals(map.get("basePlanLocked")));
        String string4 = map.get("furnitureSortedProperty");
        if (string4 != null) {
            try {
                home.setFurnitureSortedProperty(HomePieceOfFurniture.SortableProperty.valueOf(string4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        home.setFurnitureDescendingSorted("true".equals(map.get("furnitureDescendingSorted")));
    }

    private void setEnvironmentAttributes(HomeEnvironment homeEnvironment, String string, Map<String, String> map) throws SAXException {
        Integer n;
        Integer n2;
        String string2;
        Integer n3;
        Integer n4;
        String string3;
        Integer n5;
        Integer n6;
        Float f;
        String string4;
        Float f2;
        Integer n7 = this.parseOptionalColor(map, "groundColor");
        if (n7 != null) {
            homeEnvironment.setGroundColor(n7);
        }
        homeEnvironment.setGroundTexture(this.textures.get("groundTexture"));
        Integer n8 = this.parseOptionalColor(map, "skyColor");
        if (n8 != null) {
            homeEnvironment.setSkyColor(n8);
        }
        homeEnvironment.setSkyTexture(this.textures.get("skyTexture"));
        Integer n9 = this.parseOptionalColor(map, "lightColor");
        if (n9 != null) {
            homeEnvironment.setLightColor(n9);
        }
        if ((f2 = this.parseOptionalFloat(map, "wallsAlpha")) != null) {
            homeEnvironment.setWallsAlpha(f2.floatValue());
        }
        homeEnvironment.setAllLevelsVisible("true".equals(map.get("allLevelsVisible")));
        homeEnvironment.setObserverCameraElevationAdjusted(!"false".equals(map.get("observerCameraElevationAdjusted")));
        Integer n10 = this.parseOptionalColor(map, "ceillingLightColor");
        if (n10 != null) {
            homeEnvironment.setCeillingLightColor(n10);
        }
        if ((string4 = map.get("drawingMode")) != null) {
            try {
                homeEnvironment.setDrawingMode(HomeEnvironment.DrawingMode.valueOf(string4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((f = this.parseOptionalFloat(map, "subpartSizeUnderLight")) != null) {
            homeEnvironment.setSubpartSizeUnderLight(f.floatValue());
        }
        if ((n6 = this.parseOptionalInteger(map, "photoWidth")) != null) {
            homeEnvironment.setPhotoWidth(n6);
        }
        if ((n5 = this.parseOptionalInteger(map, "photoHeight")) != null) {
            homeEnvironment.setPhotoHeight(n5);
        }
        if ((string3 = map.get("photoAspectRatio")) != null) {
            try {
                homeEnvironment.setPhotoAspectRatio(AspectRatio.valueOf(string3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((n4 = this.parseOptionalInteger(map, "photoQuality")) != null) {
            homeEnvironment.setPhotoQuality(n4);
        }
        if ((n3 = this.parseOptionalInteger(map, "videoWidth")) != null) {
            homeEnvironment.setVideoWidth(n3);
        }
        if ((string2 = map.get("videoAspectRatio")) != null) {
            try {
                homeEnvironment.setVideoAspectRatio(AspectRatio.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((n2 = this.parseOptionalInteger(map, "videoQuality")) != null) {
            homeEnvironment.setVideoQuality(n2);
        }
        if ((n = this.parseOptionalInteger(map, "videoFrameRate")) != null) {
            homeEnvironment.setVideoFrameRate(n);
        }
    }

    protected HomePrint createPrint(Map<String, String> map) throws SAXException {
        HomePrint.PaperOrientation paperOrientation = HomePrint.PaperOrientation.PORTRAIT;
        try {
            if (map.get("paperOrientation") == null) {
                throw new SAXException("Missing paperOrientation attribute");
            }
            paperOrientation = HomePrint.PaperOrientation.valueOf(map.get("paperOrientation"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new HomePrint(paperOrientation, this.parseFloat(map, "paperWidth"), this.parseFloat(map, "paperHeight"), this.parseFloat(map, "paperTopMargin"), this.parseFloat(map, "paperLeftMargin"), this.parseFloat(map, "paperBottomMargin"), this.parseFloat(map, "paperRightMargin"), !"false".equals(map.get("furniturePrinted")), !"false".equals(map.get("planPrinted")), !"false".equals(map.get("view3DPrinted")), this.parseOptionalFloat(map, "planScale"), map.get("headerFormat"), map.get("footerFormat"));
    }

    protected void setCompassAttributes(Compass compass, String string, Map<String, String> map) throws SAXException {
        String string2;
        Float f;
        Float f2;
        this.setProperties(compass);
        compass.setX(this.parseOptionalFloat(map, "x").floatValue());
        compass.setY(this.parseOptionalFloat(map, "y").floatValue());
        compass.setDiameter(this.parseOptionalFloat(map, "diameter").floatValue());
        Float f3 = this.parseOptionalFloat(map, "northDirection");
        if (f3 != null) {
            compass.setNorthDirection(f3.floatValue());
        }
        if ((f2 = this.parseOptionalFloat(map, "longitude")) != null) {
            compass.setLongitude(f2.floatValue());
        }
        if ((f = this.parseOptionalFloat(map, "latitude")) != null) {
            compass.setLatitude(f.floatValue());
        }
        if ((string2 = map.get("timeZone")) != null) {
            compass.setTimeZone(string2);
        }
        compass.setVisible(!"false".equals(map.get("visible")));
    }

    private Camera createCamera(String string, Map<String, String> map) throws SAXException {
        if ("observerCamera".equals(string)) {
            return new ObserverCamera(this.parseFloat(map, "x"), this.parseFloat(map, "y"), this.parseFloat(map, "z"), this.parseFloat(map, "yaw"), this.parseFloat(map, "pitch"), this.parseFloat(map, "fieldOfView"));
        }
        return new Camera(this.parseFloat(map, "x"), this.parseFloat(map, "y"), this.parseFloat(map, "z"), this.parseFloat(map, "yaw"), this.parseFloat(map, "pitch"), this.parseFloat(map, "fieldOfView"));
    }

    protected void setCameraAttributes(Camera camera, String string, Map<String, String> map) throws SAXException {
        String string2;
        String string3;
        this.setProperties(camera);
        if (camera instanceof ObserverCamera) {
            ((ObserverCamera)camera).setFixedSize("true".equals(map.get("fixedSize")));
        }
        if ((string3 = map.get("lens")) != null) {
            try {
                camera.setLens(Camera.Lens.valueOf(string3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string2 = map.get("time")) != null) {
            try {
                camera.setTime(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for long attribute time", numberFormatException);
            }
        }
        camera.setName(map.get("name"));
    }

    private Level createLevel(Map<String, String> map) throws SAXException {
        return new Level(map.get("name"), this.parseFloat(map, "elevation"), this.parseFloat(map, "floorThickness"), this.parseFloat(map, "height"));
    }

    protected void setLevelAttributes(Level level, String string, Map<String, String> map) throws SAXException {
        this.setProperties(level);
        level.setBackgroundImage(this.backgroundImage);
        Integer n = this.parseOptionalInteger(map, "elevationIndex");
        if (n != null) {
            level.setElevationIndex(n);
        }
        level.setVisible(!"false".equals(map.get("visible")));
        level.setViewable(!"false".equals(map.get("viewable")));
    }

    private HomePieceOfFurniture createPieceOfFurniture(String string, Map<String, String> map) throws SAXException {
        String[] stringArray = map.get("tags") != null ? map.get("tags").split(" ") : null;
        float f = map.get("elevation") != null ? this.parseFloat(map, "elevation") : 0.0f;
        float f2 = map.get("dropOnTopElevation") != null ? this.parseFloat(map, "dropOnTopElevation") : 1.0f;
        Object object = null;
        if (map.get("modelRotation") != null) {
            String[] stringArray2 = map.get("modelRotation").split(" ", 9);
            if (stringArray2.length < 9) {
                throw new SAXException("Missing values for attribute modelRotation");
            }
            try {
                object = new float[][]{{Float.parseFloat(stringArray2[0]), Float.parseFloat(stringArray2[1]), Float.parseFloat(stringArray2[2])}, {Float.parseFloat(stringArray2[3]), Float.parseFloat(stringArray2[4]), Float.parseFloat(stringArray2[5])}, {Float.parseFloat(stringArray2[6]), Float.parseFloat(stringArray2[7]), Float.parseFloat(stringArray2[8])}};
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for attribute modelRotation", numberFormatException);
            }
        }
        if ("doorOrWindow".equals(string) || "true".equals(map.get("doorOrWindow"))) {
            float f3 = map.get("wallThickness") != null ? this.parseFloat(map, "wallThickness") : 1.0f;
            float f4 = map.get("wallDistance") != null ? this.parseFloat(map, "wallDistance") : 0.0f;
            String string2 = map.get("cutOutShape");
            if (string2 == null && !"doorOrWindow".equals(string)) {
                string2 = "M0,0 v1 h1 v-1 z";
            }
            return new HomeDoorOrWindow(new CatalogDoorOrWindow(map.get("catalogId"), map.get("name"), map.get("description"), map.get("information"), stringArray, this.parseOptionalLong(map, "creationDate"), this.parseOptionalFloat(map, "grade"), this.parseContent(map.get("icon")), this.parseContent(map.get("planIcon")), this.parseContent(map.get("model")), this.parseFloat(map, "width"), this.parseFloat(map, "depth"), this.parseFloat(map, "height"), f, f2, !"false".equals(map.get("movable")), string2, f3, f4, this.sashes.toArray(new Sash[this.sashes.size()]), (float[][])object, "true".equals(map.get("backFaceShown")), map.get("creator"), !"false".equals(map.get("resizable")), !"false".equals(map.get("deformable")), !"false".equals(map.get("texturable")), this.parseOptionalDecimal(map, "price"), this.parseOptionalDecimal(map, "valueAddedTaxPercentage"), map.get("currency")));
        }
        if ("light".equals(string)) {
            return new HomeLight(new CatalogLight(map.get("catalogId"), map.get("name"), map.get("description"), map.get("information"), stringArray, this.parseOptionalLong(map, "creationDate"), this.parseOptionalFloat(map, "grade"), this.parseContent(map.get("icon")), this.parseContent(map.get("planIcon")), this.parseContent(map.get("model")), this.parseFloat(map, "width"), this.parseFloat(map, "depth"), this.parseFloat(map, "height"), f, f2, !"false".equals(map.get("movable")), this.lightSources.toArray(new LightSource[this.lightSources.size()]), map.get("staircaseCutOutShape"), (float[][])object, "true".equals(map.get("backFaceShown")), map.get("creator"), !"false".equals(map.get("resizable")), !"false".equals(map.get("deformable")), !"false".equals(map.get("texturable")), this.parseOptionalDecimal(map, "price"), this.parseOptionalDecimal(map, "valueAddedTaxPercentage"), map.get("currency")));
        }
        return new HomePieceOfFurniture(new CatalogPieceOfFurniture(map.get("catalogId"), map.get("name"), map.get("description"), map.get("information"), stringArray, this.parseOptionalLong(map, "creationDate"), this.parseOptionalFloat(map, "grade"), this.parseContent(map.get("icon")), this.parseContent(map.get("planIcon")), this.parseContent(map.get("model")), this.parseFloat(map, "width"), this.parseFloat(map, "depth"), this.parseFloat(map, "height"), f, f2, !"false".equals(map.get("movable")), map.get("staircaseCutOutShape"), (float[][])object, "true".equals(map.get("backFaceShown")), map.get("creator"), !"false".equals(map.get("resizable")), !"false".equals(map.get("deformable")), !"false".equals(map.get("texturable")), this.parseOptionalDecimal(map, "price"), this.parseOptionalDecimal(map, "valueAddedTaxPercentage"), map.get("currency")));
    }

    private HomeFurnitureGroup createFurnitureGroup(Map<String, String> map, List<HomePieceOfFurniture> list) throws SAXException {
        return new HomeFurnitureGroup(list, map.get("angle") != null ? this.parseFloat(map, "angle") : 0.0f, "true".equals(map.get("modelMirrored")), map.get("name"));
    }

    protected void setPieceOfFurnitureAttributes(HomePieceOfFurniture homePieceOfFurniture, String string, Map<String, String> map) throws SAXException {
        Float f;
        Float f2;
        this.setProperties(homePieceOfFurniture);
        homePieceOfFurniture.setNameStyle(this.textStyles.get("nameStyle"));
        homePieceOfFurniture.setNameVisible("true".equals(map.get("nameVisible")));
        Float f3 = this.parseOptionalFloat(map, "nameAngle");
        if (f3 != null) {
            homePieceOfFurniture.setNameAngle(f3.floatValue());
        }
        if ((f2 = this.parseOptionalFloat(map, "nameXOffset")) != null) {
            homePieceOfFurniture.setNameXOffset(f2.floatValue());
        }
        if ((f = this.parseOptionalFloat(map, "nameYOffset")) != null) {
            homePieceOfFurniture.setNameYOffset(f.floatValue());
        }
        homePieceOfFurniture.setVisible(!"false".equals(map.get("visible")));
        if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) {
            Float f4;
            Float f5;
            Float f6 = this.parseOptionalFloat(map, "x");
            if (f6 != null) {
                homePieceOfFurniture.setX(f6.floatValue());
            }
            if ((f5 = this.parseOptionalFloat(map, "y")) != null) {
                homePieceOfFurniture.setY(f5.floatValue());
            }
            if ((f4 = this.parseOptionalFloat(map, "angle")) != null) {
                homePieceOfFurniture.setAngle(f4.floatValue());
            }
            if (homePieceOfFurniture.isResizable()) {
                homePieceOfFurniture.setModelMirrored("true".equals(map.get("modelMirrored")));
            }
            if (homePieceOfFurniture.isTexturable()) {
                Float f7;
                HomeTexture homeTexture;
                Integer n;
                if (this.materials.size() > 0) {
                    homePieceOfFurniture.setModelMaterials(this.materials.toArray(new HomeMaterial[this.materials.size()]));
                }
                if ((n = this.parseOptionalColor(map, "color")) != null) {
                    homePieceOfFurniture.setColor(n);
                }
                if ((homeTexture = this.textures.get(null)) != null) {
                    homePieceOfFurniture.setTexture(homeTexture);
                }
                if ((f7 = this.parseOptionalFloat(map, "shininess")) != null) {
                    homePieceOfFurniture.setShininess(f7);
                }
            }
            if (homePieceOfFurniture instanceof HomeLight && map.get("power") != null) {
                ((HomeLight)homePieceOfFurniture).setPower(this.parseFloat(map, "power"));
            } else if (homePieceOfFurniture instanceof HomeDoorOrWindow && "doorOrWindow".equals(string)) {
                ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(!"false".equals(map.get("boundToWall")));
            }
        }
    }

    private Wall createWall(Map<String, String> map) throws SAXException {
        return new Wall(this.parseFloat(map, "xStart"), this.parseFloat(map, "yStart"), this.parseFloat(map, "xEnd"), this.parseFloat(map, "yEnd"), this.parseFloat(map, "thickness"));
    }

    protected void setWallAttributes(Wall wall, String string, Map<String, String> map) throws SAXException {
        String string2;
        this.setProperties(wall);
        wall.setLeftSideBaseboard(this.leftSideBaseboard);
        wall.setRightSideBaseboard(this.rightSideBaseboard);
        Float f = this.parseOptionalFloat(map, "height");
        if (f != null) {
            wall.setHeight(f);
        }
        wall.setHeightAtEnd(this.parseOptionalFloat(map, "heightAtEnd"));
        wall.setArcExtent(this.parseOptionalFloat(map, "arcExtent"));
        wall.setTopColor(this.parseOptionalColor(map, "topColor"));
        wall.setLeftSideColor(this.parseOptionalColor(map, "leftSideColor"));
        wall.setLeftSideTexture(this.textures.get("leftSideTexture"));
        Float f2 = this.parseOptionalFloat(map, "leftSideShininess");
        if (f2 != null) {
            wall.setLeftSideShininess(f2.floatValue());
        }
        wall.setRightSideColor(this.parseOptionalColor(map, "rightSideColor"));
        wall.setRightSideTexture(this.textures.get("rightSideTexture"));
        Float f3 = this.parseOptionalFloat(map, "rightSideShininess");
        if (f3 != null) {
            wall.setRightSideShininess(f3.floatValue());
        }
        if ((string2 = map.get("pattern")) != null) {
            try {
                wall.setPattern(this.preferences.getPatternsCatalog().getPattern(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private Room createRoom(Map<String, String> map, float[][] fArray) {
        return new Room(fArray);
    }

    protected void setRoomAttributes(Room room, String string, Map<String, String> map) throws SAXException {
        Float f;
        Float f2;
        Float f3;
        Float f4;
        this.setProperties(room);
        room.setNameStyle(this.textStyles.get("nameStyle"));
        room.setAreaStyle(this.textStyles.get("areaStyle"));
        room.setName(map.get("name"));
        Float f5 = this.parseOptionalFloat(map, "nameAngle");
        if (f5 != null) {
            room.setNameAngle(f5.floatValue());
        }
        if ((f4 = this.parseOptionalFloat(map, "nameXOffset")) != null) {
            room.setNameXOffset(f4.floatValue());
        }
        if ((f3 = this.parseOptionalFloat(map, "nameYOffset")) != null) {
            room.setNameYOffset(f3.floatValue());
        }
        room.setAreaVisible("true".equals(map.get("areaVisible")));
        Float f6 = this.parseOptionalFloat(map, "areaAngle");
        if (f6 != null) {
            room.setAreaAngle(f6.floatValue());
        }
        if ((f2 = this.parseOptionalFloat(map, "areaXOffset")) != null) {
            room.setAreaXOffset(f2.floatValue());
        }
        if ((f = this.parseOptionalFloat(map, "areaYOffset")) != null) {
            room.setAreaYOffset(f.floatValue());
        }
        room.setFloorVisible(!"false".equals(map.get("floorVisible")));
        room.setFloorColor(this.parseOptionalColor(map, "floorColor"));
        room.setFloorTexture(this.textures.get("floorTexture"));
        Float f7 = this.parseOptionalFloat(map, "floorShininess");
        if (f7 != null) {
            room.setFloorShininess(f7.floatValue());
        }
        room.setCeilingVisible(!"false".equals(map.get("ceilingVisible")));
        room.setCeilingColor(this.parseOptionalColor(map, "ceilingColor"));
        room.setCeilingTexture(this.textures.get("ceilingTexture"));
        Float f8 = this.parseOptionalFloat(map, "ceilingShininess");
        if (f8 != null) {
            room.setCeilingShininess(f8.floatValue());
        }
    }

    private Polyline createPolyline(Map<String, String> map, float[][] fArray) {
        return new Polyline(fArray);
    }

    protected void setPolylineAttributes(Polyline polyline, String string, Map<String, String> map) throws SAXException {
        Integer n;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this.setProperties(polyline);
        Float f = this.parseOptionalFloat(map, "thickness");
        if (f != null) {
            polyline.setThickness(f.floatValue());
        }
        if ((string6 = map.get("capStyle")) != null) {
            try {
                polyline.setCapStyle(Polyline.CapStyle.valueOf(string6));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string5 = map.get("joinStyle")) != null) {
            try {
                polyline.setJoinStyle(Polyline.JoinStyle.valueOf(string5));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string4 = map.get("dashStyle")) != null) {
            try {
                polyline.setDashStyle(Polyline.DashStyle.valueOf(string4));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string3 = map.get("startArrowStyle")) != null) {
            try {
                polyline.setStartArrowStyle(Polyline.ArrowStyle.valueOf(string3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((string2 = map.get("endArrowStyle")) != null) {
            try {
                polyline.setEndArrowStyle(Polyline.ArrowStyle.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((n = this.parseOptionalColor(map, "color")) != null) {
            polyline.setColor(n);
        }
        polyline.setClosedPath("true".equals(map.get("closedPath")));
    }

    private DimensionLine createDimensionLine(Map<String, String> map) throws SAXException {
        return new DimensionLine(this.parseFloat(map, "xStart"), this.parseFloat(map, "yStart"), this.parseFloat(map, "xEnd"), this.parseFloat(map, "yEnd"), this.parseFloat(map, "offset"));
    }

    protected void setDimensionLineAttributes(DimensionLine dimensionLine, String string, Map<String, String> map) throws SAXException {
        this.setProperties(dimensionLine);
        dimensionLine.setLengthStyle(this.textStyles.get("lengthStyle"));
    }

    private Label createLabel(Map<String, String> map, String string) throws SAXException {
        return new Label(string, this.parseFloat(map, "x"), this.parseFloat(map, "y"));
    }

    protected void setLabelAttributes(Label label, String string, Map<String, String> map) throws SAXException {
        Float f;
        Float f2;
        this.setProperties(label);
        label.setStyle(this.textStyles.get(null));
        Float f3 = this.parseOptionalFloat(map, "angle");
        if (f3 != null) {
            label.setAngle(f3.floatValue());
        }
        if ((f2 = this.parseOptionalFloat(map, "elevation")) != null) {
            label.setElevation(f2.floatValue());
        }
        if ((f = this.parseOptionalFloat(map, "pitch")) != null) {
            label.setPitch(f);
        }
        label.setColor(this.parseOptionalColor(map, "color"));
        label.setOutlineColor(this.parseOptionalColor(map, "outlineColor"));
    }

    private Baseboard createBaseboard(Map<String, String> map) throws SAXException {
        return Baseboard.getInstance(this.parseFloat(map, "thickness"), this.parseFloat(map, "height"), this.parseOptionalColor(map, "color"), this.textures.get(null));
    }

    private TextStyle createTextStyle(Map<String, String> map) throws SAXException {
        return new TextStyle(map.get("fontName"), this.parseFloat(map, "fontSize"), "true".equals(map.get("bold")), "true".equals(map.get("italic")));
    }

    private HomeTexture createTexture(Map<String, String> map) throws SAXException {
        return new HomeTexture(new CatalogTexture(map.get("catalogId"), map.get("name"), this.parseContent(map.get("image")), this.parseFloat(map, "width"), this.parseFloat(map, "height"), null), map.get("angle") != null ? this.parseFloat(map, "angle") : 0.0f, !"false".equals(map.get("leftToRightOriented")));
    }

    private HomeMaterial createMaterial(Map<String, String> map) throws SAXException {
        return new HomeMaterial(map.get("name"), map.get("key"), this.parseOptionalColor(map, "color"), this.materialTexture, this.parseOptionalFloat(map, "shininess"));
    }

    private void setProperties(HomeObject homeObject) {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            homeObject.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private Integer parseOptionalColor(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return new Integer((int)Long.parseLong(string2, 16));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for color attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private Integer parseOptionalInteger(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for integer attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private Long parseOptionalLong(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for long attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private BigDecimal parseOptionalDecimal(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return new BigDecimal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for decimal attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private Float parseOptionalFloat(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return Float.valueOf(Float.parseFloat(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for float attribute " + string, numberFormatException);
            }
        }
        return null;
    }

    private float parseFloat(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Invalid value for float attribute " + string, numberFormatException);
            }
        }
        throw new SAXException("Missing float attribute " + string);
    }

    private Content parseContent(String string) throws SAXException {
        if (string != null) {
            try {
                return new ResourceURLContent(new URL(string), string.startsWith("jar:"));
            }
            catch (MalformedURLException malformedURLException) {
                if (this.contentContext != null) {
                    try {
                        return this.contentContext.lookupContent(string);
                    }
                    catch (IOException iOException) {
                        throw new SAXException("Invalid content " + string, iOException);
                    }
                }
                throw new SAXException("Missing URL base", malformedURLException);
            }
        }
        return null;
    }

    protected void setHome(Home home) {
        this.home = home;
        this.homeElementName = this.elements.peek();
    }

    public Home getHome() {
        return this.home;
    }

    private static final class JoinedWall {
        private final Wall wall;
        private final String wallAtStartId;
        private final String wallAtEndId;

        public JoinedWall(Wall wall, String string, String string2) {
            this.wall = wall;
            this.wallAtStartId = string;
            this.wallAtEndId = string2;
        }

        public Wall getWall() {
            return this.wall;
        }

        public String getWallAtStartId() {
            return this.wallAtStartId;
        }

        public String getWallAtEndId() {
            return this.wallAtEndId;
        }
    }
}

