/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class OutputFeedback
extends FeedbackCipher {
    private byte[] k = null;
    private byte[] register = null;
    private int numBytes;
    private byte[] registerSave = null;

    OutputFeedback(SymmetricCipher embeddedCipher, int numBytes) {
        super(embeddedCipher);
        if (numBytes > this.blockSize) {
            numBytes = this.blockSize;
        }
        this.numBytes = numBytes;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
    }

    @Override
    String getFeedback() {
        return "OFB";
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException {
        if (key == null || iv == null || iv.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = iv;
        this.reset();
        this.embeddedCipher.init(false, algorithm, key);
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
    }

    @Override
    void save() {
        if (this.registerSave == null) {
            this.registerSave = new byte[this.blockSize];
        }
        System.arraycopy(this.register, 0, this.registerSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.registerSave, 0, this.register, 0, this.blockSize);
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        int loopCount;
        int len = this.blockSize - this.numBytes;
        int oddBytes = plainLen % this.numBytes;
        if (len == 0) {
            int i;
            for (loopCount = plainLen / this.numBytes; loopCount > 0; --loopCount) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (i = 0; i < this.numBytes; ++i) {
                    cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                }
                System.arraycopy(this.k, 0, this.register, 0, this.numBytes);
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (i = 0; i < oddBytes; ++i) {
                    cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                }
                System.arraycopy(this.k, 0, this.register, 0, this.numBytes);
            }
        } else {
            int i;
            while (loopCount > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (i = 0; i < this.numBytes; ++i) {
                    cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                }
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                System.arraycopy(this.k, 0, this.register, len, this.numBytes);
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (i = 0; i < oddBytes; ++i) {
                    cipher[i + cipherOffset] = (byte)(this.k[i] ^ plain[i + plainOffset]);
                }
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                System.arraycopy(this.k, 0, this.register, len, this.numBytes);
            }
        }
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) {
        this.encrypt(cipher, cipherOffset, cipherLen, plain, plainOffset);
    }
}

