/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.InfixExpression;

public class ObjectProperty
extends InfixExpression {
    public void setNodeType(int n) {
        if (n != 103 && n != 151 && n != 152 && n != 163) {
            throw new IllegalArgumentException("invalid node type: " + n);
        }
        this.setType(n);
    }

    public ObjectProperty() {
        this.type = 103;
    }

    public ObjectProperty(int n) {
        super(n);
        this.type = 103;
    }

    public ObjectProperty(int n, int n2) {
        super(n, n2);
        this.type = 103;
    }

    public void setIsGetterMethod() {
        this.type = 151;
    }

    public boolean isGetterMethod() {
        return this.type == 151;
    }

    public void setIsSetterMethod() {
        this.type = 152;
    }

    public boolean isSetterMethod() {
        return this.type == 152;
    }

    public void setIsNormalMethod() {
        this.type = 163;
    }

    public boolean isNormalMethod() {
        return this.type == 163;
    }

    public boolean isMethod() {
        return this.isGetterMethod() || this.isSetterMethod() || this.isNormalMethod();
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(this.makeIndent(n + 1));
        if (this.isGetterMethod()) {
            stringBuilder.append("get ");
        } else if (this.isSetterMethod()) {
            stringBuilder.append("set ");
        }
        stringBuilder.append(this.left.toSource(this.getType() == 103 ? 0 : n));
        if (this.type == 103) {
            stringBuilder.append(": ");
        }
        stringBuilder.append(this.right.toSource(this.getType() == 103 ? 0 : n + 1));
        return stringBuilder.toString();
    }
}

