/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.contrib.TriangleRotationHandle;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class TriangleFigure
extends RectangleFigure {
    static double[] rotations = new double[]{-1.5707963267948966, -0.7853981633974483, 0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, -2.356194490192345};
    private int fRotation = 0;

    public TriangleFigure() {
        super(new Point(0, 0), new Point(0, 0));
    }

    public TriangleFigure(Point origin, Point corner) {
        super(origin, corner);
    }

    public Vector handles() {
        Vector h = super.handles();
        h.addElement(new TriangleRotationHandle(this));
        return h;
    }

    public void rotate(double angle) {
        this.willChange();
        double dist = Double.MAX_VALUE;
        int best = 0;
        for (int i = 0; i < rotations.length; ++i) {
            double d = Math.abs(angle - rotations[i]);
            if (!(d < dist)) continue;
            dist = d;
            best = i;
        }
        this.fRotation = best;
        this.changed();
    }

    public Polygon getPolygon() {
        Rectangle r = this.displayBox();
        Polygon p = new Polygon();
        switch (this.fRotation) {
            case 0: {
                p.addPoint(r.x + r.width / 2, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                p.addPoint(r.x, r.y + r.height);
                break;
            }
            case 1: {
                p.addPoint(r.x + r.width, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                p.addPoint(r.x, r.y);
                break;
            }
            case 2: {
                p.addPoint(r.x + r.width, r.y + r.height / 2);
                p.addPoint(r.x, r.y + r.height);
                p.addPoint(r.x, r.y);
                break;
            }
            case 3: {
                p.addPoint(r.x + r.width, r.y + r.height);
                p.addPoint(r.x, r.y + r.height);
                p.addPoint(r.x + r.width, r.y);
                break;
            }
            case 4: {
                p.addPoint(r.x + r.width / 2, r.y + r.height);
                p.addPoint(r.x, r.y);
                p.addPoint(r.x + r.width, r.y);
                break;
            }
            case 5: {
                p.addPoint(r.x, r.y + r.height);
                p.addPoint(r.x, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                break;
            }
            case 6: {
                p.addPoint(r.x, r.y + r.height / 2);
                p.addPoint(r.x + r.width, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                break;
            }
            case 7: {
                p.addPoint(r.x, r.y);
                p.addPoint(r.x + r.width, r.y);
                p.addPoint(r.x, r.y + r.height);
            }
        }
        return p;
    }

    public void draw(Graphics g) {
        Polygon p = this.getPolygon();
        g.setColor(this.getFillColor());
        g.fillPolygon(p);
        g.setColor(this.getFrameColor());
        g.drawPolygon(p);
    }

    public Insets connectionInsets() {
        Rectangle r = this.displayBox();
        switch (this.fRotation) {
            case 0: {
                return new Insets(r.height, r.width / 2, 0, r.width / 2);
            }
            case 1: {
                return new Insets(0, r.width, r.height, 0);
            }
            case 2: {
                return new Insets(r.height / 2, 0, r.height / 2, r.width);
            }
            case 3: {
                return new Insets(r.height, r.width, 0, 0);
            }
            case 4: {
                return new Insets(0, r.width / 2, r.height, r.width / 2);
            }
            case 5: {
                return new Insets(r.height, 0, 0, r.width);
            }
            case 6: {
                return new Insets(r.height / 2, r.width, r.height / 2, 0);
            }
            case 7: {
                return new Insets(0, 0, r.height, r.width);
            }
        }
        return null;
    }

    public boolean containsPoint(int x, int y) {
        return this.getPolygon().contains(x, y);
    }

    public Point center() {
        return PolygonFigure.center(this.getPolygon());
    }

    public Point chop(Point p) {
        return PolygonFigure.chop(this.getPolygon(), p);
    }

    public Object clone() {
        TriangleFigure figure = (TriangleFigure)super.clone();
        figure.fRotation = this.fRotation;
        return figure;
    }

    public double getRotationAngle() {
        return rotations[this.fRotation];
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fRotation);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fRotation = dr.readInt();
    }
}

