/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import CH.ifa.draw.util.StorageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;

public class StandardStorageFormat
implements StorageFormat {
    private FileFilter myFileFilter;
    private String myFileExtension;
    private String myFileDescription;

    public StandardStorageFormat() {
        this.setFileExtension(this.createFileExtension());
        this.setFileDescription(this.createFileDescription());
        this.setFileFilter(this.createFileFilter());
    }

    protected String createFileExtension() {
        this.myFileExtension = "draw";
        return "draw";
    }

    public void setFileExtension(String newFileExtension) {
        this.myFileExtension = newFileExtension;
    }

    public String getFileExtension() {
        return this.myFileExtension;
    }

    public String createFileDescription() {
        return "Internal Format (" + this.getFileExtension() + ")";
    }

    public void setFileDescription(String newFileDescription) {
        this.myFileDescription = newFileDescription;
    }

    public String getFileDescription() {
        return this.myFileDescription;
    }

    protected FileFilter createFileFilter() {
        return new FileFilter(){

            public boolean accept(File checkFile) {
                if (checkFile.isDirectory()) {
                    return true;
                }
                return checkFile.getName().endsWith("." + StandardStorageFormat.this.myFileExtension);
            }

            public String getDescription() {
                return StandardStorageFormat.this.getFileDescription();
            }
        };
    }

    public void setFileFilter(FileFilter newFileFilter) {
        this.myFileFilter = newFileFilter;
    }

    public FileFilter getFileFilter() {
        return this.myFileFilter;
    }

    public String store(String fileName, Drawing saveDrawing) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.adjustFileName(fileName));
        StorableOutput output = new StorableOutput(stream);
        output.writeStorable(saveDrawing);
        output.close();
        return this.adjustFileName(fileName);
    }

    public Drawing restore(String fileName) throws IOException {
        if (!this.hasCorrectFileExtension(fileName)) {
            return null;
        }
        FileInputStream stream = new FileInputStream(fileName);
        StorableInput input = new StorableInput(stream);
        return (Drawing)input.readStorable();
    }

    public boolean equals(Object compareObject) {
        if (compareObject instanceof StandardStorageFormat) {
            return this.getFileExtension().equals(((StandardStorageFormat)compareObject).getFileExtension());
        }
        return false;
    }

    protected String adjustFileName(String testFileName) {
        if (!this.hasCorrectFileExtension(testFileName)) {
            return testFileName + "." + this.getFileExtension();
        }
        return testFileName;
    }

    protected boolean hasCorrectFileExtension(String testFileName) {
        return testFileName.endsWith("." + this.getFileExtension());
    }
}

