/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.layout;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableLayout
extends GridBagLayout {
    public static final String NO_RESIZE = "* * 1 1 (0, 0) [0, 0, 0, 0] {0.0, 0.0}";
    public static final String RESIZE_WIDTH = "* * 1 1 (0, 0) [0, 0, 0, 0] {1.0, 0.0} w";
    public static final String RESIZE_HEIGHT = "* * 1 1 (0, 0) [0, 0, 0, 0] {0.0, 1.0} h";
    public static final String RESIZE_BOTH = "* * 1 1 (0, 0) [0, 0, 0, 0] {1.0, 1.0} wh";
    public static final String LEFT = "0 * [5 15 5 15] r";
    public static final String RIGHT = "1 * [5 15 5 15] lw";
    public static final String VERY_LEFT = "0 * [5 0 5 15] r";
    public static final String VERY_RIGHT = "1 * [5 15 5 0] lw";
    public static final String FULL = "0 * * 1 [5 15 5 15] w";
    public static final String COLUMN = "0 * wt";
    public static final String COLUMN_FILL = "0 * wh";
    private GridBagConstraints defaults;

    public TableLayout() {
        this(NO_RESIZE);
    }

    public TableLayout(String defaultOptions) {
        this.defaults = this.getGridBagConstraints(defaultOptions);
        if (this.defaults == null) {
            this.usage();
            this.defaults = new GridBagConstraints();
            System.err.println("Using Default GridBagConstraints.");
        }
    }

    public void usage() {
        System.err.println("Usage: gridx gridy gridwidth gridheight ( ipadx ipady ) [ top left bottom right ] { weightx weighty} options");
        System.err.println();
        System.err.println("you may use spaces or commas as separators.");
        System.err.println();
        System.err.println("  gridx and gridy are mandatory, can be * for RELATIVE");
        System.err.println("  gridwidth and gridheight are optional, can be * for REMAINDER");
        System.err.println("  ipadx and ipady are optional");
        System.err.println("  insets (top...right) are optional");
        System.err.println("  weights are optional and override any settings made to them by the options");
        System.err.println("  options are optional");
        System.err.println();
        System.err.println("Options may contain a set of characters which will set the corresponding");
        System.err.println("flag to true. If not set, the flag is false.");
        System.err.println();
        System.err.println("  \"r\" right align");
        System.err.println("  \"l\" left align");
        System.err.println("  \"t\" top align");
        System.err.println("  \"b\" bottom align");
        System.err.println("if none of these are set the component is placed in the center.");
        System.err.println();
        System.err.println("  \"w\" resize both cell and component in width");
        System.err.println("  \"W\" resize only cell in width");
        System.err.println("  \"h\" resize both cell and component in height");
        System.err.println("  \"H\" resize only cell in height");
        System.err.println("if none of these are set neither the component nor the cell is not resized.");
        System.err.println("and the extra space is put on the outside of the table.");
        System.err.println();
        System.err.println("The weight is calculated as follows, if not set explicitly by the {weight} section:");
        System.err.println("1.0 if character set, fill is set if lowercase.");
        System.err.println();
    }

    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, name);
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints instanceof String && (constraints = this.getGridBagConstraints((String)constraints)) == null) {
            this.usage();
            constraints = new GridBagConstraints();
            System.err.println("Using Default GridBagConstraints.");
        }
        super.addLayoutComponent(component, constraints);
    }

    public String toString() {
        return "[TableLayout: " + super.toString() + "]";
    }

    protected GridBagConstraints getGridBagConstraints(String name) {
        return TableLayout.getGridBagConstraints(name, this.defaults);
    }

    public static GridBagConstraints getGridBagConstraints(String name, GridBagConstraints def) {
        String ws = "\\s*";
        String s = "[\\s,]+";
        String d = "[+-]?\\d+";
        String gd = "([+-]?\\d+)";
        String gdstar = "((?:" + d + ")|\\*)";
        String gf = "([+-]?\\d*(?:\\.\\d*)?)";
        String go = "([tlbrWwHh]*)";
        String coordPattern = ws + gdstar + s + gdstar + "(?:" + s + gdstar + s + gdstar + ")?";
        String ipadPattern = ws + "(?:\\(" + ws + gd + s + gd + ws + "\\))?";
        String insetsPattern = ws + "(?:\\[" + ws + gd + s + gd + s + gd + s + gd + ws + "\\])?";
        String weightPattern = ws + "(?:\\{" + ws + gf + s + gf + ws + "\\})?";
        String optionPattern = ws + go;
        String restPattern = ws + "(.*)";
        Pattern pattern = Pattern.compile(coordPattern + ipadPattern + insetsPattern + weightPattern + optionPattern + restPattern);
        Matcher matcher = pattern.matcher(name);
        int nArgs = 14;
        if (!matcher.find()) {
            if (matcher.groupCount() != nArgs) {
                System.err.println("Expected " + nArgs + " arguments, but got " + matcher.groupCount() + " in '" + name + "'.");
            } else {
                System.err.println("Cannot parse '" + name + "'.");
            }
            return null;
        }
        try {
            int fill;
            int gridx = TableLayout.getPosition(matcher.group(1));
            int gridy = TableLayout.getPosition(matcher.group(2));
            int gridwidth = matcher.group(3) != null ? TableLayout.getSpan(matcher.group(3)) : def.gridwidth;
            int gridheight = matcher.group(4) != null ? TableLayout.getSpan(matcher.group(4)) : def.gridheight;
            int ipadx = matcher.group(5) != null ? Integer.parseInt(matcher.group(5)) : def.ipadx;
            int ipady = matcher.group(6) != null ? Integer.parseInt(matcher.group(6)) : def.ipady;
            Insets insets = matcher.group(7) != null ? new Insets(Integer.parseInt(matcher.group(7)), Integer.parseInt(matcher.group(8)), Integer.parseInt(matcher.group(9)), Integer.parseInt(matcher.group(10))) : def.insets;
            double weightx = matcher.group(11) != null ? Double.parseDouble(matcher.group(11)) : def.weightx;
            double weighty = matcher.group(12) != null ? Double.parseDouble(matcher.group(12)) : def.weighty;
            String options = matcher.group(13);
            int anchor = def != null ? def.anchor : 10;
            int n = fill = def != null ? def.fill : 0;
            if (options != null) {
                boolean fillHeight;
                boolean fillWidth;
                int position = 0;
                if (options.indexOf(108) >= 0 && options.indexOf(114) < 0) {
                    position |= 0x10;
                }
                if (options.indexOf(114) >= 0 && options.indexOf(108) < 0) {
                    position |= 0x20;
                }
                if (options.indexOf(116) >= 0 && options.indexOf(98) < 0) {
                    position |= 1;
                }
                if (options.indexOf(98) >= 0 && options.indexOf(116) < 0) {
                    position |= 2;
                }
                switch (position) {
                    default: {
                        break;
                    }
                    case 1: {
                        anchor = 11;
                        break;
                    }
                    case 2: {
                        anchor = 15;
                        break;
                    }
                    case 16: {
                        anchor = 17;
                        break;
                    }
                    case 17: {
                        anchor = 18;
                        break;
                    }
                    case 18: {
                        anchor = 16;
                        break;
                    }
                    case 32: {
                        anchor = 13;
                        break;
                    }
                    case 33: {
                        anchor = 12;
                        break;
                    }
                    case 34: {
                        anchor = 14;
                    }
                }
                switch (fill) {
                    default: {
                        fillWidth = false;
                        fillHeight = false;
                        break;
                    }
                    case 2: {
                        fillWidth = true;
                        fillHeight = false;
                        break;
                    }
                    case 3: {
                        fillWidth = false;
                        fillHeight = true;
                        break;
                    }
                    case 1: {
                        fillWidth = true;
                        fillHeight = true;
                    }
                }
                if (options.indexOf(119) >= 0) {
                    fillWidth = true;
                    if (matcher.group(11) == null) {
                        weightx = 1.0;
                    }
                }
                if (options.indexOf(87) >= 0 && matcher.group(11) == null) {
                    weightx = 1.0;
                }
                if (options.indexOf(104) >= 0) {
                    fillHeight = true;
                    if (matcher.group(12) == null) {
                        weighty = 1.0;
                    }
                }
                if (options.indexOf(72) >= 0 && matcher.group(12) == null) {
                    weighty = 1.0;
                }
                if (fillWidth) {
                    fill = fillHeight ? 1 : 2;
                } else if (fillHeight) {
                    fill = 3;
                }
                if (matcher.group(14) != null && !matcher.group(14).equals("")) {
                    System.err.println("Cannot parse: '" + matcher.group(14) + "' in '" + name + "'.");
                    return null;
                }
            }
            return new TableConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets, ipadx, ipady);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Problem " + nfe.getMessage() + " in '" + name + "'.");
            return null;
        }
    }

    private static int getPosition(String position) {
        if (position.equals("*")) {
            return -1;
        }
        return Integer.parseInt(position);
    }

    private static int getSpan(String span) {
        if (span.equals("*")) {
            return 0;
        }
        return Integer.parseInt(span);
    }

    public static String toString(GridBagConstraints c) {
        StringBuffer s = new StringBuffer();
        s.append(c.gridx == -1 ? "*" : String.valueOf(c.gridx));
        s.append(" ");
        s.append(c.gridy == -1 ? "*" : String.valueOf(c.gridy));
        s.append(" ");
        s.append(c.gridwidth == 0 ? "*" : String.valueOf(c.gridwidth));
        s.append(" ");
        s.append(c.gridheight == 0 ? "*" : String.valueOf(c.gridheight));
        s.append(" (");
        s.append(String.valueOf(c.ipadx));
        s.append(" ");
        s.append(String.valueOf(c.ipady));
        s.append(") [");
        s.append(String.valueOf(c.insets.top));
        s.append(" ");
        s.append(String.valueOf(c.insets.left));
        s.append(" ");
        s.append(String.valueOf(c.insets.bottom));
        s.append(" ");
        s.append(String.valueOf(c.insets.right));
        s.append("] {");
        s.append(String.valueOf(c.weightx));
        s.append(" ");
        s.append(String.valueOf(c.weighty));
        s.append("} ");
        switch (c.anchor) {
            default: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                s.append("t");
                break;
            }
            case 18: {
                s.append("tl");
                break;
            }
            case 17: {
                s.append("l");
                break;
            }
            case 16: {
                s.append("bl");
                break;
            }
            case 15: {
                s.append("b");
                break;
            }
            case 14: {
                s.append("br");
                break;
            }
            case 13: {
                s.append("r");
                break;
            }
            case 12: {
                s.append("tr");
            }
        }
        switch (c.fill) {
            default: {
                break;
            }
            case 0: {
                if (c.weightx == 1.0) {
                    s.append("W");
                }
                if (c.weighty != 1.0) break;
                s.append("H");
                break;
            }
            case 2: {
                s.append("w");
                if (c.weighty != 1.0) break;
                s.append("H");
                break;
            }
            case 3: {
                if (c.weightx == 1.0) {
                    s.append("W");
                }
                s.append("h");
                break;
            }
            case 1: {
                s.append("wh");
            }
        }
        return s.toString();
    }

    public static void main(String[] args) {
        TableLayout layout = new TableLayout();
        System.out.println(layout.getGridBagConstraints("1 2 3 4 (5 6) [7 8 9 10] {11 12} tlwh"));
        System.out.println(layout.getGridBagConstraints("1 2 3 4 [7 8 9 10] {11 12} trWh"));
        System.out.println(layout.getGridBagConstraints("1 2 3 4 (5 6) {11 12} tlwH"));
        System.out.println(layout.getGridBagConstraints("1 2 3 4 (5 6) [7 8 9 10] brwh"));
        System.out.println(layout.getGridBagConstraints("1 2 3 4 (5 6) tlWh"));
        System.out.println(layout.getGridBagConstraints("1 2 3 4"));
        System.out.println(layout.getGridBagConstraints("1 2"));
        System.out.println(layout.getGridBagConstraints("* * 2 4"));
        System.out.println(layout.getGridBagConstraints("* 0 2 4"));
        System.out.println(layout.getGridBagConstraints("0 * * *"));
        System.out.println(layout.getGridBagConstraints("0 0 * 4"));
    }

    public static class TableConstraints
    extends GridBagConstraints {
        public TableConstraints() {
        }

        public TableConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
            super(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets, ipadx, ipady);
        }

        public String toString() {
            return "TableConstraints: " + TableLayout.toString(this);
        }
    }
}

