/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.util.Callback;

public abstract class Streams {
    public static final int BUFFER_SIZE = 8192;

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, new byte[8192]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        long l;
        block6: {
            block5: {
                Objects.requireNonNull(in, "No InputStream specified");
                Objects.requireNonNull(out, "No OutputStream specified");
                boolean success = false;
                try {
                    int bytesRead;
                    long byteCount = 0L;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                        byteCount += (long)bytesRead;
                    }
                    out.flush();
                    success = true;
                    l = byteCount;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in, out});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in, out});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in, out});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in, out});
        }
        return l;
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Objects.requireNonNull(in, "No input byte array specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        int n;
        block6: {
            block5: {
                Objects.requireNonNull(in, "No Reader specified");
                Objects.requireNonNull(out, "No Writer specified");
                boolean success = false;
                try {
                    int bytesRead;
                    int byteCount = 0;
                    char[] buffer = new char[8192];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                        byteCount += bytesRead;
                    }
                    out.flush();
                    success = true;
                    n = byteCount;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in, out});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in, out});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in, out});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in, out});
        }
        return n;
    }

    public static void copy(String in, Writer out) throws IOException {
        Objects.requireNonNull(in, "No input String specified");
        Objects.requireNonNull(out, "No Writer specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        Streams.copy(in, (Writer)out);
        return out.toString();
    }

    public static int readFully(Reader reader, char[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(Reader reader, char[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static int readFully(InputStream reader, byte[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(InputStream reader, byte[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static List<String> readAllLines(InputStream input) throws IOException {
        final ArrayList<String> lines = new ArrayList<String>();
        Streams.readAllLines(input, new Callback<String>(){

            @Override
            public void handle(String line) {
                lines.add(line);
            }
        });
        return lines;
    }

    public static void readAllLines(InputStream input, Callback<String> callback) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                callback.handle(line);
            }
        }
    }

    public static BytesStream flushOnCloseStream(BytesStream os) {
        return new FlushOnCloseOutputStream(os);
    }

    private static class FlushOnCloseOutputStream
    extends BytesStream {
        private final BytesStream delegate;

        private FlushOnCloseOutputStream(BytesStream bytesStreamOutput) {
            this.delegate = bytesStreamOutput;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.delegate.writeByte(b);
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.delegate.writeBytes(b, offset, length);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public BytesReference bytes() {
            return this.delegate.bytes();
        }
    }
}

