/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

public class MapRectangleImpl
implements MapRectangle {
    private Coordinate topLeft;
    private Coordinate bottomRight;
    private Color color;
    private Stroke stroke;

    public MapRectangleImpl(Coordinate topLeft, Coordinate bottomRight) {
        this(topLeft, bottomRight, Color.BLUE, new BasicStroke(2.0f));
    }

    public MapRectangleImpl(Coordinate topLeft, Coordinate bottomRight, Color color, Stroke stroke) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.color = color;
        this.stroke = stroke;
    }

    @Override
    public Coordinate getTopLeft() {
        return this.topLeft;
    }

    @Override
    public Coordinate getBottomRight() {
        return this.bottomRight;
    }

    @Override
    public void paint(Graphics g, Point topLeft, Point bottomRight) {
        Color oldColor = g.getColor();
        g.setColor(this.color);
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            oldStroke = g2.getStroke();
            g2.setStroke(this.stroke);
        }
        g.drawRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        g.setColor(oldColor);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(oldStroke);
        }
    }

    public String toString() {
        return "MapRectangle from " + this.topLeft + " to " + this.bottomRight;
    }
}

