// autogenerated from gen/386.rules: do not edit!
// generated with: cd gen; go run *.go

package ssa

import "math"

var _ = math.MinInt8 // in case not otherwise used
func rewriteValue386(v *Value, config *Config) bool {
	switch v.Op {
	case Op386ADCL:
		return rewriteValue386_Op386ADCL(v, config)
	case Op386ADDL:
		return rewriteValue386_Op386ADDL(v, config)
	case Op386ADDLcarry:
		return rewriteValue386_Op386ADDLcarry(v, config)
	case Op386ADDLconst:
		return rewriteValue386_Op386ADDLconst(v, config)
	case Op386ANDL:
		return rewriteValue386_Op386ANDL(v, config)
	case Op386ANDLconst:
		return rewriteValue386_Op386ANDLconst(v, config)
	case Op386CMPB:
		return rewriteValue386_Op386CMPB(v, config)
	case Op386CMPBconst:
		return rewriteValue386_Op386CMPBconst(v, config)
	case Op386CMPL:
		return rewriteValue386_Op386CMPL(v, config)
	case Op386CMPLconst:
		return rewriteValue386_Op386CMPLconst(v, config)
	case Op386CMPW:
		return rewriteValue386_Op386CMPW(v, config)
	case Op386CMPWconst:
		return rewriteValue386_Op386CMPWconst(v, config)
	case Op386LEAL:
		return rewriteValue386_Op386LEAL(v, config)
	case Op386LEAL1:
		return rewriteValue386_Op386LEAL1(v, config)
	case Op386LEAL2:
		return rewriteValue386_Op386LEAL2(v, config)
	case Op386LEAL4:
		return rewriteValue386_Op386LEAL4(v, config)
	case Op386LEAL8:
		return rewriteValue386_Op386LEAL8(v, config)
	case Op386MOVBLSX:
		return rewriteValue386_Op386MOVBLSX(v, config)
	case Op386MOVBLSXload:
		return rewriteValue386_Op386MOVBLSXload(v, config)
	case Op386MOVBLZX:
		return rewriteValue386_Op386MOVBLZX(v, config)
	case Op386MOVBload:
		return rewriteValue386_Op386MOVBload(v, config)
	case Op386MOVBloadidx1:
		return rewriteValue386_Op386MOVBloadidx1(v, config)
	case Op386MOVBstore:
		return rewriteValue386_Op386MOVBstore(v, config)
	case Op386MOVBstoreconst:
		return rewriteValue386_Op386MOVBstoreconst(v, config)
	case Op386MOVBstoreconstidx1:
		return rewriteValue386_Op386MOVBstoreconstidx1(v, config)
	case Op386MOVBstoreidx1:
		return rewriteValue386_Op386MOVBstoreidx1(v, config)
	case Op386MOVLload:
		return rewriteValue386_Op386MOVLload(v, config)
	case Op386MOVLloadidx1:
		return rewriteValue386_Op386MOVLloadidx1(v, config)
	case Op386MOVLloadidx4:
		return rewriteValue386_Op386MOVLloadidx4(v, config)
	case Op386MOVLstore:
		return rewriteValue386_Op386MOVLstore(v, config)
	case Op386MOVLstoreconst:
		return rewriteValue386_Op386MOVLstoreconst(v, config)
	case Op386MOVLstoreconstidx1:
		return rewriteValue386_Op386MOVLstoreconstidx1(v, config)
	case Op386MOVLstoreconstidx4:
		return rewriteValue386_Op386MOVLstoreconstidx4(v, config)
	case Op386MOVLstoreidx1:
		return rewriteValue386_Op386MOVLstoreidx1(v, config)
	case Op386MOVLstoreidx4:
		return rewriteValue386_Op386MOVLstoreidx4(v, config)
	case Op386MOVSDconst:
		return rewriteValue386_Op386MOVSDconst(v, config)
	case Op386MOVSDload:
		return rewriteValue386_Op386MOVSDload(v, config)
	case Op386MOVSDloadidx1:
		return rewriteValue386_Op386MOVSDloadidx1(v, config)
	case Op386MOVSDloadidx8:
		return rewriteValue386_Op386MOVSDloadidx8(v, config)
	case Op386MOVSDstore:
		return rewriteValue386_Op386MOVSDstore(v, config)
	case Op386MOVSDstoreidx1:
		return rewriteValue386_Op386MOVSDstoreidx1(v, config)
	case Op386MOVSDstoreidx8:
		return rewriteValue386_Op386MOVSDstoreidx8(v, config)
	case Op386MOVSSconst:
		return rewriteValue386_Op386MOVSSconst(v, config)
	case Op386MOVSSload:
		return rewriteValue386_Op386MOVSSload(v, config)
	case Op386MOVSSloadidx1:
		return rewriteValue386_Op386MOVSSloadidx1(v, config)
	case Op386MOVSSloadidx4:
		return rewriteValue386_Op386MOVSSloadidx4(v, config)
	case Op386MOVSSstore:
		return rewriteValue386_Op386MOVSSstore(v, config)
	case Op386MOVSSstoreidx1:
		return rewriteValue386_Op386MOVSSstoreidx1(v, config)
	case Op386MOVSSstoreidx4:
		return rewriteValue386_Op386MOVSSstoreidx4(v, config)
	case Op386MOVWLSX:
		return rewriteValue386_Op386MOVWLSX(v, config)
	case Op386MOVWLSXload:
		return rewriteValue386_Op386MOVWLSXload(v, config)
	case Op386MOVWLZX:
		return rewriteValue386_Op386MOVWLZX(v, config)
	case Op386MOVWload:
		return rewriteValue386_Op386MOVWload(v, config)
	case Op386MOVWloadidx1:
		return rewriteValue386_Op386MOVWloadidx1(v, config)
	case Op386MOVWloadidx2:
		return rewriteValue386_Op386MOVWloadidx2(v, config)
	case Op386MOVWstore:
		return rewriteValue386_Op386MOVWstore(v, config)
	case Op386MOVWstoreconst:
		return rewriteValue386_Op386MOVWstoreconst(v, config)
	case Op386MOVWstoreconstidx1:
		return rewriteValue386_Op386MOVWstoreconstidx1(v, config)
	case Op386MOVWstoreconstidx2:
		return rewriteValue386_Op386MOVWstoreconstidx2(v, config)
	case Op386MOVWstoreidx1:
		return rewriteValue386_Op386MOVWstoreidx1(v, config)
	case Op386MOVWstoreidx2:
		return rewriteValue386_Op386MOVWstoreidx2(v, config)
	case Op386MULL:
		return rewriteValue386_Op386MULL(v, config)
	case Op386MULLconst:
		return rewriteValue386_Op386MULLconst(v, config)
	case Op386NEGL:
		return rewriteValue386_Op386NEGL(v, config)
	case Op386NOTL:
		return rewriteValue386_Op386NOTL(v, config)
	case Op386ORL:
		return rewriteValue386_Op386ORL(v, config)
	case Op386ORLconst:
		return rewriteValue386_Op386ORLconst(v, config)
	case Op386ROLBconst:
		return rewriteValue386_Op386ROLBconst(v, config)
	case Op386ROLLconst:
		return rewriteValue386_Op386ROLLconst(v, config)
	case Op386ROLWconst:
		return rewriteValue386_Op386ROLWconst(v, config)
	case Op386SARB:
		return rewriteValue386_Op386SARB(v, config)
	case Op386SARBconst:
		return rewriteValue386_Op386SARBconst(v, config)
	case Op386SARL:
		return rewriteValue386_Op386SARL(v, config)
	case Op386SARLconst:
		return rewriteValue386_Op386SARLconst(v, config)
	case Op386SARW:
		return rewriteValue386_Op386SARW(v, config)
	case Op386SARWconst:
		return rewriteValue386_Op386SARWconst(v, config)
	case Op386SBBL:
		return rewriteValue386_Op386SBBL(v, config)
	case Op386SBBLcarrymask:
		return rewriteValue386_Op386SBBLcarrymask(v, config)
	case Op386SETA:
		return rewriteValue386_Op386SETA(v, config)
	case Op386SETAE:
		return rewriteValue386_Op386SETAE(v, config)
	case Op386SETB:
		return rewriteValue386_Op386SETB(v, config)
	case Op386SETBE:
		return rewriteValue386_Op386SETBE(v, config)
	case Op386SETEQ:
		return rewriteValue386_Op386SETEQ(v, config)
	case Op386SETG:
		return rewriteValue386_Op386SETG(v, config)
	case Op386SETGE:
		return rewriteValue386_Op386SETGE(v, config)
	case Op386SETL:
		return rewriteValue386_Op386SETL(v, config)
	case Op386SETLE:
		return rewriteValue386_Op386SETLE(v, config)
	case Op386SETNE:
		return rewriteValue386_Op386SETNE(v, config)
	case Op386SHLL:
		return rewriteValue386_Op386SHLL(v, config)
	case Op386SHRB:
		return rewriteValue386_Op386SHRB(v, config)
	case Op386SHRL:
		return rewriteValue386_Op386SHRL(v, config)
	case Op386SHRW:
		return rewriteValue386_Op386SHRW(v, config)
	case Op386SUBL:
		return rewriteValue386_Op386SUBL(v, config)
	case Op386SUBLcarry:
		return rewriteValue386_Op386SUBLcarry(v, config)
	case Op386SUBLconst:
		return rewriteValue386_Op386SUBLconst(v, config)
	case Op386XORL:
		return rewriteValue386_Op386XORL(v, config)
	case Op386XORLconst:
		return rewriteValue386_Op386XORLconst(v, config)
	case OpAdd16:
		return rewriteValue386_OpAdd16(v, config)
	case OpAdd32:
		return rewriteValue386_OpAdd32(v, config)
	case OpAdd32F:
		return rewriteValue386_OpAdd32F(v, config)
	case OpAdd32carry:
		return rewriteValue386_OpAdd32carry(v, config)
	case OpAdd32withcarry:
		return rewriteValue386_OpAdd32withcarry(v, config)
	case OpAdd64F:
		return rewriteValue386_OpAdd64F(v, config)
	case OpAdd8:
		return rewriteValue386_OpAdd8(v, config)
	case OpAddPtr:
		return rewriteValue386_OpAddPtr(v, config)
	case OpAddr:
		return rewriteValue386_OpAddr(v, config)
	case OpAnd16:
		return rewriteValue386_OpAnd16(v, config)
	case OpAnd32:
		return rewriteValue386_OpAnd32(v, config)
	case OpAnd8:
		return rewriteValue386_OpAnd8(v, config)
	case OpAndB:
		return rewriteValue386_OpAndB(v, config)
	case OpBswap32:
		return rewriteValue386_OpBswap32(v, config)
	case OpClosureCall:
		return rewriteValue386_OpClosureCall(v, config)
	case OpCom16:
		return rewriteValue386_OpCom16(v, config)
	case OpCom32:
		return rewriteValue386_OpCom32(v, config)
	case OpCom8:
		return rewriteValue386_OpCom8(v, config)
	case OpConst16:
		return rewriteValue386_OpConst16(v, config)
	case OpConst32:
		return rewriteValue386_OpConst32(v, config)
	case OpConst32F:
		return rewriteValue386_OpConst32F(v, config)
	case OpConst64F:
		return rewriteValue386_OpConst64F(v, config)
	case OpConst8:
		return rewriteValue386_OpConst8(v, config)
	case OpConstBool:
		return rewriteValue386_OpConstBool(v, config)
	case OpConstNil:
		return rewriteValue386_OpConstNil(v, config)
	case OpConvert:
		return rewriteValue386_OpConvert(v, config)
	case OpCvt32Fto32:
		return rewriteValue386_OpCvt32Fto32(v, config)
	case OpCvt32Fto64F:
		return rewriteValue386_OpCvt32Fto64F(v, config)
	case OpCvt32to32F:
		return rewriteValue386_OpCvt32to32F(v, config)
	case OpCvt32to64F:
		return rewriteValue386_OpCvt32to64F(v, config)
	case OpCvt64Fto32:
		return rewriteValue386_OpCvt64Fto32(v, config)
	case OpCvt64Fto32F:
		return rewriteValue386_OpCvt64Fto32F(v, config)
	case OpDeferCall:
		return rewriteValue386_OpDeferCall(v, config)
	case OpDiv16:
		return rewriteValue386_OpDiv16(v, config)
	case OpDiv16u:
		return rewriteValue386_OpDiv16u(v, config)
	case OpDiv32:
		return rewriteValue386_OpDiv32(v, config)
	case OpDiv32F:
		return rewriteValue386_OpDiv32F(v, config)
	case OpDiv32u:
		return rewriteValue386_OpDiv32u(v, config)
	case OpDiv64F:
		return rewriteValue386_OpDiv64F(v, config)
	case OpDiv8:
		return rewriteValue386_OpDiv8(v, config)
	case OpDiv8u:
		return rewriteValue386_OpDiv8u(v, config)
	case OpEq16:
		return rewriteValue386_OpEq16(v, config)
	case OpEq32:
		return rewriteValue386_OpEq32(v, config)
	case OpEq32F:
		return rewriteValue386_OpEq32F(v, config)
	case OpEq64F:
		return rewriteValue386_OpEq64F(v, config)
	case OpEq8:
		return rewriteValue386_OpEq8(v, config)
	case OpEqB:
		return rewriteValue386_OpEqB(v, config)
	case OpEqPtr:
		return rewriteValue386_OpEqPtr(v, config)
	case OpGeq16:
		return rewriteValue386_OpGeq16(v, config)
	case OpGeq16U:
		return rewriteValue386_OpGeq16U(v, config)
	case OpGeq32:
		return rewriteValue386_OpGeq32(v, config)
	case OpGeq32F:
		return rewriteValue386_OpGeq32F(v, config)
	case OpGeq32U:
		return rewriteValue386_OpGeq32U(v, config)
	case OpGeq64F:
		return rewriteValue386_OpGeq64F(v, config)
	case OpGeq8:
		return rewriteValue386_OpGeq8(v, config)
	case OpGeq8U:
		return rewriteValue386_OpGeq8U(v, config)
	case OpGetClosurePtr:
		return rewriteValue386_OpGetClosurePtr(v, config)
	case OpGetG:
		return rewriteValue386_OpGetG(v, config)
	case OpGoCall:
		return rewriteValue386_OpGoCall(v, config)
	case OpGreater16:
		return rewriteValue386_OpGreater16(v, config)
	case OpGreater16U:
		return rewriteValue386_OpGreater16U(v, config)
	case OpGreater32:
		return rewriteValue386_OpGreater32(v, config)
	case OpGreater32F:
		return rewriteValue386_OpGreater32F(v, config)
	case OpGreater32U:
		return rewriteValue386_OpGreater32U(v, config)
	case OpGreater64F:
		return rewriteValue386_OpGreater64F(v, config)
	case OpGreater8:
		return rewriteValue386_OpGreater8(v, config)
	case OpGreater8U:
		return rewriteValue386_OpGreater8U(v, config)
	case OpHmul16:
		return rewriteValue386_OpHmul16(v, config)
	case OpHmul16u:
		return rewriteValue386_OpHmul16u(v, config)
	case OpHmul32:
		return rewriteValue386_OpHmul32(v, config)
	case OpHmul32u:
		return rewriteValue386_OpHmul32u(v, config)
	case OpHmul8:
		return rewriteValue386_OpHmul8(v, config)
	case OpHmul8u:
		return rewriteValue386_OpHmul8u(v, config)
	case OpInterCall:
		return rewriteValue386_OpInterCall(v, config)
	case OpIsInBounds:
		return rewriteValue386_OpIsInBounds(v, config)
	case OpIsNonNil:
		return rewriteValue386_OpIsNonNil(v, config)
	case OpIsSliceInBounds:
		return rewriteValue386_OpIsSliceInBounds(v, config)
	case OpLeq16:
		return rewriteValue386_OpLeq16(v, config)
	case OpLeq16U:
		return rewriteValue386_OpLeq16U(v, config)
	case OpLeq32:
		return rewriteValue386_OpLeq32(v, config)
	case OpLeq32F:
		return rewriteValue386_OpLeq32F(v, config)
	case OpLeq32U:
		return rewriteValue386_OpLeq32U(v, config)
	case OpLeq64F:
		return rewriteValue386_OpLeq64F(v, config)
	case OpLeq8:
		return rewriteValue386_OpLeq8(v, config)
	case OpLeq8U:
		return rewriteValue386_OpLeq8U(v, config)
	case OpLess16:
		return rewriteValue386_OpLess16(v, config)
	case OpLess16U:
		return rewriteValue386_OpLess16U(v, config)
	case OpLess32:
		return rewriteValue386_OpLess32(v, config)
	case OpLess32F:
		return rewriteValue386_OpLess32F(v, config)
	case OpLess32U:
		return rewriteValue386_OpLess32U(v, config)
	case OpLess64F:
		return rewriteValue386_OpLess64F(v, config)
	case OpLess8:
		return rewriteValue386_OpLess8(v, config)
	case OpLess8U:
		return rewriteValue386_OpLess8U(v, config)
	case OpLoad:
		return rewriteValue386_OpLoad(v, config)
	case OpLrot16:
		return rewriteValue386_OpLrot16(v, config)
	case OpLrot32:
		return rewriteValue386_OpLrot32(v, config)
	case OpLrot8:
		return rewriteValue386_OpLrot8(v, config)
	case OpLsh16x16:
		return rewriteValue386_OpLsh16x16(v, config)
	case OpLsh16x32:
		return rewriteValue386_OpLsh16x32(v, config)
	case OpLsh16x64:
		return rewriteValue386_OpLsh16x64(v, config)
	case OpLsh16x8:
		return rewriteValue386_OpLsh16x8(v, config)
	case OpLsh32x16:
		return rewriteValue386_OpLsh32x16(v, config)
	case OpLsh32x32:
		return rewriteValue386_OpLsh32x32(v, config)
	case OpLsh32x64:
		return rewriteValue386_OpLsh32x64(v, config)
	case OpLsh32x8:
		return rewriteValue386_OpLsh32x8(v, config)
	case OpLsh8x16:
		return rewriteValue386_OpLsh8x16(v, config)
	case OpLsh8x32:
		return rewriteValue386_OpLsh8x32(v, config)
	case OpLsh8x64:
		return rewriteValue386_OpLsh8x64(v, config)
	case OpLsh8x8:
		return rewriteValue386_OpLsh8x8(v, config)
	case OpMod16:
		return rewriteValue386_OpMod16(v, config)
	case OpMod16u:
		return rewriteValue386_OpMod16u(v, config)
	case OpMod32:
		return rewriteValue386_OpMod32(v, config)
	case OpMod32u:
		return rewriteValue386_OpMod32u(v, config)
	case OpMod8:
		return rewriteValue386_OpMod8(v, config)
	case OpMod8u:
		return rewriteValue386_OpMod8u(v, config)
	case OpMove:
		return rewriteValue386_OpMove(v, config)
	case OpMul16:
		return rewriteValue386_OpMul16(v, config)
	case OpMul32:
		return rewriteValue386_OpMul32(v, config)
	case OpMul32F:
		return rewriteValue386_OpMul32F(v, config)
	case OpMul32uhilo:
		return rewriteValue386_OpMul32uhilo(v, config)
	case OpMul64F:
		return rewriteValue386_OpMul64F(v, config)
	case OpMul8:
		return rewriteValue386_OpMul8(v, config)
	case OpNeg16:
		return rewriteValue386_OpNeg16(v, config)
	case OpNeg32:
		return rewriteValue386_OpNeg32(v, config)
	case OpNeg32F:
		return rewriteValue386_OpNeg32F(v, config)
	case OpNeg64F:
		return rewriteValue386_OpNeg64F(v, config)
	case OpNeg8:
		return rewriteValue386_OpNeg8(v, config)
	case OpNeq16:
		return rewriteValue386_OpNeq16(v, config)
	case OpNeq32:
		return rewriteValue386_OpNeq32(v, config)
	case OpNeq32F:
		return rewriteValue386_OpNeq32F(v, config)
	case OpNeq64F:
		return rewriteValue386_OpNeq64F(v, config)
	case OpNeq8:
		return rewriteValue386_OpNeq8(v, config)
	case OpNeqB:
		return rewriteValue386_OpNeqB(v, config)
	case OpNeqPtr:
		return rewriteValue386_OpNeqPtr(v, config)
	case OpNilCheck:
		return rewriteValue386_OpNilCheck(v, config)
	case OpNot:
		return rewriteValue386_OpNot(v, config)
	case OpOffPtr:
		return rewriteValue386_OpOffPtr(v, config)
	case OpOr16:
		return rewriteValue386_OpOr16(v, config)
	case OpOr32:
		return rewriteValue386_OpOr32(v, config)
	case OpOr8:
		return rewriteValue386_OpOr8(v, config)
	case OpOrB:
		return rewriteValue386_OpOrB(v, config)
	case OpRsh16Ux16:
		return rewriteValue386_OpRsh16Ux16(v, config)
	case OpRsh16Ux32:
		return rewriteValue386_OpRsh16Ux32(v, config)
	case OpRsh16Ux64:
		return rewriteValue386_OpRsh16Ux64(v, config)
	case OpRsh16Ux8:
		return rewriteValue386_OpRsh16Ux8(v, config)
	case OpRsh16x16:
		return rewriteValue386_OpRsh16x16(v, config)
	case OpRsh16x32:
		return rewriteValue386_OpRsh16x32(v, config)
	case OpRsh16x64:
		return rewriteValue386_OpRsh16x64(v, config)
	case OpRsh16x8:
		return rewriteValue386_OpRsh16x8(v, config)
	case OpRsh32Ux16:
		return rewriteValue386_OpRsh32Ux16(v, config)
	case OpRsh32Ux32:
		return rewriteValue386_OpRsh32Ux32(v, config)
	case OpRsh32Ux64:
		return rewriteValue386_OpRsh32Ux64(v, config)
	case OpRsh32Ux8:
		return rewriteValue386_OpRsh32Ux8(v, config)
	case OpRsh32x16:
		return rewriteValue386_OpRsh32x16(v, config)
	case OpRsh32x32:
		return rewriteValue386_OpRsh32x32(v, config)
	case OpRsh32x64:
		return rewriteValue386_OpRsh32x64(v, config)
	case OpRsh32x8:
		return rewriteValue386_OpRsh32x8(v, config)
	case OpRsh8Ux16:
		return rewriteValue386_OpRsh8Ux16(v, config)
	case OpRsh8Ux32:
		return rewriteValue386_OpRsh8Ux32(v, config)
	case OpRsh8Ux64:
		return rewriteValue386_OpRsh8Ux64(v, config)
	case OpRsh8Ux8:
		return rewriteValue386_OpRsh8Ux8(v, config)
	case OpRsh8x16:
		return rewriteValue386_OpRsh8x16(v, config)
	case OpRsh8x32:
		return rewriteValue386_OpRsh8x32(v, config)
	case OpRsh8x64:
		return rewriteValue386_OpRsh8x64(v, config)
	case OpRsh8x8:
		return rewriteValue386_OpRsh8x8(v, config)
	case OpSignExt16to32:
		return rewriteValue386_OpSignExt16to32(v, config)
	case OpSignExt8to16:
		return rewriteValue386_OpSignExt8to16(v, config)
	case OpSignExt8to32:
		return rewriteValue386_OpSignExt8to32(v, config)
	case OpSignmask:
		return rewriteValue386_OpSignmask(v, config)
	case OpSlicemask:
		return rewriteValue386_OpSlicemask(v, config)
	case OpSqrt:
		return rewriteValue386_OpSqrt(v, config)
	case OpStaticCall:
		return rewriteValue386_OpStaticCall(v, config)
	case OpStore:
		return rewriteValue386_OpStore(v, config)
	case OpSub16:
		return rewriteValue386_OpSub16(v, config)
	case OpSub32:
		return rewriteValue386_OpSub32(v, config)
	case OpSub32F:
		return rewriteValue386_OpSub32F(v, config)
	case OpSub32carry:
		return rewriteValue386_OpSub32carry(v, config)
	case OpSub32withcarry:
		return rewriteValue386_OpSub32withcarry(v, config)
	case OpSub64F:
		return rewriteValue386_OpSub64F(v, config)
	case OpSub8:
		return rewriteValue386_OpSub8(v, config)
	case OpSubPtr:
		return rewriteValue386_OpSubPtr(v, config)
	case OpTrunc16to8:
		return rewriteValue386_OpTrunc16to8(v, config)
	case OpTrunc32to16:
		return rewriteValue386_OpTrunc32to16(v, config)
	case OpTrunc32to8:
		return rewriteValue386_OpTrunc32to8(v, config)
	case OpXor16:
		return rewriteValue386_OpXor16(v, config)
	case OpXor32:
		return rewriteValue386_OpXor32(v, config)
	case OpXor8:
		return rewriteValue386_OpXor8(v, config)
	case OpZero:
		return rewriteValue386_OpZero(v, config)
	case OpZeroExt16to32:
		return rewriteValue386_OpZeroExt16to32(v, config)
	case OpZeroExt8to16:
		return rewriteValue386_OpZeroExt8to16(v, config)
	case OpZeroExt8to32:
		return rewriteValue386_OpZeroExt8to32(v, config)
	case OpZeromask:
		return rewriteValue386_OpZeromask(v, config)
	}
	return false
}
func rewriteValue386_Op386ADCL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADCL x (MOVLconst [c]) f)
	// cond:
	// result: (ADCLconst [c] x f)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		f := v.Args[2]
		v.reset(Op386ADCLconst)
		v.AuxInt = c
		v.AddArg(x)
		v.AddArg(f)
		return true
	}
	// match: (ADCL (MOVLconst [c]) x f)
	// cond:
	// result: (ADCLconst [c] x f)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		f := v.Args[2]
		v.reset(Op386ADCLconst)
		v.AuxInt = c
		v.AddArg(x)
		v.AddArg(f)
		return true
	}
	return false
}
func rewriteValue386_Op386ADDL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADDL x (MOVLconst [c]))
	// cond:
	// result: (ADDLconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386ADDLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADDL (MOVLconst [c]) x)
	// cond:
	// result: (ADDLconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386ADDLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADDL x (SHLLconst [3] y))
	// cond:
	// result: (LEAL8 x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 3 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL8)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDL x (SHLLconst [2] y))
	// cond:
	// result: (LEAL4 x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 2 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL4)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDL x (SHLLconst [1] y))
	// cond:
	// result: (LEAL2 x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 1 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDL x (ADDL y y))
	// cond:
	// result: (LEAL2 x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDL {
			break
		}
		y := v_1.Args[0]
		if y != v_1.Args[1] {
			break
		}
		v.reset(Op386LEAL2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDL x (ADDL x y))
	// cond:
	// result: (LEAL2 y x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDL {
			break
		}
		if x != v_1.Args[0] {
			break
		}
		y := v_1.Args[1]
		v.reset(Op386LEAL2)
		v.AddArg(y)
		v.AddArg(x)
		return true
	}
	// match: (ADDL x (ADDL y x))
	// cond:
	// result: (LEAL2 y x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDL {
			break
		}
		y := v_1.Args[0]
		if x != v_1.Args[1] {
			break
		}
		v.reset(Op386LEAL2)
		v.AddArg(y)
		v.AddArg(x)
		return true
	}
	// match: (ADDL (ADDLconst [c] x) y)
	// cond:
	// result: (LEAL1 [c] x y)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		c := v_0.AuxInt
		x := v_0.Args[0]
		y := v.Args[1]
		v.reset(Op386LEAL1)
		v.AuxInt = c
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDL x (ADDLconst [c] y))
	// cond:
	// result: (LEAL1 [c] x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		c := v_1.AuxInt
		y := v_1.Args[0]
		v.reset(Op386LEAL1)
		v.AuxInt = c
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDL x (LEAL [c] {s} y))
	// cond: x.Op != OpSB && y.Op != OpSB
	// result: (LEAL1 [c] {s} x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386LEAL {
			break
		}
		c := v_1.AuxInt
		s := v_1.Aux
		y := v_1.Args[0]
		if !(x.Op != OpSB && y.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDL (LEAL [c] {s} x) y)
	// cond: x.Op != OpSB && y.Op != OpSB
	// result: (LEAL1 [c] {s} x y)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		c := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		y := v.Args[1]
		if !(x.Op != OpSB && y.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDL x (NEGL y))
	// cond:
	// result: (SUBL x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386NEGL {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386SUBL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386ADDLcarry(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADDLcarry x (MOVLconst [c]))
	// cond:
	// result: (ADDLconstcarry [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386ADDLconstcarry)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADDLcarry (MOVLconst [c]) x)
	// cond:
	// result: (ADDLconstcarry [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386ADDLconstcarry)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386ADDLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADDLconst [c] (ADDL x y))
	// cond:
	// result: (LEAL1 [c] x y)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		x := v_0.Args[0]
		y := v_0.Args[1]
		v.reset(Op386LEAL1)
		v.AuxInt = c
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDLconst [c] (LEAL [d] {s} x))
	// cond: is32Bit(c+d)
	// result: (LEAL [c+d] {s} x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		d := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		if !(is32Bit(c + d)) {
			break
		}
		v.reset(Op386LEAL)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		return true
	}
	// match: (ADDLconst [c] (LEAL1 [d] {s} x y))
	// cond: is32Bit(c+d)
	// result: (LEAL1 [c+d] {s} x y)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		d := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is32Bit(c + d)) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDLconst [c] (LEAL2 [d] {s} x y))
	// cond: is32Bit(c+d)
	// result: (LEAL2 [c+d] {s} x y)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL2 {
			break
		}
		d := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is32Bit(c + d)) {
			break
		}
		v.reset(Op386LEAL2)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDLconst [c] (LEAL4 [d] {s} x y))
	// cond: is32Bit(c+d)
	// result: (LEAL4 [c+d] {s} x y)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL4 {
			break
		}
		d := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is32Bit(c + d)) {
			break
		}
		v.reset(Op386LEAL4)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDLconst [c] (LEAL8 [d] {s} x y))
	// cond: is32Bit(c+d)
	// result: (LEAL8 [c+d] {s} x y)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL8 {
			break
		}
		d := v_0.AuxInt
		s := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is32Bit(c + d)) {
			break
		}
		v.reset(Op386LEAL8)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDLconst [c] x)
	// cond: int32(c)==0
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ADDLconst [c] (MOVLconst [d]))
	// cond:
	// result: (MOVLconst [int64(int32(c+d))])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		d := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = int64(int32(c + d))
		return true
	}
	// match: (ADDLconst [c] (ADDLconst [d] x))
	// cond:
	// result: (ADDLconst [int64(int32(c+d))] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386ADDLconst)
		v.AuxInt = int64(int32(c + d))
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386ANDL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ANDL x (MOVLconst [c]))
	// cond:
	// result: (ANDLconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386ANDLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ANDL (MOVLconst [c]) x)
	// cond:
	// result: (ANDLconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386ANDLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ANDL x x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386ANDLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ANDLconst [c] (ANDLconst [d] x))
	// cond:
	// result: (ANDLconst [c & d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386ANDLconst)
		v.AuxInt = c & d
		v.AddArg(x)
		return true
	}
	// match: (ANDLconst [c] _)
	// cond: int32(c)==0
	// result: (MOVLconst [0])
	for {
		c := v.AuxInt
		if !(int32(c) == 0) {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (ANDLconst [c] x)
	// cond: int32(c)==-1
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == -1) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ANDLconst [c] (MOVLconst [d]))
	// cond:
	// result: (MOVLconst [c&d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		d := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = c & d
		return true
	}
	return false
}
func rewriteValue386_Op386CMPB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPB x (MOVLconst [c]))
	// cond:
	// result: (CMPBconst x [int64(int8(c))])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386CMPBconst)
		v.AuxInt = int64(int8(c))
		v.AddArg(x)
		return true
	}
	// match: (CMPB (MOVLconst [c]) x)
	// cond:
	// result: (InvertFlags (CMPBconst x [int64(int8(c))]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386InvertFlags)
		v0 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v0.AuxInt = int64(int8(c))
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValue386_Op386CMPBconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPBconst (MOVLconst [x]) [y])
	// cond: int8(x)==int8(y)
	// result: (FlagEQ)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int8(x) == int8(y)) {
			break
		}
		v.reset(Op386FlagEQ)
		return true
	}
	// match: (CMPBconst (MOVLconst [x]) [y])
	// cond: int8(x)<int8(y) && uint8(x)<uint8(y)
	// result: (FlagLT_ULT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int8(x) < int8(y) && uint8(x) < uint8(y)) {
			break
		}
		v.reset(Op386FlagLT_ULT)
		return true
	}
	// match: (CMPBconst (MOVLconst [x]) [y])
	// cond: int8(x)<int8(y) && uint8(x)>uint8(y)
	// result: (FlagLT_UGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int8(x) < int8(y) && uint8(x) > uint8(y)) {
			break
		}
		v.reset(Op386FlagLT_UGT)
		return true
	}
	// match: (CMPBconst (MOVLconst [x]) [y])
	// cond: int8(x)>int8(y) && uint8(x)<uint8(y)
	// result: (FlagGT_ULT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int8(x) > int8(y) && uint8(x) < uint8(y)) {
			break
		}
		v.reset(Op386FlagGT_ULT)
		return true
	}
	// match: (CMPBconst (MOVLconst [x]) [y])
	// cond: int8(x)>int8(y) && uint8(x)>uint8(y)
	// result: (FlagGT_UGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int8(x) > int8(y) && uint8(x) > uint8(y)) {
			break
		}
		v.reset(Op386FlagGT_UGT)
		return true
	}
	// match: (CMPBconst (ANDLconst _ [m]) [n])
	// cond: 0 <= int8(m) && int8(m) < int8(n)
	// result: (FlagLT_ULT)
	for {
		n := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		m := v_0.AuxInt
		if !(0 <= int8(m) && int8(m) < int8(n)) {
			break
		}
		v.reset(Op386FlagLT_ULT)
		return true
	}
	// match: (CMPBconst (ANDL x y) [0])
	// cond:
	// result: (TESTB x y)
	for {
		if v.AuxInt != 0 {
			break
		}
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDL {
			break
		}
		x := v_0.Args[0]
		y := v_0.Args[1]
		v.reset(Op386TESTB)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (CMPBconst (ANDLconst [c] x) [0])
	// cond:
	// result: (TESTBconst [int64(int8(c))] x)
	for {
		if v.AuxInt != 0 {
			break
		}
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		c := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386TESTBconst)
		v.AuxInt = int64(int8(c))
		v.AddArg(x)
		return true
	}
	// match: (CMPBconst x [0])
	// cond:
	// result: (TESTB x x)
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(Op386TESTB)
		v.AddArg(x)
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386CMPL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPL x (MOVLconst [c]))
	// cond:
	// result: (CMPLconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386CMPLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (CMPL (MOVLconst [c]) x)
	// cond:
	// result: (InvertFlags (CMPLconst x [c]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386InvertFlags)
		v0 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v0.AuxInt = c
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValue386_Op386CMPLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPLconst (MOVLconst [x]) [y])
	// cond: int32(x)==int32(y)
	// result: (FlagEQ)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int32(x) == int32(y)) {
			break
		}
		v.reset(Op386FlagEQ)
		return true
	}
	// match: (CMPLconst (MOVLconst [x]) [y])
	// cond: int32(x)<int32(y) && uint32(x)<uint32(y)
	// result: (FlagLT_ULT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int32(x) < int32(y) && uint32(x) < uint32(y)) {
			break
		}
		v.reset(Op386FlagLT_ULT)
		return true
	}
	// match: (CMPLconst (MOVLconst [x]) [y])
	// cond: int32(x)<int32(y) && uint32(x)>uint32(y)
	// result: (FlagLT_UGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int32(x) < int32(y) && uint32(x) > uint32(y)) {
			break
		}
		v.reset(Op386FlagLT_UGT)
		return true
	}
	// match: (CMPLconst (MOVLconst [x]) [y])
	// cond: int32(x)>int32(y) && uint32(x)<uint32(y)
	// result: (FlagGT_ULT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int32(x) > int32(y) && uint32(x) < uint32(y)) {
			break
		}
		v.reset(Op386FlagGT_ULT)
		return true
	}
	// match: (CMPLconst (MOVLconst [x]) [y])
	// cond: int32(x)>int32(y) && uint32(x)>uint32(y)
	// result: (FlagGT_UGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int32(x) > int32(y) && uint32(x) > uint32(y)) {
			break
		}
		v.reset(Op386FlagGT_UGT)
		return true
	}
	// match: (CMPLconst (SHRLconst _ [c]) [n])
	// cond: 0 <= n && 0 < c && c <= 32 && (1<<uint64(32-c)) <= uint64(n)
	// result: (FlagLT_ULT)
	for {
		n := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386SHRLconst {
			break
		}
		c := v_0.AuxInt
		if !(0 <= n && 0 < c && c <= 32 && (1<<uint64(32-c)) <= uint64(n)) {
			break
		}
		v.reset(Op386FlagLT_ULT)
		return true
	}
	// match: (CMPLconst (ANDLconst _ [m]) [n])
	// cond: 0 <= int32(m) && int32(m) < int32(n)
	// result: (FlagLT_ULT)
	for {
		n := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		m := v_0.AuxInt
		if !(0 <= int32(m) && int32(m) < int32(n)) {
			break
		}
		v.reset(Op386FlagLT_ULT)
		return true
	}
	// match: (CMPLconst (ANDL x y) [0])
	// cond:
	// result: (TESTL x y)
	for {
		if v.AuxInt != 0 {
			break
		}
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDL {
			break
		}
		x := v_0.Args[0]
		y := v_0.Args[1]
		v.reset(Op386TESTL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (CMPLconst (ANDLconst [c] x) [0])
	// cond:
	// result: (TESTLconst [c] x)
	for {
		if v.AuxInt != 0 {
			break
		}
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		c := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386TESTLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (CMPLconst x [0])
	// cond:
	// result: (TESTL x x)
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(Op386TESTL)
		v.AddArg(x)
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386CMPW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPW x (MOVLconst [c]))
	// cond:
	// result: (CMPWconst x [int64(int16(c))])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386CMPWconst)
		v.AuxInt = int64(int16(c))
		v.AddArg(x)
		return true
	}
	// match: (CMPW (MOVLconst [c]) x)
	// cond:
	// result: (InvertFlags (CMPWconst x [int64(int16(c))]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386InvertFlags)
		v0 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v0.AuxInt = int64(int16(c))
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValue386_Op386CMPWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (CMPWconst (MOVLconst [x]) [y])
	// cond: int16(x)==int16(y)
	// result: (FlagEQ)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int16(x) == int16(y)) {
			break
		}
		v.reset(Op386FlagEQ)
		return true
	}
	// match: (CMPWconst (MOVLconst [x]) [y])
	// cond: int16(x)<int16(y) && uint16(x)<uint16(y)
	// result: (FlagLT_ULT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int16(x) < int16(y) && uint16(x) < uint16(y)) {
			break
		}
		v.reset(Op386FlagLT_ULT)
		return true
	}
	// match: (CMPWconst (MOVLconst [x]) [y])
	// cond: int16(x)<int16(y) && uint16(x)>uint16(y)
	// result: (FlagLT_UGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int16(x) < int16(y) && uint16(x) > uint16(y)) {
			break
		}
		v.reset(Op386FlagLT_UGT)
		return true
	}
	// match: (CMPWconst (MOVLconst [x]) [y])
	// cond: int16(x)>int16(y) && uint16(x)<uint16(y)
	// result: (FlagGT_ULT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int16(x) > int16(y) && uint16(x) < uint16(y)) {
			break
		}
		v.reset(Op386FlagGT_ULT)
		return true
	}
	// match: (CMPWconst (MOVLconst [x]) [y])
	// cond: int16(x)>int16(y) && uint16(x)>uint16(y)
	// result: (FlagGT_UGT)
	for {
		y := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		x := v_0.AuxInt
		if !(int16(x) > int16(y) && uint16(x) > uint16(y)) {
			break
		}
		v.reset(Op386FlagGT_UGT)
		return true
	}
	// match: (CMPWconst (ANDLconst _ [m]) [n])
	// cond: 0 <= int16(m) && int16(m) < int16(n)
	// result: (FlagLT_ULT)
	for {
		n := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		m := v_0.AuxInt
		if !(0 <= int16(m) && int16(m) < int16(n)) {
			break
		}
		v.reset(Op386FlagLT_ULT)
		return true
	}
	// match: (CMPWconst (ANDL x y) [0])
	// cond:
	// result: (TESTW x y)
	for {
		if v.AuxInt != 0 {
			break
		}
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDL {
			break
		}
		x := v_0.Args[0]
		y := v_0.Args[1]
		v.reset(Op386TESTW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (CMPWconst (ANDLconst [c] x) [0])
	// cond:
	// result: (TESTWconst [int64(int16(c))] x)
	for {
		if v.AuxInt != 0 {
			break
		}
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		c := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386TESTWconst)
		v.AuxInt = int64(int16(c))
		v.AddArg(x)
		return true
	}
	// match: (CMPWconst x [0])
	// cond:
	// result: (TESTW x x)
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(Op386TESTW)
		v.AddArg(x)
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386LEAL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (LEAL [c] {s} (ADDLconst [d] x))
	// cond: is32Bit(c+d)
	// result: (LEAL [c+d] {s} x)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(c + d)) {
			break
		}
		v.reset(Op386LEAL)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		return true
	}
	// match: (LEAL [c] {s} (ADDL x y))
	// cond: x.Op != OpSB && y.Op != OpSB
	// result: (LEAL1 [c] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(x.Op != OpSB && y.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL [off1] {sym1} (LEAL [off2] {sym2} x))
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (LEAL [off1+off2] {mergeSym(sym1,sym2)} x)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386LEAL)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		return true
	}
	// match: (LEAL [off1] {sym1} (LEAL1 [off2] {sym2} x y))
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (LEAL1 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL [off1] {sym1} (LEAL2 [off2] {sym2} x y))
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (LEAL2 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL2 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386LEAL2)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL [off1] {sym1} (LEAL4 [off2] {sym2} x y))
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (LEAL4 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL4 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386LEAL4)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL [off1] {sym1} (LEAL8 [off2] {sym2} x y))
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (LEAL8 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL8 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v_0.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386LEAL8)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386LEAL1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (LEAL1 [c] {s} (ADDLconst [d] x) y)
	// cond: is32Bit(c+d)   && x.Op != OpSB
	// result: (LEAL1 [c+d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(c+d) && x.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL1 [c] {s} x (ADDLconst [d] y))
	// cond: is32Bit(c+d)   && y.Op != OpSB
	// result: (LEAL1 [c+d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		y := v_1.Args[0]
		if !(is32Bit(c+d) && y.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL1 [c] {s} x (SHLLconst [1] y))
	// cond:
	// result: (LEAL2 [c] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 1 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL2)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL1 [c] {s} (SHLLconst [1] x) y)
	// cond:
	// result: (LEAL2 [c] {s} y x)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386SHLLconst {
			break
		}
		if v_0.AuxInt != 1 {
			break
		}
		x := v_0.Args[0]
		y := v.Args[1]
		v.reset(Op386LEAL2)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(y)
		v.AddArg(x)
		return true
	}
	// match: (LEAL1 [c] {s} x (SHLLconst [2] y))
	// cond:
	// result: (LEAL4 [c] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 2 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL4)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL1 [c] {s} (SHLLconst [2] x) y)
	// cond:
	// result: (LEAL4 [c] {s} y x)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386SHLLconst {
			break
		}
		if v_0.AuxInt != 2 {
			break
		}
		x := v_0.Args[0]
		y := v.Args[1]
		v.reset(Op386LEAL4)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(y)
		v.AddArg(x)
		return true
	}
	// match: (LEAL1 [c] {s} x (SHLLconst [3] y))
	// cond:
	// result: (LEAL8 [c] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 3 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL8)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL1 [c] {s} (SHLLconst [3] x) y)
	// cond:
	// result: (LEAL8 [c] {s} y x)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386SHLLconst {
			break
		}
		if v_0.AuxInt != 3 {
			break
		}
		x := v_0.Args[0]
		y := v.Args[1]
		v.reset(Op386LEAL8)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(y)
		v.AddArg(x)
		return true
	}
	// match: (LEAL1 [off1] {sym1} (LEAL [off2] {sym2} x) y)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB
	// result: (LEAL1 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL1 [off1] {sym1} x (LEAL [off2] {sym2} y))
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2) && y.Op != OpSB
	// result: (LEAL1 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386LEAL {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		y := v_1.Args[0]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && y.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386LEAL2(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (LEAL2 [c] {s} (ADDLconst [d] x) y)
	// cond: is32Bit(c+d)   && x.Op != OpSB
	// result: (LEAL2 [c+d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(c+d) && x.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL2)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL2 [c] {s} x (ADDLconst [d] y))
	// cond: is32Bit(c+2*d) && y.Op != OpSB
	// result: (LEAL2 [c+2*d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		y := v_1.Args[0]
		if !(is32Bit(c+2*d) && y.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL2)
		v.AuxInt = c + 2*d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL2 [c] {s} x (SHLLconst [1] y))
	// cond:
	// result: (LEAL4 [c] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 1 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL4)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL2 [c] {s} x (SHLLconst [2] y))
	// cond:
	// result: (LEAL8 [c] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 2 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL8)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL2 [off1] {sym1} (LEAL [off2] {sym2} x) y)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB
	// result: (LEAL2 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL2)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386LEAL4(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (LEAL4 [c] {s} (ADDLconst [d] x) y)
	// cond: is32Bit(c+d)   && x.Op != OpSB
	// result: (LEAL4 [c+d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(c+d) && x.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL4)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL4 [c] {s} x (ADDLconst [d] y))
	// cond: is32Bit(c+4*d) && y.Op != OpSB
	// result: (LEAL4 [c+4*d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		y := v_1.Args[0]
		if !(is32Bit(c+4*d) && y.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL4)
		v.AuxInt = c + 4*d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL4 [c] {s} x (SHLLconst [1] y))
	// cond:
	// result: (LEAL8 [c] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 1 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386LEAL8)
		v.AuxInt = c
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL4 [off1] {sym1} (LEAL [off2] {sym2} x) y)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB
	// result: (LEAL4 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL4)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386LEAL8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (LEAL8 [c] {s} (ADDLconst [d] x) y)
	// cond: is32Bit(c+d)   && x.Op != OpSB
	// result: (LEAL8 [c+d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(c+d) && x.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL8)
		v.AuxInt = c + d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL8 [c] {s} x (ADDLconst [d] y))
	// cond: is32Bit(c+8*d) && y.Op != OpSB
	// result: (LEAL8 [c+8*d] {s} x y)
	for {
		c := v.AuxInt
		s := v.Aux
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		y := v_1.Args[0]
		if !(is32Bit(c+8*d) && y.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL8)
		v.AuxInt = c + 8*d
		v.Aux = s
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (LEAL8 [off1] {sym1} (LEAL [off2] {sym2} x) y)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB
	// result: (LEAL8 [off1+off2] {mergeSym(sym1,sym2)} x y)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		x := v_0.Args[0]
		y := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && x.Op != OpSB) {
			break
		}
		v.reset(Op386LEAL8)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBLSX(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBLSX x:(MOVBload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVBLSXload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != Op386MOVBload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, Op386MOVBLSXload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVBLSX (ANDLconst [c] x))
	// cond: c & 0x80 == 0
	// result: (ANDLconst [c & 0x7f] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		c := v_0.AuxInt
		x := v_0.Args[0]
		if !(c&0x80 == 0) {
			break
		}
		v.reset(Op386ANDLconst)
		v.AuxInt = c & 0x7f
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBLSXload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBLSXload [off1] {sym1} (LEAL [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVBLSXload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVBLSXload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBLZX(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBLZX x:(MOVBload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVBload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != Op386MOVBload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, Op386MOVBload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVBLZX x:(MOVBloadidx1 [off] {sym} ptr idx mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVBloadidx1 <v.Type> [off] {sym} ptr idx mem)
	for {
		x := v.Args[0]
		if x.Op != Op386MOVBloadidx1 {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		idx := x.Args[1]
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, Op386MOVBloadidx1, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVBLZX (ANDLconst [c] x))
	// cond:
	// result: (ANDLconst [c & 0xff] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		c := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386ANDLconst)
		v.AuxInt = c & 0xff
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBload [off] {sym} ptr (MOVBstore [off2] {sym2} ptr2 x _))
	// cond: sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)
	// result: x
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVBstore {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		ptr2 := v_1.Args[0]
		x := v_1.Args[1]
		if !(sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVBload  [off1] {sym} (ADDLconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVBload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVBload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBload  [off1] {sym1} (LEAL [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVBload  [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVBload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBload [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVBloadidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVBloadidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBload [off] {sym} (ADDL ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVBloadidx1 [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVBloadidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBloadidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBloadidx1 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVBloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVBloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBloadidx1 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVBloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVBloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstore [off] {sym} ptr (MOVBLSX x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVBLSX {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVBLZX x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVBLZX {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore  [off1] {sym} (ADDLconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVBstore  [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVBstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVLconst [c]) mem)
	// cond: validOff(off)
	// result: (MOVBstoreconst [makeValAndOff(int64(int8(c)),off)] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		mem := v.Args[2]
		if !(validOff(off)) {
			break
		}
		v.reset(Op386MOVBstoreconst)
		v.AuxInt = makeValAndOff(int64(int8(c)), off)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore  [off1] {sym1} (LEAL [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVBstore  [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVBstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVBstoreidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVBstoreidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} (ADDL ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVBstoreidx1 [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVBstoreidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p (SHRLconst [8] w) x:(MOVBstore [i-1] {s} p w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWstore [i-1] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHRLconst {
			break
		}
		if v_1.AuxInt != 8 {
			break
		}
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != Op386MOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if w != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVWstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [i] {s} p (SHRLconst [j] w) x:(MOVBstore [i-1] {s} p w0:(SHRLconst [j-8] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWstore [i-1] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHRLconst {
			break
		}
		j := v_1.AuxInt
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != Op386MOVBstore {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		if w0.Op != Op386SHRLconst {
			break
		}
		if w0.AuxInt != j-8 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVWstore)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBstoreconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstoreconst [sc] {s} (ADDLconst [off] ptr) mem)
	// cond: ValAndOff(sc).canAdd(off)
	// result: (MOVBstoreconst [ValAndOff(sc).add(off)] {s} ptr mem)
	for {
		sc := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(Op386MOVBstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = s
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreconst [sc] {sym1} (LEAL [off] {sym2} ptr) mem)
	// cond: canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)   && (ptr.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVBstoreconst [ValAndOff(sc).add(off)] {mergeSym(sym1, sym2)} ptr mem)
	for {
		sc := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off) && (ptr.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVBstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreconst [x] {sym1} (LEAL1 [off] {sym2} ptr idx) mem)
	// cond: canMergeSym(sym1, sym2)
	// result: (MOVBstoreconstidx1 [ValAndOff(x).add(off)] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		x := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVBstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreconst [x] {sym} (ADDL ptr idx) mem)
	// cond:
	// result: (MOVBstoreconstidx1 [x] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		v.reset(Op386MOVBstoreconstidx1)
		v.AuxInt = x
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreconst [c] {s} p x:(MOVBstoreconst [a] {s} p mem))
	// cond: x.Uses == 1   && ValAndOff(a).Off() + 1 == ValAndOff(c).Off()   && clobber(x)
	// result: (MOVWstoreconst [makeValAndOff(ValAndOff(a).Val()&0xff | ValAndOff(c).Val()<<8, ValAndOff(a).Off())] {s} p mem)
	for {
		c := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		x := v.Args[1]
		if x.Op != Op386MOVBstoreconst {
			break
		}
		a := x.AuxInt
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		mem := x.Args[1]
		if !(x.Uses == 1 && ValAndOff(a).Off()+1 == ValAndOff(c).Off() && clobber(x)) {
			break
		}
		v.reset(Op386MOVWstoreconst)
		v.AuxInt = makeValAndOff(ValAndOff(a).Val()&0xff|ValAndOff(c).Val()<<8, ValAndOff(a).Off())
		v.Aux = s
		v.AddArg(p)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBstoreconstidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstoreconstidx1 [x] {sym} (ADDLconst [c] ptr) idx mem)
	// cond:
	// result: (MOVBstoreconstidx1 [ValAndOff(x).add(c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		c := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVBstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreconstidx1 [x] {sym} ptr (ADDLconst [c] idx) mem)
	// cond:
	// result: (MOVBstoreconstidx1 [ValAndOff(x).add(c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		c := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVBstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreconstidx1 [c] {s} p i x:(MOVBstoreconstidx1 [a] {s} p i mem))
	// cond: x.Uses == 1   && ValAndOff(a).Off() + 1 == ValAndOff(c).Off()   && clobber(x)
	// result: (MOVWstoreconstidx1 [makeValAndOff(ValAndOff(a).Val()&0xff | ValAndOff(c).Val()<<8, ValAndOff(a).Off())] {s} p i mem)
	for {
		c := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		i := v.Args[1]
		x := v.Args[2]
		if x.Op != Op386MOVBstoreconstidx1 {
			break
		}
		a := x.AuxInt
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if i != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && ValAndOff(a).Off()+1 == ValAndOff(c).Off() && clobber(x)) {
			break
		}
		v.reset(Op386MOVWstoreconstidx1)
		v.AuxInt = makeValAndOff(ValAndOff(a).Val()&0xff|ValAndOff(c).Val()<<8, ValAndOff(a).Off())
		v.Aux = s
		v.AddArg(p)
		v.AddArg(i)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVBstoreidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstoreidx1 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVBstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVBstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx1 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVBstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVBstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx1 [i] {s} p idx (SHRLconst [8] w) x:(MOVBstoreidx1 [i-1] {s} p idx w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWstoreidx1 [i-1] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != Op386SHRLconst {
			break
		}
		if v_2.AuxInt != 8 {
			break
		}
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != Op386MOVBstoreidx1 {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		if w != x.Args[2] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVWstoreidx1)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstoreidx1 [i] {s} p idx (SHRLconst [j] w) x:(MOVBstoreidx1 [i-1] {s} p idx w0:(SHRLconst [j-8] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVWstoreidx1 [i-1] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != Op386SHRLconst {
			break
		}
		j := v_2.AuxInt
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != Op386MOVBstoreidx1 {
			break
		}
		if x.AuxInt != i-1 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		w0 := x.Args[2]
		if w0.Op != Op386SHRLconst {
			break
		}
		if w0.AuxInt != j-8 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVWstoreidx1)
		v.AuxInt = i - 1
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLload [off] {sym} ptr (MOVLstore [off2] {sym2} ptr2 x _))
	// cond: sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)
	// result: x
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLstore {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		ptr2 := v_1.Args[0]
		x := v_1.Args[1]
		if !(sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVLload  [off1] {sym} (ADDLconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVLload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVLload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLload  [off1] {sym1} (LEAL [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVLload  [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVLload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLload [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVLloadidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVLloadidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLload [off1] {sym1} (LEAL4 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVLloadidx4 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL4 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVLloadidx4)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLload [off] {sym} (ADDL ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVLloadidx1 [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVLloadidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLloadidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLloadidx1 [c] {sym} ptr (SHLLconst [2] idx) mem)
	// cond:
	// result: (MOVLloadidx4 [c] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 2 {
			break
		}
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVLloadidx4)
		v.AuxInt = c
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLloadidx1 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVLloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVLloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLloadidx1 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVLloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVLloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLloadidx4(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLloadidx4 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVLloadidx4 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVLloadidx4)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLloadidx4 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVLloadidx4 [c+4*d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVLloadidx4)
		v.AuxInt = c + 4*d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLstore  [off1] {sym} (ADDLconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVLstore  [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVLstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstore [off] {sym} ptr (MOVLconst [c]) mem)
	// cond: validOff(off)
	// result: (MOVLstoreconst [makeValAndOff(int64(int32(c)),off)] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		mem := v.Args[2]
		if !(validOff(off)) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = makeValAndOff(int64(int32(c)), off)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstore  [off1] {sym1} (LEAL [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVLstore  [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVLstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstore [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVLstoreidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVLstoreidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstore [off1] {sym1} (LEAL4 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVLstoreidx4 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL4 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVLstoreidx4)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstore [off] {sym} (ADDL ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVLstoreidx1 [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVLstoreidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLstoreconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLstoreconst [sc] {s} (ADDLconst [off] ptr) mem)
	// cond: ValAndOff(sc).canAdd(off)
	// result: (MOVLstoreconst [ValAndOff(sc).add(off)] {s} ptr mem)
	for {
		sc := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = s
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreconst [sc] {sym1} (LEAL [off] {sym2} ptr) mem)
	// cond: canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)   && (ptr.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVLstoreconst [ValAndOff(sc).add(off)] {mergeSym(sym1, sym2)} ptr mem)
	for {
		sc := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off) && (ptr.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreconst [x] {sym1} (LEAL1 [off] {sym2} ptr idx) mem)
	// cond: canMergeSym(sym1, sym2)
	// result: (MOVLstoreconstidx1 [ValAndOff(x).add(off)] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		x := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVLstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreconst [x] {sym1} (LEAL4 [off] {sym2} ptr idx) mem)
	// cond: canMergeSym(sym1, sym2)
	// result: (MOVLstoreconstidx4 [ValAndOff(x).add(off)] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		x := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL4 {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVLstoreconstidx4)
		v.AuxInt = ValAndOff(x).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreconst [x] {sym} (ADDL ptr idx) mem)
	// cond:
	// result: (MOVLstoreconstidx1 [x] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		v.reset(Op386MOVLstoreconstidx1)
		v.AuxInt = x
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLstoreconstidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLstoreconstidx1 [c] {sym} ptr (SHLLconst [2] idx) mem)
	// cond:
	// result: (MOVLstoreconstidx4 [c] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 2 {
			break
		}
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVLstoreconstidx4)
		v.AuxInt = c
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreconstidx1 [x] {sym} (ADDLconst [c] ptr) idx mem)
	// cond:
	// result: (MOVLstoreconstidx1 [ValAndOff(x).add(c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		c := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVLstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreconstidx1 [x] {sym} ptr (ADDLconst [c] idx) mem)
	// cond:
	// result: (MOVLstoreconstidx1 [ValAndOff(x).add(c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		c := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVLstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLstoreconstidx4(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLstoreconstidx4 [x] {sym} (ADDLconst [c] ptr) idx mem)
	// cond:
	// result: (MOVLstoreconstidx4 [ValAndOff(x).add(c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		c := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVLstoreconstidx4)
		v.AuxInt = ValAndOff(x).add(c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreconstidx4 [x] {sym} ptr (ADDLconst [c] idx) mem)
	// cond:
	// result: (MOVLstoreconstidx4 [ValAndOff(x).add(4*c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		c := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVLstoreconstidx4)
		v.AuxInt = ValAndOff(x).add(4 * c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLstoreidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLstoreidx1 [c] {sym} ptr (SHLLconst [2] idx) val mem)
	// cond:
	// result: (MOVLstoreidx4 [c] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 2 {
			break
		}
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVLstoreidx4)
		v.AuxInt = c
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreidx1 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVLstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVLstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreidx1 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVLstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVLstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVLstoreidx4(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVLstoreidx4 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVLstoreidx4 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVLstoreidx4)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVLstoreidx4 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVLstoreidx4 [c+4*d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVLstoreidx4)
		v.AuxInt = c + 4*d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSDconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSDconst [c])
	// cond: config.ctxt.Flag_shared
	// result: (MOVSDconst2 (MOVSDconst1 [c]))
	for {
		c := v.AuxInt
		if !(config.ctxt.Flag_shared) {
			break
		}
		v.reset(Op386MOVSDconst2)
		v0 := b.NewValue0(v.Line, Op386MOVSDconst1, config.fe.TypeUInt32())
		v0.AuxInt = c
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSDload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSDload [off1] {sym} (ADDLconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVSDload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVSDload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDload [off1] {sym1} (LEAL [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVSDload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVSDload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDload [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVSDloadidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVSDloadidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDload [off1] {sym1} (LEAL8 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVSDloadidx8 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL8 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVSDloadidx8)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDload [off] {sym} (ADDL ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVSDloadidx1 [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVSDloadidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSDloadidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSDloadidx1 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVSDloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVSDloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDloadidx1 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVSDloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVSDloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSDloadidx8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSDloadidx8 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVSDloadidx8 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVSDloadidx8)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDloadidx8 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVSDloadidx8 [c+8*d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVSDloadidx8)
		v.AuxInt = c + 8*d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSDstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSDstore [off1] {sym} (ADDLconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVSDstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVSDstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDstore [off1] {sym1} (LEAL [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVSDstore [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVSDstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDstore [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVSDstoreidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVSDstoreidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDstore [off1] {sym1} (LEAL8 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVSDstoreidx8 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL8 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVSDstoreidx8)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDstore [off] {sym} (ADDL ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVSDstoreidx1 [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVSDstoreidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSDstoreidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSDstoreidx1 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVSDstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVSDstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDstoreidx1 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVSDstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVSDstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSDstoreidx8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSDstoreidx8 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVSDstoreidx8 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVSDstoreidx8)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSDstoreidx8 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVSDstoreidx8 [c+8*d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVSDstoreidx8)
		v.AuxInt = c + 8*d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSSconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSSconst [c])
	// cond: config.ctxt.Flag_shared
	// result: (MOVSSconst2 (MOVSSconst1 [c]))
	for {
		c := v.AuxInt
		if !(config.ctxt.Flag_shared) {
			break
		}
		v.reset(Op386MOVSSconst2)
		v0 := b.NewValue0(v.Line, Op386MOVSSconst1, config.fe.TypeUInt32())
		v0.AuxInt = c
		v.AddArg(v0)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSSload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSSload [off1] {sym} (ADDLconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVSSload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVSSload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSload [off1] {sym1} (LEAL [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVSSload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVSSload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSload [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVSSloadidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVSSloadidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSload [off1] {sym1} (LEAL4 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVSSloadidx4 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL4 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVSSloadidx4)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSload [off] {sym} (ADDL ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVSSloadidx1 [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVSSloadidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSSloadidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSSloadidx1 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVSSloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVSSloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSloadidx1 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVSSloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVSSloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSSloadidx4(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSSloadidx4 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVSSloadidx4 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVSSloadidx4)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSloadidx4 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVSSloadidx4 [c+4*d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVSSloadidx4)
		v.AuxInt = c + 4*d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSSstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSSstore [off1] {sym} (ADDLconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVSSstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVSSstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSstore [off1] {sym1} (LEAL [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVSSstore [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVSSstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSstore [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVSSstoreidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVSSstoreidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSstore [off1] {sym1} (LEAL4 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVSSstoreidx4 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL4 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVSSstoreidx4)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSstore [off] {sym} (ADDL ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVSSstoreidx1 [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVSSstoreidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSSstoreidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSSstoreidx1 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVSSstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVSSstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSstoreidx1 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVSSstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVSSstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVSSstoreidx4(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVSSstoreidx4 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVSSstoreidx4 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVSSstoreidx4)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVSSstoreidx4 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVSSstoreidx4 [c+4*d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVSSstoreidx4)
		v.AuxInt = c + 4*d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWLSX(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWLSX x:(MOVWload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVWLSXload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != Op386MOVWload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, Op386MOVWLSXload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVWLSX (ANDLconst [c] x))
	// cond: c & 0x8000 == 0
	// result: (ANDLconst [c & 0x7fff] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		c := v_0.AuxInt
		x := v_0.Args[0]
		if !(c&0x8000 == 0) {
			break
		}
		v.reset(Op386ANDLconst)
		v.AuxInt = c & 0x7fff
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWLSXload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWLSXload [off1] {sym1} (LEAL [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVWLSXload [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVWLSXload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWLZX(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWLZX x:(MOVWload [off] {sym} ptr mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVWload <v.Type> [off] {sym} ptr mem)
	for {
		x := v.Args[0]
		if x.Op != Op386MOVWload {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		mem := x.Args[1]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, Op386MOVWload, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVWLZX x:(MOVWloadidx1 [off] {sym} ptr idx mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVWloadidx1 <v.Type> [off] {sym} ptr idx mem)
	for {
		x := v.Args[0]
		if x.Op != Op386MOVWloadidx1 {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		idx := x.Args[1]
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, Op386MOVWloadidx1, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVWLZX x:(MOVWloadidx2 [off] {sym} ptr idx mem))
	// cond: x.Uses == 1 && clobber(x)
	// result: @x.Block (MOVWloadidx2 <v.Type> [off] {sym} ptr idx mem)
	for {
		x := v.Args[0]
		if x.Op != Op386MOVWloadidx2 {
			break
		}
		off := x.AuxInt
		sym := x.Aux
		ptr := x.Args[0]
		idx := x.Args[1]
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		b = x.Block
		v0 := b.NewValue0(v.Line, Op386MOVWloadidx2, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = off
		v0.Aux = sym
		v0.AddArg(ptr)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	// match: (MOVWLZX (ANDLconst [c] x))
	// cond:
	// result: (ANDLconst [c & 0xffff] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386ANDLconst {
			break
		}
		c := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386ANDLconst)
		v.AuxInt = c & 0xffff
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWload [off] {sym} ptr (MOVWstore [off2] {sym2} ptr2 x _))
	// cond: sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)
	// result: x
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVWstore {
			break
		}
		off2 := v_1.AuxInt
		sym2 := v_1.Aux
		ptr2 := v_1.Args[0]
		x := v_1.Args[1]
		if !(sym == sym2 && off == off2 && isSamePtr(ptr, ptr2)) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MOVWload  [off1] {sym} (ADDLconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVWload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVWload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWload  [off1] {sym1} (LEAL [off2] {sym2} base) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVWload  [off1+off2] {mergeSym(sym1,sym2)} base mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVWload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWload [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWloadidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVWloadidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWload [off1] {sym1} (LEAL2 [off2] {sym2} ptr idx) mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWloadidx2 [off1+off2] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL2 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVWloadidx2)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWload [off] {sym} (ADDL ptr idx) mem)
	// cond: ptr.Op != OpSB
	// result: (MOVWloadidx1 [off] {sym} ptr idx mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVWloadidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWloadidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWloadidx1 [c] {sym} ptr (SHLLconst [1] idx) mem)
	// cond:
	// result: (MOVWloadidx2 [c] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 1 {
			break
		}
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVWloadidx2)
		v.AuxInt = c
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWloadidx1 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVWloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVWloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWloadidx1 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVWloadidx1 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVWloadidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWloadidx2(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWloadidx2 [c] {sym} (ADDLconst [d] ptr) idx mem)
	// cond:
	// result: (MOVWloadidx2 [c+d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVWloadidx2)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWloadidx2 [c] {sym} ptr (ADDLconst [d] idx) mem)
	// cond:
	// result: (MOVWloadidx2 [c+2*d] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVWloadidx2)
		v.AuxInt = c + 2*d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstore [off] {sym} ptr (MOVWLSX x) mem)
	// cond:
	// result: (MOVWstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVWLSX {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVWstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} ptr (MOVWLZX x) mem)
	// cond:
	// result: (MOVWstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVWLZX {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVWstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore  [off1] {sym} (ADDLconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVWstore  [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(Op386MOVWstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} ptr (MOVLconst [c]) mem)
	// cond: validOff(off)
	// result: (MOVWstoreconst [makeValAndOff(int64(int16(c)),off)] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		mem := v.Args[2]
		if !(validOff(off)) {
			break
		}
		v.reset(Op386MOVWstoreconst)
		v.AuxInt = makeValAndOff(int64(int16(c)), off)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore  [off1] {sym1} (LEAL [off2] {sym2} base) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)   && (base.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVWstore  [off1+off2] {mergeSym(sym1,sym2)} base val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		base := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2) && (base.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVWstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(base)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off1] {sym1} (LEAL1 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWstoreidx1 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVWstoreidx1)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off1] {sym1} (LEAL2 [off2] {sym2} ptr idx) val mem)
	// cond: is32Bit(off1+off2) && canMergeSym(sym1, sym2)
	// result: (MOVWstoreidx2 [off1+off2] {mergeSym(sym1,sym2)} ptr idx val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL2 {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1+off2) && canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVWstoreidx2)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} (ADDL ptr idx) val mem)
	// cond: ptr.Op != OpSB
	// result: (MOVWstoreidx1 [off] {sym} ptr idx val mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		val := v.Args[1]
		mem := v.Args[2]
		if !(ptr.Op != OpSB) {
			break
		}
		v.reset(Op386MOVWstoreidx1)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [i] {s} p (SHRLconst [16] w) x:(MOVWstore [i-2] {s} p w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVLstore [i-2] {s} p w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHRLconst {
			break
		}
		if v_1.AuxInt != 16 {
			break
		}
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != Op386MOVWstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if w != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [i] {s} p (SHRLconst [j] w) x:(MOVWstore [i-2] {s} p w0:(SHRLconst [j-16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVLstore [i-2] {s} p w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHRLconst {
			break
		}
		j := v_1.AuxInt
		w := v_1.Args[0]
		x := v.Args[2]
		if x.Op != Op386MOVWstore {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		w0 := x.Args[1]
		if w0.Op != Op386SHRLconst {
			break
		}
		if w0.AuxInt != j-16 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstore)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWstoreconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstoreconst [sc] {s} (ADDLconst [off] ptr) mem)
	// cond: ValAndOff(sc).canAdd(off)
	// result: (MOVWstoreconst [ValAndOff(sc).add(off)] {s} ptr mem)
	for {
		sc := v.AuxInt
		s := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		off := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(ValAndOff(sc).canAdd(off)) {
			break
		}
		v.reset(Op386MOVWstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = s
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconst [sc] {sym1} (LEAL [off] {sym2} ptr) mem)
	// cond: canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off)   && (ptr.Op != OpSB || !config.ctxt.Flag_shared)
	// result: (MOVWstoreconst [ValAndOff(sc).add(off)] {mergeSym(sym1, sym2)} ptr mem)
	for {
		sc := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && ValAndOff(sc).canAdd(off) && (ptr.Op != OpSB || !config.ctxt.Flag_shared)) {
			break
		}
		v.reset(Op386MOVWstoreconst)
		v.AuxInt = ValAndOff(sc).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconst [x] {sym1} (LEAL1 [off] {sym2} ptr idx) mem)
	// cond: canMergeSym(sym1, sym2)
	// result: (MOVWstoreconstidx1 [ValAndOff(x).add(off)] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		x := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL1 {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVWstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconst [x] {sym1} (LEAL2 [off] {sym2} ptr idx) mem)
	// cond: canMergeSym(sym1, sym2)
	// result: (MOVWstoreconstidx2 [ValAndOff(x).add(off)] {mergeSym(sym1,sym2)} ptr idx mem)
	for {
		x := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386LEAL2 {
			break
		}
		off := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2)) {
			break
		}
		v.reset(Op386MOVWstoreconstidx2)
		v.AuxInt = ValAndOff(x).add(off)
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconst [x] {sym} (ADDL ptr idx) mem)
	// cond:
	// result: (MOVWstoreconstidx1 [x] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDL {
			break
		}
		ptr := v_0.Args[0]
		idx := v_0.Args[1]
		mem := v.Args[1]
		v.reset(Op386MOVWstoreconstidx1)
		v.AuxInt = x
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconst [c] {s} p x:(MOVWstoreconst [a] {s} p mem))
	// cond: x.Uses == 1   && ValAndOff(a).Off() + 2 == ValAndOff(c).Off()   && clobber(x)
	// result: (MOVLstoreconst [makeValAndOff(ValAndOff(a).Val()&0xffff | ValAndOff(c).Val()<<16, ValAndOff(a).Off())] {s} p mem)
	for {
		c := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		x := v.Args[1]
		if x.Op != Op386MOVWstoreconst {
			break
		}
		a := x.AuxInt
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		mem := x.Args[1]
		if !(x.Uses == 1 && ValAndOff(a).Off()+2 == ValAndOff(c).Off() && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = makeValAndOff(ValAndOff(a).Val()&0xffff|ValAndOff(c).Val()<<16, ValAndOff(a).Off())
		v.Aux = s
		v.AddArg(p)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWstoreconstidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstoreconstidx1 [c] {sym} ptr (SHLLconst [1] idx) mem)
	// cond:
	// result: (MOVWstoreconstidx2 [c] {sym} ptr idx mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 1 {
			break
		}
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVWstoreconstidx2)
		v.AuxInt = c
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconstidx1 [x] {sym} (ADDLconst [c] ptr) idx mem)
	// cond:
	// result: (MOVWstoreconstidx1 [ValAndOff(x).add(c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		c := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVWstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconstidx1 [x] {sym} ptr (ADDLconst [c] idx) mem)
	// cond:
	// result: (MOVWstoreconstidx1 [ValAndOff(x).add(c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		c := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVWstoreconstidx1)
		v.AuxInt = ValAndOff(x).add(c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconstidx1 [c] {s} p i x:(MOVWstoreconstidx1 [a] {s} p i mem))
	// cond: x.Uses == 1   && ValAndOff(a).Off() + 2 == ValAndOff(c).Off()   && clobber(x)
	// result: (MOVLstoreconstidx1 [makeValAndOff(ValAndOff(a).Val()&0xffff | ValAndOff(c).Val()<<16, ValAndOff(a).Off())] {s} p i mem)
	for {
		c := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		i := v.Args[1]
		x := v.Args[2]
		if x.Op != Op386MOVWstoreconstidx1 {
			break
		}
		a := x.AuxInt
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if i != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && ValAndOff(a).Off()+2 == ValAndOff(c).Off() && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstoreconstidx1)
		v.AuxInt = makeValAndOff(ValAndOff(a).Val()&0xffff|ValAndOff(c).Val()<<16, ValAndOff(a).Off())
		v.Aux = s
		v.AddArg(p)
		v.AddArg(i)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWstoreconstidx2(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstoreconstidx2 [x] {sym} (ADDLconst [c] ptr) idx mem)
	// cond:
	// result: (MOVWstoreconstidx2 [ValAndOff(x).add(c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		c := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVWstoreconstidx2)
		v.AuxInt = ValAndOff(x).add(c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconstidx2 [x] {sym} ptr (ADDLconst [c] idx) mem)
	// cond:
	// result: (MOVWstoreconstidx2 [ValAndOff(x).add(2*c)] {sym} ptr idx mem)
	for {
		x := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		c := v_1.AuxInt
		idx := v_1.Args[0]
		mem := v.Args[2]
		v.reset(Op386MOVWstoreconstidx2)
		v.AuxInt = ValAndOff(x).add(2 * c)
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreconstidx2 [c] {s} p i x:(MOVWstoreconstidx2 [a] {s} p i mem))
	// cond: x.Uses == 1   && ValAndOff(a).Off() + 2 == ValAndOff(c).Off()   && clobber(x)
	// result: (MOVLstoreconstidx1 [makeValAndOff(ValAndOff(a).Val()&0xffff | ValAndOff(c).Val()<<16, ValAndOff(a).Off())] {s} p (SHLLconst <i.Type> [1] i) mem)
	for {
		c := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		i := v.Args[1]
		x := v.Args[2]
		if x.Op != Op386MOVWstoreconstidx2 {
			break
		}
		a := x.AuxInt
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if i != x.Args[1] {
			break
		}
		mem := x.Args[2]
		if !(x.Uses == 1 && ValAndOff(a).Off()+2 == ValAndOff(c).Off() && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstoreconstidx1)
		v.AuxInt = makeValAndOff(ValAndOff(a).Val()&0xffff|ValAndOff(c).Val()<<16, ValAndOff(a).Off())
		v.Aux = s
		v.AddArg(p)
		v0 := b.NewValue0(v.Line, Op386SHLLconst, i.Type)
		v0.AuxInt = 1
		v0.AddArg(i)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWstoreidx1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstoreidx1 [c] {sym} ptr (SHLLconst [1] idx) val mem)
	// cond:
	// result: (MOVWstoreidx2 [c] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386SHLLconst {
			break
		}
		if v_1.AuxInt != 1 {
			break
		}
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVWstoreidx2)
		v.AuxInt = c
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx1 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVWstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVWstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx1 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVWstoreidx1 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVWstoreidx1)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx1 [i] {s} p idx (SHRLconst [16] w) x:(MOVWstoreidx1 [i-2] {s} p idx w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVLstoreidx1 [i-2] {s} p idx w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != Op386SHRLconst {
			break
		}
		if v_2.AuxInt != 16 {
			break
		}
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != Op386MOVWstoreidx1 {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		if w != x.Args[2] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstoreidx1)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx1 [i] {s} p idx (SHRLconst [j] w) x:(MOVWstoreidx1 [i-2] {s} p idx w0:(SHRLconst [j-16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVLstoreidx1 [i-2] {s} p idx w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != Op386SHRLconst {
			break
		}
		j := v_2.AuxInt
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != Op386MOVWstoreidx1 {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		w0 := x.Args[2]
		if w0.Op != Op386SHRLconst {
			break
		}
		if w0.AuxInt != j-16 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstoreidx1)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v.AddArg(idx)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MOVWstoreidx2(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstoreidx2 [c] {sym} (ADDLconst [d] ptr) idx val mem)
	// cond:
	// result: (MOVWstoreidx2 [c+d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != Op386ADDLconst {
			break
		}
		d := v_0.AuxInt
		ptr := v_0.Args[0]
		idx := v.Args[1]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVWstoreidx2)
		v.AuxInt = c + d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx2 [c] {sym} ptr (ADDLconst [d] idx) val mem)
	// cond:
	// result: (MOVWstoreidx2 [c+2*d] {sym} ptr idx val mem)
	for {
		c := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ADDLconst {
			break
		}
		d := v_1.AuxInt
		idx := v_1.Args[0]
		val := v.Args[2]
		mem := v.Args[3]
		v.reset(Op386MOVWstoreidx2)
		v.AuxInt = c + 2*d
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(idx)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx2 [i] {s} p idx (SHRLconst [16] w) x:(MOVWstoreidx2 [i-2] {s} p idx w mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVLstoreidx1 [i-2] {s} p (SHLLconst <idx.Type> [1] idx) w mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != Op386SHRLconst {
			break
		}
		if v_2.AuxInt != 16 {
			break
		}
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != Op386MOVWstoreidx2 {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		if w != x.Args[2] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstoreidx1)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v0 := b.NewValue0(v.Line, Op386SHLLconst, idx.Type)
		v0.AuxInt = 1
		v0.AddArg(idx)
		v.AddArg(v0)
		v.AddArg(w)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstoreidx2 [i] {s} p idx (SHRLconst [j] w) x:(MOVWstoreidx2 [i-2] {s} p idx w0:(SHRLconst [j-16] w) mem))
	// cond: x.Uses == 1   && clobber(x)
	// result: (MOVLstoreidx1 [i-2] {s} p (SHLLconst <idx.Type> [1] idx) w0 mem)
	for {
		i := v.AuxInt
		s := v.Aux
		p := v.Args[0]
		idx := v.Args[1]
		v_2 := v.Args[2]
		if v_2.Op != Op386SHRLconst {
			break
		}
		j := v_2.AuxInt
		w := v_2.Args[0]
		x := v.Args[3]
		if x.Op != Op386MOVWstoreidx2 {
			break
		}
		if x.AuxInt != i-2 {
			break
		}
		if x.Aux != s {
			break
		}
		if p != x.Args[0] {
			break
		}
		if idx != x.Args[1] {
			break
		}
		w0 := x.Args[2]
		if w0.Op != Op386SHRLconst {
			break
		}
		if w0.AuxInt != j-16 {
			break
		}
		if w != w0.Args[0] {
			break
		}
		mem := x.Args[3]
		if !(x.Uses == 1 && clobber(x)) {
			break
		}
		v.reset(Op386MOVLstoreidx1)
		v.AuxInt = i - 2
		v.Aux = s
		v.AddArg(p)
		v0 := b.NewValue0(v.Line, Op386SHLLconst, idx.Type)
		v0.AuxInt = 1
		v0.AddArg(idx)
		v.AddArg(v0)
		v.AddArg(w0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386MULL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MULL x (MOVLconst [c]))
	// cond:
	// result: (MULLconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386MULLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (MULL (MOVLconst [c]) x)
	// cond:
	// result: (MULLconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386MULLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386MULLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MULLconst [c] (MULLconst [d] x))
	// cond:
	// result: (MULLconst [int64(int32(c * d))] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MULLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386MULLconst)
		v.AuxInt = int64(int32(c * d))
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [-1] x)
	// cond:
	// result: (NEGL x)
	for {
		if v.AuxInt != -1 {
			break
		}
		x := v.Args[0]
		v.reset(Op386NEGL)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [0] _)
	// cond:
	// result: (MOVLconst [0])
	for {
		if v.AuxInt != 0 {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (MULLconst [1] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 1 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [3] x)
	// cond:
	// result: (LEAL2 x x)
	for {
		if v.AuxInt != 3 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL2)
		v.AddArg(x)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [5] x)
	// cond:
	// result: (LEAL4 x x)
	for {
		if v.AuxInt != 5 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL4)
		v.AddArg(x)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [7] x)
	// cond:
	// result: (LEAL8 (NEGL <v.Type> x) x)
	for {
		if v.AuxInt != 7 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL8)
		v0 := b.NewValue0(v.Line, Op386NEGL, v.Type)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [9] x)
	// cond:
	// result: (LEAL8 x x)
	for {
		if v.AuxInt != 9 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL8)
		v.AddArg(x)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [11] x)
	// cond:
	// result: (LEAL2 x (LEAL4 <v.Type> x x))
	for {
		if v.AuxInt != 11 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL2)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386LEAL4, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [13] x)
	// cond:
	// result: (LEAL4 x (LEAL2 <v.Type> x x))
	for {
		if v.AuxInt != 13 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL4)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386LEAL2, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [21] x)
	// cond:
	// result: (LEAL4 x (LEAL4 <v.Type> x x))
	for {
		if v.AuxInt != 21 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL4)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386LEAL4, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [25] x)
	// cond:
	// result: (LEAL8 x (LEAL2 <v.Type> x x))
	for {
		if v.AuxInt != 25 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL8)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386LEAL2, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [37] x)
	// cond:
	// result: (LEAL4 x (LEAL8 <v.Type> x x))
	for {
		if v.AuxInt != 37 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL4)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386LEAL8, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [41] x)
	// cond:
	// result: (LEAL8 x (LEAL4 <v.Type> x x))
	for {
		if v.AuxInt != 41 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL8)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386LEAL4, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [73] x)
	// cond:
	// result: (LEAL8 x (LEAL8 <v.Type> x x))
	for {
		if v.AuxInt != 73 {
			break
		}
		x := v.Args[0]
		v.reset(Op386LEAL8)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386LEAL8, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: isPowerOfTwo(c)
	// result: (SHLLconst [log2(c)] x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c)) {
			break
		}
		v.reset(Op386SHLLconst)
		v.AuxInt = log2(c)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: isPowerOfTwo(c+1) && c >= 15
	// result: (SUBL (SHLLconst <v.Type> [log2(c+1)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c+1) && c >= 15) {
			break
		}
		v.reset(Op386SUBL)
		v0 := b.NewValue0(v.Line, Op386SHLLconst, v.Type)
		v0.AuxInt = log2(c + 1)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: isPowerOfTwo(c-1) && c >= 17
	// result: (LEAL1 (SHLLconst <v.Type> [log2(c-1)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c-1) && c >= 17) {
			break
		}
		v.reset(Op386LEAL1)
		v0 := b.NewValue0(v.Line, Op386SHLLconst, v.Type)
		v0.AuxInt = log2(c - 1)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: isPowerOfTwo(c-2) && c >= 34
	// result: (LEAL2 (SHLLconst <v.Type> [log2(c-2)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c-2) && c >= 34) {
			break
		}
		v.reset(Op386LEAL2)
		v0 := b.NewValue0(v.Line, Op386SHLLconst, v.Type)
		v0.AuxInt = log2(c - 2)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: isPowerOfTwo(c-4) && c >= 68
	// result: (LEAL4 (SHLLconst <v.Type> [log2(c-4)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c-4) && c >= 68) {
			break
		}
		v.reset(Op386LEAL4)
		v0 := b.NewValue0(v.Line, Op386SHLLconst, v.Type)
		v0.AuxInt = log2(c - 4)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: isPowerOfTwo(c-8) && c >= 136
	// result: (LEAL8 (SHLLconst <v.Type> [log2(c-8)] x) x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(isPowerOfTwo(c-8) && c >= 136) {
			break
		}
		v.reset(Op386LEAL8)
		v0 := b.NewValue0(v.Line, Op386SHLLconst, v.Type)
		v0.AuxInt = log2(c - 8)
		v0.AddArg(x)
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: c%3 == 0 && isPowerOfTwo(c/3)
	// result: (SHLLconst [log2(c/3)] (LEAL2 <v.Type> x x))
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(c%3 == 0 && isPowerOfTwo(c/3)) {
			break
		}
		v.reset(Op386SHLLconst)
		v.AuxInt = log2(c / 3)
		v0 := b.NewValue0(v.Line, Op386LEAL2, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: c%5 == 0 && isPowerOfTwo(c/5)
	// result: (SHLLconst [log2(c/5)] (LEAL4 <v.Type> x x))
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(c%5 == 0 && isPowerOfTwo(c/5)) {
			break
		}
		v.reset(Op386SHLLconst)
		v.AuxInt = log2(c / 5)
		v0 := b.NewValue0(v.Line, Op386LEAL4, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [c] x)
	// cond: c%9 == 0 && isPowerOfTwo(c/9)
	// result: (SHLLconst [log2(c/9)] (LEAL8 <v.Type> x x))
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(c%9 == 0 && isPowerOfTwo(c/9)) {
			break
		}
		v.reset(Op386SHLLconst)
		v.AuxInt = log2(c / 9)
		v0 := b.NewValue0(v.Line, Op386LEAL8, v.Type)
		v0.AddArg(x)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (MULLconst [c] (MOVLconst [d]))
	// cond:
	// result: (MOVLconst [int64(int32(c*d))])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		d := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = int64(int32(c * d))
		return true
	}
	return false
}
func rewriteValue386_Op386NEGL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NEGL (MOVLconst [c]))
	// cond:
	// result: (MOVLconst [int64(int32(-c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = int64(int32(-c))
		return true
	}
	return false
}
func rewriteValue386_Op386NOTL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NOTL (MOVLconst [c]))
	// cond:
	// result: (MOVLconst [^c])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = ^c
		return true
	}
	return false
}
func rewriteValue386_Op386ORL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ORL x (MOVLconst [c]))
	// cond:
	// result: (ORLconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386ORLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ORL (MOVLconst [c]) x)
	// cond:
	// result: (ORLconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386ORLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ORL x x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ORL                  x0:(MOVBload [i]   {s} p mem)     s0:(SHLLconst [8] x1:(MOVBload [i+1] {s} p mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && s0.Uses == 1   && mergePoint(b,x0,x1) != nil   && clobber(x0)   && clobber(x1)   && clobber(s0)
	// result: @mergePoint(b,x0,x1) (MOVWload [i] {s} p mem)
	for {
		x0 := v.Args[0]
		if x0.Op != Op386MOVBload {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		mem := x0.Args[1]
		s0 := v.Args[1]
		if s0.Op != Op386SHLLconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != Op386MOVBload {
			break
		}
		if x1.AuxInt != i+1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if mem != x1.Args[1] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && s0.Uses == 1 && mergePoint(b, x0, x1) != nil && clobber(x0) && clobber(x1) && clobber(s0)) {
			break
		}
		b = mergePoint(b, x0, x1)
		v0 := b.NewValue0(v.Line, Op386MOVWload, config.fe.TypeUInt16())
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(mem)
		return true
	}
	// match: (ORL o0:(ORL                        x0:(MOVWload [i]   {s} p mem)     s0:(SHLLconst [16] x1:(MOVBload [i+2] {s} p mem)))     s1:(SHLLconst [24] x2:(MOVBload [i+3] {s} p mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && o0.Uses == 1   && mergePoint(b,x0,x1,x2) != nil   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(s0)   && clobber(s1)   && clobber(o0)
	// result: @mergePoint(b,x0,x1,x2) (MOVLload [i] {s} p mem)
	for {
		o0 := v.Args[0]
		if o0.Op != Op386ORL {
			break
		}
		x0 := o0.Args[0]
		if x0.Op != Op386MOVWload {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		mem := x0.Args[1]
		s0 := o0.Args[1]
		if s0.Op != Op386SHLLconst {
			break
		}
		if s0.AuxInt != 16 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != Op386MOVBload {
			break
		}
		if x1.AuxInt != i+2 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if mem != x1.Args[1] {
			break
		}
		s1 := v.Args[1]
		if s1.Op != Op386SHLLconst {
			break
		}
		if s1.AuxInt != 24 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != Op386MOVBload {
			break
		}
		if x2.AuxInt != i+3 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if mem != x2.Args[1] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && o0.Uses == 1 && mergePoint(b, x0, x1, x2) != nil && clobber(x0) && clobber(x1) && clobber(x2) && clobber(s0) && clobber(s1) && clobber(o0)) {
			break
		}
		b = mergePoint(b, x0, x1, x2)
		v0 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(mem)
		return true
	}
	// match: (ORL                  x0:(MOVBloadidx1 [i]   {s} p idx mem)     s0:(SHLLconst [8] x1:(MOVBloadidx1 [i+1] {s} p idx mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && s0.Uses == 1   && mergePoint(b,x0,x1) != nil   && clobber(x0)   && clobber(x1)   && clobber(s0)
	// result: @mergePoint(b,x0,x1) (MOVWloadidx1 <v.Type> [i] {s} p idx mem)
	for {
		x0 := v.Args[0]
		if x0.Op != Op386MOVBloadidx1 {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		idx := x0.Args[1]
		mem := x0.Args[2]
		s0 := v.Args[1]
		if s0.Op != Op386SHLLconst {
			break
		}
		if s0.AuxInt != 8 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != Op386MOVBloadidx1 {
			break
		}
		if x1.AuxInt != i+1 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if idx != x1.Args[1] {
			break
		}
		if mem != x1.Args[2] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && s0.Uses == 1 && mergePoint(b, x0, x1) != nil && clobber(x0) && clobber(x1) && clobber(s0)) {
			break
		}
		b = mergePoint(b, x0, x1)
		v0 := b.NewValue0(v.Line, Op386MOVWloadidx1, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	// match: (ORL o0:(ORL                        x0:(MOVWloadidx1 [i]   {s} p idx mem)     s0:(SHLLconst [16] x1:(MOVBloadidx1 [i+2] {s} p idx mem)))     s1:(SHLLconst [24] x2:(MOVBloadidx1 [i+3] {s} p idx mem)))
	// cond: x0.Uses == 1   && x1.Uses == 1   && x2.Uses == 1   && s0.Uses == 1   && s1.Uses == 1   && o0.Uses == 1   && mergePoint(b,x0,x1,x2) != nil   && clobber(x0)   && clobber(x1)   && clobber(x2)   && clobber(s0)   && clobber(s1)   && clobber(o0)
	// result: @mergePoint(b,x0,x1,x2) (MOVLloadidx1 <v.Type> [i] {s} p idx mem)
	for {
		o0 := v.Args[0]
		if o0.Op != Op386ORL {
			break
		}
		x0 := o0.Args[0]
		if x0.Op != Op386MOVWloadidx1 {
			break
		}
		i := x0.AuxInt
		s := x0.Aux
		p := x0.Args[0]
		idx := x0.Args[1]
		mem := x0.Args[2]
		s0 := o0.Args[1]
		if s0.Op != Op386SHLLconst {
			break
		}
		if s0.AuxInt != 16 {
			break
		}
		x1 := s0.Args[0]
		if x1.Op != Op386MOVBloadidx1 {
			break
		}
		if x1.AuxInt != i+2 {
			break
		}
		if x1.Aux != s {
			break
		}
		if p != x1.Args[0] {
			break
		}
		if idx != x1.Args[1] {
			break
		}
		if mem != x1.Args[2] {
			break
		}
		s1 := v.Args[1]
		if s1.Op != Op386SHLLconst {
			break
		}
		if s1.AuxInt != 24 {
			break
		}
		x2 := s1.Args[0]
		if x2.Op != Op386MOVBloadidx1 {
			break
		}
		if x2.AuxInt != i+3 {
			break
		}
		if x2.Aux != s {
			break
		}
		if p != x2.Args[0] {
			break
		}
		if idx != x2.Args[1] {
			break
		}
		if mem != x2.Args[2] {
			break
		}
		if !(x0.Uses == 1 && x1.Uses == 1 && x2.Uses == 1 && s0.Uses == 1 && s1.Uses == 1 && o0.Uses == 1 && mergePoint(b, x0, x1, x2) != nil && clobber(x0) && clobber(x1) && clobber(x2) && clobber(s0) && clobber(s1) && clobber(o0)) {
			break
		}
		b = mergePoint(b, x0, x1, x2)
		v0 := b.NewValue0(v.Line, Op386MOVLloadidx1, v.Type)
		v.reset(OpCopy)
		v.AddArg(v0)
		v0.AuxInt = i
		v0.Aux = s
		v0.AddArg(p)
		v0.AddArg(idx)
		v0.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_Op386ORLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ORLconst [c] x)
	// cond: int32(c)==0
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ORLconst [c] _)
	// cond: int32(c)==-1
	// result: (MOVLconst [-1])
	for {
		c := v.AuxInt
		if !(int32(c) == -1) {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = -1
		return true
	}
	// match: (ORLconst [c] (MOVLconst [d]))
	// cond:
	// result: (MOVLconst [c|d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		d := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = c | d
		return true
	}
	return false
}
func rewriteValue386_Op386ROLBconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ROLBconst [c] (ROLBconst [d] x))
	// cond:
	// result: (ROLBconst [(c+d)& 7] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ROLBconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386ROLBconst)
		v.AuxInt = (c + d) & 7
		v.AddArg(x)
		return true
	}
	// match: (ROLBconst [0] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386ROLLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ROLLconst [c] (ROLLconst [d] x))
	// cond:
	// result: (ROLLconst [(c+d)&31] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ROLLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386ROLLconst)
		v.AuxInt = (c + d) & 31
		v.AddArg(x)
		return true
	}
	// match: (ROLLconst [0] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386ROLWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ROLWconst [c] (ROLWconst [d] x))
	// cond:
	// result: (ROLWconst [(c+d)&15] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386ROLWconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386ROLWconst)
		v.AuxInt = (c + d) & 15
		v.AddArg(x)
		return true
	}
	// match: (ROLWconst [0] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386SARB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SARB x (MOVLconst [c]))
	// cond:
	// result: (SARBconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SARBconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SARB x (MOVLconst [c]))
	// cond:
	// result: (SARBconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SARBconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386SARBconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SARBconst [c] (MOVLconst [d]))
	// cond:
	// result: (MOVLconst [d>>uint64(c)])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		d := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = d >> uint64(c)
		return true
	}
	return false
}
func rewriteValue386_Op386SARL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SARL x (MOVLconst [c]))
	// cond:
	// result: (SARLconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SARLconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SARL x (MOVLconst [c]))
	// cond:
	// result: (SARLconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SARLconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SARL x (ANDLconst [31] y))
	// cond:
	// result: (SARL x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ANDLconst {
			break
		}
		if v_1.AuxInt != 31 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386SARL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386SARLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SARLconst [c] (MOVLconst [d]))
	// cond:
	// result: (MOVLconst [d>>uint64(c)])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		d := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = d >> uint64(c)
		return true
	}
	return false
}
func rewriteValue386_Op386SARW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SARW x (MOVLconst [c]))
	// cond:
	// result: (SARWconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SARWconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SARW x (MOVLconst [c]))
	// cond:
	// result: (SARWconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SARWconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386SARWconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SARWconst [c] (MOVLconst [d]))
	// cond:
	// result: (MOVLconst [d>>uint64(c)])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		d := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = d >> uint64(c)
		return true
	}
	return false
}
func rewriteValue386_Op386SBBL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SBBL x (MOVLconst [c]) f)
	// cond:
	// result: (SBBLconst [c] x f)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		f := v.Args[2]
		v.reset(Op386SBBLconst)
		v.AuxInt = c
		v.AddArg(x)
		v.AddArg(f)
		return true
	}
	return false
}
func rewriteValue386_Op386SBBLcarrymask(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SBBLcarrymask (FlagEQ))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SBBLcarrymask (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [-1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = -1
		return true
	}
	// match: (SBBLcarrymask (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SBBLcarrymask (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [-1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = -1
		return true
	}
	// match: (SBBLcarrymask (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_Op386SETA(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETA (InvertFlags x))
	// cond:
	// result: (SETB x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETB)
		v.AddArg(x)
		return true
	}
	// match: (SETA (FlagEQ))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETA (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETA (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETA (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETA (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	return false
}
func rewriteValue386_Op386SETAE(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETAE (InvertFlags x))
	// cond:
	// result: (SETBE x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETBE)
		v.AddArg(x)
		return true
	}
	// match: (SETAE (FlagEQ))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETAE (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETAE (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETAE (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETAE (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	return false
}
func rewriteValue386_Op386SETB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETB (InvertFlags x))
	// cond:
	// result: (SETA x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETA)
		v.AddArg(x)
		return true
	}
	// match: (SETB (FlagEQ))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETB (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETB (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETB (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETB (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_Op386SETBE(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETBE (InvertFlags x))
	// cond:
	// result: (SETAE x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETAE)
		v.AddArg(x)
		return true
	}
	// match: (SETBE (FlagEQ))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETBE (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETBE (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETBE (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETBE (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_Op386SETEQ(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETEQ (InvertFlags x))
	// cond:
	// result: (SETEQ x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETEQ)
		v.AddArg(x)
		return true
	}
	// match: (SETEQ (FlagEQ))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETEQ (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETEQ (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETEQ (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETEQ (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_Op386SETG(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETG (InvertFlags x))
	// cond:
	// result: (SETL x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETL)
		v.AddArg(x)
		return true
	}
	// match: (SETG (FlagEQ))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETG (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETG (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETG (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETG (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	return false
}
func rewriteValue386_Op386SETGE(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETGE (InvertFlags x))
	// cond:
	// result: (SETLE x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETLE)
		v.AddArg(x)
		return true
	}
	// match: (SETGE (FlagEQ))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETGE (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETGE (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETGE (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETGE (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	return false
}
func rewriteValue386_Op386SETL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETL (InvertFlags x))
	// cond:
	// result: (SETG x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETG)
		v.AddArg(x)
		return true
	}
	// match: (SETL (FlagEQ))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETL (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETL (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETL (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETL (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_Op386SETLE(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETLE (InvertFlags x))
	// cond:
	// result: (SETGE x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETGE)
		v.AddArg(x)
		return true
	}
	// match: (SETLE (FlagEQ))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETLE (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETLE (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETLE (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETLE (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_Op386SETNE(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SETNE (InvertFlags x))
	// cond:
	// result: (SETNE x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386InvertFlags {
			break
		}
		x := v_0.Args[0]
		v.reset(Op386SETNE)
		v.AddArg(x)
		return true
	}
	// match: (SETNE (FlagEQ))
	// cond:
	// result: (MOVLconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagEQ {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	// match: (SETNE (FlagLT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETNE (FlagLT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagLT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETNE (FlagGT_ULT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_ULT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	// match: (SETNE (FlagGT_UGT))
	// cond:
	// result: (MOVLconst [1])
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386FlagGT_UGT {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 1
		return true
	}
	return false
}
func rewriteValue386_Op386SHLL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SHLL x (MOVLconst [c]))
	// cond:
	// result: (SHLLconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SHLLconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SHLL x (MOVLconst [c]))
	// cond:
	// result: (SHLLconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SHLLconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SHLL x (ANDLconst [31] y))
	// cond:
	// result: (SHLL x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ANDLconst {
			break
		}
		if v_1.AuxInt != 31 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386SHLL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386SHRB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SHRB x (MOVLconst [c]))
	// cond:
	// result: (SHRBconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SHRBconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SHRB x (MOVLconst [c]))
	// cond:
	// result: (SHRBconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SHRBconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386SHRL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SHRL x (MOVLconst [c]))
	// cond:
	// result: (SHRLconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SHRLconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SHRL x (MOVLconst [c]))
	// cond:
	// result: (SHRLconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SHRLconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SHRL x (ANDLconst [31] y))
	// cond:
	// result: (SHRL x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386ANDLconst {
			break
		}
		if v_1.AuxInt != 31 {
			break
		}
		y := v_1.Args[0]
		v.reset(Op386SHRL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValue386_Op386SHRW(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SHRW x (MOVLconst [c]))
	// cond:
	// result: (SHRWconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SHRWconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	// match: (SHRW x (MOVLconst [c]))
	// cond:
	// result: (SHRWconst [c&31] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SHRWconst)
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386SUBL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBL x (MOVLconst [c]))
	// cond:
	// result: (SUBLconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SUBLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (SUBL (MOVLconst [c]) x)
	// cond:
	// result: (NEGL (SUBLconst <v.Type> x [c]))
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386NEGL)
		v0 := b.NewValue0(v.Line, Op386SUBLconst, v.Type)
		v0.AuxInt = c
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
	// match: (SUBL x x)
	// cond:
	// result: (MOVLconst [0])
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_Op386SUBLcarry(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBLcarry x (MOVLconst [c]))
	// cond:
	// result: (SUBLconstcarry [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386SUBLconstcarry)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_Op386SUBLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBLconst [c] x)
	// cond: int32(c) == 0
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (SUBLconst [c] x)
	// cond:
	// result: (ADDLconst [int64(int32(-c))] x)
	for {
		c := v.AuxInt
		x := v.Args[0]
		v.reset(Op386ADDLconst)
		v.AuxInt = int64(int32(-c))
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_Op386XORL(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (XORL x (MOVLconst [c]))
	// cond:
	// result: (XORLconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != Op386MOVLconst {
			break
		}
		c := v_1.AuxInt
		v.reset(Op386XORLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (XORL (MOVLconst [c]) x)
	// cond:
	// result: (XORLconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		v.reset(Op386XORLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (XORL x x)
	// cond:
	// result: (MOVLconst [0])
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_Op386XORLconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (XORLconst [c] (XORLconst [d] x))
	// cond:
	// result: (XORLconst [c ^ d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386XORLconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(Op386XORLconst)
		v.AuxInt = c ^ d
		v.AddArg(x)
		return true
	}
	// match: (XORLconst [c] x)
	// cond: int32(c)==0
	// result: x
	for {
		c := v.AuxInt
		x := v.Args[0]
		if !(int32(c) == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (XORLconst [c] (MOVLconst [d]))
	// cond:
	// result: (MOVLconst [c^d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != Op386MOVLconst {
			break
		}
		d := v_0.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = c ^ d
		return true
	}
	return false
}
func rewriteValue386_OpAdd16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add16  x y)
	// cond:
	// result: (ADDL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ADDL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAdd32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add32  x y)
	// cond:
	// result: (ADDL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ADDL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAdd32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add32F x y)
	// cond:
	// result: (ADDSS x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ADDSS)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAdd32carry(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add32carry x y)
	// cond:
	// result: (ADDLcarry x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ADDLcarry)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAdd32withcarry(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add32withcarry x y c)
	// cond:
	// result: (ADCL x y c)
	for {
		x := v.Args[0]
		y := v.Args[1]
		c := v.Args[2]
		v.reset(Op386ADCL)
		v.AddArg(x)
		v.AddArg(y)
		v.AddArg(c)
		return true
	}
}
func rewriteValue386_OpAdd64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add64F x y)
	// cond:
	// result: (ADDSD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ADDSD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAdd8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add8   x y)
	// cond:
	// result: (ADDL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ADDL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAddPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AddPtr x y)
	// cond:
	// result: (ADDL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ADDL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAddr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Addr {sym} base)
	// cond:
	// result: (LEAL {sym} base)
	for {
		sym := v.Aux
		base := v.Args[0]
		v.reset(Op386LEAL)
		v.Aux = sym
		v.AddArg(base)
		return true
	}
}
func rewriteValue386_OpAnd16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And16 x y)
	// cond:
	// result: (ANDL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAnd32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And32 x y)
	// cond:
	// result: (ANDL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAnd8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And8  x y)
	// cond:
	// result: (ANDL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpAndB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AndB x y)
	// cond:
	// result: (ANDL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpBswap32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Bswap32 x)
	// cond:
	// result: (BSWAPL x)
	for {
		x := v.Args[0]
		v.reset(Op386BSWAPL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpClosureCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ClosureCall [argwid] entry closure mem)
	// cond:
	// result: (CALLclosure [argwid] entry closure mem)
	for {
		argwid := v.AuxInt
		entry := v.Args[0]
		closure := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386CALLclosure)
		v.AuxInt = argwid
		v.AddArg(entry)
		v.AddArg(closure)
		v.AddArg(mem)
		return true
	}
}
func rewriteValue386_OpCom16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com16 x)
	// cond:
	// result: (NOTL x)
	for {
		x := v.Args[0]
		v.reset(Op386NOTL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpCom32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com32 x)
	// cond:
	// result: (NOTL x)
	for {
		x := v.Args[0]
		v.reset(Op386NOTL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpCom8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com8  x)
	// cond:
	// result: (NOTL x)
	for {
		x := v.Args[0]
		v.reset(Op386NOTL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpConst16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const16  [val])
	// cond:
	// result: (MOVLconst [val])
	for {
		val := v.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValue386_OpConst32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const32  [val])
	// cond:
	// result: (MOVLconst [val])
	for {
		val := v.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValue386_OpConst32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const32F [val])
	// cond:
	// result: (MOVSSconst [val])
	for {
		val := v.AuxInt
		v.reset(Op386MOVSSconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValue386_OpConst64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const64F [val])
	// cond:
	// result: (MOVSDconst [val])
	for {
		val := v.AuxInt
		v.reset(Op386MOVSDconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValue386_OpConst8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const8   [val])
	// cond:
	// result: (MOVLconst [val])
	for {
		val := v.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValue386_OpConstBool(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ConstBool [b])
	// cond:
	// result: (MOVLconst [b])
	for {
		b := v.AuxInt
		v.reset(Op386MOVLconst)
		v.AuxInt = b
		return true
	}
}
func rewriteValue386_OpConstNil(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ConstNil)
	// cond:
	// result: (MOVLconst [0])
	for {
		v.reset(Op386MOVLconst)
		v.AuxInt = 0
		return true
	}
}
func rewriteValue386_OpConvert(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Convert <t> x mem)
	// cond:
	// result: (MOVLconvert <t> x mem)
	for {
		t := v.Type
		x := v.Args[0]
		mem := v.Args[1]
		v.reset(Op386MOVLconvert)
		v.Type = t
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
}
func rewriteValue386_OpCvt32Fto32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32Fto32 x)
	// cond:
	// result: (CVTTSS2SL x)
	for {
		x := v.Args[0]
		v.reset(Op386CVTTSS2SL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpCvt32Fto64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32Fto64F x)
	// cond:
	// result: (CVTSS2SD x)
	for {
		x := v.Args[0]
		v.reset(Op386CVTSS2SD)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpCvt32to32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32to32F x)
	// cond:
	// result: (CVTSL2SS x)
	for {
		x := v.Args[0]
		v.reset(Op386CVTSL2SS)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpCvt32to64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32to64F x)
	// cond:
	// result: (CVTSL2SD x)
	for {
		x := v.Args[0]
		v.reset(Op386CVTSL2SD)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpCvt64Fto32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64Fto32 x)
	// cond:
	// result: (CVTTSD2SL x)
	for {
		x := v.Args[0]
		v.reset(Op386CVTTSD2SL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpCvt64Fto32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64Fto32F x)
	// cond:
	// result: (CVTSD2SS x)
	for {
		x := v.Args[0]
		v.reset(Op386CVTSD2SS)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpDeferCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (DeferCall [argwid] mem)
	// cond:
	// result: (CALLdefer [argwid] mem)
	for {
		argwid := v.AuxInt
		mem := v.Args[0]
		v.reset(Op386CALLdefer)
		v.AuxInt = argwid
		v.AddArg(mem)
		return true
	}
}
func rewriteValue386_OpDiv16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div16  x y)
	// cond:
	// result: (DIVW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386DIVW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpDiv16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div16u x y)
	// cond:
	// result: (DIVWU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386DIVWU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpDiv32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32  x y)
	// cond:
	// result: (DIVL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386DIVL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpDiv32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32F x y)
	// cond:
	// result: (DIVSS x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386DIVSS)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpDiv32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32u x y)
	// cond:
	// result: (DIVLU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386DIVLU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpDiv64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div64F x y)
	// cond:
	// result: (DIVSD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386DIVSD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpDiv8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div8   x y)
	// cond:
	// result: (DIVW  (SignExt8to16 x) (SignExt8to16 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386DIVW)
		v0 := b.NewValue0(v.Line, OpSignExt8to16, config.fe.TypeInt16())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpSignExt8to16, config.fe.TypeInt16())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpDiv8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div8u  x y)
	// cond:
	// result: (DIVWU (ZeroExt8to16 x) (ZeroExt8to16 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386DIVWU)
		v0 := b.NewValue0(v.Line, OpZeroExt8to16, config.fe.TypeUInt16())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpZeroExt8to16, config.fe.TypeUInt16())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpEq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq16  x y)
	// cond:
	// result: (SETEQ (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETEQ)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpEq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq32  x y)
	// cond:
	// result: (SETEQ (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETEQ)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpEq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq32F x y)
	// cond:
	// result: (SETEQF (UCOMISS x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETEQF)
		v0 := b.NewValue0(v.Line, Op386UCOMISS, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpEq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq64F x y)
	// cond:
	// result: (SETEQF (UCOMISD x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETEQF)
		v0 := b.NewValue0(v.Line, Op386UCOMISD, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpEq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq8   x y)
	// cond:
	// result: (SETEQ (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETEQ)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpEqB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (EqB   x y)
	// cond:
	// result: (SETEQ (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETEQ)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpEqPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (EqPtr x y)
	// cond:
	// result: (SETEQ (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETEQ)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq16  x y)
	// cond:
	// result: (SETGE (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGE)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGeq16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq16U x y)
	// cond:
	// result: (SETAE (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETAE)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32  x y)
	// cond:
	// result: (SETGE (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGE)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32F x y)
	// cond:
	// result: (SETGEF (UCOMISS x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGEF)
		v0 := b.NewValue0(v.Line, Op386UCOMISS, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGeq32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32U x y)
	// cond:
	// result: (SETAE (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETAE)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq64F x y)
	// cond:
	// result: (SETGEF (UCOMISD x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGEF)
		v0 := b.NewValue0(v.Line, Op386UCOMISD, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq8   x y)
	// cond:
	// result: (SETGE (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGE)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGeq8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq8U  x y)
	// cond:
	// result: (SETAE (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETAE)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGetClosurePtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (GetClosurePtr)
	// cond:
	// result: (LoweredGetClosurePtr)
	for {
		v.reset(Op386LoweredGetClosurePtr)
		return true
	}
}
func rewriteValue386_OpGetG(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (GetG mem)
	// cond:
	// result: (LoweredGetG mem)
	for {
		mem := v.Args[0]
		v.reset(Op386LoweredGetG)
		v.AddArg(mem)
		return true
	}
}
func rewriteValue386_OpGoCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (GoCall [argwid] mem)
	// cond:
	// result: (CALLgo [argwid] mem)
	for {
		argwid := v.AuxInt
		mem := v.Args[0]
		v.reset(Op386CALLgo)
		v.AuxInt = argwid
		v.AddArg(mem)
		return true
	}
}
func rewriteValue386_OpGreater16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater16  x y)
	// cond:
	// result: (SETG (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETG)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGreater16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater16U x y)
	// cond:
	// result: (SETA (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETA)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGreater32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32  x y)
	// cond:
	// result: (SETG (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETG)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGreater32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32F x y)
	// cond:
	// result: (SETGF (UCOMISS x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGF)
		v0 := b.NewValue0(v.Line, Op386UCOMISS, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGreater32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32U x y)
	// cond:
	// result: (SETA (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETA)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGreater64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater64F x y)
	// cond:
	// result: (SETGF (UCOMISD x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGF)
		v0 := b.NewValue0(v.Line, Op386UCOMISD, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGreater8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater8   x y)
	// cond:
	// result: (SETG (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETG)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpGreater8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater8U  x y)
	// cond:
	// result: (SETA (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETA)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpHmul16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul16  x y)
	// cond:
	// result: (HMULW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386HMULW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpHmul16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul16u x y)
	// cond:
	// result: (HMULWU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386HMULWU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpHmul32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul32  x y)
	// cond:
	// result: (HMULL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386HMULL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpHmul32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul32u x y)
	// cond:
	// result: (HMULLU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386HMULLU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpHmul8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul8   x y)
	// cond:
	// result: (HMULB  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386HMULB)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpHmul8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul8u  x y)
	// cond:
	// result: (HMULBU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386HMULBU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpInterCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (InterCall [argwid] entry mem)
	// cond:
	// result: (CALLinter [argwid] entry mem)
	for {
		argwid := v.AuxInt
		entry := v.Args[0]
		mem := v.Args[1]
		v.reset(Op386CALLinter)
		v.AuxInt = argwid
		v.AddArg(entry)
		v.AddArg(mem)
		return true
	}
}
func rewriteValue386_OpIsInBounds(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsInBounds idx len)
	// cond:
	// result: (SETB (CMPL idx len))
	for {
		idx := v.Args[0]
		len := v.Args[1]
		v.reset(Op386SETB)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(idx)
		v0.AddArg(len)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpIsNonNil(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsNonNil p)
	// cond:
	// result: (SETNE (TESTL p p))
	for {
		p := v.Args[0]
		v.reset(Op386SETNE)
		v0 := b.NewValue0(v.Line, Op386TESTL, TypeFlags)
		v0.AddArg(p)
		v0.AddArg(p)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpIsSliceInBounds(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsSliceInBounds idx len)
	// cond:
	// result: (SETBE (CMPL idx len))
	for {
		idx := v.Args[0]
		len := v.Args[1]
		v.reset(Op386SETBE)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(idx)
		v0.AddArg(len)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq16  x y)
	// cond:
	// result: (SETLE (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETLE)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLeq16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq16U x y)
	// cond:
	// result: (SETBE (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETBE)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32  x y)
	// cond:
	// result: (SETLE (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETLE)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32F x y)
	// cond:
	// result: (SETGEF (UCOMISS y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGEF)
		v0 := b.NewValue0(v.Line, Op386UCOMISS, TypeFlags)
		v0.AddArg(y)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLeq32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32U x y)
	// cond:
	// result: (SETBE (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETBE)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq64F x y)
	// cond:
	// result: (SETGEF (UCOMISD y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGEF)
		v0 := b.NewValue0(v.Line, Op386UCOMISD, TypeFlags)
		v0.AddArg(y)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq8   x y)
	// cond:
	// result: (SETLE (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETLE)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLeq8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq8U  x y)
	// cond:
	// result: (SETBE (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETBE)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLess16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less16  x y)
	// cond:
	// result: (SETL (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETL)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLess16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less16U x y)
	// cond:
	// result: (SETB (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETB)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLess32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32  x y)
	// cond:
	// result: (SETL (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETL)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLess32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32F x y)
	// cond:
	// result: (SETGF (UCOMISS y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGF)
		v0 := b.NewValue0(v.Line, Op386UCOMISS, TypeFlags)
		v0.AddArg(y)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLess32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32U x y)
	// cond:
	// result: (SETB (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETB)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLess64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less64F x y)
	// cond:
	// result: (SETGF (UCOMISD y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETGF)
		v0 := b.NewValue0(v.Line, Op386UCOMISD, TypeFlags)
		v0.AddArg(y)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLess8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less8   x y)
	// cond:
	// result: (SETL (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETL)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLess8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less8U  x y)
	// cond:
	// result: (SETB (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETB)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpLoad(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Load <t> ptr mem)
	// cond: (is32BitInt(t) || isPtr(t))
	// result: (MOVLload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is32BitInt(t) || isPtr(t)) {
			break
		}
		v.reset(Op386MOVLload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is16BitInt(t)
	// result: (MOVWload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is16BitInt(t)) {
			break
		}
		v.reset(Op386MOVWload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (t.IsBoolean() || is8BitInt(t))
	// result: (MOVBload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(t.IsBoolean() || is8BitInt(t)) {
			break
		}
		v.reset(Op386MOVBload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is32BitFloat(t)
	// result: (MOVSSload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is32BitFloat(t)) {
			break
		}
		v.reset(Op386MOVSSload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is64BitFloat(t)
	// result: (MOVSDload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is64BitFloat(t)) {
			break
		}
		v.reset(Op386MOVSDload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_OpLrot16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lrot16 <t> x [c])
	// cond:
	// result: (ROLWconst <t> [c&15] x)
	for {
		t := v.Type
		c := v.AuxInt
		x := v.Args[0]
		v.reset(Op386ROLWconst)
		v.Type = t
		v.AuxInt = c & 15
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpLrot32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lrot32 <t> x [c])
	// cond:
	// result: (ROLLconst <t> [c&31] x)
	for {
		t := v.Type
		c := v.AuxInt
		x := v.Args[0]
		v.reset(Op386ROLLconst)
		v.Type = t
		v.AuxInt = c & 31
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpLrot8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lrot8  <t> x [c])
	// cond:
	// result: (ROLBconst <t> [c&7] x)
	for {
		t := v.Type
		c := v.AuxInt
		x := v.Args[0]
		v.reset(Op386ROLBconst)
		v.Type = t
		v.AuxInt = c & 7
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpLsh16x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x16 <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPWconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpLsh16x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x32 <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPLconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpLsh16x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x64 x (Const64 [c]))
	// cond: uint64(c) < 16
	// result: (SHLLconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 16) {
			break
		}
		v.reset(Op386SHLLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Lsh16x64 _ (Const64 [c]))
	// cond: uint64(c) >= 16
	// result: (Const16 [0])
	for {
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 16) {
			break
		}
		v.reset(OpConst16)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_OpLsh16x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x8  <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPBconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpLsh32x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x16 <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPWconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpLsh32x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x32 <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPLconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpLsh32x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x64 x (Const64 [c]))
	// cond: uint64(c) < 32
	// result: (SHLLconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 32) {
			break
		}
		v.reset(Op386SHLLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Lsh32x64 _ (Const64 [c]))
	// cond: uint64(c) >= 32
	// result: (Const32 [0])
	for {
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 32) {
			break
		}
		v.reset(OpConst32)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_OpLsh32x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x8  <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPBconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpLsh8x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x16 <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPWconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpLsh8x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x32 <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPLconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpLsh8x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x64 x (Const64 [c]))
	// cond: uint64(c) < 8
	// result: (SHLLconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 8) {
			break
		}
		v.reset(Op386SHLLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Lsh8x64 _ (Const64 [c]))
	// cond: uint64(c) >= 8
	// result: (Const8 [0])
	for {
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 8) {
			break
		}
		v.reset(OpConst8)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_OpLsh8x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x8  <t> x y)
	// cond:
	// result: (ANDL (SHLL <t> x y) (SBBLcarrymask <t> (CMPBconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHLL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpMod16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod16  x y)
	// cond:
	// result: (MODW  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MODW)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMod16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod16u x y)
	// cond:
	// result: (MODWU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MODWU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMod32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod32  x y)
	// cond:
	// result: (MODL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MODL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMod32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod32u x y)
	// cond:
	// result: (MODLU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MODLU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMod8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod8   x y)
	// cond:
	// result: (MODW  (SignExt8to16 x) (SignExt8to16 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MODW)
		v0 := b.NewValue0(v.Line, OpSignExt8to16, config.fe.TypeInt16())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpSignExt8to16, config.fe.TypeInt16())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpMod8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod8u  x y)
	// cond:
	// result: (MODWU (ZeroExt8to16 x) (ZeroExt8to16 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MODWU)
		v0 := b.NewValue0(v.Line, OpZeroExt8to16, config.fe.TypeUInt16())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpZeroExt8to16, config.fe.TypeUInt16())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpMove(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Move [s] _ _ mem)
	// cond: SizeAndAlign(s).Size() == 0
	// result: mem
	for {
		s := v.AuxInt
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = mem.Type
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 1
	// result: (MOVBstore dst (MOVBload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 1) {
			break
		}
		v.reset(Op386MOVBstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, Op386MOVBload, config.fe.TypeUInt8())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 2
	// result: (MOVWstore dst (MOVWload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 2) {
			break
		}
		v.reset(Op386MOVWstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, Op386MOVWload, config.fe.TypeUInt16())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 4
	// result: (MOVLstore dst (MOVLload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 4) {
			break
		}
		v.reset(Op386MOVLstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 3
	// result: (MOVBstore [2] dst (MOVBload [2] src mem) 		(MOVWstore dst (MOVWload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 3) {
			break
		}
		v.reset(Op386MOVBstore)
		v.AuxInt = 2
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, Op386MOVBload, config.fe.TypeUInt8())
		v0.AuxInt = 2
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386MOVWstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, Op386MOVWload, config.fe.TypeUInt16())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 5
	// result: (MOVBstore [4] dst (MOVBload [4] src mem) 		(MOVLstore dst (MOVLload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 5) {
			break
		}
		v.reset(Op386MOVBstore)
		v.AuxInt = 4
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, Op386MOVBload, config.fe.TypeUInt8())
		v0.AuxInt = 4
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386MOVLstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 6
	// result: (MOVWstore [4] dst (MOVWload [4] src mem) 		(MOVLstore dst (MOVLload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 6) {
			break
		}
		v.reset(Op386MOVWstore)
		v.AuxInt = 4
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, Op386MOVWload, config.fe.TypeUInt16())
		v0.AuxInt = 4
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386MOVLstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 7
	// result: (MOVLstore [3] dst (MOVLload [3] src mem) 		(MOVLstore dst (MOVLload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 7) {
			break
		}
		v.reset(Op386MOVLstore)
		v.AuxInt = 3
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v0.AuxInt = 3
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386MOVLstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 8
	// result: (MOVLstore [4] dst (MOVLload [4] src mem) 		(MOVLstore dst (MOVLload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 8) {
			break
		}
		v.reset(Op386MOVLstore)
		v.AuxInt = 4
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v0.AuxInt = 4
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386MOVLstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() > 8 && SizeAndAlign(s).Size()%4 != 0
	// result: (Move [SizeAndAlign(s).Size()-SizeAndAlign(s).Size()%4] 		(ADDLconst <dst.Type> dst [SizeAndAlign(s).Size()%4]) 		(ADDLconst <src.Type> src [SizeAndAlign(s).Size()%4]) 		(MOVLstore dst (MOVLload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() > 8 && SizeAndAlign(s).Size()%4 != 0) {
			break
		}
		v.reset(OpMove)
		v.AuxInt = SizeAndAlign(s).Size() - SizeAndAlign(s).Size()%4
		v0 := b.NewValue0(v.Line, Op386ADDLconst, dst.Type)
		v0.AuxInt = SizeAndAlign(s).Size() % 4
		v0.AddArg(dst)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386ADDLconst, src.Type)
		v1.AuxInt = SizeAndAlign(s).Size() % 4
		v1.AddArg(src)
		v.AddArg(v1)
		v2 := b.NewValue0(v.Line, Op386MOVLstore, TypeMem)
		v2.AddArg(dst)
		v3 := b.NewValue0(v.Line, Op386MOVLload, config.fe.TypeUInt32())
		v3.AddArg(src)
		v3.AddArg(mem)
		v2.AddArg(v3)
		v2.AddArg(mem)
		v.AddArg(v2)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() > 8 && SizeAndAlign(s).Size() <= 4*128 && SizeAndAlign(s).Size()%4 == 0 	&& !config.noDuffDevice
	// result: (DUFFCOPY [10*(128-SizeAndAlign(s).Size()/4)] dst src mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() > 8 && SizeAndAlign(s).Size() <= 4*128 && SizeAndAlign(s).Size()%4 == 0 && !config.noDuffDevice) {
			break
		}
		v.reset(Op386DUFFCOPY)
		v.AuxInt = 10 * (128 - SizeAndAlign(s).Size()/4)
		v.AddArg(dst)
		v.AddArg(src)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: (SizeAndAlign(s).Size() > 4*128 || config.noDuffDevice) && SizeAndAlign(s).Size()%4 == 0
	// result: (REPMOVSL dst src (MOVLconst [SizeAndAlign(s).Size()/4]) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !((SizeAndAlign(s).Size() > 4*128 || config.noDuffDevice) && SizeAndAlign(s).Size()%4 == 0) {
			break
		}
		v.reset(Op386REPMOVSL)
		v.AddArg(dst)
		v.AddArg(src)
		v0 := b.NewValue0(v.Line, Op386MOVLconst, config.fe.TypeUInt32())
		v0.AuxInt = SizeAndAlign(s).Size() / 4
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_OpMul16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul16  x y)
	// cond:
	// result: (MULL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MULL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMul32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul32  x y)
	// cond:
	// result: (MULL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MULL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMul32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul32F x y)
	// cond:
	// result: (MULSS x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MULSS)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMul32uhilo(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul32uhilo x y)
	// cond:
	// result: (MULLQU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MULLQU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMul64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul64F x y)
	// cond:
	// result: (MULSD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MULSD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpMul8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul8   x y)
	// cond:
	// result: (MULL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386MULL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpNeg16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg16  x)
	// cond:
	// result: (NEGL x)
	for {
		x := v.Args[0]
		v.reset(Op386NEGL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpNeg32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg32  x)
	// cond:
	// result: (NEGL x)
	for {
		x := v.Args[0]
		v.reset(Op386NEGL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpNeg32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg32F x)
	// cond: !config.use387
	// result: (PXOR x (MOVSSconst <config.Frontend().TypeFloat32()> [f2i(math.Copysign(0, -1))]))
	for {
		x := v.Args[0]
		if !(!config.use387) {
			break
		}
		v.reset(Op386PXOR)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386MOVSSconst, config.Frontend().TypeFloat32())
		v0.AuxInt = f2i(math.Copysign(0, -1))
		v.AddArg(v0)
		return true
	}
	// match: (Neg32F x)
	// cond: config.use387
	// result: (FCHS x)
	for {
		x := v.Args[0]
		if !(config.use387) {
			break
		}
		v.reset(Op386FCHS)
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_OpNeg64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg64F x)
	// cond: !config.use387
	// result: (PXOR x (MOVSDconst <config.Frontend().TypeFloat64()> [f2i(math.Copysign(0, -1))]))
	for {
		x := v.Args[0]
		if !(!config.use387) {
			break
		}
		v.reset(Op386PXOR)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386MOVSDconst, config.Frontend().TypeFloat64())
		v0.AuxInt = f2i(math.Copysign(0, -1))
		v.AddArg(v0)
		return true
	}
	// match: (Neg64F x)
	// cond: config.use387
	// result: (FCHS x)
	for {
		x := v.Args[0]
		if !(config.use387) {
			break
		}
		v.reset(Op386FCHS)
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_OpNeg8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg8   x)
	// cond:
	// result: (NEGL x)
	for {
		x := v.Args[0]
		v.reset(Op386NEGL)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpNeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq16  x y)
	// cond:
	// result: (SETNE (CMPW x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETNE)
		v0 := b.NewValue0(v.Line, Op386CMPW, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpNeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq32  x y)
	// cond:
	// result: (SETNE (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETNE)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpNeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq32F x y)
	// cond:
	// result: (SETNEF (UCOMISS x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETNEF)
		v0 := b.NewValue0(v.Line, Op386UCOMISS, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpNeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq64F x y)
	// cond:
	// result: (SETNEF (UCOMISD x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETNEF)
		v0 := b.NewValue0(v.Line, Op386UCOMISD, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpNeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq8   x y)
	// cond:
	// result: (SETNE (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETNE)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpNeqB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NeqB   x y)
	// cond:
	// result: (SETNE (CMPB x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETNE)
		v0 := b.NewValue0(v.Line, Op386CMPB, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpNeqPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NeqPtr x y)
	// cond:
	// result: (SETNE (CMPL x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SETNE)
		v0 := b.NewValue0(v.Line, Op386CMPL, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpNilCheck(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NilCheck ptr mem)
	// cond:
	// result: (LoweredNilCheck ptr mem)
	for {
		ptr := v.Args[0]
		mem := v.Args[1]
		v.reset(Op386LoweredNilCheck)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
}
func rewriteValue386_OpNot(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Not x)
	// cond:
	// result: (XORLconst [1] x)
	for {
		x := v.Args[0]
		v.reset(Op386XORLconst)
		v.AuxInt = 1
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpOffPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (OffPtr [off] ptr)
	// cond:
	// result: (ADDLconst [off] ptr)
	for {
		off := v.AuxInt
		ptr := v.Args[0]
		v.reset(Op386ADDLconst)
		v.AuxInt = off
		v.AddArg(ptr)
		return true
	}
}
func rewriteValue386_OpOr16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or16 x y)
	// cond:
	// result: (ORL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ORL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpOr32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or32 x y)
	// cond:
	// result: (ORL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ORL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpOr8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or8  x y)
	// cond:
	// result: (ORL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ORL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpOrB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (OrB x y)
	// cond:
	// result: (ORL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ORL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpRsh16Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux16 <t> x y)
	// cond:
	// result: (ANDL (SHRW <t> x y) (SBBLcarrymask <t> (CMPWconst y [16])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v2.AuxInt = 16
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh16Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux32 <t> x y)
	// cond:
	// result: (ANDL (SHRW <t> x y) (SBBLcarrymask <t> (CMPLconst y [16])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v2.AuxInt = 16
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh16Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux64 x (Const64 [c]))
	// cond: uint64(c) < 16
	// result: (SHRWconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 16) {
			break
		}
		v.reset(Op386SHRWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Rsh16Ux64 _ (Const64 [c]))
	// cond: uint64(c) >= 16
	// result: (Const16 [0])
	for {
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 16) {
			break
		}
		v.reset(OpConst16)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_OpRsh16Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux8  <t> x y)
	// cond:
	// result: (ANDL (SHRW <t> x y) (SBBLcarrymask <t> (CMPBconst y [16])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRW, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v2.AuxInt = 16
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh16x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x16 <t> x y)
	// cond:
	// result: (SARW <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPWconst y [16])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARW)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v3.AuxInt = 16
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpRsh16x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x32 <t> x y)
	// cond:
	// result: (SARW <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPLconst y [16])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARW)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v3.AuxInt = 16
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpRsh16x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x64 x (Const64 [c]))
	// cond: uint64(c) < 16
	// result: (SARWconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 16) {
			break
		}
		v.reset(Op386SARWconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Rsh16x64 x (Const64 [c]))
	// cond: uint64(c) >= 16
	// result: (SARWconst x [15])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 16) {
			break
		}
		v.reset(Op386SARWconst)
		v.AuxInt = 15
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_OpRsh16x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x8  <t> x y)
	// cond:
	// result: (SARW <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPBconst y [16])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARW)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v3.AuxInt = 16
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpRsh32Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux16 <t> x y)
	// cond:
	// result: (ANDL (SHRL <t> x y) (SBBLcarrymask <t> (CMPWconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh32Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux32 <t> x y)
	// cond:
	// result: (ANDL (SHRL <t> x y) (SBBLcarrymask <t> (CMPLconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh32Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux64 x (Const64 [c]))
	// cond: uint64(c) < 32
	// result: (SHRLconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 32) {
			break
		}
		v.reset(Op386SHRLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Rsh32Ux64 _ (Const64 [c]))
	// cond: uint64(c) >= 32
	// result: (Const32 [0])
	for {
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 32) {
			break
		}
		v.reset(OpConst32)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_OpRsh32Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux8  <t> x y)
	// cond:
	// result: (ANDL (SHRL <t> x y) (SBBLcarrymask <t> (CMPBconst y [32])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRL, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v2.AuxInt = 32
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh32x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x16 <t> x y)
	// cond:
	// result: (SARL <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPWconst y [32])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARL)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v3.AuxInt = 32
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpRsh32x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x32 <t> x y)
	// cond:
	// result: (SARL <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPLconst y [32])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARL)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v3.AuxInt = 32
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpRsh32x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x64 x (Const64 [c]))
	// cond: uint64(c) < 32
	// result: (SARLconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 32) {
			break
		}
		v.reset(Op386SARLconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Rsh32x64 x (Const64 [c]))
	// cond: uint64(c) >= 32
	// result: (SARLconst x [31])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 32) {
			break
		}
		v.reset(Op386SARLconst)
		v.AuxInt = 31
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_OpRsh32x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x8  <t> x y)
	// cond:
	// result: (SARL <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPBconst y [32])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARL)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v3.AuxInt = 32
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpRsh8Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux16 <t> x y)
	// cond:
	// result: (ANDL (SHRB <t> x y) (SBBLcarrymask <t> (CMPWconst y [8])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRB, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v2.AuxInt = 8
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh8Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux32 <t> x y)
	// cond:
	// result: (ANDL (SHRB <t> x y) (SBBLcarrymask <t> (CMPLconst y [8])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRB, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v2.AuxInt = 8
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh8Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux64 x (Const64 [c]))
	// cond: uint64(c) < 8
	// result: (SHRBconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 8) {
			break
		}
		v.reset(Op386SHRBconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Rsh8Ux64 _ (Const64 [c]))
	// cond: uint64(c) >= 8
	// result: (Const8 [0])
	for {
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 8) {
			break
		}
		v.reset(OpConst8)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValue386_OpRsh8Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux8  <t> x y)
	// cond:
	// result: (ANDL (SHRB <t> x y) (SBBLcarrymask <t> (CMPBconst y [8])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386ANDL)
		v0 := b.NewValue0(v.Line, Op386SHRB, t)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v2 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v2.AuxInt = 8
		v2.AddArg(y)
		v1.AddArg(v2)
		v.AddArg(v1)
		return true
	}
}
func rewriteValue386_OpRsh8x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x16 <t> x y)
	// cond:
	// result: (SARB <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPWconst y [8])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARB)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPWconst, TypeFlags)
		v3.AuxInt = 8
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpRsh8x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x32 <t> x y)
	// cond:
	// result: (SARB <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPLconst y [8])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARB)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v3.AuxInt = 8
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpRsh8x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x64 x (Const64 [c]))
	// cond: uint64(c) < 8
	// result: (SARBconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) < 8) {
			break
		}
		v.reset(Op386SARBconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (Rsh8x64 x (Const64 [c]))
	// cond: uint64(c) >= 8
	// result: (SARBconst x [7])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpConst64 {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 8) {
			break
		}
		v.reset(Op386SARBconst)
		v.AuxInt = 7
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValue386_OpRsh8x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x8  <t> x y)
	// cond:
	// result: (SARB <t> x (ORL <y.Type> y (NOTL <y.Type> (SBBLcarrymask <y.Type> (CMPBconst y [8])))))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SARB)
		v.Type = t
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, Op386ORL, y.Type)
		v0.AddArg(y)
		v1 := b.NewValue0(v.Line, Op386NOTL, y.Type)
		v2 := b.NewValue0(v.Line, Op386SBBLcarrymask, y.Type)
		v3 := b.NewValue0(v.Line, Op386CMPBconst, TypeFlags)
		v3.AuxInt = 8
		v3.AddArg(y)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpSignExt16to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt16to32 x)
	// cond:
	// result: (MOVWLSX x)
	for {
		x := v.Args[0]
		v.reset(Op386MOVWLSX)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpSignExt8to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt8to16  x)
	// cond:
	// result: (MOVBLSX x)
	for {
		x := v.Args[0]
		v.reset(Op386MOVBLSX)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpSignExt8to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt8to32  x)
	// cond:
	// result: (MOVBLSX x)
	for {
		x := v.Args[0]
		v.reset(Op386MOVBLSX)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpSignmask(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Signmask x)
	// cond:
	// result: (SARLconst x [31])
	for {
		x := v.Args[0]
		v.reset(Op386SARLconst)
		v.AuxInt = 31
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpSlicemask(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Slicemask <t> x)
	// cond:
	// result: (XORLconst [-1] (SARLconst <t> (SUBLconst <t> x [1]) [31]))
	for {
		t := v.Type
		x := v.Args[0]
		v.reset(Op386XORLconst)
		v.AuxInt = -1
		v0 := b.NewValue0(v.Line, Op386SARLconst, t)
		v0.AuxInt = 31
		v1 := b.NewValue0(v.Line, Op386SUBLconst, t)
		v1.AuxInt = 1
		v1.AddArg(x)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValue386_OpSqrt(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sqrt x)
	// cond:
	// result: (SQRTSD x)
	for {
		x := v.Args[0]
		v.reset(Op386SQRTSD)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpStaticCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (StaticCall [argwid] {target} mem)
	// cond:
	// result: (CALLstatic [argwid] {target} mem)
	for {
		argwid := v.AuxInt
		target := v.Aux
		mem := v.Args[0]
		v.reset(Op386CALLstatic)
		v.AuxInt = argwid
		v.Aux = target
		v.AddArg(mem)
		return true
	}
}
func rewriteValue386_OpStore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Store [8] ptr val mem)
	// cond: is64BitFloat(val.Type)
	// result: (MOVSDstore ptr val mem)
	for {
		if v.AuxInt != 8 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is64BitFloat(val.Type)) {
			break
		}
		v.reset(Op386MOVSDstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [4] ptr val mem)
	// cond: is32BitFloat(val.Type)
	// result: (MOVSSstore ptr val mem)
	for {
		if v.AuxInt != 4 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32BitFloat(val.Type)) {
			break
		}
		v.reset(Op386MOVSSstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [4] ptr val mem)
	// cond:
	// result: (MOVLstore ptr val mem)
	for {
		if v.AuxInt != 4 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVLstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [2] ptr val mem)
	// cond:
	// result: (MOVWstore ptr val mem)
	for {
		if v.AuxInt != 2 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVWstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [1] ptr val mem)
	// cond:
	// result: (MOVBstore ptr val mem)
	for {
		if v.AuxInt != 1 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(Op386MOVBstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_OpSub16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub16  x y)
	// cond:
	// result: (SUBL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SUBL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpSub32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub32  x y)
	// cond:
	// result: (SUBL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SUBL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpSub32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub32F x y)
	// cond:
	// result: (SUBSS x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SUBSS)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpSub32carry(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub32carry x y)
	// cond:
	// result: (SUBLcarry x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SUBLcarry)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpSub32withcarry(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub32withcarry x y c)
	// cond:
	// result: (SBBL x y c)
	for {
		x := v.Args[0]
		y := v.Args[1]
		c := v.Args[2]
		v.reset(Op386SBBL)
		v.AddArg(x)
		v.AddArg(y)
		v.AddArg(c)
		return true
	}
}
func rewriteValue386_OpSub64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub64F x y)
	// cond:
	// result: (SUBSD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SUBSD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpSub8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub8   x y)
	// cond:
	// result: (SUBL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SUBL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpSubPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SubPtr x y)
	// cond:
	// result: (SUBL  x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386SUBL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpTrunc16to8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc16to8  x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpTrunc32to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc32to16 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpTrunc32to8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc32to8  x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpXor16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor16 x y)
	// cond:
	// result: (XORL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386XORL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpXor32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor32 x y)
	// cond:
	// result: (XORL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386XORL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpXor8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor8  x y)
	// cond:
	// result: (XORL x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(Op386XORL)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValue386_OpZero(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Zero [s] _ mem)
	// cond: SizeAndAlign(s).Size() == 0
	// result: mem
	for {
		s := v.AuxInt
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = mem.Type
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 1
	// result: (MOVBstoreconst [0] destptr mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 1) {
			break
		}
		v.reset(Op386MOVBstoreconst)
		v.AuxInt = 0
		v.AddArg(destptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 2
	// result: (MOVWstoreconst [0] destptr mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 2) {
			break
		}
		v.reset(Op386MOVWstoreconst)
		v.AuxInt = 0
		v.AddArg(destptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 4
	// result: (MOVLstoreconst [0] destptr mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 4) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = 0
		v.AddArg(destptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 3
	// result: (MOVBstoreconst [makeValAndOff(0,2)] destptr 		(MOVWstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 3) {
			break
		}
		v.reset(Op386MOVBstoreconst)
		v.AuxInt = makeValAndOff(0, 2)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVWstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 5
	// result: (MOVBstoreconst [makeValAndOff(0,4)] destptr 		(MOVLstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 5) {
			break
		}
		v.reset(Op386MOVBstoreconst)
		v.AuxInt = makeValAndOff(0, 4)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 6
	// result: (MOVWstoreconst [makeValAndOff(0,4)] destptr 		(MOVLstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 6) {
			break
		}
		v.reset(Op386MOVWstoreconst)
		v.AuxInt = makeValAndOff(0, 4)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 7
	// result: (MOVLstoreconst [makeValAndOff(0,3)] destptr 		(MOVLstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 7) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = makeValAndOff(0, 3)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size()%4 != 0 && SizeAndAlign(s).Size() > 4
	// result: (Zero [SizeAndAlign(s).Size()-SizeAndAlign(s).Size()%4] (ADDLconst destptr [SizeAndAlign(s).Size()%4]) 		(MOVLstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size()%4 != 0 && SizeAndAlign(s).Size() > 4) {
			break
		}
		v.reset(OpZero)
		v.AuxInt = SizeAndAlign(s).Size() - SizeAndAlign(s).Size()%4
		v0 := b.NewValue0(v.Line, Op386ADDLconst, config.fe.TypeUInt32())
		v0.AuxInt = SizeAndAlign(s).Size() % 4
		v0.AddArg(destptr)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v1.AuxInt = 0
		v1.AddArg(destptr)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 8
	// result: (MOVLstoreconst [makeValAndOff(0,4)] destptr 		(MOVLstoreconst [0] destptr mem))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 8) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = makeValAndOff(0, 4)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v0.AuxInt = 0
		v0.AddArg(destptr)
		v0.AddArg(mem)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 12
	// result: (MOVLstoreconst [makeValAndOff(0,8)] destptr 		(MOVLstoreconst [makeValAndOff(0,4)] destptr 			(MOVLstoreconst [0] destptr mem)))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 12) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = makeValAndOff(0, 8)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v0.AuxInt = makeValAndOff(0, 4)
		v0.AddArg(destptr)
		v1 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v1.AuxInt = 0
		v1.AddArg(destptr)
		v1.AddArg(mem)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() == 16
	// result: (MOVLstoreconst [makeValAndOff(0,12)] destptr 		(MOVLstoreconst [makeValAndOff(0,8)] destptr 			(MOVLstoreconst [makeValAndOff(0,4)] destptr 				(MOVLstoreconst [0] destptr mem))))
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 16) {
			break
		}
		v.reset(Op386MOVLstoreconst)
		v.AuxInt = makeValAndOff(0, 12)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v0.AuxInt = makeValAndOff(0, 8)
		v0.AddArg(destptr)
		v1 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v1.AuxInt = makeValAndOff(0, 4)
		v1.AddArg(destptr)
		v2 := b.NewValue0(v.Line, Op386MOVLstoreconst, TypeMem)
		v2.AuxInt = 0
		v2.AddArg(destptr)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: SizeAndAlign(s).Size() > 16   && SizeAndAlign(s).Size() <= 4*128   && SizeAndAlign(s).Size()%4 == 0   && !config.noDuffDevice
	// result: (DUFFZERO [1*(128-SizeAndAlign(s).Size()/4)] destptr (MOVLconst [0]) mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() > 16 && SizeAndAlign(s).Size() <= 4*128 && SizeAndAlign(s).Size()%4 == 0 && !config.noDuffDevice) {
			break
		}
		v.reset(Op386DUFFZERO)
		v.AuxInt = 1 * (128 - SizeAndAlign(s).Size()/4)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVLconst, config.fe.TypeUInt32())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] destptr mem)
	// cond: (SizeAndAlign(s).Size() > 4*128 || (config.noDuffDevice && SizeAndAlign(s).Size() > 16))   && SizeAndAlign(s).Size()%4 == 0
	// result: (REPSTOSL destptr (MOVLconst [SizeAndAlign(s).Size()/4]) (MOVLconst [0]) mem)
	for {
		s := v.AuxInt
		destptr := v.Args[0]
		mem := v.Args[1]
		if !((SizeAndAlign(s).Size() > 4*128 || (config.noDuffDevice && SizeAndAlign(s).Size() > 16)) && SizeAndAlign(s).Size()%4 == 0) {
			break
		}
		v.reset(Op386REPSTOSL)
		v.AddArg(destptr)
		v0 := b.NewValue0(v.Line, Op386MOVLconst, config.fe.TypeUInt32())
		v0.AuxInt = SizeAndAlign(s).Size() / 4
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, Op386MOVLconst, config.fe.TypeUInt32())
		v1.AuxInt = 0
		v.AddArg(v1)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValue386_OpZeroExt16to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt16to32 x)
	// cond:
	// result: (MOVWLZX x)
	for {
		x := v.Args[0]
		v.reset(Op386MOVWLZX)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpZeroExt8to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt8to16  x)
	// cond:
	// result: (MOVBLZX x)
	for {
		x := v.Args[0]
		v.reset(Op386MOVBLZX)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpZeroExt8to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt8to32  x)
	// cond:
	// result: (MOVBLZX x)
	for {
		x := v.Args[0]
		v.reset(Op386MOVBLZX)
		v.AddArg(x)
		return true
	}
}
func rewriteValue386_OpZeromask(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Zeromask <t> x)
	// cond:
	// result: (XORLconst [-1] (SBBLcarrymask <t> (CMPLconst x [1])))
	for {
		t := v.Type
		x := v.Args[0]
		v.reset(Op386XORLconst)
		v.AuxInt = -1
		v0 := b.NewValue0(v.Line, Op386SBBLcarrymask, t)
		v1 := b.NewValue0(v.Line, Op386CMPLconst, TypeFlags)
		v1.AuxInt = 1
		v1.AddArg(x)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteBlock386(b *Block, config *Config) bool {
	switch b.Kind {
	case Block386EQ:
		// match: (EQ (InvertFlags cmp) yes no)
		// cond:
		// result: (EQ cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386EQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (FlagEQ) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (EQ (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (EQ (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (EQ (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case Block386GE:
		// match: (GE (InvertFlags cmp) yes no)
		// cond:
		// result: (LE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386LE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (GE (FlagEQ) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (GE (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (GE (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (GE (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (GE (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	case Block386GT:
		// match: (GT (InvertFlags cmp) yes no)
		// cond:
		// result: (LT cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386LT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (GT (FlagEQ) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (GT (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (GT (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (GT (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (GT (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	case BlockIf:
		// match: (If (SETL  cmp) yes no)
		// cond:
		// result: (LT  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETL {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386LT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETLE cmp) yes no)
		// cond:
		// result: (LE  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETLE {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386LE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETG  cmp) yes no)
		// cond:
		// result: (GT  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETG {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386GT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETGE cmp) yes no)
		// cond:
		// result: (GE  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETGE {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386GE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETEQ cmp) yes no)
		// cond:
		// result: (EQ  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETEQ {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386EQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETNE cmp) yes no)
		// cond:
		// result: (NE  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETNE {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386NE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETB  cmp) yes no)
		// cond:
		// result: (ULT cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETB {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386ULT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETBE cmp) yes no)
		// cond:
		// result: (ULE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETBE {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386ULE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETA  cmp) yes no)
		// cond:
		// result: (UGT cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETA {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETAE cmp) yes no)
		// cond:
		// result: (UGE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETAE {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETGF  cmp) yes no)
		// cond:
		// result: (UGT  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETGF {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETGEF cmp) yes no)
		// cond:
		// result: (UGE  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETGEF {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETEQF cmp) yes no)
		// cond:
		// result: (EQF  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETEQF {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386EQF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If (SETNEF cmp) yes no)
		// cond:
		// result: (NEF  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386SETNEF {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386NEF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (If cond yes no)
		// cond:
		// result: (NE (TESTB cond cond) yes no)
		for {
			v := b.Control
			_ = v
			cond := b.Control
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386NE
			v0 := b.NewValue0(v.Line, Op386TESTB, TypeFlags)
			v0.AddArg(cond)
			v0.AddArg(cond)
			b.SetControl(v0)
			_ = yes
			_ = no
			return true
		}
	case Block386LE:
		// match: (LE (InvertFlags cmp) yes no)
		// cond:
		// result: (GE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386GE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (LE (FlagEQ) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LE (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LE (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LE (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (LE (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case Block386LT:
		// match: (LT (InvertFlags cmp) yes no)
		// cond:
		// result: (GT cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386GT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (LT (FlagEQ) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (LT (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LT (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LT (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (LT (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case Block386NE:
		// match: (NE (TESTB (SETL  cmp) (SETL  cmp)) yes no)
		// cond:
		// result: (LT  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETL {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETL {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386LT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETLE cmp) (SETLE cmp)) yes no)
		// cond:
		// result: (LE  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETLE {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETLE {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386LE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETG  cmp) (SETG  cmp)) yes no)
		// cond:
		// result: (GT  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETG {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETG {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386GT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETGE cmp) (SETGE cmp)) yes no)
		// cond:
		// result: (GE  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETGE {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETGE {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386GE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETEQ cmp) (SETEQ cmp)) yes no)
		// cond:
		// result: (EQ  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETEQ {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETEQ {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386EQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETNE cmp) (SETNE cmp)) yes no)
		// cond:
		// result: (NE  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETNE {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETNE {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386NE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETB  cmp) (SETB  cmp)) yes no)
		// cond:
		// result: (ULT cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETB {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETB {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386ULT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETBE cmp) (SETBE cmp)) yes no)
		// cond:
		// result: (ULE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETBE {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETBE {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386ULE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETA  cmp) (SETA  cmp)) yes no)
		// cond:
		// result: (UGT cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETA {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETA {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETAE cmp) (SETAE cmp)) yes no)
		// cond:
		// result: (UGE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETAE {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETAE {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETGF  cmp) (SETGF  cmp)) yes no)
		// cond:
		// result: (UGT  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETGF {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETGF {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETGEF cmp) (SETGEF cmp)) yes no)
		// cond:
		// result: (UGE  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETGEF {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETGEF {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETEQF cmp) (SETEQF cmp)) yes no)
		// cond:
		// result: (EQF  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETEQF {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETEQF {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386EQF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (TESTB (SETNEF cmp) (SETNEF cmp)) yes no)
		// cond:
		// result: (NEF  cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386TESTB {
				break
			}
			v_0 := v.Args[0]
			if v_0.Op != Op386SETNEF {
				break
			}
			cmp := v_0.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != Op386SETNEF {
				break
			}
			if cmp != v_1.Args[0] {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386NEF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (InvertFlags cmp) yes no)
		// cond:
		// result: (NE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386NE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (FlagEQ) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (NE (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	case Block386UGE:
		// match: (UGE (InvertFlags cmp) yes no)
		// cond:
		// result: (ULE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386ULE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (UGE (FlagEQ) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (UGE (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (UGE (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (UGE (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (UGE (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	case Block386UGT:
		// match: (UGT (InvertFlags cmp) yes no)
		// cond:
		// result: (ULT cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386ULT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (UGT (FlagEQ) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (UGT (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (UGT (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (UGT (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (UGT (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	case Block386ULE:
		// match: (ULE (InvertFlags cmp) yes no)
		// cond:
		// result: (UGE cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (ULE (FlagEQ) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (ULE (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (ULE (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (ULE (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (ULE (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case Block386ULT:
		// match: (ULT (InvertFlags cmp) yes no)
		// cond:
		// result: (UGT cmp yes no)
		for {
			v := b.Control
			if v.Op != Op386InvertFlags {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = Block386UGT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (ULT (FlagEQ) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagEQ {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (ULT (FlagLT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (ULT (FlagLT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagLT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (ULT (FlagGT_ULT) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_ULT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (ULT (FlagGT_UGT) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != Op386FlagGT_UGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	}
	return false
}
