"use strict";

var isFunction = require("../function/is-function")
  , isObject   = require("./is-object")
  , isValue    = require("./is-value");

module.exports = function (value) {
	return (
		(isValue(value) &&
			typeof value.length === "number" &&
			// Just checking ((typeof x === 'object') && (typeof x !== 'function'))
			// won't work right for some cases, e.g.:
			// type of instance of NodeList in Safari is a 'function'

			((isObject(value) && !isFunction(value)) || typeof value === "string")) ||
		false
	);
};
