/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;

public final class ENewArray
extends AExpression {
    private final String type;
    private final List<AExpression> arguments;
    private final boolean initialize;

    public ENewArray(Location location, String type, List<AExpression> arguments, boolean initialize) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.arguments = Objects.requireNonNull(arguments);
        this.initialize = initialize;
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression argument : this.arguments) {
            argument.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        Definition.Type type;
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("A newly created array must be read from."));
        }
        try {
            type = locals.getDefinition().getType(this.type);
        }
        catch (IllegalArgumentException exception) {
            throw this.createError(new IllegalArgumentException("Not a type [" + this.type + "]."));
        }
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.expected = this.initialize ? locals.getDefinition().getType(type.struct, 0) : Definition.INT_TYPE;
            expression.internal = true;
            expression.analyze(locals);
            this.arguments.set(argument, expression.cast(locals));
        }
        this.actual = locals.getDefinition().getType(type.struct, this.initialize ? 1 : this.arguments.size());
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.initialize) {
            writer.push(this.arguments.size());
            writer.newArray(this.actual.struct.type);
            for (int index = 0; index < this.arguments.size(); ++index) {
                AExpression argument = this.arguments.get(index);
                writer.dup();
                writer.push(index);
                argument.write(writer, globals);
                writer.arrayStore(this.actual.struct.type);
            }
        } else {
            for (AExpression argument : this.arguments) {
                argument.write(writer, globals);
            }
            if (this.arguments.size() > 1) {
                writer.visitMultiANewArrayInsn(this.actual.type.getDescriptor(), this.actual.type.getDimensions());
            } else {
                writer.newArray(this.actual.struct.type);
            }
        }
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.type, this.initialize ? "init" : "dims");
    }
}

