/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptContextRegistry;
import org.elasticsearch.script.ScriptSettings;
import org.elasticsearch.script.ScriptType;

public class ScriptModes {
    private static final String SCRIPT_SETTINGS_PREFIX = "script";
    private static final String ENGINE_SETTINGS_PREFIX = "script.engine";
    final Map<String, Boolean> scriptEnabled;
    private static final String NONE = "none";
    private static final Setting<List<String>> TYPES_ALLOWED_SETTING = Setting.listSetting("script.allowed_types", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private static final Setting<List<String>> CONTEXTS_ALLOWED_SETTING = Setting.listSetting("script.allowed_contexts", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private final Set<String> typesAllowed;
    private final Set<String> contextsAllowed;

    ScriptModes(ScriptContextRegistry scriptContextRegistry, ScriptSettings scriptSettings, Settings settings) {
        HashMap<String, Boolean> scriptModes = new HashMap<String, Boolean>();
        for (Setting<Boolean> scriptModeSetting : scriptSettings.getScriptLanguageSettings()) {
            scriptModes.put(scriptModeSetting.getKey(), scriptModeSetting.get(settings));
        }
        this.scriptEnabled = Collections.unmodifiableMap(scriptModes);
        HashSet hashSet = this.typesAllowed = TYPES_ALLOWED_SETTING.exists(settings) ? new HashSet() : null;
        if (this.typesAllowed != null) {
            List<String> typesAllowedList = TYPES_ALLOWED_SETTING.get(settings);
            if (typesAllowedList.isEmpty()) {
                throw new IllegalArgumentException("must specify at least one script type or none for setting [" + TYPES_ALLOWED_SETTING.getKey() + "].");
            }
            for (String settingType : typesAllowedList) {
                if (NONE.equals(settingType)) {
                    if (typesAllowedList.size() == 1) break;
                    throw new IllegalArgumentException("cannot specify both [none] and other script types for setting [" + TYPES_ALLOWED_SETTING.getKey() + "].");
                }
                boolean found = false;
                for (ScriptType scriptType : ScriptType.values()) {
                    if (!scriptType.getName().equals(settingType)) continue;
                    found = true;
                    this.typesAllowed.add(settingType);
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("unknown script type [" + settingType + "] found in setting [" + TYPES_ALLOWED_SETTING.getKey() + "].");
            }
        }
        HashSet hashSet2 = this.contextsAllowed = CONTEXTS_ALLOWED_SETTING.exists(settings) ? new HashSet() : null;
        if (this.contextsAllowed != null) {
            List<String> contextsAllowedList = CONTEXTS_ALLOWED_SETTING.get(settings);
            if (contextsAllowedList.isEmpty()) {
                throw new IllegalArgumentException("must specify at least one script context or none for setting [" + CONTEXTS_ALLOWED_SETTING.getKey() + "].");
            }
            for (String settingContext : contextsAllowedList) {
                if (NONE.equals(settingContext)) {
                    if (contextsAllowedList.size() == 1) break;
                    throw new IllegalArgumentException("cannot specify both [none] and other script contexts for setting [" + CONTEXTS_ALLOWED_SETTING.getKey() + "].");
                }
                if (scriptContextRegistry.isSupportedContext(settingContext)) {
                    this.contextsAllowed.add(settingContext);
                    continue;
                }
                throw new IllegalArgumentException("unknown script context [" + settingContext + "] found in setting [" + CONTEXTS_ALLOWED_SETTING.getKey() + "].");
            }
        }
    }

    public boolean getScriptEnabled(String lang, ScriptType scriptType, ScriptContext scriptContext) {
        if ("native".equals(lang)) {
            return true;
        }
        if (this.typesAllowed != null && !this.typesAllowed.contains(scriptType.getName())) {
            throw new IllegalArgumentException("[" + scriptType.getName() + "] scripts cannot be executed");
        }
        if (this.contextsAllowed != null && !this.contextsAllowed.contains(scriptContext.getKey())) {
            throw new IllegalArgumentException("[" + scriptContext.getKey() + "] scripts cannot be executed");
        }
        Boolean scriptMode = this.scriptEnabled.get(ScriptModes.getKey(lang, scriptType, scriptContext));
        if (scriptMode == null) {
            throw new IllegalArgumentException("script mode not found for lang [" + lang + "], script_type [" + scriptType + "], operation [" + scriptContext.getKey() + "]");
        }
        return scriptMode;
    }

    static String operationKey(ScriptContext scriptContext) {
        return "script." + scriptContext.getKey();
    }

    static String sourceKey(ScriptType scriptType) {
        return "script." + scriptType.getName();
    }

    static String getGlobalKey(String lang, ScriptType scriptType) {
        return "script.engine." + lang + "." + scriptType;
    }

    static String getKey(String lang, ScriptType scriptType, ScriptContext scriptContext) {
        return "script.engine." + lang + "." + scriptType + "." + scriptContext.getKey();
    }

    public String toString() {
        TreeMap<String, Boolean> scriptModesTreeMap = new TreeMap<String, Boolean>();
        scriptModesTreeMap.putAll(this.scriptEnabled);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry stringScriptModeEntry : scriptModesTreeMap.entrySet()) {
            stringBuilder.append((String)stringScriptModeEntry.getKey()).append(": ").append(stringScriptModeEntry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }
}

