/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;

public abstract class ModuleSourceProviderBase
implements ModuleSourceProvider,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public ModuleSource loadSource(String string, Scriptable scriptable, Object object) throws IOException, URISyntaxException {
        if (!this.entityNeedsRevalidation(object)) {
            return NOT_MODIFIED;
        }
        ModuleSource moduleSource = this.loadFromPrivilegedLocations(string, object);
        if (moduleSource != null) {
            return moduleSource;
        }
        if (scriptable != null && (moduleSource = this.loadFromPathArray(string, scriptable, object)) != null) {
            return moduleSource;
        }
        return this.loadFromFallbackLocations(string, object);
    }

    @Override
    public ModuleSource loadSource(URI uRI, URI uRI2, Object object) throws IOException, URISyntaxException {
        return this.loadFromUri(uRI, uRI2, object);
    }

    private ModuleSource loadFromPathArray(String string, Scriptable scriptable, Object object) throws IOException {
        long l = ScriptRuntime.toUint32(ScriptableObject.getProperty(scriptable, "length"));
        int n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        for (int i = 0; i < n; ++i) {
            String string2 = ModuleSourceProviderBase.ensureTrailingSlash(ScriptableObject.getTypedProperty(scriptable, i, String.class));
            try {
                ModuleSource moduleSource;
                URI uRI = new URI(string2);
                if (!uRI.isAbsolute()) {
                    uRI = new File(string2).toURI().resolve("");
                }
                if ((moduleSource = this.loadFromUri(uRI.resolve(string), uRI, object)) == null) continue;
                return moduleSource;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new MalformedURLException(uRISyntaxException.getMessage());
            }
        }
        return null;
    }

    private static String ensureTrailingSlash(String string) {
        return string.endsWith("/") ? string : string.concat("/");
    }

    protected boolean entityNeedsRevalidation(Object object) {
        return true;
    }

    protected abstract ModuleSource loadFromUri(URI var1, URI var2, Object var3) throws IOException, URISyntaxException;

    protected ModuleSource loadFromPrivilegedLocations(String string, Object object) throws IOException, URISyntaxException {
        return null;
    }

    protected ModuleSource loadFromFallbackLocations(String string, Object object) throws IOException, URISyntaxException {
        return null;
    }
}

