/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.view;

import ch.ehi.basics.i18n.MessageFormat;
import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.view.GenericFileFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileChooser
extends JFileChooser {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(FileChooser.class);
    private boolean isOutputDirDialog = false;

    public FileChooser() {
    }

    public FileChooser(File file) {
        super(file);
    }

    public FileChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
    }

    public FileChooser(FileSystemView fileSystemView) {
        super(fileSystemView);
    }

    public FileChooser(String string) {
        super(string);
    }

    public FileChooser(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter instanceof GenericFileFilter && GenericFileFilter.getFileExtension(file) == null) {
            file = new File(file.getAbsolutePath() + "." + ((GenericFileFilter)fileFilter).getExtension());
            this.setSelectedFile(file);
        }
        if (this.getDialogType() == 0) {
            if (!file.isFile()) {
                JOptionPane.showMessageDialog(this, rsrc.getString("CTfiledoesntexist"), this.getDialogTitle(), 0);
                return;
            }
        } else if (this.getDialogType() == 1) {
            if (file.exists()) {
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(this, rsrc.getString("CTfileisntwriteable"), this.getDialogTitle(), 0);
                    return;
                }
                int n = JOptionPane.showConfirmDialog(this, rsrc.getString("CTfileexists"), this.getDialogTitle(), 1, 3);
                if (n == -1 || n == 2) {
                    this.cancelSelection();
                    return;
                }
                if (n != 0) {
                    return;
                }
            }
        } else if (this.isOutputDirDialog && file.exists()) {
            if (!file.canWrite()) {
                JOptionPane.showMessageDialog(this, rsrc.getString("CTdirisntwriteable"), this.getDialogTitle(), 0);
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, MessageFormat.format(rsrc, "CTdirexists", file.getAbsolutePath()), this.getDialogTitle(), 1, 3);
            if (n == -1 || n == 2) {
                this.cancelSelection();
                return;
            }
            if (n != 0) {
                return;
            }
        }
        super.approveSelection();
    }

    public static boolean approveFile(String string, Component component, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        if (!file.canWrite()) {
            JOptionPane.showMessageDialog(component, rsrc.getString("CTfileisntwriteable"), string2, 0);
            return false;
        }
        int n = JOptionPane.showConfirmDialog(component, rsrc.getString("CTfileexists"), string2, 1, 3);
        if (n == -1 || n == 2) {
            return false;
        }
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showOutputDirDialog(Component component) {
        this.setFileSelectionMode(1);
        this.setFileFilter(new GenericFileFilter(rsrc.getString("CTdirectories"), ""));
        this.setDialogTitle(rsrc.getString("CToutputDirTitle"));
        this.isOutputDirDialog = true;
        int n = 1;
        try {
            n = this.showDialog(component, rsrc.getString("CTdirectoryApproveButton"));
        }
        finally {
            this.isOutputDirDialog = false;
        }
        return n;
    }

    public int showInputDirDialog(Component component) {
        this.setFileSelectionMode(1);
        this.setFileFilter(new GenericFileFilter(rsrc.getString("CTdirectories"), ""));
        this.setDialogTitle(rsrc.getString("CTinputDirTitle"));
        return this.showDialog(component, rsrc.getString("CTdirectoryApproveButton"));
    }
}

