/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.ListeningCollection;

public class GpxData
extends WithAttributes
implements Data {
    public File storageFile;
    public boolean fromServer;
    public String creator;
    private final ArrayList<GpxTrack> privateTracks = new ArrayList();
    private final ArrayList<GpxRoute> privateRoutes = new ArrayList();
    private final ArrayList<WayPoint> privateWaypoints = new ArrayList();
    private final GpxTrack.GpxTrackChangeListener proxy = gpxTrackChangeEvent -> this.fireInvalidate();
    public final Collection<GpxTrack> tracks = new ListeningCollection<GpxTrack>(this.privateTracks, this::fireInvalidate){

        @Override
        protected void removed(GpxTrack gpxTrack) {
            gpxTrack.removeListener(GpxData.this.proxy);
            super.removed(gpxTrack);
        }

        @Override
        protected void added(GpxTrack gpxTrack) {
            super.added(gpxTrack);
            gpxTrack.addListener(GpxData.this.proxy);
        }
    };
    public final Collection<GpxRoute> routes = new ListeningCollection<GpxRoute>(this.privateRoutes, this::fireInvalidate);
    public final Collection<WayPoint> waypoints = new ListeningCollection<WayPoint>(this.privateWaypoints, this::fireInvalidate);
    public final Set<DataSource> dataSources = new HashSet<DataSource>();
    private final ListenerList<GpxDataChangeListener> listeners = ListenerList.create();

    public void mergeFrom(GpxData gpxData) {
        if (this.storageFile == null && gpxData.storageFile != null) {
            this.storageFile = gpxData.storageFile;
        }
        this.fromServer = this.fromServer && gpxData.fromServer;
        for (Map.Entry entry : gpxData.attr.entrySet()) {
            String string = (String)entry.getKey();
            if ("meta.links".equals(string) && this.attr.containsKey("meta.links")) {
                Collection collection = super.getCollection("meta.links");
                Collection collection2 = (Collection)entry.getValue();
                collection.addAll(collection2);
                continue;
            }
            this.put(string, entry.getValue());
        }
        gpxData.getTracks().forEach(this::addTrack);
        gpxData.getRoutes().forEach(this::addRoute);
        gpxData.getWaypoints().forEach(this::addWaypoint);
        this.dataSources.addAll(gpxData.dataSources);
        this.fireInvalidate();
    }

    public Collection<GpxTrack> getTracks() {
        return Collections.unmodifiableCollection(this.privateTracks);
    }

    public void addTrack(GpxTrack gpxTrack) {
        if (this.privateTracks.stream().anyMatch(gpxTrack2 -> gpxTrack2 == gpxTrack)) {
            throw new IllegalArgumentException(MessageFormat.format("The track was already added to this data: {0}", gpxTrack));
        }
        this.privateTracks.add(gpxTrack);
        gpxTrack.addListener(this.proxy);
        this.fireInvalidate();
    }

    public void removeTrack(GpxTrack gpxTrack) {
        if (!this.privateTracks.removeIf(gpxTrack2 -> gpxTrack2 == gpxTrack)) {
            throw new IllegalArgumentException(MessageFormat.format("The track was not in this data: {0}", gpxTrack));
        }
        gpxTrack.removeListener(this.proxy);
        this.fireInvalidate();
    }

    public Collection<GpxRoute> getRoutes() {
        return Collections.unmodifiableCollection(this.privateRoutes);
    }

    public void addRoute(GpxRoute gpxRoute) {
        if (this.privateRoutes.stream().anyMatch(gpxRoute2 -> gpxRoute2 == gpxRoute)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was already added to this data: {0}", gpxRoute));
        }
        this.privateRoutes.add(gpxRoute);
        this.fireInvalidate();
    }

    public void removeRoute(GpxRoute gpxRoute) {
        if (!this.privateRoutes.removeIf(gpxRoute2 -> gpxRoute2 == gpxRoute)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was not in this data: {0}", gpxRoute));
        }
        this.fireInvalidate();
    }

    public Collection<WayPoint> getWaypoints() {
        return Collections.unmodifiableCollection(this.privateWaypoints);
    }

    public void addWaypoint(WayPoint wayPoint) {
        if (this.privateWaypoints.stream().anyMatch(wayPoint2 -> wayPoint2 == wayPoint)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was already added to this data: {0}", wayPoint));
        }
        this.privateWaypoints.add(wayPoint);
        this.fireInvalidate();
    }

    public void removeWaypoint(WayPoint wayPoint) {
        if (!this.privateWaypoints.removeIf(wayPoint2 -> wayPoint2 == wayPoint)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was not in this data: {0}", wayPoint));
        }
        this.fireInvalidate();
    }

    public boolean hasTrackPoints() {
        return this.getTrackPoints().findAny().isPresent();
    }

    public Stream<WayPoint> getTrackPoints() {
        return this.getTracks().stream().flatMap(gpxTrack -> gpxTrack.getSegments().stream()).flatMap(gpxTrackSegment -> gpxTrackSegment.getWayPoints().stream());
    }

    public boolean hasRoutePoints() {
        return this.getRoutes().stream().anyMatch(gpxRoute -> !gpxRoute.routePoints.isEmpty());
    }

    public boolean isEmpty() {
        return !this.hasRoutePoints() && !this.hasTrackPoints() && this.waypoints.isEmpty();
    }

    public Bounds getMetaBounds() {
        Object object = this.get("meta.bounds");
        if (object instanceof Bounds) {
            return (Bounds)object;
        }
        return null;
    }

    public Bounds recalculateBounds() {
        Bounds bounds = null;
        for (WayPoint iWithAttributes : this.getWaypoints()) {
            if (bounds == null) {
                bounds = new Bounds(iWithAttributes.getCoor());
                continue;
            }
            bounds.extend(iWithAttributes.getCoor());
        }
        for (GpxRoute gpxRoute : this.getRoutes()) {
            for (WayPoint wayPoint : gpxRoute.routePoints) {
                if (bounds == null) {
                    bounds = new Bounds(wayPoint.getCoor());
                    continue;
                }
                bounds.extend(wayPoint.getCoor());
            }
        }
        for (GpxTrack gpxTrack : this.getTracks()) {
            Bounds bounds2 = gpxTrack.getBounds();
            if (bounds2 == null) continue;
            if (bounds == null) {
                bounds = new Bounds(bounds2);
                continue;
            }
            bounds.extend(bounds2);
        }
        return bounds;
    }

    public double length() {
        return this.getTracks().stream().mapToDouble(GpxTrack::length).sum();
    }

    public static Date[] getMinMaxTimeForTrack(GpxTrack gpxTrack) {
        Date[] dateArray;
        DoubleSummaryStatistics doubleSummaryStatistics = gpxTrack.getSegments().stream().flatMap(gpxTrackSegment -> gpxTrackSegment.getWayPoints().stream()).mapToDouble(wayPoint -> wayPoint.time).summaryStatistics();
        if (doubleSummaryStatistics.getCount() == 0L) {
            dateArray = null;
        } else {
            Date[] dateArray2 = new Date[2];
            dateArray2[0] = new Date((long)(doubleSummaryStatistics.getMin() * 1000.0));
            dateArray = dateArray2;
            dateArray2[1] = new Date((long)(doubleSummaryStatistics.getMax() * 1000.0));
        }
        return dateArray;
    }

    public Date[] getMinMaxTimeForAllTracks() {
        Date[] dateArray;
        double d = (double)System.currentTimeMillis() / 1000.0;
        DoubleSummaryStatistics doubleSummaryStatistics = this.tracks.stream().flatMap(gpxTrack -> gpxTrack.getSegments().stream()).flatMap(gpxTrackSegment -> gpxTrackSegment.getWayPoints().stream()).mapToDouble(wayPoint -> wayPoint.time).filter(d2 -> d2 > 0.0 && d2 <= d).summaryStatistics();
        if (doubleSummaryStatistics.getCount() == 0L) {
            dateArray = new Date[]{};
        } else {
            Date[] dateArray2 = new Date[2];
            dateArray2[0] = new Date((long)(doubleSummaryStatistics.getMin() * 1000.0));
            dateArray = dateArray2;
            dateArray2[1] = new Date((long)(doubleSummaryStatistics.getMax() * 1000.0));
        }
        return dateArray;
    }

    public WayPoint nearestPointOnTrack(EastNorth eastNorth, double d) {
        double d2 = d * d;
        Object object = null;
        double d3 = 0.0;
        double d4 = eastNorth.east();
        double d5 = eastNorth.north();
        double d6 = 0.0;
        double d7 = 0.0;
        for (GpxTrack gpxTrack : this.getTracks()) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                double d8;
                double d9;
                double d10;
                ILatLon iLatLon = null;
                Object object2 = gpxTrackSegment.getWayPoints().iterator();
                while (object2.hasNext()) {
                    double d11;
                    WayPoint wayPoint = object2.next();
                    EastNorth eastNorth2 = wayPoint.getEastNorth();
                    if (iLatLon == null) {
                        iLatLon = wayPoint;
                        d6 = eastNorth2.east();
                        d10 = d4 - d6;
                        d11 = d10 * d10 + (d9 = d5 - (d7 = eastNorth2.north())) * d9;
                        if (!(d11 < d2)) continue;
                        d2 = d11;
                        object = eastNorth2;
                        d3 = ((WayPoint)iLatLon).time;
                        continue;
                    }
                    double d12 = eastNorth2.east();
                    double d13 = eastNorth2.north();
                    d11 = d13 - d7;
                    double d14 = d6 - d12;
                    double d15 = -d11 * d6 - d14 * d7;
                    double d16 = d11 * d11 + d14 * d14;
                    if (d16 == 0.0) continue;
                    double d17 = d11 * d4 + d14 * d5 + d15;
                    if ((d17 = d17 * d17 / d16) < d2) {
                        d10 = d4 - d6;
                        d9 = d5 - d7;
                        double d18 = d10 * d10 + d9 * d9;
                        d10 = d4 - d12;
                        d9 = d5 - d13;
                        double d19 = d10 * d10 + d9 * d9;
                        if (d18 - d17 <= d16 && d19 - d17 <= d16) {
                            double d20 = Math.sqrt((d18 - d17) / d16);
                            double d21 = d6 - d20 * d14;
                            double d22 = d7 + d20 * d11;
                            object = new EastNorth(d21, d22);
                            d3 = ((WayPoint)iLatLon).time + d20 * (wayPoint.time - ((WayPoint)iLatLon).time);
                            d2 = d17;
                        }
                    }
                    iLatLon = wayPoint;
                    d6 = d12;
                    d7 = d13;
                }
                if (iLatLon == null || !((d8 = (d10 = d4 - (d6 = ((EastNorth)(object2 = iLatLon.getEastNorth())).east())) * d10 + (d9 = d5 - (d7 = ((EastNorth)object2).north())) * d9) < d2)) continue;
                d2 = d8;
                object = object2;
                d3 = ((WayPoint)iLatLon).time;
            }
        }
        if (object == null) {
            return null;
        }
        WayPoint wayPoint = new WayPoint(Main.getProjection().eastNorth2latlon((EastNorth)object));
        wayPoint.time = d3;
        return wayPoint;
    }

    public Iterable<Collection<WayPoint>> getLinesIterable(boolean ... blArray) {
        return () -> new LinesIterator(this, blArray);
    }

    public void resetEastNorthCache() {
        this.getWaypoints().forEach(WayPoint::invalidateEastNorthCache);
        this.getTrackPoints().forEach(WayPoint::invalidateEastNorthCache);
        for (GpxRoute gpxRoute : this.getRoutes()) {
            if (gpxRoute.routePoints == null) continue;
            for (WayPoint wayPoint : gpxRoute.routePoints) {
                wayPoint.invalidateEastNorthCache();
            }
        }
    }

    @Override
    public Collection<DataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.dataSources);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.dataSources == null ? 0 : this.dataSources.hashCode());
        n = 31 * n + (this.privateRoutes == null ? 0 : this.privateRoutes.hashCode());
        n = 31 * n + (this.privateTracks == null ? 0 : this.privateTracks.hashCode());
        n = 31 * n + (this.privateWaypoints == null ? 0 : this.privateWaypoints.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GpxData gpxData = (GpxData)object;
        if (this.dataSources == null ? gpxData.dataSources != null : !this.dataSources.equals(gpxData.dataSources)) {
            return false;
        }
        if (this.privateRoutes == null ? gpxData.privateRoutes != null : !this.privateRoutes.equals(gpxData.privateRoutes)) {
            return false;
        }
        if (this.privateTracks == null ? gpxData.privateTracks != null : !this.privateTracks.equals(gpxData.privateTracks)) {
            return false;
        }
        return !(this.privateWaypoints == null ? gpxData.privateWaypoints != null : !this.privateWaypoints.equals(gpxData.privateWaypoints));
    }

    public void addChangeListener(GpxDataChangeListener gpxDataChangeListener) {
        this.listeners.addListener(gpxDataChangeListener);
    }

    public void addWeakChangeListener(GpxDataChangeListener gpxDataChangeListener) {
        this.listeners.addWeakListener(gpxDataChangeListener);
    }

    public void removeChangeListener(GpxDataChangeListener gpxDataChangeListener) {
        this.listeners.removeListener(gpxDataChangeListener);
    }

    private void fireInvalidate() {
        if (this.listeners.hasListeners()) {
            GpxDataChangeEvent gpxDataChangeEvent = new GpxDataChangeEvent(this);
            this.listeners.fireEvent(gpxDataChangeListener -> gpxDataChangeListener.gpxDataChanged(gpxDataChangeEvent));
        }
    }

    public static class GpxDataChangeEvent {
        private final GpxData source;

        GpxDataChangeEvent(GpxData gpxData) {
            this.source = gpxData;
        }

        public GpxData getSource() {
            return this.source;
        }
    }

    @FunctionalInterface
    public static interface GpxDataChangeListener {
        public void gpxDataChanged(GpxDataChangeEvent var1);
    }

    public static class LinesIterator
    implements Iterator<Collection<WayPoint>> {
        private Iterator<GpxTrack> itTracks;
        private int idxTracks;
        private Iterator<GpxTrackSegment> itTrackSegments;
        private final Iterator<GpxRoute> itRoutes;
        private Collection<WayPoint> next;
        private final boolean[] trackVisibility;

        public LinesIterator(GpxData gpxData, boolean ... blArray) {
            this.itTracks = gpxData.tracks.iterator();
            this.idxTracks = -1;
            this.itRoutes = gpxData.routes.iterator();
            this.trackVisibility = blArray;
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Collection<WayPoint> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Collection<WayPoint> collection = this.next;
            this.next = this.getNext();
            return collection;
        }

        private Collection<WayPoint> getNext() {
            if (this.itTracks != null) {
                if (this.itTrackSegments != null && this.itTrackSegments.hasNext()) {
                    return this.itTrackSegments.next().getWayPoints();
                }
                while (this.itTracks.hasNext()) {
                    GpxTrack gpxTrack = this.itTracks.next();
                    ++this.idxTracks;
                    if (this.trackVisibility != null && !this.trackVisibility[this.idxTracks]) continue;
                    this.itTrackSegments = gpxTrack.getSegments().iterator();
                    if (!this.itTrackSegments.hasNext()) continue;
                    return this.itTrackSegments.next().getWayPoints();
                }
                this.itTracks = null;
            }
            if (this.itRoutes.hasNext()) {
                return this.itRoutes.next().routePoints;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

