/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class NTV2Datum
extends AbstractDatum {
    private final NTV2GridShiftFileWrapper nadgrids;

    public NTV2Datum(String string, String string2, Ellipsoid ellipsoid, NTV2GridShiftFileWrapper nTV2GridShiftFileWrapper) {
        super(string, string2, ellipsoid);
        this.nadgrids = nTV2GridShiftFileWrapper;
    }

    @Override
    public LatLon toWGS84(LatLon latLon) {
        NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
        try {
            this.nadgrids.getShiftFile().gridShiftForward(nTV2GridShift);
            return new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
        }
        catch (IOException iOException) {
            throw new JosmRuntimeException(iOException);
        }
    }

    @Override
    public LatLon fromWGS84(LatLon latLon) {
        NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
        try {
            this.nadgrids.getShiftFile().gridShiftReverse(nTV2GridShift);
            return new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
        }
        catch (IOException iOException) {
            throw new JosmRuntimeException(iOException);
        }
    }
}

