/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.autofilter;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.autofilter.AutoFilter;
import org.openstreetmap.josm.gui.autofilter.AutoFilterButton;
import org.openstreetmap.josm.gui.autofilter.AutoFilterRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.widgets.OSDLabel;
import org.openstreetmap.josm.tools.I18n;

public final class AutoFilterManager
implements NavigatableComponent.ZoomChangeListener,
MapFrame.MapModeChangeListener,
DataSetListener,
Preferences.PreferenceChangedListener {
    public static final BooleanProperty PROP_AUTO_FILTER_ENABLED = new BooleanProperty("auto.filter.enabled", true);
    public static final StringProperty PROP_AUTO_FILTER_RULE = new StringProperty("auto.filter.rule", "level");
    private static volatile AutoFilterManager instance;
    private final Map<String, AutoFilterButton> buttons = new TreeMap<String, AutoFilterButton>();
    private final List<AutoFilterRule> rules = new ArrayList<AutoFilterRule>();
    private final OSDLabel lblOSD = new OSDLabel("");
    private final FilterModel model = new FilterModel();
    private AutoFilterRule enabledRule;
    private AutoFilter currentAutoFilter;

    public static AutoFilterManager getInstance() {
        if (instance == null) {
            instance = new AutoFilterManager();
        }
        return instance;
    }

    private AutoFilterManager() {
        MapFrame.addMapModeChangeListener(this);
        Main.pref.addPreferenceChangeListener(this);
        NavigatableComponent.addZoomChangeListener(this);
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        this.registerAutoFilterRules(AutoFilterRule.defaultRules());
    }

    private synchronized void updateButtons() {
        NavigableSet<String> navigableSet;
        if (this.enabledRule != null && Main.map != null && this.enabledRule.getMinZoomLevel() <= Selector.GeneralSelector.scale2level(Main.map.mapView.getDist100Pixel()) && !(navigableSet = AutoFilterManager.getNumericValues(this.enabledRule.getKey(), this.enabledRule.getValueComparator())).equals(this.buttons.keySet())) {
            this.removeAllButtons();
            this.addNewButtons(navigableSet);
        }
    }

    private synchronized void addNewButtons(NavigableSet<String> navigableSet) {
        int n = 0;
        int n2 = 16;
        for (String object : navigableSet.descendingSet()) {
            Filter filter = new Filter();
            filter.enable = true;
            filter.inverted = true;
            filter.text = this.enabledRule.getKey() + "=" + object;
            String string = this.enabledRule.getValueFormatter().apply(object);
            AutoFilter autoFilter = new AutoFilter(string, filter.text, filter);
            AutoFilterButton autoFilterButton = new AutoFilterButton(autoFilter);
            if (autoFilter.equals(this.currentAutoFilter)) {
                autoFilterButton.getModel().setPressed(true);
            }
            this.buttons.put(object, autoFilterButton);
            n2 = Math.max(n2, autoFilterButton.getPreferredSize().width);
            Main.map.mapView.add(autoFilterButton).setLocation(3, 60 + 22 * n++);
        }
        for (AutoFilterButton autoFilterButton : this.buttons.values()) {
            autoFilterButton.setSize(n2, 20);
        }
        Main.map.mapView.validate();
    }

    private void removeAllButtons() {
        Iterator<String> iterator = this.buttons.keySet().iterator();
        while (iterator.hasNext()) {
            Main.map.mapView.remove(this.buttons.get(iterator.next()));
            iterator.remove();
        }
    }

    private static NavigableSet<String> getNumericValues(String string, Comparator<String> comparator) {
        TreeSet<String> treeSet = new TreeSet<String>(comparator);
        for (String string2 : AutoFilterManager.getTagValues(string)) {
            try {
                Integer.parseInt(string2);
                treeSet.add(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Main.trace(numberFormatException);
            }
        }
        return treeSet;
    }

    private static Set<String> getTagValues(String string) {
        DataSet dataSet = Main.getLayerManager().getEditDataSet();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (dataSet != null) {
            BBox bBox = Main.map.mapView.getState().getViewArea().getLatLonBoundsBox().toBBox();
            Consumer<OsmPrimitive> consumer = AutoFilterManager.getTagValuesConsumer(string, treeSet);
            dataSet.searchNodes(bBox).forEach(consumer);
            dataSet.searchWays(bBox).forEach(consumer);
            dataSet.searchRelations(bBox).forEach(consumer);
        }
        return treeSet;
    }

    static Consumer<OsmPrimitive> getTagValuesConsumer(String string, Set<String> set) {
        return osmPrimitive -> {
            String string2 = osmPrimitive.get(string);
            if (string2 != null) {
                Pattern pattern = Pattern.compile("(-?[0-9]+)-(-?[0-9]+)");
                for (String string3 : string2.split(";")) {
                    Matcher matcher = pattern.matcher(string3);
                    if (matcher.matches()) {
                        int n = Integer.parseInt(matcher.group(1));
                        int n2 = Integer.parseInt(matcher.group(2));
                        for (int i = Math.min(n, n2); i <= Math.max(n, n2); ++i) {
                            set.add(Integer.toString(i));
                        }
                        continue;
                    }
                    set.add(string3);
                }
            }
        };
    }

    @Override
    public void zoomChanged() {
        this.updateButtons();
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        this.updateFiltersFull();
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
        this.updateFiltersFull();
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.updateFiltersFull();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        this.updateFiltersEvent(primitivesAddedEvent, false);
        this.updateButtons();
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        this.updateFiltersFull();
        this.updateButtons();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        this.updateFiltersEvent(relationMembersChangedEvent, true);
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        this.updateFiltersEvent(tagsChangedEvent, true);
        this.updateButtons();
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
        this.updateFiltersEvent(wayNodesChangedEvent, true);
    }

    @Override
    public void mapModeChange(MapMode mapMode, MapMode mapMode2) {
        this.updateFiltersFull();
    }

    private synchronized void updateFiltersFull() {
        if (this.currentAutoFilter != null) {
            this.model.executeFilters();
        }
    }

    private synchronized void updateFiltersEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent, boolean bl) {
        if (this.currentAutoFilter != null) {
            Collection<? extends OsmPrimitive> collection = abstractDatasetChangedEvent.getPrimitives();
            this.model.executeFilters(bl ? FilterModel.getAffectedPrimitives(collection) : collection);
        }
    }

    public synchronized boolean registerAutoFilterRules(AutoFilterRule ... autoFilterRuleArray) {
        return this.rules.addAll(Arrays.asList(autoFilterRuleArray));
    }

    public synchronized boolean unregisterAutoFilterRule(AutoFilterRule autoFilterRule) {
        return this.rules.remove(Objects.requireNonNull(autoFilterRule, "rule"));
    }

    public synchronized List<AutoFilterRule> getAutoFilterRules() {
        return new ArrayList<AutoFilterRule>(this.rules);
    }

    public synchronized AutoFilterRule getAutoFilterRule(String string) {
        for (AutoFilterRule autoFilterRule : this.rules) {
            if (!string.equals(autoFilterRule.getKey())) continue;
            return autoFilterRule;
        }
        return null;
    }

    public synchronized void enableAutoFilterRule(String string) {
        this.enableAutoFilterRule(string == null ? null : this.getAutoFilterRule(string));
    }

    public synchronized void enableAutoFilterRule(AutoFilterRule autoFilterRule) {
        this.enabledRule = autoFilterRule;
    }

    public synchronized AutoFilter getCurrentAutoFilter() {
        return this.currentAutoFilter;
    }

    public synchronized void setCurrentAutoFilter(AutoFilter autoFilter) {
        this.model.clearFilters();
        this.currentAutoFilter = autoFilter;
        if (autoFilter != null) {
            this.model.addFilter(autoFilter.getFilter());
            this.model.executeFilters();
            if (this.model.isChanged()) {
                Main.getLayerManager().getEditLayer().invalidate();
            }
        }
    }

    public synchronized void drawOSDText(Graphics2D graphics2D) {
        this.model.drawOSDText(graphics2D, this.lblOSD, I18n.tr("<h2>Filter active: {0}</h2>", this.currentAutoFilter.getFilter().text), I18n.tr("</p><p>Click again on filter button to see all objects.</p></html>", new Object[0]));
    }

    private void resetCurrentAutoFilter() {
        this.setCurrentAutoFilter(null);
        this.removeAllButtons();
        if (Main.map != null) {
            Main.map.filterDialog.getFilterModel().executeFilters();
        }
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(PROP_AUTO_FILTER_ENABLED.getKey())) {
            if (PROP_AUTO_FILTER_ENABLED.get().booleanValue()) {
                this.enableAutoFilterRule(PROP_AUTO_FILTER_RULE.get());
                this.updateButtons();
            } else {
                this.enableAutoFilterRule((AutoFilterRule)null);
                this.resetCurrentAutoFilter();
            }
        } else if (preferenceChangeEvent.getKey().equals(PROP_AUTO_FILTER_RULE.getKey())) {
            this.enableAutoFilterRule(PROP_AUTO_FILTER_RULE.get());
            this.resetCurrentAutoFilter();
            this.updateButtons();
        }
    }
}

