/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.tools.I18n;

public class UploadedObjectsSummaryPanel
extends JPanel {
    public static final String NUM_OBJECTS_TO_UPLOAD_PROP = UploadedObjectsSummaryPanel.class.getName() + ".numObjectsToUpload";
    private PrimitiveList lstAdd;
    private JLabel lblAdd;
    private JScrollPane spAdd;
    private PrimitiveList lstUpdate;
    private JLabel lblUpdate;
    private JScrollPane spUpdate;
    private PrimitiveList lstDelete;
    private JLabel lblDelete;
    private JScrollPane spDelete;

    public UploadedObjectsSummaryPanel() {
        this.build();
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        OsmPrimitivRenderer osmPrimitivRenderer = new OsmPrimitivRenderer();
        this.lstAdd = new PrimitiveList();
        this.lstAdd.setCellRenderer(osmPrimitivRenderer);
        this.lstAdd.setVisibleRowCount(Math.min(this.lstAdd.getModel().getSize(), 10));
        this.spAdd = new JScrollPane(this.lstAdd);
        this.lblAdd = new JLabel(I18n.tr("Objects to add:", new Object[0]));
        this.lblAdd.setLabelFor(this.lstAdd);
        this.lstUpdate = new PrimitiveList();
        this.lstUpdate.setCellRenderer(osmPrimitivRenderer);
        this.lstUpdate.setVisibleRowCount(Math.min(this.lstUpdate.getModel().getSize(), 10));
        this.spUpdate = new JScrollPane(this.lstUpdate);
        this.lblUpdate = new JLabel(I18n.tr("Objects to modify:", new Object[0]));
        this.lblUpdate.setLabelFor(this.lstUpdate);
        this.lstDelete = new PrimitiveList();
        this.lstDelete.setCellRenderer(osmPrimitivRenderer);
        this.lstDelete.setVisibleRowCount(Math.min(this.lstDelete.getModel().getSize(), 10));
        this.spDelete = new JScrollPane(this.lstDelete);
        this.lblDelete = new JLabel(I18n.tr("Objects to delete:", new Object[0]));
        this.lblDelete.setLabelFor(this.lstDelete);
    }

    public void setUploadedPrimitives(List<OsmPrimitive> list, List<OsmPrimitive> list2, List<OsmPrimitive> list3) {
        this.lstAdd.getPrimitiveListModel().setPrimitives(list);
        this.lstUpdate.getPrimitiveListModel().setPrimitives(list2);
        this.lstDelete.getPrimitiveListModel().setPrimitives(list3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 10;
        this.removeAll();
        int n = -1;
        if (!list.isEmpty()) {
            ++n;
            gridBagConstraints.gridy = n++;
            this.lblAdd.setText(I18n.trn("{0} object to add:", "{0} objects to add:", list.size(), list.size()));
            this.add((Component)this.lblAdd, gridBagConstraints);
            gridBagConstraints2.gridy = n;
            this.add((Component)this.spAdd, gridBagConstraints2);
        }
        if (!list2.isEmpty()) {
            ++n;
            gridBagConstraints.gridy = n++;
            this.lblUpdate.setText(I18n.trn("{0} object to modify:", "{0} objects to modify:", list2.size(), list2.size()));
            this.add((Component)this.lblUpdate, gridBagConstraints);
            gridBagConstraints2.gridy = n;
            this.add((Component)this.spUpdate, gridBagConstraints2);
        }
        if (!list3.isEmpty()) {
            ++n;
            gridBagConstraints.gridy = n++;
            this.lblDelete.setText(I18n.trn("{0} object to delete:", "{0} objects to delete:", list3.size(), list3.size()));
            this.add((Component)this.lblDelete, gridBagConstraints);
            gridBagConstraints2.gridy = n;
            this.add((Component)this.spDelete, gridBagConstraints2);
        }
        this.firePropertyChange(NUM_OBJECTS_TO_UPLOAD_PROP, 0, this.getNumObjectsToUpload());
    }

    public int getNumObjectsToUpload() {
        return this.lstAdd.getModel().getSize() + this.lstUpdate.getModel().getSize() + this.lstDelete.getModel().getSize();
    }

    static class PrimitiveListModel
    extends AbstractListModel<OsmPrimitive> {
        private transient List<OsmPrimitive> primitives;

        PrimitiveListModel() {
            this.primitives = new ArrayList<OsmPrimitive>();
        }

        PrimitiveListModel(List<OsmPrimitive> list) {
            this.setPrimitives(list);
        }

        public void setPrimitives(List<OsmPrimitive> list) {
            this.primitives = Optional.ofNullable(list).orElseGet(ArrayList::new);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public OsmPrimitive getElementAt(int n) {
            if (this.primitives == null) {
                return null;
            }
            return this.primitives.get(n);
        }

        @Override
        public int getSize() {
            if (this.primitives == null) {
                return 0;
            }
            return this.primitives.size();
        }
    }

    static class PrimitiveList
    extends JList<OsmPrimitive> {
        PrimitiveList() {
            super(new PrimitiveListModel());
        }

        public PrimitiveListModel getPrimitiveListModel() {
            return (PrimitiveListModel)this.getModel();
        }
    }
}

