/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.Timer;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileRange;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ImageryAdjustAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.imagery.AutoLoadTilesAction;
import org.openstreetmap.josm.gui.layer.imagery.AutoZoomAction;
import org.openstreetmap.josm.gui.layer.imagery.DecreaseZoomAction;
import org.openstreetmap.josm.gui.layer.imagery.FlushTileCacheAction;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.layer.imagery.IncreaseZoomAction;
import org.openstreetmap.josm.gui.layer.imagery.LoadAllTilesAction;
import org.openstreetmap.josm.gui.layer.imagery.LoadErroneousTilesAction;
import org.openstreetmap.josm.gui.layer.imagery.ReprojectionTile;
import org.openstreetmap.josm.gui.layer.imagery.ShowErrorsAction;
import org.openstreetmap.josm.gui.layer.imagery.TileAnchor;
import org.openstreetmap.josm.gui.layer.imagery.TileCoordinateConverter;
import org.openstreetmap.josm.gui.layer.imagery.TilePosition;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.gui.layer.imagery.ZoomToBestAction;
import org.openstreetmap.josm.gui.layer.imagery.ZoomToNativeLevelAction;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.WMSLayerImporter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MemoryManager;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractTileSourceLayer<T extends AbstractTMSTileSource>
extends ImageryLayer
implements ImageObserver,
TileLoaderListener,
NavigatableComponent.ZoomChangeListener,
ImageryFilterSettings.FilterChangeListener,
TileSourceDisplaySettings.DisplaySettingsChangeListener {
    private static final String PREFERENCE_PREFIX = "imagery.generic";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    private static final Font InfoFont;
    private static List<MenuAddition> menuAdditions;
    public static final IntegerProperty PROP_MIN_ZOOM_LVL;
    public static final IntegerProperty PROP_MAX_ZOOM_LVL;
    public int currentZoomLevel;
    private final AttributionSupport attribution = new AttributionSupport();
    private final TileHolder clickedTileHolder = new TileHolder();
    public static final IntegerProperty ZOOM_OFFSET;
    protected TileCache tileCache;
    protected T tileSource;
    protected TileLoader tileLoader;
    private final Timer invalidateLaterTimer = new Timer(100, actionEvent -> this.invalidate());
    private final MouseAdapter adapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!AbstractTileSourceLayer.this.isVisible()) {
                return;
            }
            if (mouseEvent.getButton() == 3) {
                AbstractTileSourceLayer.this.clickedTileHolder.setTile(AbstractTileSourceLayer.this.getTileForPixelpos(mouseEvent.getX(), mouseEvent.getY()));
                new TileSourceLayerPopup().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getButton() == 1) {
                AbstractTileSourceLayer.this.attribution.handleAttribution(mouseEvent.getPoint(), true);
            }
        }
    };
    private final TileSourceDisplaySettings displaySettings = this.createDisplaySettings();
    private final ImageryAdjustAction adjustAction = new ImageryAdjustAction(this);
    protected TileCoordinateConverter coordinateConverter;
    private final TileSet nullTileSet = new TileSet();

    public AbstractTileSourceLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.setBackgroundLayer(true);
        this.setVisible(true);
        this.getFilterSettings().addFilterChangeListener(this);
        this.getDisplaySettings().addSettingsChangeListener(this);
    }

    protected TileSourceDisplaySettings createDisplaySettings() {
        return new TileSourceDisplaySettings();
    }

    public TileSourceDisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    @Override
    public void filterChanged() {
        this.invalidate();
    }

    protected abstract TileLoaderFactory getTileLoaderFactory();

    public abstract Collection<String> getNativeProjections();

    protected abstract T getTileSource();

    protected Map<String, String> getHeaders(T t) {
        if (t instanceof TemplatedTileSource) {
            return ((TemplatedTileSource)t).getHeaders();
        }
        return null;
    }

    protected void initTileSource(T t) {
        Map<String, String> map;
        block4: {
            this.coordinateConverter = new TileCoordinateConverter(Main.map.mapView, (TileSource)t, this.getDisplaySettings());
            this.attribution.initialize((Attributed)t);
            this.currentZoomLevel = this.getBestZoom();
            map = this.getHeaders(t);
            this.tileLoader = this.getTileLoaderFactory().makeTileLoader(this, map);
            try {
                if ("file".equalsIgnoreCase(new URL(((AbstractTMSTileSource)t).getBaseUrl()).getProtocol())) {
                    this.tileLoader = new OsmTileLoader(this);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!Main.isDebugEnabled()) break block4;
                Main.debug(malformedURLException.getMessage());
            }
        }
        if (this.tileLoader == null) {
            this.tileLoader = new OsmTileLoader(this, map);
        }
        this.tileCache = new MemoryTileCache(this.estimateTileCacheSize());
    }

    @Override
    public synchronized void tileLoadingFinished(Tile tile, boolean bl) {
        if (tile.hasError()) {
            bl = false;
            tile.setImage(null);
        }
        tile.setLoaded(bl);
        this.invalidateLater();
        if (Main.isDebugEnabled()) {
            Main.debug("tileLoadingFinished() tile: " + tile + " success: " + bl);
        }
    }

    public void clearTileCache() {
        if (this.tileLoader instanceof CachedTileLoader) {
            ((CachedTileLoader)((Object)this.tileLoader)).clearCache((TileSource)this.tileSource);
        }
        this.tileCache.clear();
    }

    @Override
    @Deprecated
    public double getDx() {
        return this.getDisplaySettings().getDx();
    }

    @Override
    @Deprecated
    public double getDy() {
        return this.getDisplaySettings().getDy();
    }

    @Override
    @Deprecated
    public void setOffset(OffsetBookmark offsetBookmark) {
        this.getDisplaySettings().setOffsetBookmark(offsetBookmark);
    }

    @Override
    public Object getInfoComponent() {
        EastNorth eastNorth;
        JPanel jPanel = (JPanel)super.getInfoComponent();
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        Collection<String> collection = this.getNativeProjections();
        if (collection != null) {
            arrayList.add(Arrays.asList(I18n.tr("Native projections", new Object[0]), Utils.join(", ", this.getNativeProjections())));
        }
        if ((eastNorth = this.getDisplaySettings().getDisplacement()).distanceSq(0.0, 0.0) > 1.0E-10) {
            arrayList.add(Arrays.asList(I18n.tr("Offset", new Object[0]), eastNorth.east() + ";" + eastNorth.north()));
        }
        if (this.coordinateConverter.requiresReprojection()) {
            arrayList.add(Arrays.asList(I18n.tr("Tile download projection", new Object[0]), this.tileSource.getServerCRS()));
            arrayList.add(Arrays.asList(I18n.tr("Tile display projection", new Object[0]), Main.getProjection().toCode()));
        }
        arrayList.add(Arrays.asList(I18n.tr("Current zoom", new Object[0]), Integer.toString(this.currentZoomLevel)));
        for (List list : arrayList) {
            jPanel.add((Component)new JLabel((String)list.get(0) + ':'), GBC.std());
            jPanel.add(GBC.glue(5, 0), GBC.std());
            jPanel.add((Component)this.createTextField((String)list.get(1)), GBC.eol().fill(2));
        }
        return jPanel;
    }

    @Override
    protected Action getAdjustAction() {
        return this.adjustAction;
    }

    public double getScaleFactor(int n) {
        if (this.coordinateConverter != null) {
            return this.coordinateConverter.getScaleFactor(n);
        }
        return 1.0;
    }

    public int getBestZoom() {
        int n;
        double d = this.getScaleFactor(1);
        double d2 = Math.log(d) / Math.log(2.0) / 2.0;
        int n2 = (int)Math.round(d2 + 1.0 + (double)ZOOM_OFFSET.get().intValue() / 1.9);
        int n3 = this.getMinZoomLvl();
        if (n3 <= (n = this.getMaxZoomLvl())) {
            n2 = Utils.clamp(n2, n3, n);
        } else if (n2 > n) {
            n2 = n;
        }
        return n2;
    }

    public static boolean actionSupportLayers(List<Layer> list) {
        return list.size() == 1 && list.get(0) instanceof TMSLayer;
    }

    @Override
    public void hookUpMapView() {
        this.initializeIfRequired();
        super.hookUpMapView();
    }

    @Override
    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
        this.initializeIfRequired();
        mapViewEvent.getMapView().addMouseListener(this.adapter);
        MapView.addZoomChangeListener(this);
        if (this instanceof NativeScaleLayer) {
            mapViewEvent.getMapView().setNativeScaleLayer((NativeScaleLayer)((Object)this));
        }
        mapViewEvent.getMapView().repaint(500L);
        return super.attachToMapView(mapViewEvent);
    }

    private void initializeIfRequired() {
        if (this.tileSource == null) {
            this.tileSource = this.getTileSource();
            if (this.tileSource == null) {
                throw new IllegalArgumentException(I18n.tr("Failed to create tile source", new Object[0]));
            }
            this.projectionChanged(null, Main.getProjection());
            this.initTileSource(this.tileSource);
        }
    }

    @Override
    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent mapViewEvent) {
        return new TileSourcePainter();
    }

    protected int estimateTileCacheSize() {
        Dimension dimension = GuiHelper.getMaximumScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        int n3 = 256;
        if (this.tileSource != null) {
            n3 = ((AbstractTMSTileSource)this.tileSource).getTileSize();
        }
        int n4 = (int)(Math.ceil((double)n / (double)n3 + 1.0) * Math.ceil((double)n2 / (double)n3 + 1.0));
        int n5 = (int)Math.ceil(Math.pow(2.0, ZOOM_OFFSET.get().intValue()) * (double)n4 * 4.0);
        Main.info("AbstractTileSourceLayer: estimated visible tiles: {0}, estimated cache size: {1}", n4, n5);
        return n5;
    }

    @Override
    public void displaySettingsChanged(TileSourceDisplaySettings.DisplaySettingsChangeEvent displaySettingsChangeEvent) {
        if (this.tileSource == null) {
            return;
        }
        switch (displaySettingsChangeEvent.getChangedSetting()) {
            case "automatically-change-resolution": {
                if (!this.getDisplaySettings().isAutoZoom() || this.getBestZoom() == this.currentZoomLevel) break;
                this.setZoomLevel(this.getBestZoom());
                this.invalidate();
                break;
            }
            case "automatic-downloading": {
                if (!this.getDisplaySettings().isAutoLoad()) break;
                this.invalidate();
                break;
            }
            default: {
                this.invalidate();
            }
        }
    }

    public static int checkMaxZoomLvl(int n, TileSource tileSource) {
        if (n > 30) {
            n = 30;
        }
        if (n < PROP_MIN_ZOOM_LVL.get()) {
            n = PROP_MIN_ZOOM_LVL.get();
        }
        if (tileSource != null && tileSource.getMaxZoom() != 0 && tileSource.getMaxZoom() < n) {
            n = tileSource.getMaxZoom();
        }
        return n;
    }

    public static int checkMinZoomLvl(int n, TileSource tileSource) {
        if (n < 2) {
            n = 2;
        }
        if (n > PROP_MAX_ZOOM_LVL.get()) {
            n = AbstractTileSourceLayer.getMaxZoomLvl(tileSource);
        }
        if (tileSource != null && tileSource.getMinZoom() > n) {
            n = tileSource.getMinZoom();
        }
        return n;
    }

    public static int getMaxZoomLvl(TileSource tileSource) {
        return AbstractTileSourceLayer.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), tileSource);
    }

    public static int getMinZoomLvl(TileSource tileSource) {
        return AbstractTileSourceLayer.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), tileSource);
    }

    public static void setMaxZoomLvl(int n) {
        PROP_MAX_ZOOM_LVL.put(AbstractTileSourceLayer.checkMaxZoomLvl(n, null));
    }

    public static void setMinZoomLvl(int n) {
        PROP_MIN_ZOOM_LVL.put(AbstractTileSourceLayer.checkMinZoomLvl(n, null));
    }

    @Override
    public void zoomChanged() {
        this.zoomChanged(true);
    }

    private void zoomChanged(boolean bl) {
        if (Main.isDebugEnabled()) {
            Main.debug("zoomChanged(): " + this.currentZoomLevel);
        }
        if (this.tileLoader instanceof TMSCachedTileLoader) {
            ((TMSCachedTileLoader)this.tileLoader).cancelOutstandingTasks();
        }
        if (bl) {
            this.invalidate();
        }
    }

    protected int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return AbstractTileSourceLayer.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return AbstractTileSourceLayer.getMaxZoomLvl(this.tileSource);
    }

    protected int getMinZoomLvl() {
        if (this.info.getMinZoom() != 0) {
            return AbstractTileSourceLayer.checkMinZoomLvl(this.info.getMinZoom(), this.tileSource);
        }
        return AbstractTileSourceLayer.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean bl;
        boolean bl2 = bl = this.currentZoomLevel < this.getMaxZoomLvl();
        if (Main.isDebugEnabled()) {
            Main.debug("zoomIncreaseAllowed(): " + bl + ' ' + this.currentZoomLevel + " vs. " + this.getMaxZoomLvl());
        }
        return bl;
    }

    public boolean increaseZoomLevel() {
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
            if (Main.isDebugEnabled()) {
                Main.debug("increasing zoom level to: " + this.currentZoomLevel);
            }
        } else {
            Main.warn("Current zoom level (" + this.currentZoomLevel + ") could not be increased. Max.zZoom Level " + this.getMaxZoomLvl() + " reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean setZoomLevel(int n) {
        return this.setZoomLevel(n, true);
    }

    private boolean setZoomLevel(int n, boolean bl) {
        if (n == this.currentZoomLevel) {
            return true;
        }
        if (n > this.getMaxZoomLvl()) {
            return false;
        }
        if (n < this.getMinZoomLvl()) {
            return false;
        }
        this.currentZoomLevel = n;
        this.zoomChanged(bl);
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        boolean bl;
        boolean bl2 = bl = this.currentZoomLevel > this.getMinZoomLvl();
        if (Main.isDebugEnabled()) {
            Main.debug("zoomDecreaseAllowed(): " + bl + ' ' + this.currentZoomLevel + " vs. " + this.getMinZoomLvl());
        }
        return bl;
    }

    public boolean decreaseZoomLevel() {
        if (this.zoomDecreaseAllowed()) {
            if (Main.isDebugEnabled()) {
                Main.debug("decreasing zoom level to: " + this.currentZoomLevel);
            }
            --this.currentZoomLevel;
        } else {
            return false;
        }
        this.zoomChanged();
        return true;
    }

    private Tile getOrCreateTile(TilePosition tilePosition) {
        return this.getOrCreateTile(tilePosition.getX(), tilePosition.getY(), tilePosition.getZoom());
    }

    private Tile getOrCreateTile(int n, int n2, int n3) {
        Tile tile = this.getTile(n, n2, n3);
        if (tile == null) {
            tile = this.coordinateConverter.requiresReprojection() ? new ReprojectionTile((TileSource)this.tileSource, n, n2, n3) : new Tile((TileSource)this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
        }
        return tile;
    }

    private Tile getTile(TilePosition tilePosition) {
        return this.getTile(tilePosition.getX(), tilePosition.getY(), tilePosition.getZoom());
    }

    private Tile getTile(int n, int n2, int n3) {
        if (n < ((AbstractTMSTileSource)this.tileSource).getTileXMin(n3) || n > ((AbstractTMSTileSource)this.tileSource).getTileXMax(n3) || n2 < ((AbstractTMSTileSource)this.tileSource).getTileYMin(n3) || n2 > ((AbstractTMSTileSource)this.tileSource).getTileYMax(n3)) {
            return null;
        }
        return this.tileCache.getTile((TileSource)this.tileSource, n, n2, n3);
    }

    private boolean loadTile(Tile tile, boolean bl) {
        if (tile == null) {
            return false;
        }
        if (!bl && (tile.isLoaded() || tile.hasError())) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        this.tileLoader.createTileLoaderJob(tile).submit(bl);
        return true;
    }

    private TileSet getVisibleTileSet() {
        ProjectionBounds projectionBounds = Main.map.mapView.getState().getViewArea().getProjectionBounds();
        return this.getTileSet(projectionBounds, this.currentZoomLevel);
    }

    public void loadAllTiles(boolean bl) {
        TileSet tileSet = this.getVisibleTileSet();
        if (tileSet.tooLarge()) {
            Main.warn("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        tileSet.loadAllTiles(bl);
        this.invalidate();
    }

    public void loadAllErrorTiles(boolean bl) {
        TileSet tileSet = this.getVisibleTileSet();
        tileSet.loadAllErrorTiles(bl);
        this.invalidate();
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2 = bl = (n & 0x70) != 0;
        if (Main.isDebugEnabled()) {
            Main.debug("imageUpdate() done: " + bl + " calling repaint");
        }
        if (bl) {
            this.invalidate();
        } else {
            this.invalidateLater();
        }
        return !bl;
    }

    private void invalidateLater() {
        GuiHelper.runInEDT(() -> {
            if (!this.invalidateLaterTimer.isRunning()) {
                this.invalidateLaterTimer.setRepeats(false);
                this.invalidateLaterTimer.start();
            }
        });
    }

    private boolean imageLoaded(Image image) {
        if (image == null) {
            return false;
        }
        int n = Toolkit.getDefaultToolkit().checkImage(image, -1, -1, this);
        return (n & 0x20) != 0;
    }

    private BufferedImage getLoadedTileImage(Tile tile) {
        BufferedImage bufferedImage = tile.getImage();
        if (!this.imageLoaded(bufferedImage)) {
            return null;
        }
        return bufferedImage;
    }

    private void drawImageInside(Graphics2D graphics2D, BufferedImage bufferedImage, TileAnchor tileAnchor, TileAnchor tileAnchor2, Shape shape) {
        AffineTransform affineTransform = tileAnchor.convert(tileAnchor2);
        Point2D point2D = affineTransform.transform(new Point2D.Double(0.0, 0.0), null);
        Point2D point2D2 = affineTransform.transform(new Point2D.Double(bufferedImage.getWidth(), bufferedImage.getHeight()), null);
        Shape shape2 = null;
        if (shape != null) {
            shape2 = graphics2D.getClip();
            graphics2D.clip(shape);
        }
        graphics2D.drawImage(bufferedImage, (int)Math.round(point2D.getX()), (int)Math.round(point2D.getY()), (int)Math.round(point2D2.getX()) - (int)Math.round(point2D.getX()), (int)Math.round(point2D2.getY()) - (int)Math.round(point2D.getY()), this);
        if (shape != null) {
            graphics2D.setClip(shape2);
        }
    }

    private List<Tile> paintTileImages(Graphics2D graphics2D, TileSet tileSet) {
        Object object = new Object();
        List list = Collections.synchronizedList(new ArrayList());
        tileSet.visitTiles(tile -> {
            Object object2;
            boolean bl = false;
            BufferedImage bufferedImage = null;
            TileAnchor tileAnchor = null;
            if (!tile.isLoaded() || tile.hasError()) {
                bl = true;
            } else {
                object2 = tile;
                synchronized (object2) {
                    bufferedImage = this.getLoadedTileImage((Tile)tile);
                    tileAnchor = AbstractTileSourceLayer.getAnchor(tile, bufferedImage);
                }
                if (bufferedImage == null || tileAnchor == null) {
                    bl = true;
                }
            }
            if (bl) {
                list.add(new TilePosition((Tile)tile));
                return;
            }
            bufferedImage = this.applyImageProcessors(bufferedImage);
            object2 = this.coordinateConverter.getScreenAnchorForTile((Tile)tile);
            Object object3 = object;
            synchronized (object3) {
                this.drawImageInside(graphics2D, bufferedImage, tileAnchor, (TileAnchor)object2, null);
            }
            if (tile instanceof ReprojectionTile && ((ReprojectionTile)tile).needsUpdate(Main.map.mapView.getScale())) {
                ((ReprojectionTile)tile).invalidate();
                this.loadTile((Tile)tile, false);
            }
        }, list::add);
        return list.stream().map(this::getOrCreateTile).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Tile> paintTileImages(Graphics2D graphics2D, TileSet tileSet, int n, Tile tile) {
        if (n <= 0) {
            return Collections.emptyList();
        }
        Shape shape = this.coordinateConverter.getTileShapeScreen(tile);
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        for (Tile tile2 : tileSet.allTilesCreate()) {
            Object object;
            boolean bl = false;
            BufferedImage bufferedImage = null;
            TileAnchor tileAnchor = null;
            if (!tile2.isLoaded() || tile2.hasError()) {
                bl = true;
            } else {
                object = tile2;
                synchronized (object) {
                    bufferedImage = this.getLoadedTileImage(tile2);
                    tileAnchor = AbstractTileSourceLayer.getAnchor(tile2, bufferedImage);
                }
                if (bufferedImage == null || tileAnchor == null) {
                    bl = true;
                }
            }
            if (bl) {
                linkedList.add(tile2);
                continue;
            }
            bufferedImage = this.applyImageProcessors(bufferedImage);
            if (this.tileSource.isInside(tile2, tile)) {
                object = null;
            } else {
                if (!this.tileSource.isInside(tile, tile2)) continue;
                object = shape;
            }
            TileAnchor tileAnchor2 = this.coordinateConverter.getScreenAnchorForTile(tile2);
            this.drawImageInside(graphics2D, bufferedImage, tileAnchor, tileAnchor2, (Shape)object);
        }
        return linkedList;
    }

    private static TileAnchor getAnchor(Tile tile, BufferedImage bufferedImage) {
        if (tile instanceof ReprojectionTile) {
            return ((ReprojectionTile)tile).getAnchor();
        }
        if (bufferedImage != null) {
            return new TileAnchor(new Point2D.Double(0.0, 0.0), new Point2D.Double(bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return null;
    }

    private void myDrawString(Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        String string2 = string;
        if (graphics.getFontMetrics().stringWidth(string) > ((AbstractTMSTileSource)this.tileSource).getTileSize()) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            String[] stringArray = string.split(" ");
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                String string3 = stringArray[i];
                if (graphics.getFontMetrics().stringWidth(stringBuilder.toString() + string3) > ((AbstractTMSTileSource)this.tileSource).getTileSize()) {
                    stringBuilder2.append((CharSequence)stringBuilder).append('\n');
                    stringBuilder.setLength(0);
                }
                stringBuilder.append(string3).append(' ');
            }
            stringBuilder2.append((CharSequence)stringBuilder);
            string2 = stringBuilder2.toString();
        }
        int n4 = 0;
        for (String string4 : string2.split("\n")) {
            graphics.setColor(Color.black);
            graphics.drawString(string4, n + 1, n2 + n4 + 1);
            graphics.setColor(color);
            graphics.drawString(string4, n, n2 + n4);
            n4 += graphics.getFontMetrics().getHeight() + 3;
        }
    }

    private void paintTileText(Tile tile, Graphics2D graphics2D) {
        if (tile == null) {
            return;
        }
        Point2D point2D = this.coordinateConverter.getPixelForTile(tile);
        int n = graphics2D.getFontMetrics().getHeight();
        int n2 = (int)point2D.getX();
        int n3 = (int)point2D.getY();
        int n4 = n3 + 2 + n;
        if (tile.hasError() && this.getDisplaySettings().isShowErrors()) {
            this.myDrawString(graphics2D, I18n.tr("Error", new Object[0]) + ": " + I18n.tr(tile.getErrorMessage(), new Object[0]), n2 + 2, n4);
        }
        if (Main.isDebugEnabled()) {
            graphics2D.setColor(new Color(255, 0, 0, 50));
            graphics2D.draw(this.coordinateConverter.getTileShapeScreen(tile));
        }
    }

    private LatLon getShiftedLatLon(EastNorth eastNorth) {
        return this.coordinateConverter.getProjecting().eastNorth2latlonClamped(eastNorth);
    }

    private ICoordinate getShiftedCoord(EastNorth eastNorth) {
        return this.getShiftedLatLon(eastNorth).toCoordinate();
    }

    protected TileSet getTileSet(ProjectionBounds projectionBounds, int n) {
        TileXY tileXY;
        TileXY tileXY2;
        if (n == 0) {
            return new TileSet();
        }
        if (this.coordinateConverter.requiresReprojection()) {
            Projection projection = Projections.getProjectionByCode(this.tileSource.getServerCRS());
            ProjectionBounds projectionBounds2 = new ProjectionBounds(new EastNorth(this.coordinateConverter.shiftDisplayToServer(projectionBounds.getMin())), new EastNorth(this.coordinateConverter.shiftDisplayToServer(projectionBounds.getMax())));
            ProjectionBounds projectionBounds3 = projection.getEastNorthBoundsBox(projectionBounds2, Main.getProjection());
            tileXY2 = this.tileSource.projectedToTileXY(projectionBounds3.getMin().toProjected(), n);
            tileXY = this.tileSource.projectedToTileXY(projectionBounds3.getMax().toProjected(), n);
        } else {
            IProjected iProjected = this.coordinateConverter.shiftDisplayToServer(projectionBounds.getMin());
            IProjected iProjected2 = this.coordinateConverter.shiftDisplayToServer(projectionBounds.getMax());
            tileXY2 = this.tileSource.projectedToTileXY(iProjected, n);
            tileXY = this.tileSource.projectedToTileXY(iProjected2, n);
        }
        return new TileSet(tileXY2, tileXY, n);
    }

    private static <S extends AbstractTMSTileSource> TileSetInfo getTileSetInfo(TileSet tileSet) {
        List list = tileSet.allExistingTiles();
        TileSetInfo tileSetInfo = new TileSetInfo();
        tileSetInfo.hasLoadingTiles = list.size() < tileSet.size();
        tileSetInfo.hasAllLoadedTiles = true;
        for (Tile tile : list) {
            if ("no-tile".equals(tile.getValue("tile-info"))) {
                tileSetInfo.hasOverzoomedTiles = true;
            }
            if (tile.isLoaded()) {
                if (tile.hasError()) continue;
                tileSetInfo.hasVisibleTiles = true;
                continue;
            }
            tileSetInfo.hasAllLoadedTiles = false;
            if (!tile.isLoading()) continue;
            tileSetInfo.hasLoadingTiles = true;
        }
        return tileSetInfo;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
    }

    private void drawInViewArea(Graphics2D graphics2D, MapView mapView, ProjectionBounds projectionBounds) {
        LinkedList<Tile> linkedList;
        int n = this.currentZoomLevel;
        if (this.getDisplaySettings().isAutoZoom()) {
            n = this.getBestZoom();
        }
        DeepTileSet deepTileSet = new DeepTileSet(projectionBounds, this.getMinZoomLvl(), n);
        TileSet tileSet = deepTileSet.getTileSet(n);
        int n2 = n;
        boolean bl = false;
        if (this.getDisplaySettings().isAutoZoom() && this.getDisplaySettings().isAutoLoad()) {
            linkedList = deepTileSet.getTileSetInfo(n);
            if (!(((TileSetInfo)((Object)linkedList)).hasVisibleTiles || ((TileSetInfo)((Object)linkedList)).hasLoadingTiles && !((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles)) {
                bl = true;
            }
            for (int i = n; i > deepTileSet.minZoom; --i) {
                if (!deepTileSet.getTileSetInfo((int)i).hasVisibleTiles) continue;
                n2 = i;
                break;
            }
            while (n > n2 && !((TileSetInfo)((Object)linkedList)).hasVisibleTiles && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles) {
                n = (n + n2) / 2;
                linkedList = deepTileSet.getTileSetInfo(n);
            }
            this.setZoomLevel(n, false);
            if (n == n2 && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles && n < deepTileSet.maxZoom) {
                linkedList = deepTileSet.getTileSetInfo(++n);
            }
            while (n > deepTileSet.minZoom && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles) {
                linkedList = deepTileSet.getTileSetInfo(--n);
            }
            tileSet = deepTileSet.getTileSet(n);
        } else if (this.getDisplaySettings().isAutoZoom()) {
            this.setZoomLevel(n, false);
        }
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        if (n2 != n) {
            tileSet = deepTileSet.getTileSet(n2);
            if (!deepTileSet.getTileSetInfo((int)n2).hasAllLoadedTiles && n2 < n) {
                tileSet.loadAllTiles(false);
            }
        }
        graphics2D.setColor(Color.DARK_GRAY);
        linkedList = this.paintTileImages(graphics2D, tileSet);
        int[] nArray = new int[]{1, 2, -1, -2, -3, -4, -5};
        for (int n3 : nArray) {
            if (!this.getDisplaySettings().isAutoZoom()) break;
            int n4 = n2 + n3;
            if (n4 < this.getMinZoomLvl() || n4 > this.getMaxZoomLvl()) continue;
            if (linkedList.isEmpty()) break;
            LinkedList<Tile> linkedList2 = new LinkedList<Tile>();
            for (Tile tile : linkedList) {
                if (n3 > 0 && "no-tile".equals(tile.getValue("tile-info"))) {
                    linkedList2.add(tile);
                    continue;
                }
                TileSet tileSet2 = new TileSet(this.tileSource.getCoveringTileRange(tile, n4));
                if (tileSet2.allLoadedTiles().isEmpty()) {
                    linkedList2.add(tile);
                    continue;
                }
                if (tileSet2.tooLarge()) continue;
                linkedList2.addAll(this.paintTileImages(graphics2D, tileSet2, n4, tile));
            }
            linkedList = linkedList2;
        }
        if (Main.isDebugEnabled() && !linkedList.isEmpty()) {
            Main.debug("still missed " + linkedList.size() + " in the end");
        }
        graphics2D.setColor(Color.red);
        graphics2D.setFont(InfoFont);
        Object object = tileSet.allExistingTiles().iterator();
        while (object.hasNext()) {
            Tile tile = (Tile)object.next();
            this.paintTileText(tile, graphics2D);
        }
        object = projectionBounds.getMin();
        EastNorth eastNorth = projectionBounds.getMax();
        this.attribution.paintAttribution(graphics2D, mapView.getWidth(), mapView.getHeight(), this.getShiftedCoord((EastNorth)object), this.getShiftedCoord(eastNorth), n2, this);
        graphics2D.setColor(Color.lightGray);
        if (tileSet.insane()) {
            this.myDrawString(graphics2D, I18n.tr("zoom in to load any tiles", new Object[0]), 120, 120);
        } else if (tileSet.tooLarge()) {
            this.myDrawString(graphics2D, I18n.tr("zoom in to load more tiles", new Object[0]), 120, 120);
        } else if (!this.getDisplaySettings().isAutoZoom() && tileSet.tooSmall()) {
            this.myDrawString(graphics2D, I18n.tr("increase tiles zoom level (change resolution) to see more detail", new Object[0]), 120, 120);
        }
        if (bl) {
            this.myDrawString(graphics2D, I18n.tr("No tiles at this zoom level", new Object[0]), 120, 120);
        }
        if (Main.isDebugEnabled()) {
            this.myDrawString(graphics2D, I18n.tr("Current zoom: {0}", this.currentZoomLevel), 50, 140);
            this.myDrawString(graphics2D, I18n.tr("Display zoom: {0}", n2), 50, 155);
            this.myDrawString(graphics2D, I18n.tr("Pixel scale: {0}", this.getScaleFactor(this.currentZoomLevel)), 50, 170);
            this.myDrawString(graphics2D, I18n.tr("Best zoom: {0}", this.getBestZoom()), 50, 185);
            this.myDrawString(graphics2D, I18n.tr("Estimated cache size: {0}", this.estimateTileCacheSize()), 50, 200);
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                int n5 = 200;
                for (String string : ((TMSCachedTileLoader)this.tileLoader).getStats().split("\n")) {
                    this.myDrawString(graphics2D, I18n.tr("Cache stats: {0}", string), 50, n5 += 15);
                }
            }
        }
    }

    private Tile getTileForPixelpos(int n, int n2) {
        if (Main.isDebugEnabled()) {
            Main.debug("getTileForPixelpos(" + n + ", " + n2 + ')');
        }
        TileXY tileXY = this.coordinateConverter.getTileforPixel(n, n2, this.currentZoomLevel);
        return this.getTile(tileXY.getXIndex(), tileXY.getYIndex(), this.currentZoomLevel);
    }

    public static void registerMenuAddition(Action action) {
        menuAdditions.add(new MenuAddition(action, AbstractTileSourceLayer.class));
    }

    public static void registerMenuAddition(Action action, Class<? extends AbstractTileSourceLayer<?>> clazz) {
        menuAdditions.add(new MenuAddition(action, clazz));
    }

    private List<Action> getMenuAdditions() {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        for (MenuAddition menuAddition : menuAdditions) {
            if (!menuAddition.clazz.isInstance(this)) continue;
            linkedList.add(menuAddition.addition);
        }
        if (!linkedList.isEmpty()) {
            linkedList.addFirst(Layer.SeparatorLayerAction.INSTANCE);
        }
        return linkedList;
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(this.getLayerListEntries()));
        arrayList.addAll(Arrays.asList(this.getCommonEntries()));
        arrayList.addAll(this.getMenuAdditions());
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new LayerListPopup.InfoAction(this));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public Action[] getLayerListEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE};
    }

    public Action[] getCommonEntries() {
        return new Action[]{new AutoLoadTilesAction(this), new AutoZoomAction(this), new ShowErrorsAction(this), new IncreaseZoomAction(this), new DecreaseZoomAction(this), new ZoomToBestAction(this), new ZoomToNativeLevelAction(this), new FlushTileCacheAction(this), new LoadErroneousTilesAction(this), new LoadAllTilesAction(this)};
    }

    @Override
    public String getToolTipText() {
        if (this.getDisplaySettings().isAutoLoad()) {
            return I18n.tr("{0} ({1}), automatically downloading in zoom {2}", this.getClass().getSimpleName(), this.getName(), this.currentZoomLevel);
        }
        return I18n.tr("{0} ({1}), downloading in zoom {2}", this.getClass().getSimpleName(), this.getName(), this.currentZoomLevel);
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    public PrecacheTask downloadAreaToCache(ProgressMonitor progressMonitor, List<LatLon> list, double d, double d2) {
        PrecacheTask precacheTask = new PrecacheTask(progressMonitor);
        ConcurrentSkipListSet<Tile> concurrentSkipListSet = new ConcurrentSkipListSet<Tile>((tile, tile2) -> String.CASE_INSENSITIVE_ORDER.compare(tile.getKey(), tile2.getKey()));
        for (LatLon object : list) {
            TileXY tileXY = this.tileSource.latLonToTileXY(object.lat() - d2, object.lon() - d, this.currentZoomLevel);
            TileXY tileXY2 = ((AbstractTMSTileSource)this.tileSource).latLonToTileXY(object.toCoordinate(), this.currentZoomLevel);
            TileXY tileXY3 = this.tileSource.latLonToTileXY(object.lat() + d2, object.lon() + d, this.currentZoomLevel);
            int n = Math.min(tileXY2.getYIndex() - 1, tileXY.getYIndex());
            int n2 = Math.max(tileXY2.getYIndex() + 1, tileXY3.getYIndex());
            int n3 = Math.min(tileXY2.getXIndex() - 1, tileXY.getXIndex());
            int n4 = Math.max(tileXY2.getXIndex() + 1, tileXY3.getXIndex());
            for (int i = n3; i <= n4; ++i) {
                for (int j = n; j <= n2; ++j) {
                    concurrentSkipListSet.add(new Tile((TileSource)this.tileSource, i, j, this.currentZoomLevel));
                }
            }
        }
        precacheTask.totalCount = concurrentSkipListSet.size();
        precacheTask.progressMonitor.setTicksCount(concurrentSkipListSet.size());
        TileLoader tileLoader = precacheTask.getTileLoader();
        for (Tile tile3 : concurrentSkipListSet) {
            tileLoader.createTileLoaderJob(tile3).submit();
        }
        return precacheTask;
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save WMS file", new Object[0]), WMSLayerImporter.FILE_FILTER);
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.adjustAction.destroy();
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        super.projectionChanged(projection, projection2);
        this.displaySettings.setOffsetBookmark(this.displaySettings.getOffsetBookmark());
        if (this.tileCache != null) {
            this.tileCache.clear();
        }
    }

    static {
        new TileSourceDisplaySettings();
        InfoFont = new Font("sansserif", 1, 13);
        menuAdditions = new LinkedList<MenuAddition>();
        PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.generic.min_zoom_lvl", 2);
        PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.generic.max_zoom_lvl", 20);
        ZOOM_OFFSET = new IntegerProperty("imagery.generic.zoom_offset", 0);
    }

    private class TileSourcePainter
    extends AbstractMapViewPaintable.CompatibilityModeLayerPainter {
        private MemoryManager.MemoryHandle<?> memory;

        private TileSourcePainter() {
            super(AbstractTileSourceLayer.this);
        }

        @Override
        public void paint(MapViewGraphics mapViewGraphics) {
            this.allocateCacheMemory();
            if (this.memory != null) {
                this.doPaint(mapViewGraphics);
            }
        }

        private void doPaint(MapViewGraphics mapViewGraphics) {
            AbstractTileSourceLayer.this.drawInViewArea(mapViewGraphics.getDefaultGraphics(), mapViewGraphics.getMapView(), mapViewGraphics.getClipBounds().getProjectionBounds());
        }

        private void allocateCacheMemory() {
            MemoryManager memoryManager;
            if (this.memory == null && (memoryManager = MemoryManager.getInstance()).isAvailable(this.getEstimatedCacheSize())) {
                try {
                    this.memory = memoryManager.allocateMemory("tile source layer", this.getEstimatedCacheSize(), Object::new);
                }
                catch (MemoryManager.NotEnoughMemoryException notEnoughMemoryException) {
                    Main.warn("Could not allocate tile source memory", notEnoughMemoryException);
                }
            }
        }

        protected long getEstimatedCacheSize() {
            return 4L * (long)((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileSize() * (long)((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileSize() * (long)AbstractTileSourceLayer.this.estimateTileCacheSize();
        }

        @Override
        public void detachFromMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
            mapViewEvent.getMapView().removeMouseListener(AbstractTileSourceLayer.this.adapter);
            MapView.removeZoomChangeListener(AbstractTileSourceLayer.this);
            super.detachFromMapView(mapViewEvent);
            if (this.memory != null) {
                this.memory.free();
            }
        }
    }

    public class PrecacheTask
    implements TileLoaderListener {
        private final ProgressMonitor progressMonitor;
        private int totalCount;
        private final AtomicInteger processedCount = new AtomicInteger(0);
        private final TileLoader tileLoader;

        public PrecacheTask(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
            this.tileLoader = AbstractTileSourceLayer.this.getTileLoaderFactory().makeTileLoader(this, AbstractTileSourceLayer.this.getHeaders(AbstractTileSourceLayer.this.tileSource));
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                ((TMSCachedTileLoader)this.tileLoader).setDownloadExecutor(TMSCachedTileLoader.getNewThreadPoolExecutor("Precache downloader"));
            }
        }

        public boolean isFinished() {
            return this.processedCount.get() >= this.totalCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void cancel() {
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                ((TMSCachedTileLoader)this.tileLoader).cancelOutstandingTasks();
            }
        }

        @Override
        public void tileLoadingFinished(Tile tile, boolean bl) {
            int n = this.processedCount.incrementAndGet();
            if (bl) {
                this.progressMonitor.worked(1);
                this.progressMonitor.setCustomText(I18n.tr("Downloaded {0}/{1} tiles", n, this.totalCount));
            } else {
                Main.warn("Tile loading failure: " + tile + " - " + tile.getErrorMessage());
            }
        }

        public TileLoader getTileLoader() {
            return this.tileLoader;
        }
    }

    private static class MenuAddition {
        final Action addition;
        final Class<? extends AbstractTileSourceLayer> clazz;

        MenuAddition(Action action, Class<? extends AbstractTileSourceLayer> clazz) {
            this.addition = action;
            this.clazz = clazz;
        }
    }

    private class DeepTileSet {
        private final ProjectionBounds bounds;
        private final int minZoom;
        private final int maxZoom;
        private final TileSet[] tileSets;
        private final TileSetInfo[] tileSetInfos;

        DeepTileSet(ProjectionBounds projectionBounds, int n, int n2) {
            this.bounds = projectionBounds;
            this.minZoom = n;
            this.maxZoom = n2;
            this.tileSets = new TileSet[n2 - n + 1];
            this.tileSetInfos = new TileSetInfo[n2 - n + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSet getTileSet(int n) {
            if (n < this.minZoom) {
                return AbstractTileSourceLayer.this.nullTileSet;
            }
            TileSet[] tileSetArray = this.tileSets;
            synchronized (this.tileSets) {
                TileSet tileSet = this.tileSets[n - this.minZoom];
                if (tileSet == null) {
                    this.tileSets[n - this.minZoom] = tileSet = AbstractTileSourceLayer.this.getTileSet(this.bounds, n);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tileSet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSetInfo getTileSetInfo(int n) {
            if (n < this.minZoom) {
                return new TileSetInfo();
            }
            TileSetInfo[] tileSetInfoArray = this.tileSetInfos;
            synchronized (this.tileSetInfos) {
                TileSetInfo tileSetInfo = this.tileSetInfos[n - this.minZoom];
                if (tileSetInfo == null) {
                    this.tileSetInfos[n - this.minZoom] = tileSetInfo = AbstractTileSourceLayer.getTileSetInfo(this.getTileSet(n));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tileSetInfo;
            }
        }
    }

    private static class TileSetInfo {
        boolean hasVisibleTiles;
        boolean hasOverzoomedTiles;
        boolean hasLoadingTiles;
        boolean hasAllLoadedTiles;

        private TileSetInfo() {
        }
    }

    protected class TileSet
    extends TileRange {
        protected TileSet(TileXY tileXY, TileXY tileXY2, int n) {
            super(tileXY, tileXY2, n);
            this.sanitize();
        }

        protected TileSet(TileRange tileRange) {
            super(tileRange);
            this.sanitize();
        }

        private TileSet() {
        }

        protected void sanitize() {
            if (this.minX < ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMin(this.zoom)) {
                this.minX = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMin(this.zoom);
            }
            if (this.minY < ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMin(this.zoom)) {
                this.minY = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMin(this.zoom);
            }
            if (this.maxX > ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMax(this.zoom)) {
                this.maxX = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileXMax(this.zoom);
            }
            if (this.maxY > ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMax(this.zoom)) {
                this.maxY = ((AbstractTMSTileSource)AbstractTileSourceLayer.this.tileSource).getTileYMax(this.zoom);
            }
        }

        private boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        private boolean tooLarge() {
            return this.insane() || this.tilesSpanned() > 20.0;
        }

        private boolean insane() {
            return AbstractTileSourceLayer.this.tileCache == null || this.size() > AbstractTileSourceLayer.this.tileCache.getCacheSize();
        }

        private List<Tile> allExistingTiles() {
            return this.allTiles(tilePosition -> AbstractTileSourceLayer.this.getTile(tilePosition));
        }

        private List<Tile> allTilesCreate() {
            return this.allTiles(tilePosition -> AbstractTileSourceLayer.this.getOrCreateTile(tilePosition));
        }

        private List<Tile> allTiles(Function<TilePosition, Tile> function) {
            return this.tilePositions().map(function).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public Stream<TilePosition> tilePositions() {
            if (this.zoom == 0 || this.insane()) {
                return Stream.empty();
            }
            return IntStream.rangeClosed(this.minX, this.maxX).mapToObj(n -> IntStream.rangeClosed(this.minY, this.maxY).mapToObj(n2 -> new TilePosition(n, n2, this.zoom))).flatMap(Function.identity());
        }

        private List<Tile> allLoadedTiles() {
            return this.allExistingTiles().stream().filter(Tile::isLoaded).collect(Collectors.toList());
        }

        private Comparator<Tile> getTileDistanceComparator() {
            int n = (int)Math.ceil((double)(this.minX + this.maxX) / 2.0);
            int n2 = (int)Math.ceil((double)(this.minY + this.maxY) / 2.0);
            return Comparator.comparingInt(tile -> Math.abs(tile.getXtile() - n) + Math.abs(tile.getYtile() - n2));
        }

        private void loadAllTiles(boolean bl) {
            if (!AbstractTileSourceLayer.this.getDisplaySettings().isAutoLoad() && !bl) {
                return;
            }
            List<Tile> list = this.allTilesCreate();
            list.sort(this.getTileDistanceComparator());
            for (Tile tile : list) {
                AbstractTileSourceLayer.this.loadTile(tile, bl);
            }
        }

        private void loadAllErrorTiles(boolean bl) {
            if (!AbstractTileSourceLayer.this.getDisplaySettings().isAutoLoad() && !bl) {
                return;
            }
            for (Tile tile : this.allTilesCreate()) {
                if (!tile.hasError()) continue;
                AbstractTileSourceLayer.this.tileLoader.createTileLoaderJob(tile).submit(bl);
            }
        }

        public void visitTiles(Consumer<Tile> consumer, Consumer<TilePosition> consumer2) {
            ((Stream)this.tilePositions().parallel()).forEach(tilePosition -> this.visitTilePosition(consumer, (TilePosition)tilePosition, consumer2));
        }

        private void visitTilePosition(Consumer<Tile> consumer, TilePosition tilePosition, Consumer<TilePosition> consumer2) {
            Tile tile = AbstractTileSourceLayer.this.getTile(tilePosition);
            if (tile == null) {
                consumer2.accept(tilePosition);
            } else {
                consumer.accept(tile);
            }
        }

        public String toString() {
            return this.getClass().getName() + ": zoom: " + this.zoom + " X(" + this.minX + ", " + this.maxX + ") Y(" + this.minY + ", " + this.maxY + ") size: " + this.size();
        }
    }

    public class TileSourceLayerPopup
    extends JPopupMenu {
        public TileSourceLayerPopup() {
            for (Action action : AbstractTileSourceLayer.this.getCommonEntries()) {
                if (action instanceof Layer.LayerAction) {
                    this.add(((Layer.LayerAction)((Object)action)).createMenuComponent());
                    continue;
                }
                this.add(new JMenuItem(action));
            }
            this.add(new JSeparator());
            this.add(new JMenuItem(new LoadTileAction()));
            this.add(new JMenuItem(new ShowTileInfoAction()));
        }
    }

    private static final class TileHolder {
        private Tile t;

        private TileHolder() {
        }

        public Tile getTile() {
            return this.t;
        }

        public void setTile(Tile tile) {
            this.t = tile;
        }
    }

    private final class LoadTileAction
    extends AbstractAction {
        private LoadTileAction() {
            super(I18n.tr("Load tile", new Object[0]));
            this.setEnabled(AbstractTileSourceLayer.this.clickedTileHolder.getTile() != null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tile tile = AbstractTileSourceLayer.this.clickedTileHolder.getTile();
            if (tile != null) {
                AbstractTileSourceLayer.this.loadTile(tile, true);
                AbstractTileSourceLayer.this.invalidate();
            }
        }
    }

    private final class ShowTileInfoAction
    extends AbstractAction {
        private ShowTileInfoAction() {
            super(I18n.tr("Show tile info", new Object[0]));
            this.setEnabled(AbstractTileSourceLayer.this.clickedTileHolder.getTile() != null);
        }

        private String getSizeString(int n) {
            return "" + n + 'x' + n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tile tile = AbstractTileSourceLayer.this.clickedTileHolder.getTile();
            if (tile != null) {
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Tile Info", new Object[0]), I18n.tr("OK", new Object[0]));
                JPanel jPanel = new JPanel(new GridBagLayout());
                Rectangle2D rectangle2D = AbstractTileSourceLayer.this.coordinateConverter.getRectangleForTile(tile);
                String string = "";
                try {
                    string = tile.getUrl();
                }
                catch (IOException iOException) {
                    Main.trace(iOException);
                }
                ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
                arrayList.add(Arrays.asList(I18n.tr("Tile name", new Object[0]), tile.getKey()));
                arrayList.add(Arrays.asList(I18n.tr("Tile URL", new Object[0]), string));
                arrayList.add(Arrays.asList(I18n.tr("Tile size", new Object[0]), this.getSizeString(tile.getTileSource().getTileSize())));
                arrayList.add(Arrays.asList(I18n.tr("Tile display size", new Object[0]), "" + rectangle2D.getWidth() + 'x' + rectangle2D.getHeight()));
                if (AbstractTileSourceLayer.this.coordinateConverter.requiresReprojection()) {
                    arrayList.add(Arrays.asList(I18n.tr("Reprojection", new Object[0]), tile.getTileSource().getServerCRS() + " -> " + Main.getProjection().toCode()));
                    BufferedImage bufferedImage = tile.getImage();
                    if (bufferedImage != null) {
                        arrayList.add(Arrays.asList(I18n.tr("Reprojected tile size", new Object[0]), bufferedImage.getWidth() + "x" + bufferedImage.getHeight()));
                    }
                }
                for (List object : arrayList) {
                    jPanel.add((Component)new JLabel((String)object.get(0) + ':'), GBC.std());
                    jPanel.add(GBC.glue(5, 0), GBC.std());
                    jPanel.add((Component)AbstractTileSourceLayer.this.createTextField((String)object.get(1)), GBC.eol().fill(2));
                }
                for (Map.Entry entry : tile.getMetadata().entrySet()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Metadata ", new Object[0]) + I18n.tr((String)entry.getKey(), new Object[0]) + ':'), GBC.std());
                    jPanel.add(GBC.glue(5, 0), GBC.std());
                    String string2 = (String)entry.getValue();
                    if ("lastModification".equals(entry.getKey()) || "expirationTime".equals(entry.getKey())) {
                        string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(Long.parseLong(string2)));
                    }
                    jPanel.add((Component)AbstractTileSourceLayer.this.createTextField(string2), GBC.eol().fill(2));
                }
                extendedDialog.setIcon(1);
                extendedDialog.setContent(jPanel);
                extendedDialog.showDialog();
            }
        }
    }
}

