/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.PlayHeadDragMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.io.audio.AudioUtil;
import org.openstreetmap.josm.tools.I18n;

public final class PlayHeadMarker
extends Marker {
    private Timer timer;
    private double animationInterval;
    private static volatile PlayHeadMarker playHead;
    private MapMode oldMode;
    private LatLon oldCoor;
    private final boolean enabled = Main.pref.getBoolean("marker.traceaudio", true);
    private boolean wasPlaying;
    private int dropTolerance;
    private boolean jumpToMarker;

    public static PlayHeadMarker create() {
        if (playHead == null) {
            playHead = new PlayHeadMarker();
        }
        return playHead;
    }

    private PlayHeadMarker() {
        super(LatLon.ZERO, "", Main.pref.get("marker.audiotracericon", "audio-tracer"), null, -1.0, 0.0);
        if (!this.enabled) {
            return;
        }
        this.dropTolerance = Main.pref.getInteger("marker.playHeadDropTolerance", 50);
        if (Main.isDisplayingMapView()) {
            Main.map.mapView.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && playHead.containsPoint(mouseEvent.getPoint())) {
                        PlayHeadMarker.this.oldMode = Main.map.mapMode;
                        PlayHeadMarker.this.oldCoor = PlayHeadMarker.this.getCoor();
                        PlayHeadDragMode playHeadDragMode = new PlayHeadDragMode(playHead);
                        Main.map.selectMapMode(playHeadDragMode);
                        playHeadDragMode.mousePressed(mouseEvent);
                    }
                }
            });
        }
    }

    @Override
    public boolean containsPoint(Point point) {
        Point point2 = Main.map.mapView.getPoint(this.getEastNorth());
        Rectangle rectangle = new Rectangle(point2.x, point2.y, this.symbol.getIconWidth(), this.symbol.getIconHeight());
        return rectangle.contains(point);
    }

    public void startDrag() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.wasPlaying = AudioPlayer.playing();
        if (this.wasPlaying) {
            try {
                AudioPlayer.pause();
            }
            catch (IOException | InterruptedException exception) {
                AudioUtil.audioMalfunction(exception);
            }
        }
    }

    private void endDrag(boolean bl) {
        if (!this.wasPlaying || bl) {
            try {
                AudioPlayer.pause();
            }
            catch (IOException | InterruptedException exception) {
                AudioUtil.audioMalfunction(exception);
            }
        }
        if (bl) {
            this.setCoor(this.oldCoor);
        }
        Main.map.selectMapMode(this.oldMode);
        Main.map.mapView.repaint();
        this.timer.start();
    }

    public void drag(EastNorth eastNorth) {
        this.setEastNorth(eastNorth);
        Main.map.mapView.repaint();
    }

    public void reposition(EastNorth eastNorth) {
        Object object;
        WayPoint wayPoint = null;
        AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
        if (audioMarker != null && audioMarker.parentLayer != null && audioMarker.parentLayer.fromLayer != null) {
            object = Main.map.mapView.getPoint(eastNorth);
            EastNorth eastNorth2 = Main.map.mapView.getEastNorth(((Point)object).x + this.dropTolerance, ((Point)object).y);
            wayPoint = audioMarker.parentLayer.fromLayer.data.nearestPointOnTrack(eastNorth, eastNorth2.east() - eastNorth.east());
        }
        object = null;
        if (wayPoint != null && audioMarker != null && audioMarker.parentLayer != null) {
            for (Marker marker : audioMarker.parentLayer.data) {
                if (!(marker instanceof AudioMarker)) continue;
                AudioMarker audioMarker2 = (AudioMarker)marker;
                if (audioMarker2.time > wayPoint.time) break;
                object = audioMarker2;
            }
        }
        if (object == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to drag the play head near to the GPX track whose associated sound track you were playing (after the first marker).", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            this.endDrag(true);
        } else {
            if (wayPoint != null) {
                this.setCoor(wayPoint.getCoor());
                ((AudioMarker)object).play(wayPoint.time - ((AudioMarker)object).time);
            }
            this.endDrag(false);
        }
    }

    public void synchronize(EastNorth eastNorth) {
        AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
        if (audioMarker == null) {
            return;
        }
        Point point = Main.map.mapView.getPoint(eastNorth);
        ButtonMarker buttonMarker = null;
        if (audioMarker.parentLayer != null) {
            double d = 1.0E100;
            for (Marker marker : audioMarker.parentLayer.data) {
                double d2;
                if (!(marker instanceof AudioMarker) || !((d2 = marker.getEastNorth().distanceSq(eastNorth)) < d)) continue;
                buttonMarker = (AudioMarker)marker;
                d = d2;
            }
        }
        if (buttonMarker != null && !buttonMarker.containsPoint(point)) {
            buttonMarker = null;
        }
        if (buttonMarker == null) {
            Point point2 = Main.map.mapView.getPoint(eastNorth);
            EastNorth eastNorth2 = Main.map.mapView.getEastNorth(point2.x + this.dropTolerance, point2.y);
            WayPoint wayPoint = audioMarker.parentLayer.fromLayer.data.nearestPointOnTrack(eastNorth, eastNorth2.east() - eastNorth.east());
            if (wayPoint == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to SHIFT-drag the play head onto an audio marker or onto the track point where you want to synchronize.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                this.endDrag(true);
                return;
            }
            buttonMarker = audioMarker.parentLayer.addAudioMarker(wayPoint.time, wayPoint.getCoor());
        }
        if (buttonMarker == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to create new audio marker.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            this.endDrag(true);
        } else if (audioMarker.parentLayer.synchronizeAudioMarkers((AudioMarker)buttonMarker)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Audio synchronized at point {0}.", audioMarker.parentLayer.syncAudioMarker.getText()), I18n.tr("Information", new Object[0]), 1);
            this.setCoor(audioMarker.parentLayer.syncAudioMarker.getCoor());
            this.endDrag(false);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to synchronize in layer being played.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            this.endDrag(true);
        }
    }

    public void paint(Graphics graphics, MapView mapView) {
        if (this.time < 0.0) {
            return;
        }
        Point point = mapView.getPoint(this.getEastNorth());
        this.paintIcon(mapView, graphics, point.x, point.y);
    }

    public void animate() {
        if (!this.enabled) {
            return;
        }
        this.jumpToMarker = true;
        if (this.timer == null) {
            this.animationInterval = Main.pref.getDouble("marker.audioanimationinterval", 1.0);
            this.timer = new Timer((int)(this.animationInterval * 1000.0), actionEvent -> this.timerAction());
            this.timer.setInitialDelay(0);
        } else {
            this.timer.stop();
        }
        this.timer.start();
    }

    public void timerAction() {
        AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
        if (audioMarker == null) {
            return;
        }
        double d = audioMarker.time + AudioPlayer.position() - audioMarker.offset - audioMarker.syncOffset;
        if (Math.abs(d - this.time) < this.animationInterval) {
            return;
        }
        if (audioMarker.parentLayer == null) {
            return;
        }
        GpxLayer gpxLayer = audioMarker.parentLayer.fromLayer;
        if (gpxLayer == null) {
            return;
        }
        ILatLon iLatLon = null;
        ILatLon iLatLon2 = null;
        for (GpxTrack gpxTrack : gpxLayer.data.getTracks()) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    if (d < wayPoint.time) {
                        iLatLon2 = wayPoint;
                        break;
                    }
                    iLatLon = wayPoint;
                }
                if (iLatLon2 == null) continue;
                break;
            }
            if (iLatLon2 == null) continue;
            break;
        }
        if (iLatLon == null) {
            return;
        }
        this.setEastNorth(iLatLon2 == null ? iLatLon.getEastNorth() : iLatLon.getEastNorth().interpolate(iLatLon2.getEastNorth(), (d - ((WayPoint)iLatLon).time) / (((WayPoint)iLatLon2).time - ((WayPoint)iLatLon).time)));
        this.time = d;
        if (this.jumpToMarker) {
            this.jumpToMarker = false;
            Main.map.mapView.zoomTo(iLatLon.getEastNorth());
        }
        Main.map.mapView.repaint();
    }
}

