/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.preferences.plugin.PluginListPanel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PluginCheckBox
extends JCheckBox
implements ActionListener {
    private final transient PluginInformation pi;
    private final PluginListPanel panel;
    private final transient PluginPreferencesModel ppModel;

    PluginCheckBox(PluginInformation pluginInformation, boolean bl, PluginListPanel pluginListPanel, PluginPreferencesModel pluginPreferencesModel) {
        this.pi = pluginInformation;
        this.panel = pluginListPanel;
        this.ppModel = pluginPreferencesModel;
        this.setSelected(bl);
        this.setToolTipText(PluginListPanel.formatCheckboxTooltipText(pluginInformation));
        this.addActionListener(this);
    }

    protected void selectRequiredPlugins(PluginInformation pluginInformation) {
        if (pluginInformation != null && pluginInformation.requires != null) {
            for (String string : pluginInformation.getRequiredPlugins()) {
                if (this.ppModel.isSelectedPlugin(string)) continue;
                this.ppModel.setPluginSelected(string, true);
                this.selectRequiredPlugins(this.ppModel.getPluginInformation(string));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.ppModel.setPluginSelected(this.pi.getName(), this.isSelected());
        if (this.isSelected() && this.pi.requires != null) {
            this.selectRequiredPlugins(this.pi);
            PluginHandler.checkRequiredPluginsPreconditions(this.panel, this.ppModel.getAvailablePlugins(), this.pi, false);
        } else if (!this.isSelected()) {
            HashSet<String> hashSet = new HashSet<String>();
            block0: for (PluginInformation pluginInformation : this.ppModel.getAvailablePlugins()) {
                if (pluginInformation.equals(this.pi) || pluginInformation.requires == null || !this.ppModel.isSelectedPlugin(pluginInformation.getName())) continue;
                for (String string : pluginInformation.getRequiredPlugins()) {
                    if (!string.equals(this.pi.getName())) continue;
                    hashSet.add(pluginInformation.getName());
                    continue block0;
                }
            }
            if (!hashSet.isEmpty()) {
                PluginCheckBox.alertPluginStillRequired(this.panel, this.pi.getName(), hashSet);
            }
        }
    }

    private static void alertPluginStillRequired(Component component, String string, Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder("<html>").append(I18n.trn("Plugin {0} is still required by this plugin:", "Plugin {0} is still required by these {1} plugins:", set.size(), Utils.escapeReservedCharactersHTML(string), set.size())).append(Utils.joinAsHtmlUnorderedList(set)).append("</html>");
        JOptionPane.showMessageDialog(component, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2);
    }
}

