/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class ListenableWeakReference<T>
extends WeakReference<T> {
    private static final ReferenceQueue<Object> GLOBAL_QUEUE = new ReferenceQueue();
    private static Thread thread;
    private Runnable runOnDereference;

    public ListenableWeakReference(T t) {
        this(t, () -> {});
    }

    public ListenableWeakReference(T t, Runnable runnable) {
        super(t, GLOBAL_QUEUE);
        this.runOnDereference = runnable;
        ListenableWeakReference.ensureQueueStarted();
    }

    protected void onDereference() {
        this.runOnDereference.run();
    }

    private static synchronized void ensureQueueStarted() {
        if (thread == null) {
            thread = new Thread(ListenableWeakReference::clean, "Weak reference cleaner");
            thread.start();
        }
    }

    private static void clean() {
        boolean bl = true;
        try {
            while (bl) {
                Reference<Object> reference = GLOBAL_QUEUE.remove();
                if (!(reference instanceof ListenableWeakReference)) continue;
                ((ListenableWeakReference)reference).onDereference();
            }
        }
        catch (InterruptedException interruptedException) {
            bl = false;
            BugReport.intercept(interruptedException).warn();
            Thread.currentThread().interrupt();
        }
    }
}

