/*
 * Decompiled with CFR 0.152.
 */
package javaslang;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javaslang.Tuple2;
import javaslang.ValueModule;
import javaslang.collection.Iterator;
import javaslang.collection.List;
import javaslang.collection.Stream;

public interface Value<T>
extends Iterable<T> {
    @Override
    default public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        for (Object t : this) {
            action.accept(t);
        }
    }

    public T get();

    public boolean isEmpty();

    public boolean isSingleValued();

    public String stringPrefix();

    @Override
    public Iterator<T> iterator();

    default public java.util.List<T> toJavaList() {
        return ValueModule.toJavaCollection(this, new ArrayList());
    }

    default public <K, V, MAP extends Map<K, V>> MAP toJavaMap(Supplier<MAP> factory2, Function<? super T, ? extends Tuple2<? extends K, ? extends V>> f) {
        Objects.requireNonNull(f, "f is null");
        Map map2 = (Map)factory2.get();
        if (!this.isEmpty()) {
            if (this.isSingleValued()) {
                Tuple2<? extends K, ? extends V> entry = f.apply(this.get());
                map2.put(entry._1, entry._2);
            } else {
                for (Object a : this) {
                    Tuple2<? extends K, ? extends V> entry = f.apply(a);
                    map2.put(entry._1, entry._2);
                }
            }
        }
        return (MAP)map2;
    }

    default public List<T> toList() {
        return ValueModule.toTraversable(this, List.empty(), List::of, List::ofAll);
    }

    default public Stream<T> toStream() {
        return ValueModule.toTraversable(this, Stream.empty(), Stream::of, Stream::ofAll);
    }

    public String toString();
}

