/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionBase;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrEnumConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator$WhenMappings;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorWithScope;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.VariableLValue;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u00100\u001a\u00020.J\u0018\u00101\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u00100\u001a\u00020.H\u0002J\u0018\u00102\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u0002042\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000206J \u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020*H\u0002J\u000e\u0010F\u001a\u0002042\u0006\u0010'\u001a\u00020(J\u000e\u0010G\u001a\u0002042\u0006\u0010'\u001a\u00020(J\u0018\u0010H\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010I\u001a\u0004\u0018\u00010\f2\u0006\u0010J\u001a\u000206J\u0016\u0010K\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\fJ\u001c\u0010M\u001a\u00020\u001a*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00105\u001a\u00020NH\u0002J$\u0010O\u001a\u00020**\u00020\u00142\u000e\u0010P\u001a\n\u0012\u0006\b\u0001\u0012\u00020R0Q2\u0006\u0010+\u001a\u00020,H\u0002J\u001c\u0010@\u001a\u00020\u001a*\u00020\u00142\u0006\u0010S\u001a\u0002062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010T\u001a\u00020**\u00020*H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "loopTable", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "getScope", "()Lorg/jetbrains/kotlin/ir/builders/Scope;", "getScopeOwner", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "createStatementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "generateAnonymousInitializerBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "ktAnonymousInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "generateAnySuperConstructorCall", "", "irBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrBlockBodyImpl;", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateDefaultParameters", "ktFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrFunctionBase;", "ktParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "generateDelegatingConstructorCall", "ktConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "generateEnumConstructorCallOrSuperCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "enumClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateEnumEntryInitializer", "enumEntryDescriptor", "generateEnumEntrySuperConstructorCall", "generateEnumSuperConstructorCall", "generateFunctionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "ktBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateLambdaBody", "ktFun", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "generatePrimaryConstructorBody", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generatePropertyInitializerBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "ktInitializer", "generateReturnExpression", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrReturnImpl;", "startOffset", "", "endOffset", "returnValue", "generateSecondaryConstructorBody", "generateSecondaryConstructorBodyWithNestedInitializers", "generateSuperConstructorCall", "getLoop", "expression", "putLoop", "irLoop", "generateBlockBodyStatements", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "generateEnumConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "ktExpression", "wrapWithReturn", "kotlin-compiler"})
public final class BodyGenerator
implements GeneratorWithScope {
    @NotNull
    private final Scope scope;
    private final HashMap<KtLoopExpression, IrLoop> loopTable;
    @NotNull
    private final DeclarationDescriptor scopeOwner;
    @NotNull
    private final GeneratorContext context;

    @Override
    @NotNull
    public Scope getScope() {
        return this.scope;
    }

    public final void generateDefaultParameters(@NotNull KtFunction ktFunction, @NotNull IrFunctionBase irFunction) {
        Intrinsics.checkParameterIsNotNull(ktFunction, "ktFunction");
        Intrinsics.checkParameterIsNotNull(irFunction, "irFunction");
        KtParameterList ktParameterList = ktFunction.getValueParameterList();
        if (ktParameterList == null) {
            return;
        }
        this.generateDefaultParameters(ktParameterList, irFunction);
    }

    public final void generateDefaultParameters(@NotNull KtParameterList ktParameterList, @NotNull IrFunctionBase irFunction) {
        Intrinsics.checkParameterIsNotNull(ktParameterList, "ktParameterList");
        Intrinsics.checkParameterIsNotNull(irFunction, "irFunction");
        StatementGenerator statementGenerator = this.createStatementGenerator();
        for (KtParameter ktParameter : ktParameterList.getParameters()) {
            ValueParameterDescriptor valueParameter;
            KtExpression ktDefaultValue;
            if (ktParameter.getDefaultValue() == null) {
                continue;
            }
            WritableSlice<KtParameter, VariableDescriptor> writableSlice = BindingContext.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.VALUE_PARAMETER");
            Object v = GeneratorKt.getOrFail(this, writableSlice, ktParameter);
            if (!(v instanceof ValueParameterDescriptor)) {
                v = null;
            }
            if ((ValueParameterDescriptor)v == null) {
                continue;
            }
            KtExpression ktExpression = ktDefaultValue;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "ktDefaultValue");
            IrExpression irDefaultValue = statementGenerator.generateExpression(ktExpression);
            irFunction.putDefault(valueParameter, new IrExpressionBodyImpl(irDefaultValue));
        }
    }

    @NotNull
    public final IrBody generateFunctionBody(@NotNull KtExpression ktBody) {
        Intrinsics.checkParameterIsNotNull(ktBody, "ktBody");
        StatementGenerator statementGenerator = this.createStatementGenerator();
        IrBlockBodyImpl irBlockBody = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktBody), PsiUtilsKt.getEndOffset(ktBody));
        if (ktBody instanceof KtBlockExpression) {
            this.generateBlockBodyStatements(statementGenerator, irBlockBody, (KtBlockExpression)ktBody);
        } else {
            this.generateReturnExpression(statementGenerator, ktBody, irBlockBody);
        }
        return irBlockBody;
    }

    @NotNull
    public final IrExpressionBody generatePropertyInitializerBody(@NotNull KtExpression ktInitializer) {
        Intrinsics.checkParameterIsNotNull(ktInitializer, "ktInitializer");
        return new IrExpressionBodyImpl(this.createStatementGenerator().generateExpression(ktInitializer));
    }

    @NotNull
    public final IrBody generateLambdaBody(@NotNull KtFunctionLiteral ktFun) {
        Intrinsics.checkParameterIsNotNull(ktFun, "ktFun");
        StatementGenerator statementGenerator = this.createStatementGenerator();
        KtBlockExpression ktBlockExpression = ktFun.getBodyExpression();
        if (ktBlockExpression == null) {
            Intrinsics.throwNpe();
        }
        KtBlockExpression ktBody = ktBlockExpression;
        IrBlockBodyImpl irBlockBody = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktBody), PsiUtilsKt.getEndOffset(ktBody));
        for (KtParameter ktParameter : ktFun.getValueParameters()) {
            KtDestructuringDeclaration ktDestructuringDeclaration;
            if (ktParameter.getDestructuringDeclaration() == null) {
                continue;
            }
            WritableSlice<KtParameter, VariableDescriptor> writableSlice = BindingContext.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.VALUE_PARAMETER");
            VariableDescriptor valueParameter = (VariableDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktParameter);
            int n = PsiUtilsKt.getStartOffset(ktDestructuringDeclaration);
            int n2 = PsiUtilsKt.getEndOffset(ktDestructuringDeclaration);
            VariableDescriptor variableDescriptor = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "valueParameter");
            VariableLValue parameterValue = new VariableLValue(n, n2, variableDescriptor, IrStatementOrigin.DESTRUCTURING_DECLARATION.INSTANCE);
            KtDestructuringDeclaration ktDestructuringDeclaration2 = ktDestructuringDeclaration;
            Intrinsics.checkExpressionValueIsNotNull(ktDestructuringDeclaration2, "ktDestructuringDeclaration");
            statementGenerator.declareComponentVariablesInBlock(ktDestructuringDeclaration2, irBlockBody, parameterValue);
        }
        if (ktBody instanceof KtBlockExpression) {
            List<KtExpression> ktBodyStatements = ktBody.getStatements();
            Collection collection = ktBodyStatements;
            if (!collection.isEmpty()) {
                KtExpression ktReturnedValue;
                for (KtExpression ktStatement : CollectionsKt.dropLast(ktBodyStatements, 1)) {
                    List<IrStatement> list2 = irBlockBody.getStatements();
                    KtExpression ktExpression = ktStatement;
                    Intrinsics.checkExpressionValueIsNotNull(ktExpression, "ktStatement");
                    list2.add(statementGenerator.generateStatement(ktExpression));
                }
                KtExpression ktExpression = ktReturnedValue = CollectionsKt.last(ktBodyStatements);
                Intrinsics.checkExpressionValueIsNotNull(ktExpression, "ktReturnedValue");
                this.generateReturnExpression(statementGenerator, ktExpression, irBlockBody);
            } else {
                List<IrStatement> list3 = irBlockBody.getStatements();
                int n = PsiUtilsKt.getStartOffset(ktBody);
                int n3 = PsiUtilsKt.getEndOffset(ktBody);
                int n4 = PsiUtilsKt.getStartOffset(ktBody);
                int n5 = PsiUtilsKt.getEndOffset(ktBody);
                SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.unitType");
                KotlinType kotlinType = simpleType2;
                ClassDescriptor classDescriptor = this.getContext().getBuiltIns().getUnit();
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "context.builtIns.unit");
                list3.add(this.generateReturnExpression(n, n3, new IrGetObjectValueImpl(n4, n5, kotlinType, classDescriptor)));
            }
        }
        return irBlockBody;
    }

    private final void generateBlockBodyStatements(@NotNull StatementGenerator $receiver, IrBlockBodyImpl irBlockBody, KtBlockExpression ktBody) {
        for (KtExpression ktStatement : ktBody.getStatements()) {
            List<IrStatement> list2 = irBlockBody.getStatements();
            KtExpression ktExpression = ktStatement;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "ktStatement");
            list2.add($receiver.generateStatement(ktExpression));
        }
    }

    private final void generateReturnExpression(@NotNull StatementGenerator $receiver, KtExpression ktExpression, IrBlockBodyImpl irBlockBody) {
        IrStatement irReturnExpression = $receiver.generateStatement(ktExpression);
        if (irReturnExpression instanceof IrExpression) {
            irBlockBody.getStatements().add(this.wrapWithReturn((IrExpression)irReturnExpression));
        } else {
            irBlockBody.getStatements().add(irReturnExpression);
        }
    }

    private final IrExpression wrapWithReturn(@NotNull IrExpression $receiver) {
        return $receiver instanceof IrReturn || $receiver instanceof IrErrorExpression || $receiver instanceof IrThrow ? $receiver : (IrExpression)this.generateReturnExpression($receiver.getStartOffset(), $receiver.getEndOffset(), $receiver);
    }

    private final IrReturnImpl generateReturnExpression(int startOffset, int endOffset, IrExpression returnValue) {
        DeclarationDescriptor declarationDescriptor = this.scopeOwner;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (callableDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("'return' in a non-callable: " + this.scopeOwner)));
        }
        CallableDescriptor returnTarget = callableDescriptor;
        SimpleType simpleType2 = this.getContext().getBuiltIns().getNothingType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.nothingType");
        return new IrReturnImpl(startOffset, endOffset, simpleType2, returnTarget, returnValue);
    }

    @NotNull
    public final IrBody generateSecondaryConstructorBody(@NotNull KtSecondaryConstructor ktConstructor) {
        IrBlockBodyImpl irBlockBody;
        block0: {
            KtBlockExpression ktBlockExpression;
            Intrinsics.checkParameterIsNotNull(ktConstructor, "ktConstructor");
            irBlockBody = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktConstructor), PsiUtilsKt.getEndOffset(ktConstructor));
            this.generateDelegatingConstructorCall(irBlockBody, ktConstructor);
            KtBlockExpression ktBlockExpression2 = ktConstructor.getBodyExpression();
            if (ktBlockExpression2 == null) break block0;
            KtBlockExpression ktBody = ktBlockExpression = ktBlockExpression2;
            StatementGenerator statementGenerator = this.createStatementGenerator();
            KtBlockExpression ktBlockExpression3 = ktBody;
            Intrinsics.checkExpressionValueIsNotNull(ktBlockExpression3, "ktBody");
            this.generateBlockBodyStatements(statementGenerator, irBlockBody, ktBlockExpression3);
        }
        return irBlockBody;
    }

    private final void generateDelegatingConstructorCall(IrBlockBodyImpl irBlockBody, KtSecondaryConstructor ktConstructor) {
        DeclarationDescriptor declarationDescriptor = this.scopeOwner;
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
        }
        ClassConstructorDescriptor constructorDescriptor = (ClassConstructorDescriptor)declarationDescriptor;
        StatementGenerator statementGenerator = this.createStatementGenerator();
        KtConstructorDelegationCall ktDelegatingConstructorCall = ktConstructor.getDelegationCall();
        ResolvedCall<? extends CallableDescriptor> delegatingConstructorResolvedCall = GeneratorKt.getResolvedCall(this, ktDelegatingConstructorCall);
        if (delegatingConstructorResolvedCall == null) {
            if (Intrinsics.areEqual((Object)constructorDescriptor.getContainingDeclaration().getKind(), (Object)ClassKind.ENUM_CLASS)) {
                this.generateEnumSuperConstructorCall(irBlockBody, ktConstructor);
            } else {
                this.generateAnySuperConstructorCall(irBlockBody, ktConstructor);
            }
            return;
        }
        CallBuilder delegatingConstructorCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator, delegatingConstructorResolvedCall);
        IrExpression irDelegatingConstructorCall = new CallGenerator(statementGenerator).generateDelegatingConstructorCall(PsiUtilsKt.getStartOffset(ktDelegatingConstructorCall), PsiUtilsKt.getEndOffset(ktDelegatingConstructorCall), delegatingConstructorCall);
        irBlockBody.getStatements().add(irDelegatingConstructorCall);
    }

    @NotNull
    public final StatementGenerator createStatementGenerator() {
        return new StatementGenerator(this, this.getScope());
    }

    public final void putLoop(@NotNull KtLoopExpression expression2, @NotNull IrLoop irLoop) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(irLoop, "irLoop");
        Map map2 = this.loopTable;
        IrLoop irLoop2 = irLoop;
        map2.put(expression2, irLoop2);
    }

    @Nullable
    public final IrLoop getLoop(@NotNull KtExpression expression2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Map map3 = map2 = (Map)this.loopTable;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return (IrLoop)map3.get(expression2);
    }

    @NotNull
    public final IrBody generatePrimaryConstructorBody(@NotNull KtClassOrObject ktClassOrObject) {
        Intrinsics.checkParameterIsNotNull(ktClassOrObject, "ktClassOrObject");
        IrBlockBodyImpl irBlockBody = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktClassOrObject), PsiUtilsKt.getEndOffset(ktClassOrObject));
        this.generateSuperConstructorCall(irBlockBody, ktClassOrObject);
        DeclarationDescriptor declarationDescriptor = this.scopeOwner;
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
        }
        ClassDescriptor classDescriptor = ((ClassConstructorDescriptor)declarationDescriptor).getContainingDeclaration();
        irBlockBody.getStatements().add(new IrInstanceInitializerCallImpl(PsiUtilsKt.getStartOffset(ktClassOrObject), PsiUtilsKt.getEndOffset(ktClassOrObject), classDescriptor));
        return irBlockBody;
    }

    @NotNull
    public final IrBody generateSecondaryConstructorBodyWithNestedInitializers(@NotNull KtSecondaryConstructor ktConstructor) {
        IrBlockBodyImpl irBlockBody;
        block1: {
            KtBlockExpression ktBlockExpression;
            Intrinsics.checkParameterIsNotNull(ktConstructor, "ktConstructor");
            irBlockBody = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktConstructor), PsiUtilsKt.getEndOffset(ktConstructor));
            this.generateDelegatingConstructorCall(irBlockBody, ktConstructor);
            WritableSlice<PsiElement, ConstructorDescriptor> writableSlice = BindingContext.CONSTRUCTOR;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.CONSTRUCTOR");
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktConstructor)).getContainingDeclaration();
            if (classifierDescriptorWithTypeParameters == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptorWithTypeParameters;
            irBlockBody.getStatements().add(new IrInstanceInitializerCallImpl(PsiUtilsKt.getStartOffset(ktConstructor), PsiUtilsKt.getEndOffset(ktConstructor), classDescriptor));
            KtBlockExpression ktBlockExpression2 = ktConstructor.getBodyExpression();
            if (ktBlockExpression2 == null) break block1;
            KtBlockExpression ktBody = ktBlockExpression = ktBlockExpression2;
            StatementGenerator statementGenerator = this.createStatementGenerator();
            KtBlockExpression ktBlockExpression3 = ktBody;
            Intrinsics.checkExpressionValueIsNotNull(ktBlockExpression3, "ktBody");
            this.generateBlockBodyStatements(statementGenerator, irBlockBody, ktBlockExpression3);
        }
        return irBlockBody;
    }

    private final void generateSuperConstructorCall(IrBlockBodyImpl irBlockBody, KtClassOrObject ktClassOrObject) {
        WritableSlice<PsiElement, ClassDescriptor> writableSlice = BindingContext.CLASS;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.CLASS");
        ClassDescriptor classDescriptor = (ClassDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktClassOrObject);
        switch (BodyGenerator$WhenMappings.$EnumSwitchMapping$0[classDescriptor.getKind().ordinal()]) {
            case 1: {
                this.generateEnumSuperConstructorCall(irBlockBody, ktClassOrObject);
                break;
            }
            case 2: {
                List<IrStatement> list2 = irBlockBody.getStatements();
                KtClassOrObject ktClassOrObject2 = ktClassOrObject;
                if (ktClassOrObject2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEnumEntry");
                }
                KtEnumEntry ktEnumEntry = (KtEnumEntry)ktClassOrObject2;
                ClassDescriptor classDescriptor2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "classDescriptor");
                list2.add(this.generateEnumEntrySuperConstructorCall(ktEnumEntry, classDescriptor2));
                break;
            }
            default: {
                StatementGenerator statementGenerator = this.createStatementGenerator();
                KtSuperTypeList ktSuperTypeList = ktClassOrObject.getSuperTypeList();
                if (ktSuperTypeList != null) {
                    KtSuperTypeList ktSuperTypeList2;
                    KtSuperTypeList ktSuperTypeList3 = ktSuperTypeList2 = ktSuperTypeList;
                    for (KtSuperTypeListEntry ktSuperTypeListEntry : ktSuperTypeList3.getEntries()) {
                        if (!(ktSuperTypeListEntry instanceof KtSuperTypeCallEntry)) continue;
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktSuperTypeListEntry);
                        if (resolvedCall2 == null) {
                            Intrinsics.throwNpe();
                        }
                        CallBuilder superConstructorCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator, resolvedCall2);
                        IrExpression irSuperConstructorCall = new CallGenerator(statementGenerator).generateDelegatingConstructorCall(PsiUtilsKt.getStartOffset(ktSuperTypeListEntry), PsiUtilsKt.getEndOffset(ktSuperTypeListEntry), superConstructorCall);
                        irBlockBody.getStatements().add(irSuperConstructorCall);
                        return;
                    }
                }
                ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(classDescriptor);
                boolean bl = KotlinBuiltIns.isAny(superClass);
                if (_Assertions.ENABLED && !bl) {
                    String string = classDescriptor + ": Super class should be any: " + superClass;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.generateAnySuperConstructorCall(irBlockBody, ktClassOrObject);
            }
        }
    }

    private final void generateAnySuperConstructorCall(IrBlockBodyImpl irBlockBody, KtElement ktElement) {
        ClassConstructorDescriptor anyConstructor = (ClassConstructorDescriptor)CollectionsKt.single((Iterable)this.getContext().getBuiltIns().getAny().getConstructors());
        List<IrStatement> list2 = irBlockBody.getStatements();
        int n = PsiUtilsKt.getStartOffset(ktElement);
        int n2 = PsiUtilsKt.getEndOffset(ktElement);
        ClassConstructorDescriptor classConstructorDescriptor = anyConstructor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor, "anyConstructor");
        list2.add(new IrDelegatingConstructorCallImpl(n, n2, classConstructorDescriptor, null));
    }

    private final void generateEnumSuperConstructorCall(IrBlockBodyImpl irBlockBody, KtElement ktElement) {
        ClassConstructorDescriptor enumConstructor = (ClassConstructorDescriptor)CollectionsKt.single((Iterable)this.getContext().getBuiltIns().getEnum().getConstructors());
        List<IrStatement> list2 = irBlockBody.getStatements();
        int n = PsiUtilsKt.getStartOffset(ktElement);
        int n2 = PsiUtilsKt.getEndOffset(ktElement);
        ClassConstructorDescriptor classConstructorDescriptor = enumConstructor;
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor, "enumConstructor");
        list2.add(new IrEnumConstructorCallImpl(n, n2, classConstructorDescriptor));
    }

    private final IrExpression generateEnumEntrySuperConstructorCall(KtEnumEntry ktEnumEntry, ClassDescriptor enumEntryDescriptor) {
        DeclarationDescriptor declarationDescriptor = enumEntryDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return this.generateEnumConstructorCallOrSuperCall(ktEnumEntry, (ClassDescriptor)declarationDescriptor);
    }

    @NotNull
    public final IrBlockBody generateAnonymousInitializerBody(@NotNull KtAnonymousInitializer ktAnonymousInitializer) {
        Intrinsics.checkParameterIsNotNull(ktAnonymousInitializer, "ktAnonymousInitializer");
        KtExpression ktExpression = ktAnonymousInitializer.getBody();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktBody = ktExpression;
        IrBlockBodyImpl irBlockBody = new IrBlockBodyImpl(PsiUtilsKt.getStartOffset(ktBody), PsiUtilsKt.getEndOffset(ktBody));
        if (ktBody instanceof KtBlockExpression) {
            this.generateBlockBodyStatements(this.createStatementGenerator(), irBlockBody, (KtBlockExpression)ktBody);
        } else {
            irBlockBody.getStatements().add(this.createStatementGenerator().generateStatement(ktBody));
        }
        return irBlockBody;
    }

    @NotNull
    public final IrExpression generateEnumEntryInitializer(@NotNull KtEnumEntry ktEnumEntry, @NotNull ClassDescriptor enumEntryDescriptor) {
        Intrinsics.checkParameterIsNotNull(ktEnumEntry, "ktEnumEntry");
        Intrinsics.checkParameterIsNotNull(enumEntryDescriptor, "enumEntryDescriptor");
        Collection collection = ktEnumEntry.getDeclarations();
        if (!collection.isEmpty()) {
            ClassConstructorDescriptor classConstructorDescriptor = enumEntryDescriptor.getUnsubstitutedPrimaryConstructor();
            if (classConstructorDescriptor == null) {
                Intrinsics.throwNpe();
            }
            ClassConstructorDescriptor enumEntryConstructor = classConstructorDescriptor;
            int n = PsiUtilsKt.getStartOffset(ktEnumEntry);
            int n2 = PsiUtilsKt.getEndOffset(ktEnumEntry);
            ClassConstructorDescriptor classConstructorDescriptor2 = enumEntryConstructor;
            Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor2, "enumEntryConstructor");
            return new IrEnumConstructorCallImpl(n, n2, classConstructorDescriptor2);
        }
        DeclarationDescriptor declarationDescriptor = enumEntryDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return this.generateEnumConstructorCallOrSuperCall(ktEnumEntry, (ClassDescriptor)declarationDescriptor);
    }

    private final IrExpression generateEnumConstructorCallOrSuperCall(KtEnumEntry ktEnumEntry, ClassDescriptor enumClassDescriptor) {
        Object v1;
        block5: {
            Iterable iterable;
            StatementGenerator statementGenerator = this.createStatementGenerator();
            KtSuperTypeListEntry ktSuperCallElement = CollectionsKt.firstOrNull(ktEnumEntry.getSuperTypeListEntries());
            if (ktSuperCallElement != null) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktSuperCallElement);
                if (resolvedCall2 == null) {
                    Intrinsics.throwNpe();
                }
                return this.generateEnumConstructorCall(statementGenerator, resolvedCall2, ktEnumEntry);
            }
            ResolvedCall<? extends CallableDescriptor> enumDefaultConstructorCall = GeneratorKt.getResolvedCall(this, ktEnumEntry);
            if (enumDefaultConstructorCall != null) {
                return this.generateEnumConstructorCall(statementGenerator, enumDefaultConstructorCall, ktEnumEntry);
            }
            Iterable iterable2 = iterable = (Iterable)enumClassDescriptor.getConstructors();
            for (Object t : iterable2) {
                ClassConstructorDescriptor it = (ClassConstructorDescriptor)t;
                if (!it.getValueParameters().isEmpty()) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        ClassConstructorDescriptor enumClassConstructor = v1;
        return new IrEnumConstructorCallImpl(PsiUtilsKt.getStartOffset(ktEnumEntry), PsiUtilsKt.getEndOffset(ktEnumEntry), enumClassConstructor);
    }

    private final IrExpression generateEnumConstructorCall(@NotNull StatementGenerator $receiver, ResolvedCall<? extends CallableDescriptor> constructorCall, KtEnumEntry ktEnumEntry) {
        return new CallGenerator($receiver).generateEnumConstructorSuperCall(PsiUtilsKt.getStartOffset(ktEnumEntry), PsiUtilsKt.getEndOffset(ktEnumEntry), ArgumentsGenerationUtilsKt.pregenerateCall($receiver, constructorCall));
    }

    @NotNull
    public final DeclarationDescriptor getScopeOwner() {
        return this.scopeOwner;
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.context;
    }

    public BodyGenerator(@NotNull DeclarationDescriptor scopeOwner, @NotNull GeneratorContext context) {
        Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.scopeOwner = scopeOwner;
        this.context = context;
        this.scope = new Scope(this.scopeOwner);
        this.loopTable = new HashMap();
    }
}

