/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.i18n;

import java.util.Set;

public class ReplacementTrieNode {
    private char cLetter;
    private int nInputLength;
    private String sLaTeXCode = null;
    private int nFontencs = 0;
    private ReplacementTrieNode son = null;
    private ReplacementTrieNode brother = null;

    public ReplacementTrieNode(char cLetter, int nInputLength) {
        this.cLetter = cLetter;
        this.nInputLength = nInputLength;
    }

    public char getLetter() {
        return this.cLetter;
    }

    public int getInputLength() {
        return this.nInputLength;
    }

    public String getLaTeXCode() {
        return this.sLaTeXCode;
    }

    public int getFontencs() {
        return this.nFontencs;
    }

    protected void setLaTeXCode(String sLaTeXCode) {
        this.sLaTeXCode = sLaTeXCode;
    }

    protected void setFontencs(int nFontencs) {
        this.nFontencs = nFontencs;
    }

    protected ReplacementTrieNode getFirstChild() {
        return this.son;
    }

    protected ReplacementTrieNode getNextSibling() {
        return this.brother;
    }

    protected ReplacementTrieNode getChildByLetter(char cLetter) {
        for (ReplacementTrieNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (cLetter != child.getLetter()) continue;
            return child;
        }
        return null;
    }

    protected void appendChild(ReplacementTrieNode node) {
        if (this.son == null) {
            this.son = node;
        } else {
            this.son.appendSibling(node);
        }
    }

    protected void appendSibling(ReplacementTrieNode node) {
        if (this.brother == null) {
            this.brother = node;
        } else {
            this.brother.appendSibling(node);
        }
    }

    protected ReplacementTrieNode get(String sInput, int nStart, int nEnd) {
        if (nStart >= nEnd) {
            return null;
        }
        char c = sInput.charAt(nStart);
        for (ReplacementTrieNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getLetter() != c) continue;
            if (child.getLaTeXCode() != null) {
                return child;
            }
            return child.get(sInput, nStart + 1, nEnd);
        }
        return null;
    }

    protected void put(String sInput, String sLaTeXCode, int nFontencs) {
        char c = sInput.charAt(0);
        ReplacementTrieNode child = this.getChildByLetter(c);
        if (child == null) {
            child = new ReplacementTrieNode(c, this.getInputLength() + 1);
            this.appendChild(child);
        }
        if (sInput.length() > 1) {
            child.put(sInput.substring(1), sLaTeXCode, nFontencs);
        } else {
            child.setLaTeXCode(sLaTeXCode);
            child.setFontencs(nFontencs);
        }
    }

    protected void collectStrings(Set<String> strings, String sPrefix) {
        for (ReplacementTrieNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getLaTeXCode() != null) {
                strings.add(sPrefix + child.getLetter());
            }
            child.collectStrings(strings, sPrefix + child.getLetter());
        }
    }

    public String toString() {
        String s = Character.toString(this.cLetter);
        if (this.brother != null) {
            s = s + this.brother.toString();
        }
        s = this.son != null ? s + "\nInputLength " + (this.nInputLength + 1) + ", " + this.son.toString() : s + "\n";
        return s;
    }
}

