'use strict';

module.exports = read;

function read() {
  if (process.stdin.isTTY || process.env.TAP) {
    return Promise.resolve(null);
  }

  return new Promise(function (resolve) {
    var data = '';

    process.stdin.resume();
    process.stdin.setEncoding('utf8');
    process.stdin.on('data', function (chunk) {
      return data += chunk;
    });
    process.stdin.on('end', function () {
      return resolve(data);
    });
  });
}