var parse = require('./parse-mvn');
var fs = require('fs');
var path = require('path');
var subProcess = require('./sub-process');

module.exports = {
  inspect: inspect,
};

function inspect(root, targetFile, options) {
  if (!options) { options = { dev: false }; }
  return subProcess.execute(
    'mvn',
    buildArgs(root, targetFile, options.args),
    { cwd: root }
  )
  .then(function (result) {
    return {
      plugin: {
        name: 'bundled:maven',
        runtime: 'unknown',
      },
      package: parse(result, options.dev),
    };
  });
}

function buildArgs(root, targetFile, mavenArgs) {
  // Requires Maven >= 2.2
  var args = ['dependency:tree', '-DoutputType=dot'];
  if (targetFile) {
    if (!fs.existsSync(path.resolve(root, targetFile))) {
      throw new Error('File not found: ' + targetFile);
    }
    args.push('--file=' + targetFile);
  }
  if (mavenArgs) {
    args.push(mavenArgs);
  }
  return args;
}
