/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

import com.baselet.control.basics.geom.GeometricFunctions;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.Direction;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Line {
    private static final Logger log = LoggerFactory.getLogger(Line.class);
    private final PointDouble start;
    private final PointDouble end;

    public Line(PointDouble start, PointDouble end) {
        this.start = start;
        this.end = end;
    }

    public PointDouble getStart() {
        return this.start;
    }

    public PointDouble getEnd() {
        return this.end;
    }

    public PointDouble getPoint(boolean start) {
        return start ? this.getStart() : this.getEnd();
    }

    public PointDouble getCenter() {
        return new PointDouble((this.start.getX() + this.end.getX()) / 2.0, (this.start.getY() + this.end.getY()) / 2.0);
    }

    public double getLength() {
        return GeometricFunctions.distanceBetweenTwoPoints(this.start, this.end);
    }

    public PointDouble getPointOnLineWithDistanceFrom(boolean fromStart, double distance) {
        if (fromStart) {
            return GeometricFunctions.getPointOnLineWithDistanceFromStart(this.start, this.end, distance);
        }
        return GeometricFunctions.getPointOnLineWithDistanceFromStart(this.end, this.start, distance);
    }

    public double getAngleOfSlope() {
        double radius = this.getLength();
        double rad = Math.acos((this.start.x - this.end.x) / radius);
        double radDeg = Math.toDegrees(rad);
        if (this.start.y < this.end.y) {
            radDeg = 360.0 - radDeg;
        }
        return radDeg;
    }

    public double getDistanceToPoint(PointDouble pointToCheck) {
        double dist = GeometricFunctions.getDistanceBetweenLineAndPoint(this.start, this.end, pointToCheck);
        log.trace("Minimal distance between " + this + " and " + pointToCheck + " is " + dist);
        return dist;
    }

    public PointDouble[] toPoints() {
        return new PointDouble[]{this.start, this.end};
    }

    public Direction getDirectionOfLine(boolean directionOfStart) {
        double angleOfSlope = this.getAngleOfSlope();
        Direction direction = angleOfSlope > 315.0 || angleOfSlope < 45.0 ? Direction.RIGHT : (angleOfSlope < 135.0 ? Direction.DOWN : (angleOfSlope < 225.0 ? Direction.LEFT : Direction.UP));
        if (!directionOfStart) {
            direction = direction.invert();
        }
        return direction;
    }

    public List<PointDouble> getIntersectionPoints(Rectangle rectangle) {
        return GeometricFunctions.getIntersectionPoints(this, rectangle);
    }

    public Line getShorterVersion(boolean fromStart, double shortenBy) {
        PointDouble shortenedPoint = this.getPointOnLineWithDistanceFrom(fromStart, shortenBy);
        if (fromStart) {
            return new Line(shortenedPoint, this.end);
        }
        return new Line(this.start, shortenedPoint);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Line other = (Line)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    public String toString() {
        return "Line [start=" + this.start + ", end=" + this.end + "]";
    }
}

