/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.facet;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Priority;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.FirstRunFacet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.relation.facet.LineDescriptionPositionFacet;
import com.baselet.element.relation.facet.LineDescriptionUtils;
import com.baselet.element.relation.facet.SettingsRelation;
import com.baselet.element.relation.helper.LineDescriptionEnum;
import com.baselet.element.relation.helper.RelationPointHandler;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LineDescriptionFacet
extends FirstRunFacet {
    static final int X_DIST_TO_LINE = 4;
    static final int LOWER_Y_DIST_TO_LINE = 1;
    static final int UPPER_Y_DIST_TO_LINE = 5;
    static final int MIDDLE_DISTANCE_TO_LINE = 4;
    public static final LineDescriptionFacet INSTANCE = new LineDescriptionFacet();

    private LineDescriptionFacet() {
    }

    @Override
    public boolean checkStart(String line, PropertiesParserState state) {
        return !line.startsWith("lt=");
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Arrays.asList(new AutocompletionText(String.valueOf(LineDescriptionEnum.MESSAGE_START.getKey()) + "=", "message at start"), new AutocompletionText(String.valueOf(LineDescriptionEnum.MESSAGE_END.getKey()) + "=", "message at end"), new AutocompletionText(String.valueOf(LineDescriptionEnum.ROLE_START.getKey()) + "=", "role at start"), new AutocompletionText(String.valueOf(LineDescriptionEnum.ROLE_END.getKey()) + "=", "role at end"));
    }

    @Override
    public void handleLine(String line, PropertiesParserState state) {
    }

    private RelationPointHandler getRelationPoints(PropertiesParserState state) {
        return ((SettingsRelation)state.getSettings()).getRelationPoints();
    }

    private void addIndex(RelationPointHandler relationPoints, int index, Set<Integer> usedIndexes, Rectangle rect) {
        relationPoints.setTextBox(index, rect);
        usedIndexes.add(index);
    }

    @Override
    public void parsingFinished(PropertiesParserState state, List<String> handledLines) {
        Map displacements = state.getOrInitFacetResponse(LineDescriptionPositionFacet.class, new HashMap());
        RelationPointHandler relationPoints = this.getRelationPoints(state);
        DrawHandler drawer = state.getDrawer();
        HashSet<Integer> usedIndexes = new HashSet<Integer>();
        ArrayList<String> middleLines = new ArrayList<String>();
        ArrayList<String> otherLines = new ArrayList<String>();
        for (String line : handledLines) {
            if (LineDescriptionEnum.forString(line) == LineDescriptionEnum.MESSAGE_MIDDLE) {
                middleLines.add(line);
                continue;
            }
            otherLines.add(line);
        }
        this.printMiddleDescription(relationPoints, drawer, usedIndexes, middleLines);
        this.printEndDescriptions(displacements, relationPoints, drawer, usedIndexes, otherLines);
        relationPoints.resetTextBoxIndexesExcept(usedIndexes);
        relationPoints.resizeRectAndReposPoints();
    }

    private void printMiddleDescription(RelationPointHandler relationPoints, DrawHandler drawer, Set<Integer> usedIndexes, List<String> middleLines) {
        double halfMiddleBlockHeight = (double)middleLines.size() * drawer.textHeightMaxWithSpace() / 2.0;
        Rectangle textSpace = null;
        int i = 0;
        while (i < middleLines.size()) {
            String line = LineDescriptionUtils.replaceArrowsWithUtf8Characters(middleLines.get(i));
            PointDouble pointText = LineDescriptionUtils.calcPosOfMiddleText(drawer, line, relationPoints.getMiddleLine(), i, halfMiddleBlockHeight);
            drawer.print(line, pointText, AlignHorizontal.LEFT);
            textSpace = this.increaseTextSpaceRectangleForLine(textSpace, drawer, line, pointText);
            ++i;
        }
        if (textSpace != null) {
            this.addIndex(relationPoints, LineDescriptionEnum.MESSAGE_MIDDLE.getIndex(), usedIndexes, textSpace);
        }
    }

    private void printEndDescriptions(Map<String, Point> displacements, RelationPointHandler relationPoints, DrawHandler drawer, Set<Integer> usedIndexes, List<String> otherLines) {
        for (String line : otherLines) {
            LineDescriptionEnum enumVal = LineDescriptionEnum.forString(line);
            String[] split = line.split("=", -1);
            String text = split[1];
            if (text.isEmpty()) continue;
            Rectangle textSpace = null;
            String[] splitAtLineEndChar = SharedUtils.splitAtLineEndChar(text);
            int i = 0;
            while (i < splitAtLineEndChar.length) {
                String subline = splitAtLineEndChar[i];
                PointDouble pointText = LineDescriptionUtils.calcPosOfLineDescriptionText(drawer, subline, i, splitAtLineEndChar.length, relationPoints, enumVal);
                pointText = this.applyDisplacements(displacements, enumVal, pointText);
                drawer.print(subline, pointText, AlignHorizontal.LEFT);
                textSpace = this.increaseTextSpaceRectangleForLine(textSpace, drawer, subline, pointText);
                ++i;
            }
            this.addIndex(relationPoints, enumVal.getIndex(), usedIndexes, textSpace);
        }
    }

    private PointDouble applyDisplacements(Map<String, Point> displacements, LineDescriptionEnum enumVal, PointDouble pointText) {
        Point displacement = displacements.get(enumVal.getKey());
        if (displacement != null) {
            pointText = new PointDouble(pointText.getX() + (double)displacement.getX(), pointText.getY() + (double)displacement.getY());
        }
        return pointText;
    }

    private Rectangle increaseTextSpaceRectangleForLine(Rectangle textSpaceRect, DrawHandler drawer, String line, PointDouble pointText) {
        Rectangle newSpaceRect = new Rectangle(pointText.getX(), pointText.getY() - drawer.textHeightMax(), drawer.textWidth(line), drawer.textHeightMax());
        textSpaceRect = Rectangle.mergeToLeft(textSpaceRect, newSpaceRect);
        return textSpaceRect;
    }

    @Override
    public Priority getPriority() {
        return Priority.LOWEST;
    }
}

