/*
 * Decompiled with CFR 0.152.
 */
package test.tools;

import dguitar.adaptors.song.Tempo;
import dguitar.players.sound.EventSoundPlayer;
import dguitar.players.sound.Performance;
import dguitar.players.sound.PerformanceEventListener;
import dguitar.players.sound.PerformanceTimerListener;
import dguitar.players.sound.RealtimeSoundPlayer;
import dguitar.players.sound.SoundPlayer;
import dguitar.players.sound.midi.MetaPerformer;
import dguitar.players.sound.midi.MidiPerformanceEventListenerProxy;
import dguitar.players.sound.midi.MidiPerformanceTimerListenerProxy;
import dguitar.players.sound.midi.PerformanceLive;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Track;

public class MockMidiPlayer
implements SoundPlayer,
RealtimeSoundPlayer,
EventSoundPlayer,
Runnable {
    private String className;
    private Logger logger;
    PerformanceLive live;
    List listeners;
    Thread playerThread;
    private int timerFrequency;
    private boolean noteEventsEnabled;
    static /* synthetic */ Class class$0;

    public MockMidiPlayer() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("test.tools.MockMidiPlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.className = clazz.toString();
        this.logger = Logger.getLogger(this.className);
        this.listeners = new LinkedList();
        this.playerThread = new Thread(this);
    }

    public Performance createPerformance(int tracks, Tempo tempo, int resolution) {
        try {
            PerformanceLive aLive = new PerformanceLive(tracks, tempo, resolution);
            aLive.enableNoteEvents(this.noteEventsEnabled);
            aLive.setTimerFrequency(this.timerFrequency);
            return aLive;
        }
        catch (InvalidMidiDataException e) {
            this.logger.severe("Could not create a performance object");
            return null;
        }
    }

    public void start() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            MetaPerformer mp = (MetaPerformer)it.next();
            mp.setContainer(this.live);
        }
        this.playerThread.start();
    }

    public void stop() {
        this.playerThread.interrupt();
    }

    public void waitForCompletion() {
        while (this.playerThread.isAlive()) {
            try {
                this.playerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setPerformance(Performance performance) {
        this.live = (PerformanceLive)performance;
    }

    public void close() {
    }

    public void addTimerListener(PerformanceTimerListener listener) {
        MidiPerformanceTimerListenerProxy proxy = new MidiPerformanceTimerListenerProxy(listener);
        this.listeners.add(proxy);
    }

    public void addEventListener(PerformanceEventListener listener) {
        MidiPerformanceEventListenerProxy proxy = new MidiPerformanceEventListenerProxy(listener);
        this.listeners.add(proxy);
    }

    public void run() {
        LinkedList<MidiEvent> metaEvents = new LinkedList<MidiEvent>();
        PerformanceLive sequence = this.live;
        Track[] midiTracks = sequence.getTracks();
        int t = 0;
        while (t < midiTracks.length) {
            Track midiTrack = midiTracks[t];
            int size = midiTrack.size();
            int i = 0;
            while (i < size) {
                MetaMessage mm;
                MidiEvent event = midiTrack.get(i);
                MidiMessage message = event.getMessage();
                if (message.getStatus() == 255 && (mm = (MetaMessage)message).getType() == 1) {
                    metaEvents.add(event);
                }
                ++i;
            }
            ++t;
        }
        Collections.sort(metaEvents, new Comparator(){

            public int compare(Object o1, Object o2) {
                long t2;
                MidiEvent e1 = (MidiEvent)o1;
                MidiEvent e2 = (MidiEvent)o2;
                long t1 = e1.getTick();
                if (t1 < (t2 = e2.getTick())) {
                    return -1;
                }
                if (t1 > t2) {
                    return 1;
                }
                return 0;
            }
        });
        Iterator it = metaEvents.iterator();
        while (it.hasNext()) {
            MidiEvent event = (MidiEvent)it.next();
            MetaMessage message = (MetaMessage)event.getMessage();
            Iterator l = this.listeners.iterator();
            while (l.hasNext()) {
                MetaEventListener listener = (MetaEventListener)l.next();
                listener.meta(message);
            }
        }
    }

    public void setTimerFrequency(int ppq) {
        this.timerFrequency = ppq;
    }

    public void enableNoteEvents(boolean enable) {
        this.noteEventsEnabled = enable;
    }
}

