/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.text;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.stathissideris.ascii2image.core.FileUtils;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.GridPattern;
import org.stathissideris.ascii2image.text.GridPatternGroup;
import org.stathissideris.ascii2image.text.StringUtils;

public class TextGrid {
    private static final boolean DEBUG = false;
    private ArrayList<StringBuilder> rows;
    private static char[] boundaries = new char[]{'/', '\\', '|', '-', '*', '=', ':'};
    private static char[] undisputableBoundaries = new char[]{'|', '-', '*', '=', ':'};
    private static char[] horizontalLines = new char[]{'-', '='};
    private static char[] verticalLines = new char[]{'|', ':'};
    private static char[] arrowHeads = new char[]{'<', '>', '^', 'v', 'V'};
    private static char[] cornerChars = new char[]{'\\', '/', '+'};
    private static char[] pointMarkers = new char[]{'*'};
    private static char[] dashedLines = new char[]{':', '~', '='};
    private static char[] entryPoints1 = new char[]{'\\'};
    private static char[] entryPoints2 = new char[]{'|', ':', '+', '\\', '/'};
    private static char[] entryPoints3 = new char[]{'/'};
    private static char[] entryPoints4 = new char[]{'-', '=', '+', '\\', '/'};
    private static char[] entryPoints5 = new char[]{'\\'};
    private static char[] entryPoints6 = new char[]{'|', ':', '+', '\\', '/'};
    private static char[] entryPoints7 = new char[]{'/'};
    private static char[] entryPoints8 = new char[]{'-', '=', '+', '\\', '/'};
    private static HashMap<String, String> humanColorCodes = new HashMap();
    private static HashSet<String> markupTags;

    public void addToMarkupTags(Collection<String> collection) {
        markupTags.addAll(collection);
    }

    public static void main(String[] stringArray) throws Exception {
        TextGrid textGrid = new TextGrid();
        textGrid.loadFrom("tests/text/art10.txt");
        TextGrid textGrid2 = textGrid;
        textGrid2.getClass();
        textGrid.writeStringTo(textGrid2.new Cell(28, 1), "testing");
        textGrid.findMarkupTags();
        textGrid.printDebug();
    }

    public TextGrid() {
        this.rows = new ArrayList();
    }

    public TextGrid(int n, int n2) {
        String string = StringUtils.repeatString(" ", n);
        this.rows = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            this.rows.add(new StringBuilder(string));
        }
    }

    public static TextGrid makeSameSizeAs(TextGrid textGrid) {
        return new TextGrid(textGrid.getWidth(), textGrid.getHeight());
    }

    public TextGrid(TextGrid textGrid) {
        this.rows = new ArrayList();
        for (StringBuilder stringBuilder : textGrid.getRows()) {
            this.rows.add(new StringBuilder(stringBuilder));
        }
    }

    public void clear() {
        String string = StringUtils.repeatString(" ", this.getWidth());
        int n = this.getHeight();
        this.rows.clear();
        for (int i = 0; i < n; ++i) {
            this.rows.add(new StringBuilder(string));
        }
    }

    public char get(int n, int n2) {
        if (n > this.getWidth() - 1 || n2 > this.getHeight() - 1 || n < 0 || n2 < 0) {
            return '\u0000';
        }
        return this.rows.get(n2).charAt(n);
    }

    public char get(Cell cell) {
        if (cell.x > this.getWidth() - 1 || cell.y > this.getHeight() - 1 || cell.x < 0 || cell.y < 0) {
            return '\u0000';
        }
        return this.rows.get(cell.y).charAt(cell.x);
    }

    public StringBuilder getRow(int n) {
        return this.rows.get(n);
    }

    public TextGrid getSubGrid(int n, int n2, int n3, int n4) {
        TextGrid textGrid = new TextGrid(n3, n4);
        for (int i = 0; i < n4; ++i) {
            textGrid.setRow(i, new StringBuilder(this.getRow(n2 + i).subSequence(n, n + n3)));
        }
        return textGrid;
    }

    public TextGrid getTestingSubGrid(Cell cell) {
        return this.getSubGrid(cell.x - 1, cell.y - 1, 3, 3);
    }

    public String getStringAt(int n, int n2, int n3) {
        return this.getStringAt(new Cell(n, n2), n3);
    }

    public String getStringAt(Cell cell, int n) {
        int n2 = cell.x;
        int n3 = cell.y;
        if (n2 > this.getWidth() - 1 || n3 > this.getHeight() - 1 || n2 < 0 || n3 < 0) {
            return null;
        }
        return this.rows.get(n3).substring(n2, n2 + n);
    }

    public char getNorthOf(int n, int n2) {
        return this.get(n, n2 - 1);
    }

    public char getSouthOf(int n, int n2) {
        return this.get(n, n2 + 1);
    }

    public char getEastOf(int n, int n2) {
        return this.get(n + 1, n2);
    }

    public char getWestOf(int n, int n2) {
        return this.get(n - 1, n2);
    }

    public char getNorthOf(Cell cell) {
        return this.getNorthOf(cell.x, cell.y);
    }

    public char getSouthOf(Cell cell) {
        return this.getSouthOf(cell.x, cell.y);
    }

    public char getEastOf(Cell cell) {
        return this.getEastOf(cell.x, cell.y);
    }

    public char getWestOf(Cell cell) {
        return this.getWestOf(cell.x, cell.y);
    }

    public void writeStringTo(int n, int n2, String string) {
        this.writeStringTo(new Cell(n, n2), string);
    }

    public void writeStringTo(Cell cell, String string) {
        if (this.isOutOfBounds(cell)) {
            return;
        }
        this.rows.get(cell.y).replace(cell.x, cell.x + string.length(), string);
    }

    public void set(Cell cell, char c) {
        this.set(cell.x, cell.y, c);
    }

    public void set(int n, int n2, char c) {
        if (n > this.getWidth() - 1 || n2 > this.getHeight() - 1) {
            return;
        }
        StringBuilder stringBuilder = this.rows.get(n2);
        stringBuilder.setCharAt(n, c);
    }

    public void setRow(int n, String string) {
        if (n > this.getHeight() || string.length() != this.getWidth()) {
            throw new IllegalArgumentException("setRow out of bounds or string wrong size");
        }
        this.rows.set(n, new StringBuilder(string));
    }

    public void setRow(int n, StringBuilder stringBuilder) {
        if (n > this.getHeight() || stringBuilder.length() != this.getWidth()) {
            throw new IllegalArgumentException("setRow out of bounds or string wrong size");
        }
        this.rows.set(n, stringBuilder);
    }

    public int getWidth() {
        if (this.rows.size() == 0) {
            return 0;
        }
        return this.rows.get(0).length();
    }

    public int getHeight() {
        return this.rows.size();
    }

    public void printDebug() {
        Iterator<StringBuilder> iterator = this.rows.iterator();
        int n = 0;
        System.out.println("    " + StringUtils.repeatString("0123456789", (int)Math.floor(this.getWidth() / 10) + 1));
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = new Integer(n).toString();
            if (n < 10) {
                string2 = " " + string2;
            }
            System.out.println(string2 + " (" + string + ")");
            ++n;
        }
    }

    public String getDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<StringBuilder> iterator = this.rows.iterator();
        int n = 0;
        stringBuilder.append("    " + StringUtils.repeatString("0123456789", (int)Math.floor(this.getWidth() / 10) + 1) + "\n");
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = new Integer(n).toString();
            if (n < 10) {
                string2 = " " + string2;
            }
            string = string.replaceAll("\n", "\\\\n");
            string = string.replaceAll("\r", "\\\\r");
            stringBuilder.append(string2 + " (" + string + ")\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getDebugString();
    }

    public boolean add(TextGrid textGrid) {
        if (this.getWidth() != textGrid.getWidth() || this.getHeight() != textGrid.getHeight()) {
            return false;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.get(j, i) != ' ') continue;
                this.set(j, i, textGrid.get(j, i));
            }
        }
        return true;
    }

    public void replaceTypeOnLine() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                char c = this.get(j, i);
                if (!Character.isLetterOrDigit(c)) continue;
                boolean bl = this.isOnHorizontalLine(j, i);
                boolean bl2 = this.isOnVerticalLine(j, i);
                if (bl && bl2) {
                    this.set(j, i, '+');
                    continue;
                }
                if (bl) {
                    this.set(j, i, '-');
                    continue;
                }
                if (!bl2) continue;
                this.set(j, i, '|');
            }
        }
    }

    public void replacePointMarkersOnLine() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                char c = this.get(j, i);
                Cell cell = new Cell(j, i);
                if (!StringUtils.isOneOf(c, pointMarkers) || !this.isStarOnLine(cell)) continue;
                boolean bl = false;
                if (StringUtils.isOneOf(this.get(cell.getEast()), horizontalLines)) {
                    bl = true;
                }
                if (StringUtils.isOneOf(this.get(cell.getWest()), horizontalLines)) {
                    bl = true;
                }
                boolean bl2 = false;
                if (StringUtils.isOneOf(this.get(cell.getNorth()), verticalLines)) {
                    bl2 = true;
                }
                if (StringUtils.isOneOf(this.get(cell.getSouth()), verticalLines)) {
                    bl2 = true;
                }
                if (bl && bl2) {
                    this.set(j, i, '+');
                    continue;
                }
                if (bl) {
                    this.set(j, i, '-');
                    continue;
                }
                if (!bl2) continue;
                this.set(j, i, '|');
            }
        }
    }

    public CellSet getPointMarkersOnLine() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                char c = this.get(j, i);
                if (!StringUtils.isOneOf(c, pointMarkers) || !this.isStarOnLine(new Cell(j, i))) continue;
                cellSet.add(new Cell(j, i));
            }
        }
        return cellSet;
    }

    public void replaceHumanColorCodes() {
        int n = this.getHeight();
        for (int i = 0; i < n; ++i) {
            String string = this.rows.get(i).toString();
            for (String string2 : humanColorCodes.keySet()) {
                String string3 = humanColorCodes.get(string2);
                if (string3 == null) continue;
                string2 = "c" + string2;
                string3 = "c" + string3;
                string = string.replaceAll(string2, string3);
                this.rows.set(i, new StringBuilder(string));
                string = this.rows.get(i).toString();
            }
        }
    }

    public void replaceAll(char c, char c2) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                char c3 = this.get(j, i);
                if (c3 != c) continue;
                this.set(j, i, c2);
            }
        }
    }

    public boolean hasBlankCells() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = new Cell(j, i);
                if (!this.isBlank(cell)) continue;
                return true;
            }
        }
        return false;
    }

    public CellSet getAllNonBlank() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = new Cell(j, i);
                if (this.isBlank(cell)) continue;
                cellSet.add(cell);
            }
        }
        return cellSet;
    }

    public CellSet getAllBoundaries() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = new Cell(j, i);
                if (!this.isBoundary(cell)) continue;
                cellSet.add(cell);
            }
        }
        return cellSet;
    }

    public CellSet getAllBlanksBetweenCharacters() {
        CellSet cellSet = new CellSet();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = new Cell(j, i);
                if (!this.isBlankBetweenCharacters(cell)) continue;
                cellSet.add(cell);
            }
        }
        return cellSet;
    }

    public ArrayList<CellStringPair> findStrings() {
        ArrayList<CellStringPair> arrayList = new ArrayList<CellStringPair>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.isBlank(j, i)) continue;
                Cell cell = new Cell(j, i);
                String string = String.valueOf(this.get(j, i));
                char c = this.get(++j, i);
                boolean bl = false;
                while (!bl) {
                    string = string + String.valueOf(c);
                    c = this.get(++j, i);
                    char c2 = this.get(j + 1, i);
                    if (c != ' ' && c != '\u0000' || c2 != ' ' && c2 != '\u0000') continue;
                    bl = true;
                }
                arrayList.add(new CellStringPair(cell, string));
            }
        }
        return arrayList;
    }

    public boolean hasEntryPoint(Cell cell, int n) {
        String string = "";
        char c = this.get(cell);
        if (n == 1) {
            return StringUtils.isOneOf(c, entryPoints1);
        }
        if (n == 2) {
            return StringUtils.isOneOf(c, entryPoints2);
        }
        if (n == 3) {
            return StringUtils.isOneOf(c, entryPoints3);
        }
        if (n == 4) {
            return StringUtils.isOneOf(c, entryPoints4);
        }
        if (n == 5) {
            return StringUtils.isOneOf(c, entryPoints5);
        }
        if (n == 6) {
            return StringUtils.isOneOf(c, entryPoints6);
        }
        if (n == 7) {
            return StringUtils.isOneOf(c, entryPoints7);
        }
        if (n == 8) {
            return StringUtils.isOneOf(c, entryPoints8);
        }
        return false;
    }

    public boolean isBlankBetweenCharacters(Cell cell) {
        return this.isBlank(cell) && !this.isBlank(cell.getEast()) && !this.isBlank(cell.getWest());
    }

    public void removeNonText() {
        this.removeArrowheads();
        this.removeColorCodes();
        this.removeBoundaries();
        this.removeMarkupTags();
    }

    public void removeArrowheads() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = new Cell(j, i);
                if (!this.isArrowhead(cell)) continue;
                this.set(cell, ' ');
            }
        }
    }

    public void removeColorCodes() {
        Iterator<CellColorPair> iterator = this.findColorCodes().iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next().cell;
            this.set(cell, ' ');
            cell = cell.getEast();
            this.set(cell, ' ');
            cell = cell.getEast();
            this.set(cell, ' ');
            cell = cell.getEast();
            this.set(cell, ' ');
        }
    }

    public void removeBoundaries() {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = new Cell(j, i);
                if (!this.isBoundary(cell)) continue;
                arrayList.add(cell);
            }
        }
        for (Cell cell : arrayList) {
            this.set(cell, ' ');
        }
    }

    public ArrayList<Cell> findArrowheads() {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = new Cell(j, i);
                if (!this.isArrowhead(cell)) continue;
                arrayList.add(cell);
            }
        }
        return arrayList;
    }

    public ArrayList<CellColorPair> findColorCodes() {
        Pattern pattern = Pattern.compile("c[A-F0-9]{3}");
        ArrayList<CellColorPair> arrayList = new ArrayList<CellColorPair>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - 3; ++j) {
                Cell cell = new Cell(j, i);
                String string = this.getStringAt(cell, 4);
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                char c = string.charAt(1);
                char c2 = string.charAt(2);
                char c3 = string.charAt(3);
                int n3 = Integer.valueOf(String.valueOf(c), 16) * 17;
                int n4 = Integer.valueOf(String.valueOf(c2), 16) * 17;
                int n5 = Integer.valueOf(String.valueOf(c3), 16) * 17;
                arrayList.add(new CellColorPair(cell, new Color(n3, n4, n5)));
            }
        }
        return arrayList;
    }

    public ArrayList<CellTagPair> findMarkupTags() {
        Pattern pattern = Pattern.compile("\\{(.+?)\\}");
        ArrayList<CellTagPair> arrayList = new ArrayList<CellTagPair>();
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n - 3; ++j) {
                String string;
                String string2;
                Matcher matcher;
                Cell cell = new Cell(j, i);
                char c = this.get(cell);
                if (c != '{' || !(matcher = pattern.matcher(string2 = this.rows.get(i).substring(j))).find() || !markupTags.contains(string = matcher.group(1))) continue;
                arrayList.add(new CellTagPair(new Cell(j, i), string));
            }
        }
        return arrayList;
    }

    public void removeMarkupTags() {
        for (CellTagPair cellTagPair : this.findMarkupTags()) {
            String string = cellTagPair.tag;
            if (string == null) continue;
            int n = 2 + string.length();
            this.writeStringTo(cellTagPair.cell, StringUtils.repeatString(" ", n));
        }
    }

    public boolean matchesAny(GridPatternGroup gridPatternGroup) {
        return gridPatternGroup.isAnyMatchedBy(this);
    }

    public boolean matchesAll(GridPatternGroup gridPatternGroup) {
        return gridPatternGroup.areAllMatchedBy(this);
    }

    public boolean matches(GridPattern gridPattern) {
        return gridPattern.isMatchedBy(this);
    }

    public boolean isOnHorizontalLine(Cell cell) {
        return this.isOnHorizontalLine(cell.x, cell.y);
    }

    private boolean isOnHorizontalLine(int n, int n2) {
        char c = this.get(n - 1, n2);
        char c2 = this.get(n + 1, n2);
        return TextGrid.isHorizontalLine(c) && TextGrid.isHorizontalLine(c2);
    }

    public boolean isOnVerticalLine(Cell cell) {
        return this.isOnVerticalLine(cell.x, cell.y);
    }

    private boolean isOnVerticalLine(int n, int n2) {
        char c = this.get(n, n2 - 1);
        char c2 = this.get(n, n2 + 1);
        return TextGrid.isVerticalLine(c) && TextGrid.isVerticalLine(c2);
    }

    public static boolean isBoundary(char c) {
        return StringUtils.isOneOf(c, boundaries);
    }

    public boolean isBoundary(int n, int n2) {
        return this.isBoundary(new Cell(n, n2));
    }

    public boolean isBoundary(Cell cell) {
        char c = this.get(cell.x, cell.y);
        if ('\u0000' == c) {
            return false;
        }
        if ('+' == c || '\\' == c || '/' == c) {
            System.out.print("");
            return this.isIntersection(cell) || this.isCorner(cell) || this.isStub(cell) || this.isCrossOnLine(cell);
        }
        return StringUtils.isOneOf(c, boundaries) && !this.isLoneDiagonal(cell);
    }

    public boolean isLine(Cell cell) {
        return this.isHorizontalLine(cell) || this.isVerticalLine(cell);
    }

    public static boolean isHorizontalLine(char c) {
        return StringUtils.isOneOf(c, horizontalLines);
    }

    public boolean isHorizontalLine(Cell cell) {
        return this.isHorizontalLine(cell.x, cell.y);
    }

    public boolean isHorizontalLine(int n, int n2) {
        char c = this.get(n, n2);
        if ('\u0000' == c) {
            return false;
        }
        return StringUtils.isOneOf(c, horizontalLines);
    }

    public static boolean isVerticalLine(char c) {
        return StringUtils.isOneOf(c, verticalLines);
    }

    public boolean isVerticalLine(Cell cell) {
        return this.isVerticalLine(cell.x, cell.y);
    }

    public boolean isVerticalLine(int n, int n2) {
        char c = this.get(n, n2);
        if ('\u0000' == c) {
            return false;
        }
        return StringUtils.isOneOf(c, verticalLines);
    }

    public boolean isLinesEnd(int n, int n2) {
        return this.isLinesEnd(new Cell(n, n2));
    }

    public boolean isLinesEnd(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.linesEndCriteria);
    }

    public boolean isVerticalLinesEnd(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.verticalLinesEndCriteria);
    }

    public boolean isHorizontalLinesEnd(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.horizontalLinesEndCriteria);
    }

    public boolean isPointCell(Cell cell) {
        return this.isCorner(cell) || this.isIntersection(cell) || this.isStub(cell) || this.isLinesEnd(cell);
    }

    public boolean containsAtLeastOneDashedLine(CellSet cellSet) {
        for (Cell cell : cellSet) {
            if (!StringUtils.isOneOf(this.get(cell), dashedLines)) continue;
            return true;
        }
        return false;
    }

    public boolean exactlyOneNeighbourIsBoundary(Cell cell) {
        int n = 0;
        if (this.isBoundary(cell.getNorth())) {
            ++n;
        }
        if (this.isBoundary(cell.getSouth())) {
            ++n;
        }
        if (this.isBoundary(cell.getEast())) {
            ++n;
        }
        if (this.isBoundary(cell.getWest())) {
            ++n;
        }
        return n == 1;
    }

    public boolean isStub(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.stubCriteria);
    }

    public boolean isCrossOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.crossOnLineCriteria);
    }

    public boolean isHorizontalCrossOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.horizontalCrossOnLineCriteria);
    }

    public boolean isVerticalCrossOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.verticalCrossOnLineCriteria);
    }

    public boolean isStarOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.starOnLineCriteria);
    }

    public boolean isLoneDiagonal(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.loneDiagonalCriteria);
    }

    public boolean isHorizontalStarOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.horizontalStarOnLineCriteria);
    }

    public boolean isVerticalStarOnLine(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.verticalStarOnLineCriteria);
    }

    public boolean isArrowhead(Cell cell) {
        return this.isNorthArrowhead(cell) || this.isSouthArrowhead(cell) || this.isWestArrowhead(cell) || this.isEastArrowhead(cell);
    }

    public boolean isNorthArrowhead(Cell cell) {
        return this.get(cell) == '^';
    }

    public boolean isEastArrowhead(Cell cell) {
        return this.get(cell) == '>';
    }

    public boolean isWestArrowhead(Cell cell) {
        return this.get(cell) == '<';
    }

    public boolean isSouthArrowhead(Cell cell) {
        return (this.get(cell) == 'v' || this.get(cell) == 'V') && this.isVerticalLine(cell.getNorth());
    }

    public boolean isBullet(int n, int n2) {
        return this.isBullet(new Cell(n, n2));
    }

    public boolean isBullet(Cell cell) {
        char c = this.get(cell);
        return (c == 'o' || c == '*') && this.isBlank(cell.getEast()) && this.isBlank(cell.getWest()) && Character.isLetterOrDigit(this.get(cell.getEast().getEast()));
    }

    public void replaceBullets() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Cell cell = new Cell(j, i);
                if (!this.isBullet(cell)) continue;
                this.set(cell, ' ');
                this.set(cell.getEast(), '\u2022');
            }
        }
    }

    public boolean isStringsStart(Cell cell) {
        return !this.isBlank(cell) && this.isBlank(cell.getWest());
    }

    public boolean isStringsEnd(Cell cell) {
        return !this.isBlank(cell) && this.isBlank(cell.getEast());
    }

    public int otherStringsStartInTheSameColumn(Cell cell) {
        if (!this.isStringsStart(cell)) {
            return 0;
        }
        int n = 0;
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            Cell cell2 = new Cell(cell.x, i);
            if (cell2.equals(cell) || !this.isStringsStart(cell2)) continue;
            ++n;
        }
        return n;
    }

    public int otherStringsEndInTheSameColumn(Cell cell) {
        if (!this.isStringsEnd(cell)) {
            return 0;
        }
        int n = 0;
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            Cell cell2 = new Cell(cell.x, i);
            if (cell2.equals(cell) || !this.isStringsEnd(cell2)) continue;
            ++n;
        }
        return n;
    }

    public boolean isColumnBlank(int n) {
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            if (this.isBlank(n, i)) continue;
            return false;
        }
        return true;
    }

    public CellSet followLine(int n, int n2) {
        return this.followLine(new Cell(n, n2));
    }

    public CellSet followIntersection(Cell cell) {
        return this.followIntersection(cell, null);
    }

    public CellSet followIntersection(Cell cell, Cell cell2) {
        if (!this.isIntersection(cell)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        Cell cell3 = cell.getNorth();
        Cell cell4 = cell.getSouth();
        Cell cell5 = cell.getEast();
        Cell cell6 = cell.getWest();
        if (this.hasEntryPoint(cell3, 6)) {
            cellSet.add(cell3);
        }
        if (this.hasEntryPoint(cell4, 2)) {
            cellSet.add(cell4);
        }
        if (this.hasEntryPoint(cell5, 8)) {
            cellSet.add(cell5);
        }
        if (this.hasEntryPoint(cell6, 4)) {
            cellSet.add(cell6);
        }
        if (cellSet.contains(cell2)) {
            cellSet.remove(cell2);
        }
        return cellSet;
    }

    public CellSet followLine(Cell cell) {
        if (this.isHorizontalLine(cell)) {
            CellSet cellSet = new CellSet();
            if (this.isBoundary(cell.getEast())) {
                cellSet.add(cell.getEast());
            }
            if (this.isBoundary(cell.getWest())) {
                cellSet.add(cell.getWest());
            }
            return cellSet;
        }
        if (this.isVerticalLine(cell)) {
            CellSet cellSet = new CellSet();
            if (this.isBoundary(cell.getNorth())) {
                cellSet.add(cell.getNorth());
            }
            if (this.isBoundary(cell.getSouth())) {
                cellSet.add(cell.getSouth());
            }
            return cellSet;
        }
        return null;
    }

    public CellSet followLine(Cell cell, Cell cell2) {
        CellSet cellSet = this.followLine(cell);
        if (cellSet.contains(cell2)) {
            cellSet.remove(cell2);
        }
        return cellSet;
    }

    public CellSet followCorner(Cell cell) {
        return this.followCorner(cell, null);
    }

    public CellSet followCorner(Cell cell, Cell cell2) {
        if (!this.isCorner(cell)) {
            return null;
        }
        if (this.isCorner1(cell)) {
            return this.followCorner1(cell, cell2);
        }
        if (this.isCorner2(cell)) {
            return this.followCorner2(cell, cell2);
        }
        if (this.isCorner3(cell)) {
            return this.followCorner3(cell, cell2);
        }
        if (this.isCorner4(cell)) {
            return this.followCorner4(cell, cell2);
        }
        return null;
    }

    public CellSet followCorner1(Cell cell) {
        return this.followCorner1(cell, null);
    }

    public CellSet followCorner1(Cell cell, Cell cell2) {
        if (!this.isCorner1(cell)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (!cell.getSouth().equals(cell2)) {
            cellSet.add(cell.getSouth());
        }
        if (!cell.getEast().equals(cell2)) {
            cellSet.add(cell.getEast());
        }
        return cellSet;
    }

    public CellSet followCorner2(Cell cell) {
        return this.followCorner2(cell, null);
    }

    public CellSet followCorner2(Cell cell, Cell cell2) {
        if (!this.isCorner2(cell)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (!cell.getSouth().equals(cell2)) {
            cellSet.add(cell.getSouth());
        }
        if (!cell.getWest().equals(cell2)) {
            cellSet.add(cell.getWest());
        }
        return cellSet;
    }

    public CellSet followCorner3(Cell cell) {
        return this.followCorner3(cell, null);
    }

    public CellSet followCorner3(Cell cell, Cell cell2) {
        if (!this.isCorner3(cell)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (!cell.getNorth().equals(cell2)) {
            cellSet.add(cell.getNorth());
        }
        if (!cell.getWest().equals(cell2)) {
            cellSet.add(cell.getWest());
        }
        return cellSet;
    }

    public CellSet followCorner4(Cell cell) {
        return this.followCorner4(cell, null);
    }

    public CellSet followCorner4(Cell cell, Cell cell2) {
        if (!this.isCorner4(cell)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (!cell.getNorth().equals(cell2)) {
            cellSet.add(cell.getNorth());
        }
        if (!cell.getEast().equals(cell2)) {
            cellSet.add(cell.getEast());
        }
        return cellSet;
    }

    public CellSet followStub(Cell cell) {
        return this.followStub(cell, null);
    }

    public CellSet followStub(Cell cell, Cell cell2) {
        if (!this.isStub(cell)) {
            return null;
        }
        CellSet cellSet = new CellSet();
        if (this.isBoundary(cell.getEast())) {
            cellSet.add(cell.getEast());
        } else if (this.isBoundary(cell.getWest())) {
            cellSet.add(cell.getWest());
        } else if (this.isBoundary(cell.getNorth())) {
            cellSet.add(cell.getNorth());
        } else if (this.isBoundary(cell.getSouth())) {
            cellSet.add(cell.getSouth());
        }
        if (cellSet.contains(cell2)) {
            cellSet.remove(cell2);
        }
        return cellSet;
    }

    public CellSet followCell(Cell cell) {
        return this.followCell(cell, null);
    }

    public CellSet followCell(Cell cell, Cell cell2) {
        if (this.isIntersection(cell)) {
            return this.followIntersection(cell, cell2);
        }
        if (this.isCorner(cell)) {
            return this.followCorner(cell, cell2);
        }
        if (this.isLine(cell)) {
            return this.followLine(cell, cell2);
        }
        if (this.isStub(cell)) {
            return this.followStub(cell, cell2);
        }
        if (this.isCrossOnLine(cell)) {
            return this.followCrossOnLine(cell, cell2);
        }
        System.err.println("Umbiguous input at position " + cell + ":");
        TextGrid textGrid = this.getTestingSubGrid(cell);
        textGrid.printDebug();
        throw new RuntimeException("Cannot follow cell " + cell + ": cannot determine cell type");
    }

    public String getCellTypeAsString(Cell cell) {
        if (this.isK(cell)) {
            return "K";
        }
        if (this.isT(cell)) {
            return "T";
        }
        if (this.isInverseK(cell)) {
            return "inverse K";
        }
        if (this.isInverseT(cell)) {
            return "inverse T";
        }
        if (this.isCorner1(cell)) {
            return "corner 1";
        }
        if (this.isCorner2(cell)) {
            return "corner 2";
        }
        if (this.isCorner3(cell)) {
            return "corner 3";
        }
        if (this.isCorner4(cell)) {
            return "corner 4";
        }
        if (this.isLine(cell)) {
            return "line";
        }
        if (this.isStub(cell)) {
            return "stub";
        }
        if (this.isCrossOnLine(cell)) {
            return "crossOnLine";
        }
        return "unrecognisable type";
    }

    public CellSet followCrossOnLine(Cell cell, Cell cell2) {
        CellSet cellSet = new CellSet();
        if (this.isHorizontalCrossOnLine(cell)) {
            cellSet.add(cell.getEast());
            cellSet.add(cell.getWest());
        } else if (this.isVerticalCrossOnLine(cell)) {
            cellSet.add(cell.getNorth());
            cellSet.add(cell.getSouth());
        }
        if (cellSet.contains(cell2)) {
            cellSet.remove(cell2);
        }
        return cellSet;
    }

    public boolean isOutOfBounds(Cell cell) {
        return cell.x > this.getWidth() - 1 || cell.y > this.getHeight() - 1 || cell.x < 0 || cell.y < 0;
    }

    public boolean isOutOfBounds(int n, int n2) {
        char c = this.get(n, n2);
        return '\u0000' == c;
    }

    public boolean isBlank(Cell cell) {
        char c = this.get(cell);
        if ('\u0000' == c) {
            return false;
        }
        return c == ' ';
    }

    public boolean isBlank(int n, int n2) {
        char c = this.get(n, n2);
        if ('\u0000' == c) {
            return true;
        }
        return c == ' ';
    }

    public boolean isCorner(Cell cell) {
        return this.isCorner(cell.x, cell.y);
    }

    public boolean isCorner(int n, int n2) {
        return this.isNormalCorner(n, n2) || this.isRoundCorner(n, n2);
    }

    public boolean matchesAny(Cell cell, GridPatternGroup gridPatternGroup) {
        TextGrid textGrid = this.getTestingSubGrid(cell);
        return textGrid.matchesAny(gridPatternGroup);
    }

    public boolean isCorner1(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.corner1Criteria);
    }

    public boolean isCorner2(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.corner2Criteria);
    }

    public boolean isCorner3(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.corner3Criteria);
    }

    public boolean isCorner4(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.corner4Criteria);
    }

    public boolean isCross(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.crossCriteria);
    }

    public boolean isK(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.KCriteria);
    }

    public boolean isInverseK(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.inverseKCriteria);
    }

    public boolean isT(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.TCriteria);
    }

    public boolean isInverseT(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.inverseTCriteria);
    }

    public boolean isNormalCorner(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.normalCornerCriteria);
    }

    public boolean isNormalCorner(int n, int n2) {
        return this.isNormalCorner(new Cell(n, n2));
    }

    public boolean isRoundCorner(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.roundCornerCriteria);
    }

    public boolean isRoundCorner(int n, int n2) {
        return this.isRoundCorner(new Cell(n, n2));
    }

    public boolean isIntersection(Cell cell) {
        return this.matchesAny(cell, GridPatternGroup.intersectionCriteria);
    }

    public boolean isIntersection(int n, int n2) {
        return this.isIntersection(new Cell(n, n2));
    }

    public void copyCellsTo(CellSet cellSet, TextGrid textGrid) {
        for (Cell cell : cellSet) {
            textGrid.set(cell, this.get(cell));
        }
    }

    public boolean equals(TextGrid textGrid) {
        if (textGrid.getHeight() != this.getHeight() || textGrid.getWidth() != this.getWidth()) {
            return false;
        }
        int n = textGrid.getHeight();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = this.getRow(i).toString();
            if (string2.equals(string = textGrid.getRow(i).toString())) continue;
            return false;
        }
        return true;
    }

    public void fillCellsWith(Iterable iterable, char c) {
        for (Cell cell : iterable) {
            this.set(cell.x, cell.y, c);
        }
    }

    public CellSet fillContinuousArea(int n, int n2, char c) {
        return this.fillContinuousArea(new Cell(n, n2), c);
    }

    public CellSet fillContinuousArea(Cell cell, char c) {
        if (this.isOutOfBounds(cell)) {
            throw new IllegalArgumentException("Attempted to fill area out of bounds: " + cell);
        }
        return this.seedFillOld(cell, c);
    }

    private CellSet seedFill(Cell cell, char c) {
        CellSet cellSet = new CellSet();
        char c2 = this.get(cell);
        if (c2 == c) {
            return cellSet;
        }
        if (this.isOutOfBounds(cell)) {
            return cellSet;
        }
        Stack<Cell> stack = new Stack<Cell>();
        stack.push(cell);
        while (!stack.isEmpty()) {
            Cell cell2 = (Cell)stack.pop();
            cellSet.add(cell2);
            Cell cell3 = cell2.getNorth();
            Cell cell4 = cell2.getSouth();
            Cell cell5 = cell2.getEast();
            Cell cell6 = cell2.getWest();
            if (this.get(cell3) == c2 && !cellSet.contains(cell3)) {
                stack.push(cell3);
            }
            if (this.get(cell4) == c2 && !cellSet.contains(cell4)) {
                stack.push(cell4);
            }
            if (this.get(cell5) == c2 && !cellSet.contains(cell5)) {
                stack.push(cell5);
            }
            if (this.get(cell6) != c2 || cellSet.contains(cell6)) continue;
            stack.push(cell6);
        }
        return cellSet;
    }

    private CellSet seedFillOld(Cell cell, char c) {
        CellSet cellSet = new CellSet();
        char c2 = this.get(cell);
        if (c2 == c) {
            return cellSet;
        }
        if (this.isOutOfBounds(cell)) {
            return cellSet;
        }
        Stack<Cell> stack = new Stack<Cell>();
        stack.push(cell);
        while (!stack.isEmpty()) {
            Cell cell2 = (Cell)stack.pop();
            this.set(cell2, c);
            cellSet.add(cell2);
            Cell cell3 = cell2.getNorth();
            Cell cell4 = cell2.getSouth();
            Cell cell5 = cell2.getEast();
            Cell cell6 = cell2.getWest();
            if (this.get(cell3) == c2) {
                stack.push(cell3);
            }
            if (this.get(cell4) == c2) {
                stack.push(cell4);
            }
            if (this.get(cell5) == c2) {
                stack.push(cell5);
            }
            if (this.get(cell6) != c2) continue;
            stack.push(cell6);
        }
        return cellSet;
    }

    public CellSet findBoundariesExpandingFrom(Cell cell) {
        CellSet cellSet = new CellSet();
        char c = this.get(cell);
        if (this.isOutOfBounds(cell)) {
            return cellSet;
        }
        char c2 = '\u0001';
        Stack<Cell> stack = new Stack<Cell>();
        stack.push(cell);
        while (!stack.isEmpty()) {
            Cell cell2 = (Cell)stack.pop();
            this.set(cell2, c2);
            Cell cell3 = cell2.getNorth();
            Cell cell4 = cell2.getSouth();
            Cell cell5 = cell2.getEast();
            Cell cell6 = cell2.getWest();
            if (this.get(cell3) == c) {
                stack.push(cell3);
            } else if (this.get(cell3) == '*') {
                cellSet.add(cell3);
            }
            if (this.get(cell4) == c) {
                stack.push(cell4);
            } else if (this.get(cell4) == '*') {
                cellSet.add(cell4);
            }
            if (this.get(cell5) == c) {
                stack.push(cell5);
            } else if (this.get(cell5) == '*') {
                cellSet.add(cell5);
            }
            if (this.get(cell6) == c) {
                stack.push(cell6);
                continue;
            }
            if (this.get(cell6) != '*') continue;
            cellSet.add(cell6);
        }
        return cellSet;
    }

    private CellSet seedFillLine(Cell cell, char c) {
        CellSet cellSet = new CellSet();
        Stack<LineSegment> stack = new Stack<LineSegment>();
        char c2 = this.get(cell);
        if (c2 == c) {
            return cellSet;
        }
        if (this.isOutOfBounds(cell)) {
            return cellSet;
        }
        stack.push(new LineSegment(cell.x, cell.x, cell.y, 1));
        stack.push(new LineSegment(cell.x, cell.x, cell.y + 1, -1));
        while (!stack.isEmpty()) {
            boolean bl;
            int n;
            LineSegment lineSegment = (LineSegment)stack.pop();
            for (n = lineSegment.x1; n >= 0 && this.get(n, lineSegment.y) == c2; --n) {
                this.set(n, lineSegment.y, c);
                cellSet.add(new Cell(n, lineSegment.y));
            }
            int n2 = cell.getEast().x;
            boolean bl2 = bl = n > lineSegment.x1;
            if (n2 < lineSegment.x1) {
                stack.push(new LineSegment(n, n2, lineSegment.y - 1, -lineSegment.dy));
            }
            n = lineSegment.x1 + 1;
            do {
                if (!bl) {
                    while (n < this.getWidth() && this.get(n, lineSegment.y) == c2) {
                        this.set(n, lineSegment.y, c);
                        cellSet.add(new Cell(n, lineSegment.y));
                        ++n;
                    }
                    stack.push(new LineSegment(n2, n - 1, lineSegment.y, lineSegment.dy));
                    if (n > lineSegment.x2 + 1) {
                        stack.push(new LineSegment(lineSegment.x2 + 1, n - 1, lineSegment.y, -lineSegment.dy));
                    }
                }
                bl = false;
                ++n;
                while (n <= lineSegment.x2 && this.get(n, lineSegment.y) != c2) {
                    ++n;
                }
                n2 = n;
            } while (n < lineSegment.x2);
        }
        return cellSet;
    }

    public boolean cellContainsDashedLineChar(Cell cell) {
        char c = this.get(cell);
        return StringUtils.isOneOf(c, dashedLines);
    }

    public boolean loadFrom(String string) throws FileNotFoundException, IOException {
        return this.loadFrom(string, null);
    }

    public boolean loadFrom(String string, ProcessingOptions processingOptions) throws IOException {
        String string2 = processingOptions == null ? null : processingOptions.getCharacterEncoding();
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        InputStream inputStream = "-".equals(string) ? System.in : new FileInputStream(string);
        String[] stringArray = FileUtils.readFile(inputStream, string, string2).split("(\r)?\n");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new StringBuilder(stringArray[i]));
        }
        return this.initialiseWithLines(arrayList, processingOptions);
    }

    public boolean initialiseWithText(String string, ProcessingOptions processingOptions) throws UnsupportedEncodingException {
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        String[] stringArray = string.split("(\r)?\n");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(new StringBuilder(stringArray[i]));
        }
        return this.initialiseWithLines(arrayList, processingOptions);
    }

    public boolean initialiseWithLines(ArrayList<StringBuilder> arrayList, ProcessingOptions processingOptions) throws UnsupportedEncodingException {
        Object object;
        Object object2;
        int n;
        boolean bl = false;
        for (n = arrayList.size() - 1; n >= 0 && !bl; --n) {
            StringBuilder stringBuilder = arrayList.get(n);
            if (StringUtils.isBlank(stringBuilder.toString())) continue;
            bl = true;
        }
        this.rows = new ArrayList<StringBuilder>(arrayList.subList(0, n + 2));
        if (processingOptions != null) {
            this.fixTabs(processingOptions.getTabSize());
        } else {
            this.fixTabs(8);
        }
        int n2 = 2;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        if (processingOptions != null) {
            string = processingOptions.getCharacterEncoding();
        }
        Iterator<StringBuilder> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().toString();
            if (string != null) {
                object = ((String)object2).getBytes();
                object2 = new String((byte[])object, string);
            }
            if (((String)object2).length() > n3) {
                n3 = ((String)object2).length();
            }
            this.rows.set(n4, new StringBuilder((String)object2));
            ++n4;
        }
        iterator = this.rows.iterator();
        object2 = new ArrayList();
        object = new StringBuilder(StringUtils.repeatString(" ", n3 + n2 * 2));
        ((ArrayList)object2).add(object);
        ((ArrayList)object2).add(object);
        while (iterator.hasNext()) {
            StringBuilder stringBuilder = iterator.next();
            if (stringBuilder.length() < n3) {
                String string2 = StringUtils.repeatString(" ", n2);
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(string2);
                stringBuilder2.append((CharSequence)stringBuilder);
                stringBuilder2.append(StringUtils.repeatString(" ", n3 - stringBuilder.length()));
                stringBuilder2.append(string2);
                ((ArrayList)object2).add(stringBuilder2);
                continue;
            }
            ((ArrayList)object2).add(new StringBuilder("  ").append((CharSequence)stringBuilder).append("  "));
        }
        ((ArrayList)object2).add(object);
        ((ArrayList)object2).add(object);
        this.rows = object2;
        this.replaceBullets();
        this.replaceHumanColorCodes();
        return true;
    }

    private void fixTabs(int n) {
        int n2 = 0;
        Iterator<StringBuilder> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\t') {
                    int n3 = n - stringBuilder.length() % n;
                    String string2 = StringUtils.repeatString(" ", n3);
                    stringBuilder.append(string2);
                    continue;
                }
                String string3 = Character.toString(cArray[i]);
                stringBuilder.append(string3);
            }
            this.rows.set(n2, stringBuilder);
            ++n2;
        }
    }

    protected ArrayList<StringBuilder> getRows() {
        return this.rows;
    }

    static {
        humanColorCodes.put("GRE", "9D9");
        humanColorCodes.put("BLU", "55B");
        humanColorCodes.put("PNK", "FAA");
        humanColorCodes.put("RED", "E32");
        humanColorCodes.put("YEL", "FF3");
        humanColorCodes.put("BLK", "000");
        markupTags = new HashSet();
        markupTags.add("d");
        markupTags.add("s");
        markupTags.add("io");
        markupTags.add("c");
        markupTags.add("mo");
        markupTags.add("tr");
        markupTags.add("o");
    }

    private class LineSegment {
        int x1;
        int x2;
        int y;
        int dy;

        public LineSegment(int n, int n2, int n3, int n4) {
            this.x1 = n;
            this.x2 = n2;
            this.y = n3;
            this.dy = n4;
        }
    }

    public class Cell {
        public int x;
        public int y;

        public Cell(Cell cell) {
            this(cell.x, cell.y);
        }

        public Cell(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public Cell getNorth() {
            return new Cell(this.x, this.y - 1);
        }

        public Cell getSouth() {
            return new Cell(this.x, this.y + 1);
        }

        public Cell getEast() {
            return new Cell(this.x + 1, this.y);
        }

        public Cell getWest() {
            return new Cell(this.x - 1, this.y);
        }

        public Cell getNW() {
            return new Cell(this.x - 1, this.y - 1);
        }

        public Cell getNE() {
            return new Cell(this.x + 1, this.y - 1);
        }

        public Cell getSW() {
            return new Cell(this.x - 1, this.y + 1);
        }

        public Cell getSE() {
            return new Cell(this.x + 1, this.y + 1);
        }

        public CellSet getNeighbours4() {
            CellSet cellSet = new CellSet();
            cellSet.add(this.getNorth());
            cellSet.add(this.getSouth());
            cellSet.add(this.getWest());
            cellSet.add(this.getEast());
            return cellSet;
        }

        public CellSet getNeighbours8() {
            CellSet cellSet = new CellSet();
            cellSet.add(this.getNorth());
            cellSet.add(this.getSouth());
            cellSet.add(this.getWest());
            cellSet.add(this.getEast());
            cellSet.add(this.getNW());
            cellSet.add(this.getNE());
            cellSet.add(this.getSW());
            cellSet.add(this.getSE());
            return cellSet;
        }

        public boolean isNorthOf(Cell cell) {
            return this.y < cell.y;
        }

        public boolean isSouthOf(Cell cell) {
            return this.y > cell.y;
        }

        public boolean isWestOf(Cell cell) {
            return this.x < cell.x;
        }

        public boolean isEastOf(Cell cell) {
            return this.x > cell.x;
        }

        public boolean equals(Object object) {
            Cell cell = (Cell)object;
            if (cell == null) {
                return false;
            }
            return this.x == cell.x && this.y == cell.y;
        }

        public int hashCode() {
            return this.x << 16 | this.y;
        }

        public boolean isNextTo(int n, int n2) {
            if (Math.abs(n - this.x) == 1 && Math.abs(n2 - this.y) == 1) {
                return false;
            }
            if (Math.abs(n - this.x) == 1 && n2 == this.y) {
                return true;
            }
            return Math.abs(n2 - this.y) == 1 && n == this.x;
        }

        public boolean isNextTo(Cell cell) {
            if (cell == null) {
                throw new IllegalArgumentException("cell cannot be null");
            }
            return this.isNextTo(cell.x, cell.y);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }

        public void scale(int n) {
            this.x *= n;
            this.y *= n;
        }
    }

    public class CellTagPair {
        public Cell cell;
        public String tag;

        public CellTagPair(Cell cell, String string) {
            this.cell = cell;
            this.tag = string;
        }
    }

    public class CellStringPair {
        public Cell cell;
        public String string;

        public CellStringPair(Cell cell, String string) {
            this.cell = cell;
            this.string = string;
        }
    }

    public class CellColorPair {
        public Color color;
        public Cell cell;

        public CellColorPair(Cell cell, Color color) {
            this.cell = cell;
            this.color = color;
        }
    }
}

