/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestPutSearchTemplateAction
extends BaseRestHandler {
    public RestPutSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_search/template/{id}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_search/template/{id}", (RestHandler)this);
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        BytesReference content = request.requiredContent();
        PutStoredScriptRequest put = new PutStoredScriptRequest(id, "mustache", content, request.getXContentType());
        return channel -> client.admin().cluster().putStoredScript(put, (ActionListener)new AcknowledgedRestListener(channel));
    }
}

