/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

abstract class AbstractStringProcessor
extends AbstractProcessor {
    private final String field;
    private final boolean ignoreMissing;

    AbstractStringProcessor(String tag, String field, boolean ignoreMissing) {
        super(tag);
        this.field = field;
        this.ignoreMissing = ignoreMissing;
    }

    public String getField() {
        return this.field;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public final void execute(IngestDocument document) {
        String val = (String)document.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (val == null && this.ignoreMissing) {
            return;
        }
        if (val == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        document.setFieldValue(this.field, (Object)this.process(val));
    }

    protected abstract String process(String var1);

    static abstract class Factory
    implements Processor.Factory {
        final String processorType;

        protected Factory(String processorType) {
            this.processorType = processorType;
        }

        public AbstractStringProcessor create(Map<String, Processor.Factory> registry, String tag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)this.processorType, (String)tag, config, (String)"field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)this.processorType, (String)tag, config, (String)"ignore_missing", (boolean)false);
            return this.newProcessor(tag, field, ignoreMissing);
        }

        protected abstract AbstractStringProcessor newProcessor(String var1, String var2, boolean var3);
    }
}

