/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public abstract class CombineFunction
extends Enum<CombineFunction>
implements Writeable {
    public static final /* enum */ CombineFunction MULTIPLY = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 1.toFloat(queryScore * Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation boostExpl = Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0]);
            Explanation minExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, boostExpl});
            return Explanation.match((float)(queryExpl.getValue() * minExpl.getValue()), (String)"function score, product of:", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    };
    public static final /* enum */ CombineFunction REPLACE = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 2.toFloat(Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation boostExpl = Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0]);
            return Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, boostExpl});
        }
    };
    public static final /* enum */ CombineFunction SUM = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 3.toFloat(queryScore + Math.min(funcScore, maxBoost));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation minExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((float)(Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue()), (String)"sum of", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    };
    public static final /* enum */ CombineFunction AVG = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 4.toFloat((Math.min(funcScore, maxBoost) + queryScore) / 2.0);
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation minExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((float)4.toFloat((double)(Math.min(funcExpl.getValue(), maxBoost) + queryExpl.getValue()) / 2.0), (String)"avg of", (Explanation[])new Explanation[]{queryExpl, minExpl});
        }
    };
    public static final /* enum */ CombineFunction MIN = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 5.toFloat(Math.min(queryScore, Math.min(funcScore, maxBoost)));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation innerMinExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((float)Math.min(Math.min(funcExpl.getValue(), maxBoost), queryExpl.getValue()), (String)"min of", (Explanation[])new Explanation[]{queryExpl, innerMinExpl});
        }
    };
    public static final /* enum */ CombineFunction MAX = new CombineFunction(){

        @Override
        public float combine(double queryScore, double funcScore, double maxBoost) {
            return 6.toFloat(Math.max(queryScore, Math.min(funcScore, maxBoost)));
        }

        @Override
        public Explanation explain(Explanation queryExpl, Explanation funcExpl, float maxBoost) {
            Explanation innerMinExpl = Explanation.match((float)Math.min(funcExpl.getValue(), maxBoost), (String)"min of:", (Explanation[])new Explanation[]{funcExpl, Explanation.match((float)maxBoost, (String)"maxBoost", (Explanation[])new Explanation[0])});
            return Explanation.match((float)Math.max(Math.min(funcExpl.getValue(), maxBoost), queryExpl.getValue()), (String)"max of:", (Explanation[])new Explanation[]{queryExpl, innerMinExpl});
        }
    };
    private static final /* synthetic */ CombineFunction[] $VALUES;

    public static CombineFunction[] values() {
        return (CombineFunction[])$VALUES.clone();
    }

    public static CombineFunction valueOf(String name) {
        return Enum.valueOf(CombineFunction.class, name);
    }

    public abstract float combine(double var1, double var3, double var5);

    public static float toFloat(double input) {
        assert (CombineFunction.deviation(input) <= 0.001) : "input " + input + " out of float scope for function score deviation: " + CombineFunction.deviation(input);
        return (float)input;
    }

    private static double deviation(double input) {
        float floatVersion = (float)input;
        return Double.compare(floatVersion, input) == 0 || input == 0.0 ? 0.0 : 1.0 - (double)floatVersion / input;
    }

    public abstract Explanation explain(Explanation var1, Explanation var2, float var3);

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static CombineFunction readFromStream(StreamInput in) throws IOException {
        return in.readEnum(CombineFunction.class);
    }

    public static CombineFunction fromString(String combineFunction) {
        return CombineFunction.valueOf(combineFunction.toUpperCase(Locale.ROOT));
    }

    static {
        $VALUES = new CombineFunction[]{MULTIPLY, REPLACE, SUM, AVG, MIN, MAX};
    }
}

