/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestActions {
    public static final ParseField _SHARDS_FIELD = new ParseField("_shards", new String[0]);
    public static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    public static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    public static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    public static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);

    public static long parseVersion(RestRequest request) {
        if (request.hasParam("version")) {
            return request.paramAsLong("version", -3L);
        }
        String ifMatch = request.header("If-Match");
        if (ifMatch != null) {
            return Long.parseLong(ifMatch);
        }
        return -3L;
    }

    public static long parseVersion(RestRequest request, long defaultVersion) {
        long version = RestActions.parseVersion(request);
        return version == -3L ? defaultVersion : version;
    }

    public static void buildBroadcastShardsHeader(XContentBuilder builder, ToXContent.Params params, BroadcastResponse response) throws IOException {
        RestActions.buildBroadcastShardsHeader(builder, params, response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), response.getShardFailures());
    }

    public static void buildBroadcastShardsHeader(XContentBuilder builder, ToXContent.Params params, int total, int successful, int failed, ShardOperationFailedException[] shardFailures) throws IOException {
        builder.startObject(_SHARDS_FIELD.getPreferredName());
        builder.field(TOTAL_FIELD.getPreferredName(), total);
        builder.field(SUCCESSFUL_FIELD.getPreferredName(), successful);
        builder.field(FAILED_FIELD.getPreferredName(), failed);
        if (shardFailures != null && shardFailures.length > 0) {
            builder.startArray(FAILURES_FIELD.getPreferredName());
            boolean group = params.paramAsBoolean("group_shard_failures", true);
            for (ShardOperationFailedException shardFailure : group ? ExceptionsHelper.groupBy(shardFailures) : shardFailures) {
                builder.startObject();
                shardFailure.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static <NodeResponse extends BaseNodeResponse> void buildNodesHeader(XContentBuilder builder, ToXContent.Params params, BaseNodesResponse<NodeResponse> response) throws IOException {
        int successful = response.getNodes().size();
        int failed = response.failures().size();
        RestActions.buildNodesHeader(builder, params, successful + failed, successful, failed, response.failures());
    }

    public static void buildNodesHeader(XContentBuilder builder, ToXContent.Params params, int total, int successful, int failed, List<FailedNodeException> failures) throws IOException {
        builder.startObject("_nodes");
        builder.field("total", total);
        builder.field("successful", successful);
        builder.field("failed", failed);
        if (!failures.isEmpty()) {
            builder.startArray("failures");
            for (FailedNodeException failure : failures) {
                builder.startObject();
                failure.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static <NodesResponse extends BaseNodesResponse> BytesRestResponse nodesResponse(XContentBuilder builder, ToXContent.Params params, NodesResponse response) throws IOException {
        builder.startObject();
        RestActions.buildNodesHeader(builder, params, response);
        builder.field("cluster_name", response.getClusterName().value());
        ((ToXContent)((Object)response)).toXContent(builder, params);
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    public static QueryBuilder urlParamsToQueryBuilder(RestRequest request) {
        String queryString = request.param("q");
        if (queryString == null) {
            return null;
        }
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery(queryString);
        queryBuilder.defaultField(request.param("df"));
        queryBuilder.analyzer(request.param("analyzer"));
        queryBuilder.analyzeWildcard(request.paramAsBoolean("analyze_wildcard", false));
        queryBuilder.lenient(request.paramAsBoolean("lenient", null));
        String defaultOperator = request.param("default_operator");
        if (defaultOperator != null) {
            queryBuilder.defaultOperator(Operator.fromString(defaultOperator));
        }
        return queryBuilder;
    }

    public static QueryBuilder getQueryContent(XContentParser requestParser) {
        QueryParseContext context = new QueryParseContext(requestParser);
        return context.parseTopLevelQueryBuilder();
    }

    public static class NodesResponseRestListener<NodesResponse extends BaseNodesResponse>
    extends RestBuilderListener<NodesResponse> {
        public NodesResponseRestListener(RestChannel channel) {
            super(channel);
        }

        @Override
        public RestResponse buildResponse(NodesResponse response, XContentBuilder builder) throws Exception {
            return RestActions.nodesResponse(builder, this.channel.request(), response);
        }
    }
}

