/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.ic;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangPort;
import com.ericsson.otp.erlang.OtpErlangRef;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.ic.Pid;
import com.ericsson.otp.ic.Port;
import com.ericsson.otp.ic.Ref;
import com.ericsson.otp.ic.Term;

public class TermHelper {
    private TermHelper() {
    }

    public static void marshal(OtpOutputStream otpOutputStream, Term term) throws Exception {
        term.write_value(otpOutputStream);
    }

    public static Term unmarshal(OtpInputStream otpInputStream) throws Exception {
        Term term = new Term();
        int n = otpInputStream.peek();
        if (n == 131) {
            otpInputStream.read1();
            n = otpInputStream.peek();
        }
        term.tag = n;
        otpInputStream.mark(0);
        OtpErlangObject otpErlangObject = otpInputStream.read_any();
        term.insert_Object(otpErlangObject);
        switch (n) {
            case 97: 
            case 98: 
            case 110: {
                otpInputStream.reset();
                term.longV = otpInputStream.read_long();
                break;
            }
            case 100: 
            case 118: 
            case 119: {
                otpInputStream.reset();
                term.atomV = otpInputStream.read_atom();
                break;
            }
            case 99: {
                otpInputStream.reset();
                term.doubleV = otpInputStream.read_double();
                break;
            }
            case 101: 
            case 114: {
                otpInputStream.reset();
                OtpErlangRef otpErlangRef = otpInputStream.read_ref();
                if (otpErlangRef.isNewRef()) {
                    term.RefV = new Ref(otpErlangRef.node(), otpErlangRef.ids(), otpErlangRef.creation());
                    break;
                }
                term.RefV = new Ref(otpErlangRef.node(), otpErlangRef.id(), otpErlangRef.creation());
                break;
            }
            case 102: {
                otpInputStream.reset();
                OtpErlangPort otpErlangPort = otpInputStream.read_port();
                term.PortV = new Port(otpErlangPort.node(), otpErlangPort.id(), otpErlangPort.creation());
                break;
            }
            case 103: {
                otpInputStream.reset();
                OtpErlangPid otpErlangPid = otpInputStream.read_pid();
                term.PidV = new Pid(otpErlangPid.node(), otpErlangPid.id(), otpErlangPid.serial(), otpErlangPid.creation());
                break;
            }
            case 107: {
                otpInputStream.reset();
                term.stringV = otpInputStream.read_string();
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: {
                OtpOutputStream otpOutputStream = new OtpOutputStream();
                otpErlangObject.encode(otpOutputStream);
                term.insert_Streamable(otpOutputStream);
                break;
            }
            default: {
                throw new OtpErlangDecodeException("Uknown data type: " + n);
            }
        }
        return term;
    }
}

