/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.image;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.ImageIcon;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.image.ImageFile;
import org.fibs.geotag.image.ImageFileFactory;
import org.fibs.geotag.image.ImageRotator;

public final class ThumbnailGenerator {
    private ThumbnailGenerator() {
    }

    public static BufferedImage createThumbnailImage(BufferedImage originalImage, int longestSide) {
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        double scaleFactor = 1.0;
        scaleFactor = width > height ? (double)longestSide / (double)width : (double)longestSide / (double)height;
        AffineTransform transform = new AffineTransform();
        transform.scale(scaleFactor, scaleFactor);
        int thumbnailWidth = (int)((double)width * scaleFactor);
        int thumbnailHeight = (int)((double)height * scaleFactor);
        BufferedImage thumbImage = new BufferedImage(thumbnailWidth, thumbnailHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.drawImage(originalImage, transform, null);
        return thumbImage;
    }

    public static boolean loadThumbnail(ImageInfo imageInfo) {
        try {
            BufferedImage originalImage;
            imageInfo.setThumbNailStatus(ImageInfo.THUMBNAIL_STATUS.LOADING);
            File file = new File(imageInfo.getPath());
            ImageFile imageFile = ImageFileFactory.createImageFile(file);
            if (imageFile != null && (originalImage = imageFile.read()) != null) {
                BufferedImage rotatedImage = new ImageRotator(originalImage, imageInfo).rotate();
                imageInfo.setWidth(rotatedImage.getWidth());
                imageInfo.setHeight(rotatedImage.getHeight());
                BufferedImage thumbImage = ThumbnailGenerator.createThumbnailImage(rotatedImage, Settings.get(Settings.SETTING.THUMBNAIL_SIZE, 150));
                ImageIcon imageIcon = new ImageIcon(thumbImage);
                imageInfo.setThumbnail(imageIcon);
                imageInfo.setThumbNailStatus(ImageInfo.THUMBNAIL_STATUS.AVAILABLE);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        imageInfo.setThumbNailStatus(ImageInfo.THUMBNAIL_STATUS.UNKNOWN);
        return false;
    }
}

