/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TestSelectionMatcher {
    private final List<Pattern> includePatterns;

    public TestSelectionMatcher(Collection<String> includedTests) {
        this.includePatterns = new ArrayList<Pattern>(includedTests.size());
        for (String includedTest : includedTests) {
            this.includePatterns.add(this.preparePattern(includedTest));
        }
    }

    private Pattern preparePattern(String input) {
        String[] split;
        StringBuilder pattern = new StringBuilder();
        for (String s : split = StringUtils.splitPreserveAllTokens((String)input, (char)'*')) {
            if (s.equals("")) {
                pattern.append(".*");
                continue;
            }
            if (pattern.length() > 0) {
                pattern.append(".*");
            }
            pattern.append(Pattern.quote(s));
        }
        return Pattern.compile(pattern.toString());
    }

    public boolean matchesTest(String className, String methodName) {
        String fullName = className + "." + methodName;
        for (Pattern pattern : this.includePatterns) {
            if (methodName != null && pattern.matcher(fullName).matches()) {
                return true;
            }
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }
}

