/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.DelegatingClassBuilderFactory;
import org.jetbrains.kotlin.codegen.optimization.OptimizationClassBuilder;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;

public class OptimizationClassBuilderFactory
extends DelegatingClassBuilderFactory {
    private final boolean disableOptimization;

    public OptimizationClassBuilderFactory(ClassBuilderFactory delegate2, boolean disableOptimization) {
        super(delegate2);
        this.disableOptimization = disableOptimization;
    }

    @Override
    @NotNull
    public OptimizationClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilderFactory", "newClassBuilder"));
        }
        OptimizationClassBuilder optimizationClassBuilder = new OptimizationClassBuilder(this.getDelegate().newClassBuilder(origin), this.disableOptimization);
        if (optimizationClassBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/OptimizationClassBuilderFactory", "newClassBuilder"));
        }
        return optimizationClassBuilder;
    }
}

