/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BeanBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;

public class XmlSerializerUtil {
    private XmlSerializerUtil() {
    }

    public static <T> void copyBean(@NotNull T from, @NotNull T to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerUtil", "copyBean"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerUtil", "copyBean"));
        }
        assert (from.getClass().isAssignableFrom(to.getClass())) : "Beans of different classes specified: Cannot assign " + from.getClass() + " to " + to.getClass();
        for (MutableAccessor accessor : BeanBinding.getAccessors(from.getClass())) {
            accessor.set(to, accessor.read(from));
        }
    }

    public static <T> T createCopy(@NotNull T from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerUtil", "createCopy"));
        }
        try {
            Object to = ReflectionUtil.newInstance(from.getClass());
            XmlSerializerUtil.copyBean(from, to);
            return (T)to;
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

