/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.base.Predicate;
import org.jetbrains.kotlin.com.google.common.base.Predicates;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.RangeToIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class PrimitiveBinaryOperationFIF
extends Enum<PrimitiveBinaryOperationFIF>
implements FunctionIntrinsicFactory {
    public static final /* enum */ PrimitiveBinaryOperationFIF INSTANCE = new PrimitiveBinaryOperationFIF();
    private static final BinaryOperationIntrinsicBase INT_MULTIPLICATION_INTRINSIC;
    @NotNull
    private static final BinaryOperationIntrinsicBase BUILTINS_COMPARE_TO_INTRINSIC;
    @NotNull
    private static final BinaryOperationIntrinsicBase PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC;
    @NotNull
    private static final NamePredicate BINARY_OPERATIONS;
    private static final DescriptorPredicate INT_BINARY_OPERATIONS;
    private static final DescriptorPredicate SIMPLE_INT_MULTIPLICATION;
    private static final DescriptorPredicate INT_DIVISION;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_BINARY_OPERATIONS;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS;
    private static final Predicate<FunctionDescriptor> INT_WITH_BIT_OPERATIONS;
    private static final DescriptorPredicate BOOLEAN_OPERATIONS;
    private static final DescriptorPredicate STRING_PLUS;
    private static final DescriptorPredicate INT_MULTIPLICATION;
    private static final DescriptorPredicate CHAR_RANGE_TO;
    private static final DescriptorPredicate NUMBER_RANGE_TO;
    private static final ImmutableMap<String, JsBinaryOperator> BINARY_BITWISE_OPERATIONS;
    private static final Predicate<FunctionDescriptor> PREDICATE;
    private static final /* synthetic */ PrimitiveBinaryOperationFIF[] $VALUES;

    public static PrimitiveBinaryOperationFIF[] values() {
        return (PrimitiveBinaryOperationFIF[])$VALUES.clone();
    }

    public static PrimitiveBinaryOperationFIF valueOf(String name2) {
        return Enum.valueOf(PrimitiveBinaryOperationFIF.class, name2);
    }

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        JsBinaryOperator op;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getIntrinsic"));
        }
        if (CHAR_RANGE_TO.apply(descriptor2)) {
            return new RangeToIntrinsic(descriptor2);
        }
        if (PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS.apply(descriptor2)) {
            return PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC;
        }
        if (KotlinBuiltIns.isBuiltIn(descriptor2) && descriptor2.getName().equals(OperatorNameConventions.COMPARE_TO)) {
            return BUILTINS_COMPARE_TO_INTRINSIC;
        }
        if (!PREDICATE.apply(descriptor2)) {
            return null;
        }
        if (INT_MULTIPLICATION.apply(descriptor2)) {
            return INT_MULTIPLICATION_INTRINSIC;
        }
        if (NUMBER_RANGE_TO.apply(descriptor2)) {
            return new RangeToIntrinsic(descriptor2);
        }
        if (INT_WITH_BIT_OPERATIONS.apply(descriptor2) && (op = BINARY_BITWISE_OPERATIONS.get(descriptor2.getName().asString())) != null) {
            return new OptimizedIntBinaryOperationInstrinsic(op);
        }
        JsBinaryOperator operator = PrimitiveBinaryOperationFIF.getOperator(descriptor2);
        if (INT_BINARY_OPERATIONS.apply(descriptor2)) {
            return new AdditiveIntBinaryOperationInstrinsic(operator);
        }
        if (SIMPLE_INT_MULTIPLICATION.apply(descriptor2) || INT_DIVISION.apply(descriptor2)) {
            return new IntBinaryOperationFunctionIntrinsic(operator);
        }
        PrimitiveBinaryOperationFunctionIntrinsic result2 = new PrimitiveBinaryOperationFunctionIntrinsic(operator);
        if (PatternBuilder.pattern("Char.plus|minus(Int)").apply(descriptor2)) {
            return new CharAndIntBinaryOperationFunctionIntrinsic(result2);
        }
        if (PatternBuilder.pattern("Char.minus(Char)").apply(descriptor2)) {
            return new CharAndCharBinaryOperationFunctionIntrinsic(result2);
        }
        if (PatternBuilder.pattern("String.plus(Any)").apply(descriptor2)) {
            return new StringAndCharBinaryOperationFunctionIntrinsic(result2);
        }
        return result2;
    }

    @NotNull
    private static JsBinaryOperator getOperator(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
        }
        Name descriptorName = descriptor2.getName().equals(OperatorNameConventions.MOD) ? OperatorNameConventions.REM : descriptor2.getName();
        KtToken token = (KtToken)OperatorConventions.BINARY_OPERATION_NAMES.inverse().get(descriptorName);
        if (token == null) {
            token = (KtToken)OperatorConventions.BOOLEAN_OPERATIONS.inverse().get(descriptorName);
        }
        if (token == null) {
            assert (descriptorName.asString().equals("xor"));
            JsBinaryOperator jsBinaryOperator = JsBinaryOperator.BIT_XOR;
            if (jsBinaryOperator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
            }
            return jsBinaryOperator;
        }
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(token);
        if (jsBinaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
        }
        return jsBinaryOperator;
    }

    static {
        $VALUES = new PrimitiveBinaryOperationFIF[]{INSTANCE};
        INT_MULTIPLICATION_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
                if (left == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                }
                if (right == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                }
                if (this.isSafeConstant(left) || this.isSafeConstant(right)) {
                    JsExpression jsExpression = JsAstUtils.toInt32(JsAstUtils.mul(left, right));
                    if (jsExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                    }
                    return jsExpression;
                }
                JsInvocation jsInvocation = new JsInvocation((JsExpression)Namer.imul(), left, right);
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                }
                return jsInvocation;
            }

            private boolean isSafeConstant(@NotNull JsExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "isSafeConstant"));
                }
                if (!(expression instanceof JsNumberLiteral.JsIntLiteral)) {
                    return false;
                }
                int value = ((JsNumberLiteral.JsIntLiteral)expression).value;
                return Math.abs(value) < 0x100000;
            }
        };
        BUILTINS_COMPARE_TO_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
                if (left == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "doApply"));
                }
                if (right == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "doApply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "doApply"));
                }
                JsExpression jsExpression = JsAstUtils.compareTo(left, right);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "doApply"));
                }
                return jsExpression;
            }
        };
        PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC = new BinaryOperationIntrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
                if (left == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3", "doApply"));
                }
                if (right == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3", "doApply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3", "doApply"));
                }
                JsExpression jsExpression = JsAstUtils.primitiveCompareTo(left, right);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3", "doApply"));
                }
                return jsExpression;
            }
        };
        BINARY_OPERATIONS = new NamePredicate(OperatorNameConventions.BINARY_OPERATION_NAMES);
        INT_BINARY_OPERATIONS = PatternBuilder.pattern("Int.plus|minus(Int)");
        SIMPLE_INT_MULTIPLICATION = PatternBuilder.pattern("Byte|Short.times(Byte|Short)");
        INT_DIVISION = PatternBuilder.pattern("Byte|Short|Int.div(Byte|Short|Int)");
        PRIMITIVE_NUMBERS_BINARY_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, BINARY_OPERATIONS);
        PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, "compareTo");
        INT_WITH_BIT_OPERATIONS = Predicates.or(PatternBuilder.pattern("Int.or|and|xor|shl|shr|ushr"), PatternBuilder.pattern("Short|Byte.or|and|xor"));
        BOOLEAN_OPERATIONS = PatternBuilder.pattern("Boolean.or|and|xor");
        STRING_PLUS = PatternBuilder.pattern("String.plus");
        INT_MULTIPLICATION = PatternBuilder.pattern("Int.times(Int)");
        CHAR_RANGE_TO = PatternBuilder.pattern("Char.rangeTo(Char)");
        NUMBER_RANGE_TO = PatternBuilder.pattern("Byte|Short|Int.rangeTo(Byte|Short|Int)");
        BINARY_BITWISE_OPERATIONS = ImmutableMap.builder().put("or", JsBinaryOperator.BIT_OR).put("and", JsBinaryOperator.BIT_AND).put("xor", JsBinaryOperator.BIT_XOR).put("shl", JsBinaryOperator.SHL).put("shr", JsBinaryOperator.SHR).put("ushr", JsBinaryOperator.SHRU).build();
        PREDICATE = Predicates.or(PRIMITIVE_NUMBERS_BINARY_OPERATIONS, BOOLEAN_OPERATIONS, STRING_PLUS, INT_WITH_BIT_OPERATIONS, PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS);
    }

    private static class StringAndCharBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private StringAndCharBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            if (functionIntrinsic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionIntrinsic", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$StringAndCharBinaryOperationFunctionIntrinsic", "<init>"));
            }
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$StringAndCharBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$StringAndCharBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$StringAndCharBinaryOperationFunctionIntrinsic", "doApply"));
            }
            JsExpression jsExpression = this.functionIntrinsic.doApply(left, TopLevelFIF.TO_STRING.apply(right, Collections.emptyList(), context), context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$StringAndCharBinaryOperationFunctionIntrinsic", "doApply"));
            }
            return jsExpression;
        }
    }

    private static class CharAndCharBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private CharAndCharBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            if (functionIntrinsic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionIntrinsic", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndCharBinaryOperationFunctionIntrinsic", "<init>"));
            }
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndCharBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndCharBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndCharBinaryOperationFunctionIntrinsic", "doApply"));
            }
            JsExpression jsExpression = this.functionIntrinsic.doApply(left, right, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndCharBinaryOperationFunctionIntrinsic", "doApply"));
            }
            return jsExpression;
        }
    }

    private static class CharAndIntBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final BinaryOperationIntrinsicBase functionIntrinsic;

        private CharAndIntBinaryOperationFunctionIntrinsic(@NotNull BinaryOperationIntrinsicBase functionIntrinsic) {
            if (functionIntrinsic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionIntrinsic", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndIntBinaryOperationFunctionIntrinsic", "<init>"));
            }
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndIntBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndIntBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndIntBinaryOperationFunctionIntrinsic", "doApply"));
            }
            JsExpression jsExpression = JsAstUtils.toChar(this.functionIntrinsic.doApply(left, right, context));
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$CharAndIntBinaryOperationFunctionIntrinsic", "doApply"));
            }
            return jsExpression;
        }
    }

    private static class AdditiveIntBinaryOperationInstrinsic
    extends OptimizedIntBinaryOperationInstrinsic {
        public AdditiveIntBinaryOperationInstrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$AdditiveIntBinaryOperationInstrinsic", "<init>"));
            }
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$AdditiveIntBinaryOperationInstrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$AdditiveIntBinaryOperationInstrinsic", "doApply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$AdditiveIntBinaryOperationInstrinsic", "doApply"));
            }
            JsExpression jsExpression = JsAstUtils.toInt32(super.doApply(left, right, context));
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$AdditiveIntBinaryOperationInstrinsic", "doApply"));
            }
            return jsExpression;
        }
    }

    private static class OptimizedIntBinaryOperationInstrinsic
    extends PrimitiveBinaryOperationFunctionIntrinsic {
        public OptimizedIntBinaryOperationInstrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "<init>"));
            }
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "doApply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "doApply"));
            }
            left = OptimizedIntBinaryOperationInstrinsic.unwrapAdditive(left);
            right = OptimizedIntBinaryOperationInstrinsic.unwrapAdditive(right);
            JsExpression jsExpression = super.doApply(left, right, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "doApply"));
            }
            return jsExpression;
        }

        @NotNull
        private static JsExpression unwrapAdditive(@NotNull JsExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "unwrapAdditive"));
            }
            JsExpression toIntArgument = JsAstUtils.extractToInt32Argument(expression);
            if (toIntArgument == null) {
                JsExpression jsExpression = expression;
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "unwrapAdditive"));
                }
                return jsExpression;
            }
            if (!(toIntArgument instanceof JsBinaryOperation)) {
                JsExpression jsExpression = expression;
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "unwrapAdditive"));
                }
                return jsExpression;
            }
            JsBinaryOperator operator = ((JsBinaryOperation)toIntArgument).getOperator();
            switch (operator) {
                case ADD: 
                case SUB: {
                    JsExpression jsExpression = toIntArgument;
                    if (jsExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "unwrapAdditive"));
                    }
                    return jsExpression;
                }
            }
            JsExpression jsExpression = expression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$OptimizedIntBinaryOperationInstrinsic", "unwrapAdditive"));
            }
            return jsExpression;
        }
    }

    private static class IntBinaryOperationFunctionIntrinsic
    extends PrimitiveBinaryOperationFunctionIntrinsic {
        private IntBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$IntBinaryOperationFunctionIntrinsic", "<init>"));
            }
            super(operator);
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$IntBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$IntBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$IntBinaryOperationFunctionIntrinsic", "doApply"));
            }
            JsExpression jsExpression = JsAstUtils.toInt32(super.doApply(left, right, context));
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$IntBinaryOperationFunctionIntrinsic", "doApply"));
            }
            return jsExpression;
        }
    }

    private static class PrimitiveBinaryOperationFunctionIntrinsic
    extends BinaryOperationIntrinsicBase {
        @NotNull
        private final JsBinaryOperator operator;

        private PrimitiveBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "<init>"));
            }
            this.operator = operator;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "doApply"));
            }
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(this.operator, left, right);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "doApply"));
            }
            return jsBinaryOperation;
        }
    }

    private static abstract class BinaryOperationIntrinsicBase
    extends FunctionIntrinsicWithReceiverComputed {
        private BinaryOperationIntrinsicBase() {
        }

        @NotNull
        public abstract JsExpression doApply(@NotNull JsExpression var1, @NotNull JsExpression var2, @NotNull TranslationContext var3);

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$BinaryOperationIntrinsicBase", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$BinaryOperationIntrinsicBase", "apply"));
            }
            assert (receiver != null);
            assert (arguments2.size() == 1);
            JsExpression jsExpression = this.doApply(receiver, arguments2.get(0), context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$BinaryOperationIntrinsicBase", "apply"));
            }
            return jsExpression;
        }
    }
}

