/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.resolve.OverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.resolve.PlatformConfigurator;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.lazy.DelegationFilter;
import org.jetbrains.kotlin.types.DynamicTypesSettings;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00062\u0006\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "", "platformName", "", "(Ljava/lang/String;)V", "excludedImports", "", "Lorg/jetbrains/kotlin/name/FqName;", "getExcludedImports", "()Ljava/util/List;", "multiTargetPlatform", "Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform;", "getMultiTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform;", "platformConfigurator", "Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformConfigurator", "()Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformName", "()Ljava/lang/String;", "getDefaultImports", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "toString", "Default", "kotlin-compiler"})
public abstract class TargetPlatform {
    @NotNull
    private final String platformName;

    @NotNull
    public String toString() {
        return this.platformName;
    }

    @NotNull
    public abstract PlatformConfigurator getPlatformConfigurator();

    @NotNull
    public abstract List<ImportPath> getDefaultImports(@NotNull LanguageVersionSettings var1);

    @NotNull
    public List<FqName> getExcludedImports() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public abstract MultiTargetPlatform getMultiTargetPlatform();

    @NotNull
    public final String getPlatformName() {
        return this.platformName;
    }

    public TargetPlatform(@NotNull String platformName) {
        Intrinsics.checkParameterIsNotNull(platformName, "platformName");
        this.platformName = platformName;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/TargetPlatform$Default;", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "()V", "multiTargetPlatform", "Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform;", "getMultiTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform;", "platformConfigurator", "Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformConfigurator", "()Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getDefaultImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlin-compiler"})
    public static final class Default
    extends TargetPlatform {
        @NotNull
        private static final PlatformConfigurator platformConfigurator;
        public static final Default INSTANCE;

        @Override
        @NotNull
        public List<ImportPath> getDefaultImports(@NotNull LanguageVersionSettings languageVersionSettings) {
            ArrayList<ImportPath> arrayList;
            Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
            ArrayList<ImportPath> $receiver = arrayList = new ArrayList<ImportPath>();
            $receiver.add(new ImportPath("kotlin.*"));
            $receiver.add(new ImportPath("kotlin.annotation.*"));
            $receiver.add(new ImportPath("kotlin.collections.*"));
            $receiver.add(new ImportPath("kotlin.ranges.*"));
            $receiver.add(new ImportPath("kotlin.sequences.*"));
            $receiver.add(new ImportPath("kotlin.text.*"));
            $receiver.add(new ImportPath("kotlin.io.*"));
            if (languageVersionSettings.supportsFeature(LanguageFeature.DefaultImportOfPackageKotlinComparisons)) {
                $receiver.add(new ImportPath("kotlin.comparisons.*"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        public PlatformConfigurator getPlatformConfigurator() {
            return platformConfigurator;
        }

        @Override
        @NotNull
        public MultiTargetPlatform getMultiTargetPlatform() {
            return MultiTargetPlatform.Common.INSTANCE;
        }

        private Default() {
            super("Default");
            platformConfigurator.1 v0;
            INSTANCE = this;
            DynamicTypesSettings dynamicTypesSettings = new DynamicTypesSettings();
            platformConfigurator.1 var2_2 = v0;
            platformConfigurator.1 var3_3 = v0;
            List list2 = CollectionsKt.emptyList();
            List list3 = CollectionsKt.emptyList();
            List list4 = CollectionsKt.emptyList();
            List list5 = CollectionsKt.emptyList();
            List list6 = CollectionsKt.emptyList();
            IdentifierChecker identifierChecker = IdentifierChecker.DEFAULT.INSTANCE;
            OverloadFilter overloadFilter = OverloadFilter.DEFAULT.INSTANCE;
            PlatformToKotlinClassMap platformToKotlinClassMap = PlatformToKotlinClassMap.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull(platformToKotlinClassMap, "PlatformToKotlinClassMap.EMPTY");
            var2_2(dynamicTypesSettings, list2, list3, list4, list5, list6, identifierChecker, overloadFilter, platformToKotlinClassMap, (DelegationFilter)DelegationFilter.DEFAULT.INSTANCE, (OverridesBackwardCompatibilityHelper)OverridesBackwardCompatibilityHelper.DEFAULT.INSTANCE);
            platformConfigurator = var3_3;
        }

        static {
            new Default();
        }
    }
}

