/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InterfaceDefaultMethodCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class InterfaceDefaultMethodCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        boolean supportDefaults = Intrinsics.areEqual(context.getCompilerConfiguration().get(JVMConfigurationKeys.JVM_TARGET), JvmTarget.JVM_1_8);
        Object obj = resolvedCall2.getResultingDescriptor();
        if (!(obj instanceof FunctionDescriptor)) {
            obj = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)obj;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (!supportDefaults && DescriptorUtils.isStaticDeclaration(descriptor2) && DescriptorUtils.isInterface(descriptor2.getContainingDeclaration()) && descriptor2 instanceof JavaCallableMemberDescriptor) {
            context.getTrace().report(ErrorsJvm.INTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET.on(reportOn));
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        if (CallResolverUtilKt.getSuperCallExpression(call2) == null) {
            return;
        }
        if (!DescriptorUtils.isInterface(descriptor2.getOriginal().getContainingDeclaration())) {
            return;
        }
        FunctionDescriptor realDescriptor = (FunctionDescriptor)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
        DeclarationDescriptor declarationDescriptor = realDescriptor.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor realDescriptorOwner = classDescriptor;
        if (DescriptorUtils.isInterface(realDescriptorOwner) && realDescriptor instanceof JavaCallableMemberDescriptor) {
            ClassifierDescriptor classifier2 = DescriptorUtils.getParentOfType(context.getScope().getOwnerDescriptor(), ClassifierDescriptor.class);
            if (classifier2 != null && DescriptorUtils.isInterface(classifier2)) {
                context.getTrace().report(ErrorsJvm.INTERFACE_CANT_CALL_DEFAULT_METHOD_VIA_SUPER.on(reportOn));
            } else if (!supportDefaults) {
                context.getTrace().report(ErrorsJvm.DEFAULT_METHOD_CALL_FROM_JAVA6_TARGET.on(reportOn));
            }
        }
    }
}

