/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.TypeIntersectionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

public class IntersectionTypeConstructor
implements TypeConstructor {
    private final Set<KotlinType> intersectedTypes;
    private final int hashCode;

    public IntersectionTypeConstructor(Collection<KotlinType> typesToIntersect) {
        assert (!typesToIntersect.isEmpty()) : "Attempt to create an empty intersection";
        this.intersectedTypes = new LinkedHashSet<KotlinType>(typesToIntersect);
        this.hashCode = ((Object)this.intersectedTypes).hashCode();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/IntersectionTypeConstructor", "getParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        Set<KotlinType> set = this.intersectedTypes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/IntersectionTypeConstructor", "getSupertypes"));
        }
        return set;
    }

    public MemberScope createScopeForKotlinType() {
        return TypeIntersectionScope.create("member scope for intersection type " + this, this.intersectedTypes);
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = this.intersectedTypes.iterator().next().getConstructor().getBuiltIns();
        if (kotlinBuiltIns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/IntersectionTypeConstructor", "getBuiltIns"));
        }
        return kotlinBuiltIns;
    }

    public String toString() {
        return IntersectionTypeConstructor.makeDebugNameForIntersectionType(this.intersectedTypes);
    }

    private static String makeDebugNameForIntersectionType(Iterable<KotlinType> resultingTypes) {
        StringBuilder debugName = new StringBuilder("{");
        Iterator<KotlinType> iterator2 = resultingTypes.iterator();
        while (iterator2.hasNext()) {
            KotlinType type2 = iterator2.next();
            debugName.append(type2.toString());
            if (!iterator2.hasNext()) continue;
            debugName.append(" & ");
        }
        debugName.append("}");
        return debugName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntersectionTypeConstructor that = (IntersectionTypeConstructor)o;
        return !(this.intersectedTypes != null ? !((Object)this.intersectedTypes).equals(that.intersectedTypes) : that.intersectedTypes != null);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

