/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationState;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerDaemonProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkerDaemonClient<T extends WorkSpec>
implements Worker<T>,
Stoppable {
    private final DaemonForkOptions forkOptions;
    private final WorkerDaemonProcess<T> workerDaemonProcess;
    private final WorkerProcess workerProcess;
    private final BuildOperationExecutor buildOperationExecutor;
    private int uses;

    public WorkerDaemonClient(DaemonForkOptions forkOptions, WorkerDaemonProcess<T> workerDaemonProcess, WorkerProcess workerProcess, BuildOperationExecutor buildOperationExecutor) {
        this.forkOptions = forkOptions;
        this.workerDaemonProcess = workerDaemonProcess;
        this.workerProcess = workerProcess;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultWorkResult execute(final T spec, WorkerLeaseRegistry.WorkerLease parentWorkerWorkerLease, final BuildOperationState parentBuildOperation) {
        WorkerLeaseRegistry.WorkerLeaseCompletion workerLease = parentWorkerWorkerLease.startChild();
        try {
            DefaultWorkResult defaultWorkResult = (DefaultWorkResult)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<DefaultWorkResult>(){

                public DefaultWorkResult call(BuildOperationContext context) {
                    WorkerDaemonClient.this.uses++;
                    return WorkerDaemonClient.this.workerDaemonProcess.execute(spec);
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)spec.getDisplayName()).parent(parentBuildOperation);
                }
            });
            return defaultWorkResult;
        }
        finally {
            workerLease.leaseFinish();
        }
    }

    @Override
    public DefaultWorkResult execute(T spec) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompatibleWith(DaemonForkOptions required) {
        return this.forkOptions.isCompatibleWith(required);
    }

    JvmMemoryStatus getJvmMemoryStatus() {
        return this.workerProcess.getJvmMemoryStatus();
    }

    public void stop() {
        this.workerDaemonProcess.stop();
    }

    DaemonForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public int getUses() {
        return this.uses;
    }
}

