/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerDaemonStarter;
import org.gradle.workers.internal.WorkerProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDaemonClientsManager {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonFactory.class);
    private final Object lock = new Object();
    private final List<WorkerDaemonClient> allClients = new ArrayList<WorkerDaemonClient>();
    private final List<WorkerDaemonClient> idleClients = new ArrayList<WorkerDaemonClient>();
    private WorkerDaemonStarter workerDaemonStarter;

    public WorkerDaemonClientsManager(WorkerDaemonStarter workerDaemonStarter) {
        this.workerDaemonStarter = workerDaemonStarter;
    }

    public <T extends WorkSpec> WorkerDaemonClient<T> reserveIdleClient(DaemonForkOptions forkOptions) {
        return this.reserveIdleClient(forkOptions, this.idleClients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions, List<WorkerDaemonClient> clients) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<WorkerDaemonClient> it = clients.iterator();
            while (it.hasNext()) {
                WorkerDaemonClient candidate = it.next();
                if (!candidate.isCompatibleWith(forkOptions)) continue;
                it.remove();
                return candidate;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends WorkSpec> WorkerDaemonClient<T> reserveNewClient(Class<? extends WorkerProtocol<T>> workerProtocolImplementationClass, File workingDir, DaemonForkOptions forkOptions) {
        WorkerDaemonClient client = this.workerDaemonStarter.startDaemon(workerProtocolImplementationClass, workingDir, forkOptions);
        Object object = this.lock;
        synchronized (object) {
            this.allClients.add(client);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(WorkerDaemonClient client) {
        Object object = this.lock;
        synchronized (object) {
            this.idleClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.debug("Stopping {} worker daemon(s).", (Object)this.allClients.size());
            CompositeStoppable.stoppable(this.allClients).stop();
            LOGGER.info("Stopped {} worker daemon(s).", (Object)this.allClients.size());
            this.allClients.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectIdleClientsToStop(Transformer<List<WorkerDaemonClient>, List<WorkerDaemonClient>> selectionFunction) {
        Object object = this.lock;
        synchronized (object) {
            List sortedClients = CollectionUtils.sort(this.idleClients, (Comparator)new Comparator<WorkerDaemonClient>(){

                @Override
                public int compare(WorkerDaemonClient o1, WorkerDaemonClient o2) {
                    return new Integer(o1.getUses()).compareTo(o2.getUses());
                }
            });
            List clientsToStop = (List)selectionFunction.transform(new ArrayList(sortedClients));
            if (!clientsToStop.isEmpty()) {
                this.idleClients.removeAll(clientsToStop);
                this.allClients.removeAll(clientsToStop);
                LOGGER.debug("Stopping {} worker daemon(s).", (Object)clientsToStop.size());
                CompositeStoppable.stoppable((Iterable)clientsToStop).stop();
                LOGGER.info("Stopped {} worker daemon(s).", (Object)clientsToStop.size());
            }
        }
    }
}

