/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestClassScanner;
import org.gradle.api.internal.tasks.testing.detection.TestExecuter;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.processors.MaxNParallelTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.RestartEveryNTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.internal.tasks.testing.worker.ForkingTestClassProcessor;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Factory;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.time.TimeProvider;
import org.gradle.internal.time.TrueTimeProvider;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class DefaultTestExecuter
implements TestExecuter {
    private static final Logger LOGGER = Logging.getLogger(DefaultTestExecuter.class);
    private final WorkerProcessFactory workerFactory;
    private final ActorFactory actorFactory;
    private final ModuleRegistry moduleRegistry;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final int maxWorkerCount;

    public DefaultTestExecuter(WorkerProcessFactory workerFactory, ActorFactory actorFactory, ModuleRegistry moduleRegistry, WorkerLeaseRegistry workerLeaseRegistry, BuildOperationExecutor buildOperationExecutor, int maxWorkerCount) {
        this.workerFactory = workerFactory;
        this.actorFactory = actorFactory;
        this.moduleRegistry = moduleRegistry;
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.maxWorkerCount = maxWorkerCount;
    }

    @Override
    public void execute(final Test testTask, TestResultProcessor testResultProcessor) {
        DefaultTestClassScanner detector;
        TestFramework testFramework = testTask.getTestFramework();
        final WorkerTestClassProcessorFactory testInstanceFactory = testFramework.getProcessorFactory();
        final WorkerLeaseRegistry.WorkerLease currentWorkerLease = this.workerLeaseRegistry.getCurrentWorkerLease();
        ImmutableSet classpath = ImmutableSet.copyOf((Iterable)testTask.getClasspath());
        Factory<TestClassProcessor> forkingProcessorFactory = new Factory<TestClassProcessor>((Set)classpath, testFramework){
            final /* synthetic */ Set val$classpath;
            final /* synthetic */ TestFramework val$testFramework;
            {
                this.val$classpath = set;
                this.val$testFramework = testFramework;
            }

            public TestClassProcessor create() {
                return new ForkingTestClassProcessor(currentWorkerLease, DefaultTestExecuter.this.workerFactory, testInstanceFactory, (JavaForkOptions)testTask, (Iterable)this.val$classpath, this.val$testFramework.getWorkerConfigurationAction(), DefaultTestExecuter.this.moduleRegistry);
            }
        };
        Factory<TestClassProcessor> reforkingProcessorFactory = new Factory<TestClassProcessor>((Factory)forkingProcessorFactory, testTask){
            final /* synthetic */ Factory val$forkingProcessorFactory;
            final /* synthetic */ Test val$testTask;
            {
                this.val$forkingProcessorFactory = factory;
                this.val$testTask = test;
            }

            public TestClassProcessor create() {
                return new RestartEveryNTestClassProcessor(this.val$forkingProcessorFactory, this.val$testTask.getForkEvery());
            }
        };
        MaxNParallelTestClassProcessor processor = new MaxNParallelTestClassProcessor(this.getMaxParallelForks(testTask), (Factory)reforkingProcessorFactory, this.actorFactory);
        FileTree testClassFiles = testTask.getCandidateClassFiles();
        if (testTask.isScanForTestClasses()) {
            TestFrameworkDetector testFrameworkDetector = testFramework.getDetector();
            testFrameworkDetector.setTestClasses(testTask.getTestClassesDirs().getFiles());
            testFrameworkDetector.setTestClasspath((Set<File>)classpath);
            detector = new DefaultTestClassScanner(testClassFiles, testFrameworkDetector, (TestClassProcessor)processor);
        } else {
            detector = new DefaultTestClassScanner(testClassFiles, null, (TestClassProcessor)processor);
        }
        Object testTaskOperationId = this.buildOperationExecutor.getCurrentOperation().getParentId();
        new TestMainAction((Runnable)detector, (TestClassProcessor)processor, testResultProcessor, (TimeProvider)new TrueTimeProvider(), testTaskOperationId, (Object)testTask.getPath(), "Gradle Test Run " + testTask.getIdentityPath()).run();
    }

    private int getMaxParallelForks(Test testTask) {
        int maxParallelForks = testTask.getMaxParallelForks();
        if (maxParallelForks > this.maxWorkerCount) {
            LOGGER.info("{}.maxParallelForks ({}) is larger than max-workers ({}), forcing it to {}", new Object[]{testTask.getName(), maxParallelForks, this.maxWorkerCount, this.maxWorkerCount});
            maxParallelForks = this.maxWorkerCount;
        }
        return maxParallelForks;
    }
}

