/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskTypeTaskStateChanges
extends SimpleTaskStateChanges {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTypeTaskStateChanges.class);
    private final String taskPath;
    private final ImplementationSnapshot taskImplementation;
    private final ImmutableList<ImplementationSnapshot> taskActionImplementations;
    private final TaskExecution previousExecution;

    public TaskTypeTaskStateChanges(@Nullable TaskExecution previousExecution, TaskExecution currentExecution, String taskPath, Class<? extends TaskInternal> taskClass, Collection<ContextAwareTaskAction> taskActions, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        ImplementationSnapshot taskImplementation = new ImplementationSnapshot(taskClass.getName(), classLoaderHierarchyHasher.getClassLoaderHash(taskClass.getClassLoader()));
        ImmutableList<ImplementationSnapshot> taskActionImplementations = this.collectActionImplementations(taskActions, classLoaderHierarchyHasher);
        currentExecution.setTaskImplementation(taskImplementation);
        currentExecution.setTaskActionImplementations(taskActionImplementations);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Task {} implementation: {}", (Object)taskPath, (Object)taskImplementation);
            LOGGER.debug("Task {} action implementations: {}", (Object)taskPath, taskActionImplementations);
        }
        this.taskPath = taskPath;
        this.taskImplementation = taskImplementation;
        this.taskActionImplementations = taskActionImplementations;
        this.previousExecution = previousExecution;
    }

    private ImmutableList<ImplementationSnapshot> collectActionImplementations(Collection<ContextAwareTaskAction> taskActions, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        if (taskActions.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder actionImpls = ImmutableList.builder();
        for (ContextAwareTaskAction taskAction : taskActions) {
            String typeName = taskAction.getActionClassName();
            HashCode classLoaderHash = classLoaderHierarchyHasher.getClassLoaderHash(taskAction.getClassLoader());
            actionImpls.add((Object)new ImplementationSnapshot(typeName, classLoaderHash));
        }
        return actionImpls.build();
    }

    @Override
    protected void addAllChanges(List<TaskStateChange> changes) {
        ImplementationSnapshot prevImplementation = this.previousExecution.getTaskImplementation();
        if (!this.taskImplementation.getTypeName().equals(prevImplementation.getTypeName())) {
            changes.add(new DescriptiveChange("Task '%s' has changed type from '%s' to '%s'.", this.taskPath, prevImplementation.getTypeName(), this.taskImplementation.getTypeName()));
            return;
        }
        if (this.taskImplementation.hasUnknownClassLoader()) {
            changes.add(new DescriptiveChange("Task '%s' was loaded with an unknown classloader", this.taskPath));
            return;
        }
        if (prevImplementation.hasUnknownClassLoader()) {
            changes.add(new DescriptiveChange("Task '%s' was loaded with an unknown classloader during the previous execution", this.taskPath));
            return;
        }
        if (!this.taskImplementation.getClassLoaderHash().equals((Object)prevImplementation.getClassLoaderHash())) {
            changes.add(new DescriptiveChange("Task '%s' class path has changed from %s to %s.", this.taskPath, prevImplementation.getClassLoaderHash(), this.taskImplementation.getClassLoaderHash()));
            return;
        }
        if (TaskTypeTaskStateChanges.hasAnyUnknownClassLoader(this.taskActionImplementations)) {
            changes.add(new DescriptiveChange("Task '%s' has an additional action that was loaded with an unknown classloader", this.taskPath));
            return;
        }
        if (TaskTypeTaskStateChanges.hasAnyUnknownClassLoader(this.previousExecution.getTaskActionImplementations())) {
            changes.add(new DescriptiveChange("Task '%s' had an additional action that was loaded with an unknown classloader during the previous execution", this.taskPath));
            return;
        }
        if (!this.taskActionImplementations.equals(this.previousExecution.getTaskActionImplementations())) {
            changes.add(new DescriptiveChange("Task '%s' has additional actions that have changed", this.taskPath));
        }
    }

    private static boolean hasAnyUnknownClassLoader(Iterable<ImplementationSnapshot> implementations) {
        for (ImplementationSnapshot implementation : implementations) {
            if (!implementation.hasUnknownClassLoader()) continue;
            return true;
        }
        return false;
    }
}

